// Code generated by go-swagger; DO NOT EDIT.

//
// Copyright 2021 The Sigstore Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	stderrors "errors"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DSSEV001Schema DSSE v0.0.1 Schema
//
// # Schema for DSSE envelopes
//
// swagger:model dsseV001Schema
type DSSEV001Schema struct {

	// envelope hash
	EnvelopeHash *DSSEV001SchemaEnvelopeHash `json:"envelopeHash,omitempty"`

	// payload hash
	PayloadHash *DSSEV001SchemaPayloadHash `json:"payloadHash,omitempty"`

	// proposed content
	ProposedContent *DSSEV001SchemaProposedContent `json:"proposedContent,omitempty"`

	// extracted collection of all signatures of the envelope's payload; elements will be sorted by lexicographical order of the base64 encoded signature strings
	// Read Only: true
	// Min Items: 1
	Signatures []*DSSEV001SchemaSignaturesItems0 `json:"signatures"`
}

// Validate validates this dsse v001 schema
func (m *DSSEV001Schema) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateEnvelopeHash(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePayloadHash(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProposedContent(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSignatures(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DSSEV001Schema) validateEnvelopeHash(formats strfmt.Registry) error {
	if swag.IsZero(m.EnvelopeHash) { // not required
		return nil
	}

	if m.EnvelopeHash != nil {
		if err := m.EnvelopeHash.Validate(formats); err != nil {
			ve := new(errors.Validation)
			if stderrors.As(err, &ve) {
				return ve.ValidateName("envelopeHash")
			}
			ce := new(errors.CompositeError)
			if stderrors.As(err, &ce) {
				return ce.ValidateName("envelopeHash")
			}

			return err
		}
	}

	return nil
}

func (m *DSSEV001Schema) validatePayloadHash(formats strfmt.Registry) error {
	if swag.IsZero(m.PayloadHash) { // not required
		return nil
	}

	if m.PayloadHash != nil {
		if err := m.PayloadHash.Validate(formats); err != nil {
			ve := new(errors.Validation)
			if stderrors.As(err, &ve) {
				return ve.ValidateName("payloadHash")
			}
			ce := new(errors.CompositeError)
			if stderrors.As(err, &ce) {
				return ce.ValidateName("payloadHash")
			}

			return err
		}
	}

	return nil
}

func (m *DSSEV001Schema) validateProposedContent(formats strfmt.Registry) error {
	if swag.IsZero(m.ProposedContent) { // not required
		return nil
	}

	if m.ProposedContent != nil {
		if err := m.ProposedContent.Validate(formats); err != nil {
			ve := new(errors.Validation)
			if stderrors.As(err, &ve) {
				return ve.ValidateName("proposedContent")
			}
			ce := new(errors.CompositeError)
			if stderrors.As(err, &ce) {
				return ce.ValidateName("proposedContent")
			}

			return err
		}
	}

	return nil
}

func (m *DSSEV001Schema) validateSignatures(formats strfmt.Registry) error {
	if swag.IsZero(m.Signatures) { // not required
		return nil
	}

	iSignaturesSize := int64(len(m.Signatures))

	if err := validate.MinItems("signatures", "body", iSignaturesSize, 1); err != nil {
		return err
	}

	for i := 0; i < len(m.Signatures); i++ {
		if swag.IsZero(m.Signatures[i]) { // not required
			continue
		}

		if m.Signatures[i] != nil {
			if err := m.Signatures[i].Validate(formats); err != nil {
				ve := new(errors.Validation)
				if stderrors.As(err, &ve) {
					return ve.ValidateName("signatures" + "." + strconv.Itoa(i))
				}
				ce := new(errors.CompositeError)
				if stderrors.As(err, &ce) {
					return ce.ValidateName("signatures" + "." + strconv.Itoa(i))
				}

				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this dsse v001 schema based on the context it is used
func (m *DSSEV001Schema) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateEnvelopeHash(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePayloadHash(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProposedContent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSignatures(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DSSEV001Schema) contextValidateEnvelopeHash(ctx context.Context, formats strfmt.Registry) error {

	if m.EnvelopeHash != nil {

		if swag.IsZero(m.EnvelopeHash) { // not required
			return nil
		}

		if err := m.EnvelopeHash.ContextValidate(ctx, formats); err != nil {
			ve := new(errors.Validation)
			if stderrors.As(err, &ve) {
				return ve.ValidateName("envelopeHash")
			}
			ce := new(errors.CompositeError)
			if stderrors.As(err, &ce) {
				return ce.ValidateName("envelopeHash")
			}

			return err
		}
	}

	return nil
}

func (m *DSSEV001Schema) contextValidatePayloadHash(ctx context.Context, formats strfmt.Registry) error {

	if m.PayloadHash != nil {

		if swag.IsZero(m.PayloadHash) { // not required
			return nil
		}

		if err := m.PayloadHash.ContextValidate(ctx, formats); err != nil {
			ve := new(errors.Validation)
			if stderrors.As(err, &ve) {
				return ve.ValidateName("payloadHash")
			}
			ce := new(errors.CompositeError)
			if stderrors.As(err, &ce) {
				return ce.ValidateName("payloadHash")
			}

			return err
		}
	}

	return nil
}

func (m *DSSEV001Schema) contextValidateProposedContent(ctx context.Context, formats strfmt.Registry) error {

	if m.ProposedContent != nil {

		if swag.IsZero(m.ProposedContent) { // not required
			return nil
		}

		if err := m.ProposedContent.ContextValidate(ctx, formats); err != nil {
			ve := new(errors.Validation)
			if stderrors.As(err, &ve) {
				return ve.ValidateName("proposedContent")
			}
			ce := new(errors.CompositeError)
			if stderrors.As(err, &ce) {
				return ce.ValidateName("proposedContent")
			}

			return err
		}
	}

	return nil
}

func (m *DSSEV001Schema) contextValidateSignatures(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "signatures", "body", m.Signatures); err != nil {
		return err
	}

	for i := 0; i < len(m.Signatures); i++ {

		if m.Signatures[i] != nil {

			if swag.IsZero(m.Signatures[i]) { // not required
				return nil
			}

			if err := m.Signatures[i].ContextValidate(ctx, formats); err != nil {
				ve := new(errors.Validation)
				if stderrors.As(err, &ve) {
					return ve.ValidateName("signatures" + "." + strconv.Itoa(i))
				}
				ce := new(errors.CompositeError)
				if stderrors.As(err, &ce) {
					return ce.ValidateName("signatures" + "." + strconv.Itoa(i))
				}

				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *DSSEV001Schema) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DSSEV001Schema) UnmarshalBinary(b []byte) error {
	var res DSSEV001Schema
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DSSEV001SchemaEnvelopeHash Specifies the hash algorithm and value encompassing the entire envelope sent to Rekor
//
// swagger:model DSSEV001SchemaEnvelopeHash
type DSSEV001SchemaEnvelopeHash struct {

	// The hashing function used to compute the hash value
	// Required: true
	// Enum: ["sha256"]
	Algorithm *string `json:"algorithm"`

	// The value of the computed digest over the entire envelope
	// Required: true
	Value *string `json:"value"`
}

// Validate validates this DSSE v001 schema envelope hash
func (m *DSSEV001SchemaEnvelopeHash) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAlgorithm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateValue(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var dsseV001SchemaEnvelopeHashTypeAlgorithmPropEnum []any

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["sha256"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dsseV001SchemaEnvelopeHashTypeAlgorithmPropEnum = append(dsseV001SchemaEnvelopeHashTypeAlgorithmPropEnum, v)
	}
}

const (

	// DSSEV001SchemaEnvelopeHashAlgorithmSha256 captures enum value "sha256"
	DSSEV001SchemaEnvelopeHashAlgorithmSha256 string = "sha256"
)

// prop value enum
func (m *DSSEV001SchemaEnvelopeHash) validateAlgorithmEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dsseV001SchemaEnvelopeHashTypeAlgorithmPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DSSEV001SchemaEnvelopeHash) validateAlgorithm(formats strfmt.Registry) error {

	if err := validate.Required("envelopeHash"+"."+"algorithm", "body", m.Algorithm); err != nil {
		return err
	}

	// value enum
	if err := m.validateAlgorithmEnum("envelopeHash"+"."+"algorithm", "body", *m.Algorithm); err != nil {
		return err
	}

	return nil
}

func (m *DSSEV001SchemaEnvelopeHash) validateValue(formats strfmt.Registry) error {

	if err := validate.Required("envelopeHash"+"."+"value", "body", m.Value); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this DSSE v001 schema envelope hash based on the context it is used
func (m *DSSEV001SchemaEnvelopeHash) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *DSSEV001SchemaEnvelopeHash) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DSSEV001SchemaEnvelopeHash) UnmarshalBinary(b []byte) error {
	var res DSSEV001SchemaEnvelopeHash
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DSSEV001SchemaPayloadHash Specifies the hash algorithm and value covering the payload within the DSSE envelope
//
// swagger:model DSSEV001SchemaPayloadHash
type DSSEV001SchemaPayloadHash struct {

	// The hashing function used to compute the hash value
	// Required: true
	// Enum: ["sha256"]
	Algorithm *string `json:"algorithm"`

	// The value of the computed digest over the payload within the envelope
	// Required: true
	Value *string `json:"value"`
}

// Validate validates this DSSE v001 schema payload hash
func (m *DSSEV001SchemaPayloadHash) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAlgorithm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateValue(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var dsseV001SchemaPayloadHashTypeAlgorithmPropEnum []any

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["sha256"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dsseV001SchemaPayloadHashTypeAlgorithmPropEnum = append(dsseV001SchemaPayloadHashTypeAlgorithmPropEnum, v)
	}
}

const (

	// DSSEV001SchemaPayloadHashAlgorithmSha256 captures enum value "sha256"
	DSSEV001SchemaPayloadHashAlgorithmSha256 string = "sha256"
)

// prop value enum
func (m *DSSEV001SchemaPayloadHash) validateAlgorithmEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dsseV001SchemaPayloadHashTypeAlgorithmPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DSSEV001SchemaPayloadHash) validateAlgorithm(formats strfmt.Registry) error {

	if err := validate.Required("payloadHash"+"."+"algorithm", "body", m.Algorithm); err != nil {
		return err
	}

	// value enum
	if err := m.validateAlgorithmEnum("payloadHash"+"."+"algorithm", "body", *m.Algorithm); err != nil {
		return err
	}

	return nil
}

func (m *DSSEV001SchemaPayloadHash) validateValue(formats strfmt.Registry) error {

	if err := validate.Required("payloadHash"+"."+"value", "body", m.Value); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this DSSE v001 schema payload hash based on the context it is used
func (m *DSSEV001SchemaPayloadHash) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *DSSEV001SchemaPayloadHash) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DSSEV001SchemaPayloadHash) UnmarshalBinary(b []byte) error {
	var res DSSEV001SchemaPayloadHash
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DSSEV001SchemaProposedContent DSSE v001 schema proposed content
//
// swagger:model DSSEV001SchemaProposedContent
type DSSEV001SchemaProposedContent struct {

	// DSSE envelope specified as a stringified JSON object
	// Required: true
	Envelope *string `json:"envelope"`

	// collection of all verification material (e.g. public keys or certificates) used to verify signatures over envelope's payload, specified as base64-encoded strings
	// Required: true
	// Min Items: 1
	Verifiers []strfmt.Base64 `json:"verifiers"`
}

// Validate validates this DSSE v001 schema proposed content
func (m *DSSEV001SchemaProposedContent) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateEnvelope(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVerifiers(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DSSEV001SchemaProposedContent) validateEnvelope(formats strfmt.Registry) error {

	if err := validate.Required("proposedContent"+"."+"envelope", "body", m.Envelope); err != nil {
		return err
	}

	return nil
}

func (m *DSSEV001SchemaProposedContent) validateVerifiers(formats strfmt.Registry) error {

	if err := validate.Required("proposedContent"+"."+"verifiers", "body", m.Verifiers); err != nil {
		return err
	}

	iVerifiersSize := int64(len(m.Verifiers))

	if err := validate.MinItems("proposedContent"+"."+"verifiers", "body", iVerifiersSize, 1); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this DSSE v001 schema proposed content based on context it is used
func (m *DSSEV001SchemaProposedContent) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DSSEV001SchemaProposedContent) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DSSEV001SchemaProposedContent) UnmarshalBinary(b []byte) error {
	var res DSSEV001SchemaProposedContent
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DSSEV001SchemaSignaturesItems0 a signature of the envelope's payload along with the verification material for the signature
//
// swagger:model DSSEV001SchemaSignaturesItems0
type DSSEV001SchemaSignaturesItems0 struct {

	// base64 encoded signature of the payload
	// Required: true
	// Pattern: ^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=|[A-Za-z0-9+\/]{4})$
	Signature *string `json:"signature"`

	// verification material that was used to verify the corresponding signature, specified as a base64 encoded string
	// Required: true
	// Format: byte
	Verifier *strfmt.Base64 `json:"verifier"`
}

// Validate validates this DSSE v001 schema signatures items0
func (m *DSSEV001SchemaSignaturesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSignature(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVerifier(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DSSEV001SchemaSignaturesItems0) validateSignature(formats strfmt.Registry) error {

	if err := validate.Required("signature", "body", m.Signature); err != nil {
		return err
	}

	if err := validate.Pattern("signature", "body", *m.Signature, `^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=|[A-Za-z0-9+\/]{4})$`); err != nil {
		return err
	}

	return nil
}

func (m *DSSEV001SchemaSignaturesItems0) validateVerifier(formats strfmt.Registry) error {

	if err := validate.Required("verifier", "body", m.Verifier); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this DSSE v001 schema signatures items0 based on context it is used
func (m *DSSEV001SchemaSignaturesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DSSEV001SchemaSignaturesItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DSSEV001SchemaSignaturesItems0) UnmarshalBinary(b []byte) error {
	var res DSSEV001SchemaSignaturesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
