% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/result.R
\name{unitizer_result}
\alias{unitizer_result}
\alias{unitizer_results}
\alias{print.unitizer_result}
\alias{print.unitizer_results}
\title{Return Values and Related Methods for \code{unitize} Functions}
\usage{
\method{print}{unitizer_result}(x, ...)

\method{print}{unitizer_results}(x, ...)
}
\arguments{
\item{x}{the object to print}

\item{...}{extra arguments for print generic}
}
\value{
\code{x}, invisibly
}
\description{
\code{unitize} and related functions are run primarily for the interactive
environment they provide and for their side effects (updating stored
\code{unitizer} objects), but the return values may be useful under some
circumstances if you need to retrieve test status, user selections, etc..
}
\details{
\code{unitize} and \code{review} return a \code{unitizer_result} S3 object.
This is a data frame that contains details about the status of each test.
\code{unitize_dir} returns a \code{unitize_results} S3 object, which is a
list of \code{unitize_result}  objects.

Both \code{unitize_results} and \code{unitize_result} have \code{print}
methods documented here. In addition to the \code{print} methods, both of
the result objects have \code{\link{get_unitizer}} methods so that you can
retrieve the stored \code{unitizer} objects.

Please note that with \code{unitize_dir} you can re-review a single
\code{unitizer} several times during during a single call to
\code{unitize_dir}.  This is to allow you to re-evaluate specific
\code{unitizers} easily without having to re-run the entire directory again.
Unfortunately, as a result of this feature, the return values of
\code{unitize_dir} can be misleading because they only report the result of
the last review cycle.

Additionally, \code{unitize_dir} will report user selections during the last
review even if in the end the user chose not to save the modified
\code{unitizer}.  You will be alerted to this by an onscreen message from the
\code{print} method (this is tracked in the "updated" attribute of the
\code{unitizer_result} object).  Finally, if in the last iteration before
exit you did not save the \code{unitizer}, but you did save it in  previous
review cycles in the same \code{unitize_dir} call, the displayed selections
and test outcomes will correspond to the last unsaved iteration, not the
one that was saved.  You will be alerted to this by an on-screen message
(this is tracked through the "updated.at.least.once" attribute of the
\code{unitizer_result} object).
}
\seealso{
\code{\link{unitize}}, \code{\link{get_unitizer}}
}
