% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsity.R
\name{sparsity}
\alias{sparsity}
\title{Calculate sparsity of data frames, matrices, and sparse matrices}
\usage{
sparsity(x, sample = NULL)
}
\arguments{
\item{x}{a data frame, matrix of sparse matrix.}

\item{sample}{a integer or \code{NULL}. Number of rows to sample to estimate
sparsity. If \code{NULL} then no sampling is performed. Will not be used when
\code{x} is a sparse matrix. Defaults to \code{NULL}.}
}
\value{
a single number, between 0 and 1.
}
\description{
Turning data frame with sparse columns into sparse matrix using
\code{\link[Matrix:sparseMatrix]{Matrix::sparseMatrix()}}.
}
\details{
Only numeric 0s are considered zeroes in this calculations. Missing values,
logical vectors and then string \code{"0"} aren't counted.
}
\examples{

# data frame
sparsity(mtcars)

# Matrix
set.seed(1234)
mat <- matrix(sample(0:1, 100, TRUE, c(0.9, 0.1)), nrow = 10)
colnames(mat) <- letters[1:10]

sparsity(mat)

# Sparse matrix
sparse_mat <- Matrix::Matrix(mat, sparse = TRUE)

sparsity(sparse_mat)
}
