% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/system.R
\name{ps_tty_size}
\alias{ps_tty_size}
\title{Query the size of the current terminal}
\usage{
ps_tty_size()
}
\description{
If the standard output of the current R process is not a terminal,
e.g. because it is redirected to a file, or the R process is running in
a GUI, then it will throw an error. You need to handle this error if
you want to use this function in a package.
}
\details{
If an error happens, the error message is different depending on
what type of device the standard output is. Some common error messages
are:
\itemize{
\item "Inappropriate ioctl for device."
\item "Operation not supported on socket."
\item "Operation not supported by device."
}

Whatever the error message, \code{ps_tty_size} always fails with an error of
class \code{ps_unknown_tty_size}, which you can catch.
}
\examples{
# An example that falls back to the 'width' option
tryCatch(
  ps_tty_size(),
  ps_unknown_tty_size = function(err) {
    c(width = getOption("width"), height = NA_integer_)
  }
)
}
