% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverage_fraction.R
\name{coverage_fraction}
\alias{coverage_fraction}
\alias{coverage_fraction,RasterLayer,sf-method}
\alias{coverage_fraction,RasterLayer,sfc_MULTIPOLYGON-method}
\alias{coverage_fraction,RasterLayer,sfc_POLYGON-method}
\alias{coverage_fraction,SpatRaster,sf-method}
\alias{coverage_fraction,SpatRaster,sfc_MULTIPOLYGON-method}
\alias{coverage_fraction,SpatRaster,sfc_POLYGON-method}
\title{Compute the fraction of raster cells covered by a polygon}
\usage{
\S4method{coverage_fraction}{RasterLayer,sf}(x, y, crop = FALSE)

\S4method{coverage_fraction}{RasterLayer,sfc_MULTIPOLYGON}(x, y, crop)

\S4method{coverage_fraction}{RasterLayer,sfc_POLYGON}(x, y, crop)

\S4method{coverage_fraction}{SpatRaster,sf}(x, y, crop = FALSE)

\S4method{coverage_fraction}{SpatRaster,sfc_MULTIPOLYGON}(x, y, crop)

\S4method{coverage_fraction}{SpatRaster,sfc_POLYGON}(x, y, crop)
}
\arguments{
\item{x}{a (possibly empty) \code{RasterLayer} whose resolution and
extent will be used for the generated \code{RasterLayer}.}

\item{y}{a \code{sf} object with polygonal geometries}

\item{crop}{if \code{TRUE}, each generated \code{RasterLayer} will be
cropped to the extent of its associated feature.}
}
\value{
a list with a \code{RasterLayer} for each feature in \code{y}.
           Values of the raster represent the fraction of each
           cell in \code{x} that is covered by \code{y}.
}
\description{
Compute the fraction of raster cells covered by a polygon
}
\examples{
rast <- raster::raster(matrix(1:100, ncol=10), xmn=0, ymn=0, xmx=10, ymx=10)
poly <- sf::st_as_sfc('POLYGON ((2 2, 7 6, 4 9, 2 2))')

cov_frac <- coverage_fraction(rast, poly)[[1]]
}
