/* SPDX-License-Identifier: MIT */
/*
 * LoongArch instruction formats, opcodes, and encoders for TCG use.
 *
 * This file is auto-generated by genqemutcgdefs from
 * https://github.com/loongson-community/loongarch-opcodes,
 * from commit 7f353fb69bd99ce6edfad7ad63948c4bb526f0bf.
 * DO NOT EDIT.
 */

typedef enum {
    OPC_MOVGR2SCR = 0x00000800,
    OPC_MOVSCR2GR = 0x00000c00,
    OPC_CLZ_W = 0x00001400,
    OPC_CTZ_W = 0x00001c00,
    OPC_CLZ_D = 0x00002400,
    OPC_CTZ_D = 0x00002c00,
    OPC_REVB_2H = 0x00003000,
    OPC_REVB_2W = 0x00003800,
    OPC_REVB_D = 0x00003c00,
    OPC_SEXT_H = 0x00005800,
    OPC_SEXT_B = 0x00005c00,
    OPC_ADD_W = 0x00100000,
    OPC_ADD_D = 0x00108000,
    OPC_SUB_W = 0x00110000,
    OPC_SUB_D = 0x00118000,
    OPC_SLT = 0x00120000,
    OPC_SLTU = 0x00128000,
    OPC_MASKEQZ = 0x00130000,
    OPC_MASKNEZ = 0x00138000,
    OPC_NOR = 0x00140000,
    OPC_AND = 0x00148000,
    OPC_OR = 0x00150000,
    OPC_XOR = 0x00158000,
    OPC_ORN = 0x00160000,
    OPC_ANDN = 0x00168000,
    OPC_SLL_W = 0x00170000,
    OPC_SRL_W = 0x00178000,
    OPC_SRA_W = 0x00180000,
    OPC_SLL_D = 0x00188000,
    OPC_SRL_D = 0x00190000,
    OPC_SRA_D = 0x00198000,
    OPC_ROTR_B = 0x001a0000,
    OPC_ROTR_H = 0x001a8000,
    OPC_ROTR_W = 0x001b0000,
    OPC_ROTR_D = 0x001b8000,
    OPC_MUL_W = 0x001c0000,
    OPC_MULH_W = 0x001c8000,
    OPC_MULH_WU = 0x001d0000,
    OPC_MUL_D = 0x001d8000,
    OPC_MULH_D = 0x001e0000,
    OPC_MULH_DU = 0x001e8000,
    OPC_DIV_W = 0x00200000,
    OPC_MOD_W = 0x00208000,
    OPC_DIV_WU = 0x00210000,
    OPC_MOD_WU = 0x00218000,
    OPC_DIV_D = 0x00220000,
    OPC_MOD_D = 0x00228000,
    OPC_DIV_DU = 0x00230000,
    OPC_MOD_DU = 0x00238000,
    OPC_SLLI_W = 0x00408000,
    OPC_SLLI_D = 0x00410000,
    OPC_SRLI_W = 0x00448000,
    OPC_SRLI_D = 0x00450000,
    OPC_SRAI_W = 0x00488000,
    OPC_SRAI_D = 0x00490000,
    OPC_ROTRI_B = 0x004c2000,
    OPC_ROTRI_H = 0x004c4000,
    OPC_ROTRI_W = 0x004c8000,
    OPC_ROTRI_D = 0x004d0000,
    OPC_BSTRINS_W = 0x00600000,
    OPC_BSTRPICK_W = 0x00608000,
    OPC_BSTRINS_D = 0x00800000,
    OPC_BSTRPICK_D = 0x00c00000,
    OPC_FMOV_D = 0x01149800,
    OPC_MOVGR2FR_D = 0x0114a800,
    OPC_MOVFR2GR_D = 0x0114b800,
    OPC_SLTI = 0x02000000,
    OPC_SLTUI = 0x02400000,
    OPC_ADDI_W = 0x02800000,
    OPC_ADDI_D = 0x02c00000,
    OPC_CU52I_D = 0x03000000,
    OPC_ANDI = 0x03400000,
    OPC_ORI = 0x03800000,
    OPC_XORI = 0x03c00000,
    OPC_VBITSEL_V = 0x0d100000,
    OPC_XVBITSEL_V = 0x0d200000,
    OPC_VSHUF_B = 0x0d500000,
    OPC_XVSHUF_B = 0x0d600000,
    OPC_ADDU16I_D = 0x10000000,
    OPC_LU12I_W = 0x14000000,
    OPC_CU32I_D = 0x16000000,
    OPC_PCADDU2I = 0x18000000,
    OPC_PCALAU12I = 0x1a000000,
    OPC_PCADDU12I = 0x1c000000,
    OPC_PCADDU18I = 0x1e000000,
    OPC_LD_B = 0x28000000,
    OPC_LD_H = 0x28400000,
    OPC_LD_W = 0x28800000,
    OPC_LD_D = 0x28c00000,
    OPC_ST_B = 0x29000000,
    OPC_ST_H = 0x29400000,
    OPC_ST_W = 0x29800000,
    OPC_ST_D = 0x29c00000,
    OPC_LD_BU = 0x2a000000,
    OPC_LD_HU = 0x2a400000,
    OPC_LD_WU = 0x2a800000,
    OPC_FLD_S = 0x2b000000,
    OPC_FST_S = 0x2b400000,
    OPC_FLD_D = 0x2b800000,
    OPC_FST_D = 0x2bc00000,
    OPC_VLD = 0x2c000000,
    OPC_VST = 0x2c400000,
    OPC_XVLD = 0x2c800000,
    OPC_XVST = 0x2cc00000,
    OPC_VLDREPL_D = 0x30100000,
    OPC_VLDREPL_W = 0x30200000,
    OPC_VLDREPL_H = 0x30400000,
    OPC_VLDREPL_B = 0x30800000,
    OPC_VSTELM_D = 0x31100000,
    OPC_VSTELM_W = 0x31200000,
    OPC_VSTELM_H = 0x31400000,
    OPC_VSTELM_B = 0x31800000,
    OPC_XVLDREPL_D = 0x32100000,
    OPC_XVLDREPL_W = 0x32200000,
    OPC_XVLDREPL_H = 0x32400000,
    OPC_XVLDREPL_B = 0x32800000,
    OPC_XVSTELM_D = 0x33100000,
    OPC_XVSTELM_W = 0x33200000,
    OPC_XVSTELM_H = 0x33400000,
    OPC_XVSTELM_B = 0x33800000,
    OPC_LDX_B = 0x38000000,
    OPC_LDX_H = 0x38040000,
    OPC_LDX_W = 0x38080000,
    OPC_LDX_D = 0x380c0000,
    OPC_STX_B = 0x38100000,
    OPC_STX_H = 0x38140000,
    OPC_STX_W = 0x38180000,
    OPC_STX_D = 0x381c0000,
    OPC_LDX_BU = 0x38200000,
    OPC_LDX_HU = 0x38240000,
    OPC_LDX_WU = 0x38280000,
    OPC_FLDX_S = 0x38300000,
    OPC_FLDX_D = 0x38340000,
    OPC_FSTX_S = 0x38380000,
    OPC_FSTX_D = 0x383c0000,
    OPC_VLDX = 0x38400000,
    OPC_VSTX = 0x38440000,
    OPC_XVLDX = 0x38480000,
    OPC_XVSTX = 0x384c0000,
    OPC_DBAR = 0x38720000,
    OPC_JISCR0 = 0x48000200,
    OPC_JISCR1 = 0x48000300,
    OPC_JIRL = 0x4c000000,
    OPC_B = 0x50000000,
    OPC_BL = 0x54000000,
    OPC_BEQ = 0x58000000,
    OPC_BNE = 0x5c000000,
    OPC_BGT = 0x60000000,
    OPC_BLE = 0x64000000,
    OPC_BGTU = 0x68000000,
    OPC_BLEU = 0x6c000000,
    OPC_VSEQ_B = 0x70000000,
    OPC_VSEQ_H = 0x70008000,
    OPC_VSEQ_W = 0x70010000,
    OPC_VSEQ_D = 0x70018000,
    OPC_VSLE_B = 0x70020000,
    OPC_VSLE_H = 0x70028000,
    OPC_VSLE_W = 0x70030000,
    OPC_VSLE_D = 0x70038000,
    OPC_VSLE_BU = 0x70040000,
    OPC_VSLE_HU = 0x70048000,
    OPC_VSLE_WU = 0x70050000,
    OPC_VSLE_DU = 0x70058000,
    OPC_VSLT_B = 0x70060000,
    OPC_VSLT_H = 0x70068000,
    OPC_VSLT_W = 0x70070000,
    OPC_VSLT_D = 0x70078000,
    OPC_VSLT_BU = 0x70080000,
    OPC_VSLT_HU = 0x70088000,
    OPC_VSLT_WU = 0x70090000,
    OPC_VSLT_DU = 0x70098000,
    OPC_VADD_B = 0x700a0000,
    OPC_VADD_H = 0x700a8000,
    OPC_VADD_W = 0x700b0000,
    OPC_VADD_D = 0x700b8000,
    OPC_VSUB_B = 0x700c0000,
    OPC_VSUB_H = 0x700c8000,
    OPC_VSUB_W = 0x700d0000,
    OPC_VSUB_D = 0x700d8000,
    OPC_VSADD_B = 0x70460000,
    OPC_VSADD_H = 0x70468000,
    OPC_VSADD_W = 0x70470000,
    OPC_VSADD_D = 0x70478000,
    OPC_VSSUB_B = 0x70480000,
    OPC_VSSUB_H = 0x70488000,
    OPC_VSSUB_W = 0x70490000,
    OPC_VSSUB_D = 0x70498000,
    OPC_VSADD_BU = 0x704a0000,
    OPC_VSADD_HU = 0x704a8000,
    OPC_VSADD_WU = 0x704b0000,
    OPC_VSADD_DU = 0x704b8000,
    OPC_VSSUB_BU = 0x704c0000,
    OPC_VSSUB_HU = 0x704c8000,
    OPC_VSSUB_WU = 0x704d0000,
    OPC_VSSUB_DU = 0x704d8000,
    OPC_VMAX_B = 0x70700000,
    OPC_VMAX_H = 0x70708000,
    OPC_VMAX_W = 0x70710000,
    OPC_VMAX_D = 0x70718000,
    OPC_VMIN_B = 0x70720000,
    OPC_VMIN_H = 0x70728000,
    OPC_VMIN_W = 0x70730000,
    OPC_VMIN_D = 0x70738000,
    OPC_VMAX_BU = 0x70740000,
    OPC_VMAX_HU = 0x70748000,
    OPC_VMAX_WU = 0x70750000,
    OPC_VMAX_DU = 0x70758000,
    OPC_VMIN_BU = 0x70760000,
    OPC_VMIN_HU = 0x70768000,
    OPC_VMIN_WU = 0x70770000,
    OPC_VMIN_DU = 0x70778000,
    OPC_VMUL_B = 0x70840000,
    OPC_VMUL_H = 0x70848000,
    OPC_VMUL_W = 0x70850000,
    OPC_VMUL_D = 0x70858000,
    OPC_VSLL_B = 0x70e80000,
    OPC_VSLL_H = 0x70e88000,
    OPC_VSLL_W = 0x70e90000,
    OPC_VSLL_D = 0x70e98000,
    OPC_VSRL_B = 0x70ea0000,
    OPC_VSRL_H = 0x70ea8000,
    OPC_VSRL_W = 0x70eb0000,
    OPC_VSRL_D = 0x70eb8000,
    OPC_VSRA_B = 0x70ec0000,
    OPC_VSRA_H = 0x70ec8000,
    OPC_VSRA_W = 0x70ed0000,
    OPC_VSRA_D = 0x70ed8000,
    OPC_VROTR_B = 0x70ee0000,
    OPC_VROTR_H = 0x70ee8000,
    OPC_VROTR_W = 0x70ef0000,
    OPC_VROTR_D = 0x70ef8000,
    OPC_VREPLVE_B = 0x71220000,
    OPC_VREPLVE_H = 0x71228000,
    OPC_VREPLVE_W = 0x71230000,
    OPC_VREPLVE_D = 0x71238000,
    OPC_VAND_V = 0x71260000,
    OPC_VOR_V = 0x71268000,
    OPC_VXOR_V = 0x71270000,
    OPC_VNOR_V = 0x71278000,
    OPC_VANDN_V = 0x71280000,
    OPC_VORN_V = 0x71288000,
    OPC_VSEQI_B = 0x72800000,
    OPC_VSEQI_H = 0x72808000,
    OPC_VSEQI_W = 0x72810000,
    OPC_VSEQI_D = 0x72818000,
    OPC_VSLEI_B = 0x72820000,
    OPC_VSLEI_H = 0x72828000,
    OPC_VSLEI_W = 0x72830000,
    OPC_VSLEI_D = 0x72838000,
    OPC_VSLEI_BU = 0x72840000,
    OPC_VSLEI_HU = 0x72848000,
    OPC_VSLEI_WU = 0x72850000,
    OPC_VSLEI_DU = 0x72858000,
    OPC_VSLTI_B = 0x72860000,
    OPC_VSLTI_H = 0x72868000,
    OPC_VSLTI_W = 0x72870000,
    OPC_VSLTI_D = 0x72878000,
    OPC_VSLTI_BU = 0x72880000,
    OPC_VSLTI_HU = 0x72888000,
    OPC_VSLTI_WU = 0x72890000,
    OPC_VSLTI_DU = 0x72898000,
    OPC_VADDI_BU = 0x728a0000,
    OPC_VADDI_HU = 0x728a8000,
    OPC_VADDI_WU = 0x728b0000,
    OPC_VADDI_DU = 0x728b8000,
    OPC_VSUBI_BU = 0x728c0000,
    OPC_VSUBI_HU = 0x728c8000,
    OPC_VSUBI_WU = 0x728d0000,
    OPC_VSUBI_DU = 0x728d8000,
    OPC_VMAXI_B = 0x72900000,
    OPC_VMAXI_H = 0x72908000,
    OPC_VMAXI_W = 0x72910000,
    OPC_VMAXI_D = 0x72918000,
    OPC_VMINI_B = 0x72920000,
    OPC_VMINI_H = 0x72928000,
    OPC_VMINI_W = 0x72930000,
    OPC_VMINI_D = 0x72938000,
    OPC_VMAXI_BU = 0x72940000,
    OPC_VMAXI_HU = 0x72948000,
    OPC_VMAXI_WU = 0x72950000,
    OPC_VMAXI_DU = 0x72958000,
    OPC_VMINI_BU = 0x72960000,
    OPC_VMINI_HU = 0x72968000,
    OPC_VMINI_WU = 0x72970000,
    OPC_VMINI_DU = 0x72978000,
    OPC_VNEG_B = 0x729c3000,
    OPC_VNEG_H = 0x729c3400,
    OPC_VNEG_W = 0x729c3800,
    OPC_VNEG_D = 0x729c3c00,
    OPC_VREPLGR2VR_B = 0x729f0000,
    OPC_VREPLGR2VR_H = 0x729f0400,
    OPC_VREPLGR2VR_W = 0x729f0800,
    OPC_VREPLGR2VR_D = 0x729f0c00,
    OPC_VROTRI_B = 0x72a02000,
    OPC_VROTRI_H = 0x72a04000,
    OPC_VROTRI_W = 0x72a08000,
    OPC_VROTRI_D = 0x72a10000,
    OPC_VINSGR2VR_B = 0x72eb8000,
    OPC_VINSGR2VR_H = 0x72ebc000,
    OPC_VINSGR2VR_W = 0x72ebe000,
    OPC_VINSGR2VR_D = 0x72ebf000,
    OPC_VPICKVE2GR_B = 0x72ef8000,
    OPC_VPICKVE2GR_H = 0x72efc000,
    OPC_VPICKVE2GR_W = 0x72efe000,
    OPC_VPICKVE2GR_D = 0x72eff000,
    OPC_VPICKVE2GR_BU = 0x72f38000,
    OPC_VPICKVE2GR_HU = 0x72f3c000,
    OPC_VPICKVE2GR_WU = 0x72f3e000,
    OPC_VPICKVE2GR_DU = 0x72f3f000,
    OPC_VREPLVEI_B = 0x72f78000,
    OPC_VREPLVEI_H = 0x72f7c000,
    OPC_VREPLVEI_W = 0x72f7e000,
    OPC_VREPLVEI_D = 0x72f7f000,
    OPC_VBITCLRI_B = 0x73102000,
    OPC_VBITCLRI_H = 0x73104000,
    OPC_VBITCLRI_W = 0x73108000,
    OPC_VBITCLRI_D = 0x73110000,
    OPC_VBITSETI_B = 0x73142000,
    OPC_VBITSETI_H = 0x73144000,
    OPC_VBITSETI_W = 0x73148000,
    OPC_VBITSETI_D = 0x73150000,
    OPC_VBITREVI_B = 0x73182000,
    OPC_VBITREVI_H = 0x73184000,
    OPC_VBITREVI_W = 0x73188000,
    OPC_VBITREVI_D = 0x73190000,
    OPC_VSLLI_B = 0x732c2000,
    OPC_VSLLI_H = 0x732c4000,
    OPC_VSLLI_W = 0x732c8000,
    OPC_VSLLI_D = 0x732d0000,
    OPC_VSRLI_B = 0x73302000,
    OPC_VSRLI_H = 0x73304000,
    OPC_VSRLI_W = 0x73308000,
    OPC_VSRLI_D = 0x73310000,
    OPC_VSRAI_B = 0x73342000,
    OPC_VSRAI_H = 0x73344000,
    OPC_VSRAI_W = 0x73348000,
    OPC_VSRAI_D = 0x73350000,
    OPC_VBITSELI_B = 0x73c40000,
    OPC_VANDI_B = 0x73d00000,
    OPC_VORI_B = 0x73d40000,
    OPC_VXORI_B = 0x73d80000,
    OPC_VNORI_B = 0x73dc0000,
    OPC_VLDI = 0x73e00000,
    OPC_XVSEQ_B = 0x74000000,
    OPC_XVSEQ_H = 0x74008000,
    OPC_XVSEQ_W = 0x74010000,
    OPC_XVSEQ_D = 0x74018000,
    OPC_XVSLE_B = 0x74020000,
    OPC_XVSLE_H = 0x74028000,
    OPC_XVSLE_W = 0x74030000,
    OPC_XVSLE_D = 0x74038000,
    OPC_XVSLE_BU = 0x74040000,
    OPC_XVSLE_HU = 0x74048000,
    OPC_XVSLE_WU = 0x74050000,
    OPC_XVSLE_DU = 0x74058000,
    OPC_XVSLT_B = 0x74060000,
    OPC_XVSLT_H = 0x74068000,
    OPC_XVSLT_W = 0x74070000,
    OPC_XVSLT_D = 0x74078000,
    OPC_XVSLT_BU = 0x74080000,
    OPC_XVSLT_HU = 0x74088000,
    OPC_XVSLT_WU = 0x74090000,
    OPC_XVSLT_DU = 0x74098000,
    OPC_XVADD_B = 0x740a0000,
    OPC_XVADD_H = 0x740a8000,
    OPC_XVADD_W = 0x740b0000,
    OPC_XVADD_D = 0x740b8000,
    OPC_XVSUB_B = 0x740c0000,
    OPC_XVSUB_H = 0x740c8000,
    OPC_XVSUB_W = 0x740d0000,
    OPC_XVSUB_D = 0x740d8000,
    OPC_XVSADD_B = 0x74460000,
    OPC_XVSADD_H = 0x74468000,
    OPC_XVSADD_W = 0x74470000,
    OPC_XVSADD_D = 0x74478000,
    OPC_XVSSUB_B = 0x74480000,
    OPC_XVSSUB_H = 0x74488000,
    OPC_XVSSUB_W = 0x74490000,
    OPC_XVSSUB_D = 0x74498000,
    OPC_XVSADD_BU = 0x744a0000,
    OPC_XVSADD_HU = 0x744a8000,
    OPC_XVSADD_WU = 0x744b0000,
    OPC_XVSADD_DU = 0x744b8000,
    OPC_XVSSUB_BU = 0x744c0000,
    OPC_XVSSUB_HU = 0x744c8000,
    OPC_XVSSUB_WU = 0x744d0000,
    OPC_XVSSUB_DU = 0x744d8000,
    OPC_XVMAX_B = 0x74700000,
    OPC_XVMAX_H = 0x74708000,
    OPC_XVMAX_W = 0x74710000,
    OPC_XVMAX_D = 0x74718000,
    OPC_XVMIN_B = 0x74720000,
    OPC_XVMIN_H = 0x74728000,
    OPC_XVMIN_W = 0x74730000,
    OPC_XVMIN_D = 0x74738000,
    OPC_XVMAX_BU = 0x74740000,
    OPC_XVMAX_HU = 0x74748000,
    OPC_XVMAX_WU = 0x74750000,
    OPC_XVMAX_DU = 0x74758000,
    OPC_XVMIN_BU = 0x74760000,
    OPC_XVMIN_HU = 0x74768000,
    OPC_XVMIN_WU = 0x74770000,
    OPC_XVMIN_DU = 0x74778000,
    OPC_XVMUL_B = 0x74840000,
    OPC_XVMUL_H = 0x74848000,
    OPC_XVMUL_W = 0x74850000,
    OPC_XVMUL_D = 0x74858000,
    OPC_XVSLL_B = 0x74e80000,
    OPC_XVSLL_H = 0x74e88000,
    OPC_XVSLL_W = 0x74e90000,
    OPC_XVSLL_D = 0x74e98000,
    OPC_XVSRL_B = 0x74ea0000,
    OPC_XVSRL_H = 0x74ea8000,
    OPC_XVSRL_W = 0x74eb0000,
    OPC_XVSRL_D = 0x74eb8000,
    OPC_XVSRA_B = 0x74ec0000,
    OPC_XVSRA_H = 0x74ec8000,
    OPC_XVSRA_W = 0x74ed0000,
    OPC_XVSRA_D = 0x74ed8000,
    OPC_XVROTR_B = 0x74ee0000,
    OPC_XVROTR_H = 0x74ee8000,
    OPC_XVROTR_W = 0x74ef0000,
    OPC_XVROTR_D = 0x74ef8000,
    OPC_XVREPLVE_B = 0x75220000,
    OPC_XVREPLVE_H = 0x75228000,
    OPC_XVREPLVE_W = 0x75230000,
    OPC_XVREPLVE_D = 0x75238000,
    OPC_XVAND_V = 0x75260000,
    OPC_XVOR_V = 0x75268000,
    OPC_XVXOR_V = 0x75270000,
    OPC_XVNOR_V = 0x75278000,
    OPC_XVANDN_V = 0x75280000,
    OPC_XVORN_V = 0x75288000,
    OPC_XVSEQI_B = 0x76800000,
    OPC_XVSEQI_H = 0x76808000,
    OPC_XVSEQI_W = 0x76810000,
    OPC_XVSEQI_D = 0x76818000,
    OPC_XVSLEI_B = 0x76820000,
    OPC_XVSLEI_H = 0x76828000,
    OPC_XVSLEI_W = 0x76830000,
    OPC_XVSLEI_D = 0x76838000,
    OPC_XVSLEI_BU = 0x76840000,
    OPC_XVSLEI_HU = 0x76848000,
    OPC_XVSLEI_WU = 0x76850000,
    OPC_XVSLEI_DU = 0x76858000,
    OPC_XVSLTI_B = 0x76860000,
    OPC_XVSLTI_H = 0x76868000,
    OPC_XVSLTI_W = 0x76870000,
    OPC_XVSLTI_D = 0x76878000,
    OPC_XVSLTI_BU = 0x76880000,
    OPC_XVSLTI_HU = 0x76888000,
    OPC_XVSLTI_WU = 0x76890000,
    OPC_XVSLTI_DU = 0x76898000,
    OPC_XVADDI_BU = 0x768a0000,
    OPC_XVADDI_HU = 0x768a8000,
    OPC_XVADDI_WU = 0x768b0000,
    OPC_XVADDI_DU = 0x768b8000,
    OPC_XVSUBI_BU = 0x768c0000,
    OPC_XVSUBI_HU = 0x768c8000,
    OPC_XVSUBI_WU = 0x768d0000,
    OPC_XVSUBI_DU = 0x768d8000,
    OPC_XVMAXI_B = 0x76900000,
    OPC_XVMAXI_H = 0x76908000,
    OPC_XVMAXI_W = 0x76910000,
    OPC_XVMAXI_D = 0x76918000,
    OPC_XVMINI_B = 0x76920000,
    OPC_XVMINI_H = 0x76928000,
    OPC_XVMINI_W = 0x76930000,
    OPC_XVMINI_D = 0x76938000,
    OPC_XVMAXI_BU = 0x76940000,
    OPC_XVMAXI_HU = 0x76948000,
    OPC_XVMAXI_WU = 0x76950000,
    OPC_XVMAXI_DU = 0x76958000,
    OPC_XVMINI_BU = 0x76960000,
    OPC_XVMINI_HU = 0x76968000,
    OPC_XVMINI_WU = 0x76970000,
    OPC_XVMINI_DU = 0x76978000,
    OPC_XVNEG_B = 0x769c3000,
    OPC_XVNEG_H = 0x769c3400,
    OPC_XVNEG_W = 0x769c3800,
    OPC_XVNEG_D = 0x769c3c00,
    OPC_XVREPLGR2VR_B = 0x769f0000,
    OPC_XVREPLGR2VR_H = 0x769f0400,
    OPC_XVREPLGR2VR_W = 0x769f0800,
    OPC_XVREPLGR2VR_D = 0x769f0c00,
    OPC_XVROTRI_B = 0x76a02000,
    OPC_XVROTRI_H = 0x76a04000,
    OPC_XVROTRI_W = 0x76a08000,
    OPC_XVROTRI_D = 0x76a10000,
    OPC_XVINSGR2VR_W = 0x76ebc000,
    OPC_XVINSGR2VR_D = 0x76ebe000,
    OPC_XVPICKVE2GR_W = 0x76efc000,
    OPC_XVPICKVE2GR_D = 0x76efe000,
    OPC_XVPICKVE2GR_WU = 0x76f3c000,
    OPC_XVPICKVE2GR_DU = 0x76f3e000,
    OPC_XVREPL128VEI_B = 0x76f78000,
    OPC_XVREPL128VEI_H = 0x76f7c000,
    OPC_XVREPL128VEI_W = 0x76f7e000,
    OPC_XVREPL128VEI_D = 0x76f7f000,
    OPC_XVREPLVE0_B = 0x77070000,
    OPC_XVREPLVE0_H = 0x77078000,
    OPC_XVREPLVE0_W = 0x7707c000,
    OPC_XVREPLVE0_D = 0x7707e000,
    OPC_XVREPLVE0_Q = 0x7707f000,
    OPC_XVBITCLRI_B = 0x77102000,
    OPC_XVBITCLRI_H = 0x77104000,
    OPC_XVBITCLRI_W = 0x77108000,
    OPC_XVBITCLRI_D = 0x77110000,
    OPC_XVBITSETI_B = 0x77142000,
    OPC_XVBITSETI_H = 0x77144000,
    OPC_XVBITSETI_W = 0x77148000,
    OPC_XVBITSETI_D = 0x77150000,
    OPC_XVBITREVI_B = 0x77182000,
    OPC_XVBITREVI_H = 0x77184000,
    OPC_XVBITREVI_W = 0x77188000,
    OPC_XVBITREVI_D = 0x77190000,
    OPC_XVSLLI_B = 0x772c2000,
    OPC_XVSLLI_H = 0x772c4000,
    OPC_XVSLLI_W = 0x772c8000,
    OPC_XVSLLI_D = 0x772d0000,
    OPC_XVSRLI_B = 0x77302000,
    OPC_XVSRLI_H = 0x77304000,
    OPC_XVSRLI_W = 0x77308000,
    OPC_XVSRLI_D = 0x77310000,
    OPC_XVSRAI_B = 0x77342000,
    OPC_XVSRAI_H = 0x77344000,
    OPC_XVSRAI_W = 0x77348000,
    OPC_XVSRAI_D = 0x77350000,
    OPC_XVBITSELI_B = 0x77c40000,
    OPC_XVANDI_B = 0x77d00000,
    OPC_XVORI_B = 0x77d40000,
    OPC_XVXORI_B = 0x77d80000,
    OPC_XVNORI_B = 0x77dc0000,
    OPC_XVLDI = 0x77e00000,
} LoongArchInsn;

static int32_t __attribute__((unused))
encode_d_slot(LoongArchInsn opc, uint32_t d)
{
    return opc | d;
}

static int32_t __attribute__((unused))
encode_dj_slots(LoongArchInsn opc, uint32_t d, uint32_t j)
{
    return opc | d | j << 5;
}

static int32_t __attribute__((unused))
encode_djk_slots(LoongArchInsn opc, uint32_t d, uint32_t j, uint32_t k)
{
    return opc | d | j << 5 | k << 10;
}

static int32_t __attribute__((unused))
encode_djka_slots(LoongArchInsn opc, uint32_t d, uint32_t j, uint32_t k,
                  uint32_t a)
{
    return opc | d | j << 5 | k << 10 | a << 15;
}

static int32_t __attribute__((unused))
encode_djkm_slots(LoongArchInsn opc, uint32_t d, uint32_t j, uint32_t k,
                  uint32_t m)
{
    return opc | d | j << 5 | k << 10 | m << 16;
}

static int32_t __attribute__((unused))
encode_djkn_slots(LoongArchInsn opc, uint32_t d, uint32_t j, uint32_t k,
                  uint32_t n)
{
    return opc | d | j << 5 | k << 10 | n << 18;
}

static int32_t __attribute__((unused))
encode_dk_slots(LoongArchInsn opc, uint32_t d, uint32_t k)
{
    return opc | d | k << 10;
}

static int32_t __attribute__((unused))
encode_dfj_insn(LoongArchInsn opc, TCGReg d, TCGReg fj)
{
    tcg_debug_assert(d >= 0 && d <= 0x1f);
    tcg_debug_assert(fj >= 0x20 && fj <= 0x3f);
    return encode_dj_slots(opc, d, fj & 0x1f);
}

static int32_t __attribute__((unused))
encode_dj_insn(LoongArchInsn opc, TCGReg d, TCGReg j)
{
    tcg_debug_assert(d >= 0 && d <= 0x1f);
    tcg_debug_assert(j >= 0 && j <= 0x1f);
    return encode_dj_slots(opc, d, j);
}

static int32_t __attribute__((unused))
encode_djk_insn(LoongArchInsn opc, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_debug_assert(d >= 0 && d <= 0x1f);
    tcg_debug_assert(j >= 0 && j <= 0x1f);
    tcg_debug_assert(k >= 0 && k <= 0x1f);
    return encode_djk_slots(opc, d, j, k);
}

static int32_t __attribute__((unused))
encode_djsk12_insn(LoongArchInsn opc, TCGReg d, TCGReg j, int32_t sk12)
{
    tcg_debug_assert(d >= 0 && d <= 0x1f);
    tcg_debug_assert(j >= 0 && j <= 0x1f);
    tcg_debug_assert(sk12 >= -0x800 && sk12 <= 0x7ff);
    return encode_djk_slots(opc, d, j, sk12 & 0xfff);
}

static int32_t __attribute__((unused))
encode_djsk16_insn(LoongArchInsn opc, TCGReg d, TCGReg j, int32_t sk16)
{
    tcg_debug_assert(d >= 0 && d <= 0x1f);
    tcg_debug_assert(j >= 0 && j <= 0x1f);
    tcg_debug_assert(sk16 >= -0x8000 && sk16 <= 0x7fff);
    return encode_djk_slots(opc, d, j, sk16 & 0xffff);
}

static int32_t __attribute__((unused))
encode_djuk12_insn(LoongArchInsn opc, TCGReg d, TCGReg j, uint32_t uk12)
{
    tcg_debug_assert(d >= 0 && d <= 0x1f);
    tcg_debug_assert(j >= 0 && j <= 0x1f);
    tcg_debug_assert(uk12 <= 0xfff);
    return encode_djk_slots(opc, d, j, uk12);
}

static int32_t __attribute__((unused))
encode_djuk3_insn(LoongArchInsn opc, TCGReg d, TCGReg j, uint32_t uk3)
{
    tcg_debug_assert(d >= 0 && d <= 0x1f);
    tcg_debug_assert(j >= 0 && j <= 0x1f);
    tcg_debug_assert(uk3 <= 0x7);
    return encode_djk_slots(opc, d, j, uk3);
}

static int32_t __attribute__((unused))
encode_djuk4_insn(LoongArchInsn opc, TCGReg d, TCGReg j, uint32_t uk4)
{
    tcg_debug_assert(d >= 0 && d <= 0x1f);
    tcg_debug_assert(j >= 0 && j <= 0x1f);
    tcg_debug_assert(uk4 <= 0xf);
    return encode_djk_slots(opc, d, j, uk4);
}

static int32_t __attribute__((unused))
encode_djuk5_insn(LoongArchInsn opc, TCGReg d, TCGReg j, uint32_t uk5)
{
    tcg_debug_assert(d >= 0 && d <= 0x1f);
    tcg_debug_assert(j >= 0 && j <= 0x1f);
    tcg_debug_assert(uk5 <= 0x1f);
    return encode_djk_slots(opc, d, j, uk5);
}

static int32_t __attribute__((unused))
encode_djuk5um5_insn(LoongArchInsn opc, TCGReg d, TCGReg j, uint32_t uk5,
                     uint32_t um5)
{
    tcg_debug_assert(d >= 0 && d <= 0x1f);
    tcg_debug_assert(j >= 0 && j <= 0x1f);
    tcg_debug_assert(uk5 <= 0x1f);
    tcg_debug_assert(um5 <= 0x1f);
    return encode_djkm_slots(opc, d, j, uk5, um5);
}

static int32_t __attribute__((unused))
encode_djuk6_insn(LoongArchInsn opc, TCGReg d, TCGReg j, uint32_t uk6)
{
    tcg_debug_assert(d >= 0 && d <= 0x1f);
    tcg_debug_assert(j >= 0 && j <= 0x1f);
    tcg_debug_assert(uk6 <= 0x3f);
    return encode_djk_slots(opc, d, j, uk6);
}

static int32_t __attribute__((unused))
encode_djuk6um6_insn(LoongArchInsn opc, TCGReg d, TCGReg j, uint32_t uk6,
                     uint32_t um6)
{
    tcg_debug_assert(d >= 0 && d <= 0x1f);
    tcg_debug_assert(j >= 0 && j <= 0x1f);
    tcg_debug_assert(uk6 <= 0x3f);
    tcg_debug_assert(um6 <= 0x3f);
    return encode_djkm_slots(opc, d, j, uk6, um6);
}

static int32_t __attribute__((unused))
encode_dsj20_insn(LoongArchInsn opc, TCGReg d, int32_t sj20)
{
    tcg_debug_assert(d >= 0 && d <= 0x1f);
    tcg_debug_assert(sj20 >= -0x80000 && sj20 <= 0x7ffff);
    return encode_dj_slots(opc, d, sj20 & 0xfffff);
}

static int32_t __attribute__((unused))
encode_dtj_insn(LoongArchInsn opc, TCGReg d, TCGReg tj)
{
    tcg_debug_assert(d >= 0 && d <= 0x1f);
    tcg_debug_assert(tj >= 0 && tj <= 0x3);
    return encode_dj_slots(opc, d, tj);
}

static int32_t __attribute__((unused))
encode_dvjuk1_insn(LoongArchInsn opc, TCGReg d, TCGReg vj, uint32_t uk1)
{
    tcg_debug_assert(d >= 0 && d <= 0x1f);
    tcg_debug_assert(vj >= 0x20 && vj <= 0x3f);
    tcg_debug_assert(uk1 <= 0x1);
    return encode_djk_slots(opc, d, vj & 0x1f, uk1);
}

static int32_t __attribute__((unused))
encode_dvjuk2_insn(LoongArchInsn opc, TCGReg d, TCGReg vj, uint32_t uk2)
{
    tcg_debug_assert(d >= 0 && d <= 0x1f);
    tcg_debug_assert(vj >= 0x20 && vj <= 0x3f);
    tcg_debug_assert(uk2 <= 0x3);
    return encode_djk_slots(opc, d, vj & 0x1f, uk2);
}

static int32_t __attribute__((unused))
encode_dvjuk3_insn(LoongArchInsn opc, TCGReg d, TCGReg vj, uint32_t uk3)
{
    tcg_debug_assert(d >= 0 && d <= 0x1f);
    tcg_debug_assert(vj >= 0x20 && vj <= 0x3f);
    tcg_debug_assert(uk3 <= 0x7);
    return encode_djk_slots(opc, d, vj & 0x1f, uk3);
}

static int32_t __attribute__((unused))
encode_dvjuk4_insn(LoongArchInsn opc, TCGReg d, TCGReg vj, uint32_t uk4)
{
    tcg_debug_assert(d >= 0 && d <= 0x1f);
    tcg_debug_assert(vj >= 0x20 && vj <= 0x3f);
    tcg_debug_assert(uk4 <= 0xf);
    return encode_djk_slots(opc, d, vj & 0x1f, uk4);
}

static int32_t __attribute__((unused))
encode_dxjuk2_insn(LoongArchInsn opc, TCGReg d, TCGReg xj, uint32_t uk2)
{
    tcg_debug_assert(d >= 0 && d <= 0x1f);
    tcg_debug_assert(xj >= 0x20 && xj <= 0x3f);
    tcg_debug_assert(uk2 <= 0x3);
    return encode_djk_slots(opc, d, xj & 0x1f, uk2);
}

static int32_t __attribute__((unused))
encode_dxjuk3_insn(LoongArchInsn opc, TCGReg d, TCGReg xj, uint32_t uk3)
{
    tcg_debug_assert(d >= 0 && d <= 0x1f);
    tcg_debug_assert(xj >= 0x20 && xj <= 0x3f);
    tcg_debug_assert(uk3 <= 0x7);
    return encode_djk_slots(opc, d, xj & 0x1f, uk3);
}

static int32_t __attribute__((unused))
encode_fdfj_insn(LoongArchInsn opc, TCGReg fd, TCGReg fj)
{
    tcg_debug_assert(fd >= 0x20 && fd <= 0x3f);
    tcg_debug_assert(fj >= 0x20 && fj <= 0x3f);
    return encode_dj_slots(opc, fd & 0x1f, fj & 0x1f);
}

static int32_t __attribute__((unused))
encode_fdj_insn(LoongArchInsn opc, TCGReg fd, TCGReg j)
{
    tcg_debug_assert(fd >= 0x20 && fd <= 0x3f);
    tcg_debug_assert(j >= 0 && j <= 0x1f);
    return encode_dj_slots(opc, fd & 0x1f, j);
}

static int32_t __attribute__((unused))
encode_fdjk_insn(LoongArchInsn opc, TCGReg fd, TCGReg j, TCGReg k)
{
    tcg_debug_assert(fd >= 0x20 && fd <= 0x3f);
    tcg_debug_assert(j >= 0 && j <= 0x1f);
    tcg_debug_assert(k >= 0 && k <= 0x1f);
    return encode_djk_slots(opc, fd & 0x1f, j, k);
}

static int32_t __attribute__((unused))
encode_fdjsk12_insn(LoongArchInsn opc, TCGReg fd, TCGReg j, int32_t sk12)
{
    tcg_debug_assert(fd >= 0x20 && fd <= 0x3f);
    tcg_debug_assert(j >= 0 && j <= 0x1f);
    tcg_debug_assert(sk12 >= -0x800 && sk12 <= 0x7ff);
    return encode_djk_slots(opc, fd & 0x1f, j, sk12 & 0xfff);
}

static int32_t __attribute__((unused))
encode_sd10k16_insn(LoongArchInsn opc, int32_t sd10k16)
{
    tcg_debug_assert(sd10k16 >= -0x2000000 && sd10k16 <= 0x1ffffff);
    return encode_dk_slots(opc, (sd10k16 >> 16) & 0x3ff, sd10k16 & 0xffff);
}

static int32_t __attribute__((unused))
encode_sd5k16_insn(LoongArchInsn opc, int32_t sd5k16)
{
    tcg_debug_assert(sd5k16 >= -0x100000 && sd5k16 <= 0xfffff);
    return encode_dk_slots(opc, (sd5k16 >> 16) & 0x1f, sd5k16 & 0xffff);
}

static int32_t __attribute__((unused))
encode_tdj_insn(LoongArchInsn opc, TCGReg td, TCGReg j)
{
    tcg_debug_assert(td >= 0 && td <= 0x3);
    tcg_debug_assert(j >= 0 && j <= 0x1f);
    return encode_dj_slots(opc, td, j);
}

static int32_t __attribute__((unused))
encode_ud15_insn(LoongArchInsn opc, uint32_t ud15)
{
    tcg_debug_assert(ud15 <= 0x7fff);
    return encode_d_slot(opc, ud15);
}

static int32_t __attribute__((unused))
encode_vdj_insn(LoongArchInsn opc, TCGReg vd, TCGReg j)
{
    tcg_debug_assert(vd >= 0x20 && vd <= 0x3f);
    tcg_debug_assert(j >= 0 && j <= 0x1f);
    return encode_dj_slots(opc, vd & 0x1f, j);
}

static int32_t __attribute__((unused))
encode_vdjk_insn(LoongArchInsn opc, TCGReg vd, TCGReg j, TCGReg k)
{
    tcg_debug_assert(vd >= 0x20 && vd <= 0x3f);
    tcg_debug_assert(j >= 0 && j <= 0x1f);
    tcg_debug_assert(k >= 0 && k <= 0x1f);
    return encode_djk_slots(opc, vd & 0x1f, j, k);
}

static int32_t __attribute__((unused))
encode_vdjsk10_insn(LoongArchInsn opc, TCGReg vd, TCGReg j, int32_t sk10)
{
    tcg_debug_assert(vd >= 0x20 && vd <= 0x3f);
    tcg_debug_assert(j >= 0 && j <= 0x1f);
    tcg_debug_assert(sk10 >= -0x200 && sk10 <= 0x1ff);
    return encode_djk_slots(opc, vd & 0x1f, j, sk10 & 0x3ff);
}

static int32_t __attribute__((unused))
encode_vdjsk11_insn(LoongArchInsn opc, TCGReg vd, TCGReg j, int32_t sk11)
{
    tcg_debug_assert(vd >= 0x20 && vd <= 0x3f);
    tcg_debug_assert(j >= 0 && j <= 0x1f);
    tcg_debug_assert(sk11 >= -0x400 && sk11 <= 0x3ff);
    return encode_djk_slots(opc, vd & 0x1f, j, sk11 & 0x7ff);
}

static int32_t __attribute__((unused))
encode_vdjsk12_insn(LoongArchInsn opc, TCGReg vd, TCGReg j, int32_t sk12)
{
    tcg_debug_assert(vd >= 0x20 && vd <= 0x3f);
    tcg_debug_assert(j >= 0 && j <= 0x1f);
    tcg_debug_assert(sk12 >= -0x800 && sk12 <= 0x7ff);
    return encode_djk_slots(opc, vd & 0x1f, j, sk12 & 0xfff);
}

static int32_t __attribute__((unused))
encode_vdjsk8un1_insn(LoongArchInsn opc, TCGReg vd, TCGReg j, int32_t sk8,
                      uint32_t un1)
{
    tcg_debug_assert(vd >= 0x20 && vd <= 0x3f);
    tcg_debug_assert(j >= 0 && j <= 0x1f);
    tcg_debug_assert(sk8 >= -0x80 && sk8 <= 0x7f);
    tcg_debug_assert(un1 <= 0x1);
    return encode_djkn_slots(opc, vd & 0x1f, j, sk8 & 0xff, un1);
}

static int32_t __attribute__((unused))
encode_vdjsk8un2_insn(LoongArchInsn opc, TCGReg vd, TCGReg j, int32_t sk8,
                      uint32_t un2)
{
    tcg_debug_assert(vd >= 0x20 && vd <= 0x3f);
    tcg_debug_assert(j >= 0 && j <= 0x1f);
    tcg_debug_assert(sk8 >= -0x80 && sk8 <= 0x7f);
    tcg_debug_assert(un2 <= 0x3);
    return encode_djkn_slots(opc, vd & 0x1f, j, sk8 & 0xff, un2);
}

static int32_t __attribute__((unused))
encode_vdjsk8un3_insn(LoongArchInsn opc, TCGReg vd, TCGReg j, int32_t sk8,
                      uint32_t un3)
{
    tcg_debug_assert(vd >= 0x20 && vd <= 0x3f);
    tcg_debug_assert(j >= 0 && j <= 0x1f);
    tcg_debug_assert(sk8 >= -0x80 && sk8 <= 0x7f);
    tcg_debug_assert(un3 <= 0x7);
    return encode_djkn_slots(opc, vd & 0x1f, j, sk8 & 0xff, un3);
}

static int32_t __attribute__((unused))
encode_vdjsk8un4_insn(LoongArchInsn opc, TCGReg vd, TCGReg j, int32_t sk8,
                      uint32_t un4)
{
    tcg_debug_assert(vd >= 0x20 && vd <= 0x3f);
    tcg_debug_assert(j >= 0 && j <= 0x1f);
    tcg_debug_assert(sk8 >= -0x80 && sk8 <= 0x7f);
    tcg_debug_assert(un4 <= 0xf);
    return encode_djkn_slots(opc, vd & 0x1f, j, sk8 & 0xff, un4);
}

static int32_t __attribute__((unused))
encode_vdjsk9_insn(LoongArchInsn opc, TCGReg vd, TCGReg j, int32_t sk9)
{
    tcg_debug_assert(vd >= 0x20 && vd <= 0x3f);
    tcg_debug_assert(j >= 0 && j <= 0x1f);
    tcg_debug_assert(sk9 >= -0x100 && sk9 <= 0xff);
    return encode_djk_slots(opc, vd & 0x1f, j, sk9 & 0x1ff);
}

static int32_t __attribute__((unused))
encode_vdjuk1_insn(LoongArchInsn opc, TCGReg vd, TCGReg j, uint32_t uk1)
{
    tcg_debug_assert(vd >= 0x20 && vd <= 0x3f);
    tcg_debug_assert(j >= 0 && j <= 0x1f);
    tcg_debug_assert(uk1 <= 0x1);
    return encode_djk_slots(opc, vd & 0x1f, j, uk1);
}

static int32_t __attribute__((unused))
encode_vdjuk2_insn(LoongArchInsn opc, TCGReg vd, TCGReg j, uint32_t uk2)
{
    tcg_debug_assert(vd >= 0x20 && vd <= 0x3f);
    tcg_debug_assert(j >= 0 && j <= 0x1f);
    tcg_debug_assert(uk2 <= 0x3);
    return encode_djk_slots(opc, vd & 0x1f, j, uk2);
}

static int32_t __attribute__((unused))
encode_vdjuk3_insn(LoongArchInsn opc, TCGReg vd, TCGReg j, uint32_t uk3)
{
    tcg_debug_assert(vd >= 0x20 && vd <= 0x3f);
    tcg_debug_assert(j >= 0 && j <= 0x1f);
    tcg_debug_assert(uk3 <= 0x7);
    return encode_djk_slots(opc, vd & 0x1f, j, uk3);
}

static int32_t __attribute__((unused))
encode_vdjuk4_insn(LoongArchInsn opc, TCGReg vd, TCGReg j, uint32_t uk4)
{
    tcg_debug_assert(vd >= 0x20 && vd <= 0x3f);
    tcg_debug_assert(j >= 0 && j <= 0x1f);
    tcg_debug_assert(uk4 <= 0xf);
    return encode_djk_slots(opc, vd & 0x1f, j, uk4);
}

static int32_t __attribute__((unused))
encode_vdsj13_insn(LoongArchInsn opc, TCGReg vd, int32_t sj13)
{
    tcg_debug_assert(vd >= 0x20 && vd <= 0x3f);
    tcg_debug_assert(sj13 >= -0x1000 && sj13 <= 0xfff);
    return encode_dj_slots(opc, vd & 0x1f, sj13 & 0x1fff);
}

static int32_t __attribute__((unused))
encode_vdvj_insn(LoongArchInsn opc, TCGReg vd, TCGReg vj)
{
    tcg_debug_assert(vd >= 0x20 && vd <= 0x3f);
    tcg_debug_assert(vj >= 0x20 && vj <= 0x3f);
    return encode_dj_slots(opc, vd & 0x1f, vj & 0x1f);
}

static int32_t __attribute__((unused))
encode_vdvjk_insn(LoongArchInsn opc, TCGReg vd, TCGReg vj, TCGReg k)
{
    tcg_debug_assert(vd >= 0x20 && vd <= 0x3f);
    tcg_debug_assert(vj >= 0x20 && vj <= 0x3f);
    tcg_debug_assert(k >= 0 && k <= 0x1f);
    return encode_djk_slots(opc, vd & 0x1f, vj & 0x1f, k);
}

static int32_t __attribute__((unused))
encode_vdvjsk5_insn(LoongArchInsn opc, TCGReg vd, TCGReg vj, int32_t sk5)
{
    tcg_debug_assert(vd >= 0x20 && vd <= 0x3f);
    tcg_debug_assert(vj >= 0x20 && vj <= 0x3f);
    tcg_debug_assert(sk5 >= -0x10 && sk5 <= 0xf);
    return encode_djk_slots(opc, vd & 0x1f, vj & 0x1f, sk5 & 0x1f);
}

static int32_t __attribute__((unused))
encode_vdvjuk1_insn(LoongArchInsn opc, TCGReg vd, TCGReg vj, uint32_t uk1)
{
    tcg_debug_assert(vd >= 0x20 && vd <= 0x3f);
    tcg_debug_assert(vj >= 0x20 && vj <= 0x3f);
    tcg_debug_assert(uk1 <= 0x1);
    return encode_djk_slots(opc, vd & 0x1f, vj & 0x1f, uk1);
}

static int32_t __attribute__((unused))
encode_vdvjuk2_insn(LoongArchInsn opc, TCGReg vd, TCGReg vj, uint32_t uk2)
{
    tcg_debug_assert(vd >= 0x20 && vd <= 0x3f);
    tcg_debug_assert(vj >= 0x20 && vj <= 0x3f);
    tcg_debug_assert(uk2 <= 0x3);
    return encode_djk_slots(opc, vd & 0x1f, vj & 0x1f, uk2);
}

static int32_t __attribute__((unused))
encode_vdvjuk3_insn(LoongArchInsn opc, TCGReg vd, TCGReg vj, uint32_t uk3)
{
    tcg_debug_assert(vd >= 0x20 && vd <= 0x3f);
    tcg_debug_assert(vj >= 0x20 && vj <= 0x3f);
    tcg_debug_assert(uk3 <= 0x7);
    return encode_djk_slots(opc, vd & 0x1f, vj & 0x1f, uk3);
}

static int32_t __attribute__((unused))
encode_vdvjuk4_insn(LoongArchInsn opc, TCGReg vd, TCGReg vj, uint32_t uk4)
{
    tcg_debug_assert(vd >= 0x20 && vd <= 0x3f);
    tcg_debug_assert(vj >= 0x20 && vj <= 0x3f);
    tcg_debug_assert(uk4 <= 0xf);
    return encode_djk_slots(opc, vd & 0x1f, vj & 0x1f, uk4);
}

static int32_t __attribute__((unused))
encode_vdvjuk5_insn(LoongArchInsn opc, TCGReg vd, TCGReg vj, uint32_t uk5)
{
    tcg_debug_assert(vd >= 0x20 && vd <= 0x3f);
    tcg_debug_assert(vj >= 0x20 && vj <= 0x3f);
    tcg_debug_assert(uk5 <= 0x1f);
    return encode_djk_slots(opc, vd & 0x1f, vj & 0x1f, uk5);
}

static int32_t __attribute__((unused))
encode_vdvjuk6_insn(LoongArchInsn opc, TCGReg vd, TCGReg vj, uint32_t uk6)
{
    tcg_debug_assert(vd >= 0x20 && vd <= 0x3f);
    tcg_debug_assert(vj >= 0x20 && vj <= 0x3f);
    tcg_debug_assert(uk6 <= 0x3f);
    return encode_djk_slots(opc, vd & 0x1f, vj & 0x1f, uk6);
}

static int32_t __attribute__((unused))
encode_vdvjuk8_insn(LoongArchInsn opc, TCGReg vd, TCGReg vj, uint32_t uk8)
{
    tcg_debug_assert(vd >= 0x20 && vd <= 0x3f);
    tcg_debug_assert(vj >= 0x20 && vj <= 0x3f);
    tcg_debug_assert(uk8 <= 0xff);
    return encode_djk_slots(opc, vd & 0x1f, vj & 0x1f, uk8);
}

static int32_t __attribute__((unused))
encode_vdvjvk_insn(LoongArchInsn opc, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_debug_assert(vd >= 0x20 && vd <= 0x3f);
    tcg_debug_assert(vj >= 0x20 && vj <= 0x3f);
    tcg_debug_assert(vk >= 0x20 && vk <= 0x3f);
    return encode_djk_slots(opc, vd & 0x1f, vj & 0x1f, vk & 0x1f);
}

static int32_t __attribute__((unused))
encode_vdvjvkva_insn(LoongArchInsn opc, TCGReg vd, TCGReg vj, TCGReg vk,
                     TCGReg va)
{
    tcg_debug_assert(vd >= 0x20 && vd <= 0x3f);
    tcg_debug_assert(vj >= 0x20 && vj <= 0x3f);
    tcg_debug_assert(vk >= 0x20 && vk <= 0x3f);
    tcg_debug_assert(va >= 0x20 && va <= 0x3f);
    return encode_djka_slots(opc, vd & 0x1f, vj & 0x1f, vk & 0x1f, va & 0x1f);
}

static int32_t __attribute__((unused))
encode_xdj_insn(LoongArchInsn opc, TCGReg xd, TCGReg j)
{
    tcg_debug_assert(xd >= 0x20 && xd <= 0x3f);
    tcg_debug_assert(j >= 0 && j <= 0x1f);
    return encode_dj_slots(opc, xd & 0x1f, j);
}

static int32_t __attribute__((unused))
encode_xdjk_insn(LoongArchInsn opc, TCGReg xd, TCGReg j, TCGReg k)
{
    tcg_debug_assert(xd >= 0x20 && xd <= 0x3f);
    tcg_debug_assert(j >= 0 && j <= 0x1f);
    tcg_debug_assert(k >= 0 && k <= 0x1f);
    return encode_djk_slots(opc, xd & 0x1f, j, k);
}

static int32_t __attribute__((unused))
encode_xdjsk10_insn(LoongArchInsn opc, TCGReg xd, TCGReg j, int32_t sk10)
{
    tcg_debug_assert(xd >= 0x20 && xd <= 0x3f);
    tcg_debug_assert(j >= 0 && j <= 0x1f);
    tcg_debug_assert(sk10 >= -0x200 && sk10 <= 0x1ff);
    return encode_djk_slots(opc, xd & 0x1f, j, sk10 & 0x3ff);
}

static int32_t __attribute__((unused))
encode_xdjsk11_insn(LoongArchInsn opc, TCGReg xd, TCGReg j, int32_t sk11)
{
    tcg_debug_assert(xd >= 0x20 && xd <= 0x3f);
    tcg_debug_assert(j >= 0 && j <= 0x1f);
    tcg_debug_assert(sk11 >= -0x400 && sk11 <= 0x3ff);
    return encode_djk_slots(opc, xd & 0x1f, j, sk11 & 0x7ff);
}

static int32_t __attribute__((unused))
encode_xdjsk12_insn(LoongArchInsn opc, TCGReg xd, TCGReg j, int32_t sk12)
{
    tcg_debug_assert(xd >= 0x20 && xd <= 0x3f);
    tcg_debug_assert(j >= 0 && j <= 0x1f);
    tcg_debug_assert(sk12 >= -0x800 && sk12 <= 0x7ff);
    return encode_djk_slots(opc, xd & 0x1f, j, sk12 & 0xfff);
}

static int32_t __attribute__((unused))
encode_xdjsk8un2_insn(LoongArchInsn opc, TCGReg xd, TCGReg j, int32_t sk8,
                      uint32_t un2)
{
    tcg_debug_assert(xd >= 0x20 && xd <= 0x3f);
    tcg_debug_assert(j >= 0 && j <= 0x1f);
    tcg_debug_assert(sk8 >= -0x80 && sk8 <= 0x7f);
    tcg_debug_assert(un2 <= 0x3);
    return encode_djkn_slots(opc, xd & 0x1f, j, sk8 & 0xff, un2);
}

static int32_t __attribute__((unused))
encode_xdjsk8un3_insn(LoongArchInsn opc, TCGReg xd, TCGReg j, int32_t sk8,
                      uint32_t un3)
{
    tcg_debug_assert(xd >= 0x20 && xd <= 0x3f);
    tcg_debug_assert(j >= 0 && j <= 0x1f);
    tcg_debug_assert(sk8 >= -0x80 && sk8 <= 0x7f);
    tcg_debug_assert(un3 <= 0x7);
    return encode_djkn_slots(opc, xd & 0x1f, j, sk8 & 0xff, un3);
}

static int32_t __attribute__((unused))
encode_xdjsk8un4_insn(LoongArchInsn opc, TCGReg xd, TCGReg j, int32_t sk8,
                      uint32_t un4)
{
    tcg_debug_assert(xd >= 0x20 && xd <= 0x3f);
    tcg_debug_assert(j >= 0 && j <= 0x1f);
    tcg_debug_assert(sk8 >= -0x80 && sk8 <= 0x7f);
    tcg_debug_assert(un4 <= 0xf);
    return encode_djkn_slots(opc, xd & 0x1f, j, sk8 & 0xff, un4);
}

static int32_t __attribute__((unused))
encode_xdjsk8un5_insn(LoongArchInsn opc, TCGReg xd, TCGReg j, int32_t sk8,
                      uint32_t un5)
{
    tcg_debug_assert(xd >= 0x20 && xd <= 0x3f);
    tcg_debug_assert(j >= 0 && j <= 0x1f);
    tcg_debug_assert(sk8 >= -0x80 && sk8 <= 0x7f);
    tcg_debug_assert(un5 <= 0x1f);
    return encode_djkn_slots(opc, xd & 0x1f, j, sk8 & 0xff, un5);
}

static int32_t __attribute__((unused))
encode_xdjsk9_insn(LoongArchInsn opc, TCGReg xd, TCGReg j, int32_t sk9)
{
    tcg_debug_assert(xd >= 0x20 && xd <= 0x3f);
    tcg_debug_assert(j >= 0 && j <= 0x1f);
    tcg_debug_assert(sk9 >= -0x100 && sk9 <= 0xff);
    return encode_djk_slots(opc, xd & 0x1f, j, sk9 & 0x1ff);
}

static int32_t __attribute__((unused))
encode_xdjuk2_insn(LoongArchInsn opc, TCGReg xd, TCGReg j, uint32_t uk2)
{
    tcg_debug_assert(xd >= 0x20 && xd <= 0x3f);
    tcg_debug_assert(j >= 0 && j <= 0x1f);
    tcg_debug_assert(uk2 <= 0x3);
    return encode_djk_slots(opc, xd & 0x1f, j, uk2);
}

static int32_t __attribute__((unused))
encode_xdjuk3_insn(LoongArchInsn opc, TCGReg xd, TCGReg j, uint32_t uk3)
{
    tcg_debug_assert(xd >= 0x20 && xd <= 0x3f);
    tcg_debug_assert(j >= 0 && j <= 0x1f);
    tcg_debug_assert(uk3 <= 0x7);
    return encode_djk_slots(opc, xd & 0x1f, j, uk3);
}

static int32_t __attribute__((unused))
encode_xdsj13_insn(LoongArchInsn opc, TCGReg xd, int32_t sj13)
{
    tcg_debug_assert(xd >= 0x20 && xd <= 0x3f);
    tcg_debug_assert(sj13 >= -0x1000 && sj13 <= 0xfff);
    return encode_dj_slots(opc, xd & 0x1f, sj13 & 0x1fff);
}

static int32_t __attribute__((unused))
encode_xdxj_insn(LoongArchInsn opc, TCGReg xd, TCGReg xj)
{
    tcg_debug_assert(xd >= 0x20 && xd <= 0x3f);
    tcg_debug_assert(xj >= 0x20 && xj <= 0x3f);
    return encode_dj_slots(opc, xd & 0x1f, xj & 0x1f);
}

static int32_t __attribute__((unused))
encode_xdxjk_insn(LoongArchInsn opc, TCGReg xd, TCGReg xj, TCGReg k)
{
    tcg_debug_assert(xd >= 0x20 && xd <= 0x3f);
    tcg_debug_assert(xj >= 0x20 && xj <= 0x3f);
    tcg_debug_assert(k >= 0 && k <= 0x1f);
    return encode_djk_slots(opc, xd & 0x1f, xj & 0x1f, k);
}

static int32_t __attribute__((unused))
encode_xdxjsk5_insn(LoongArchInsn opc, TCGReg xd, TCGReg xj, int32_t sk5)
{
    tcg_debug_assert(xd >= 0x20 && xd <= 0x3f);
    tcg_debug_assert(xj >= 0x20 && xj <= 0x3f);
    tcg_debug_assert(sk5 >= -0x10 && sk5 <= 0xf);
    return encode_djk_slots(opc, xd & 0x1f, xj & 0x1f, sk5 & 0x1f);
}

static int32_t __attribute__((unused))
encode_xdxjuk1_insn(LoongArchInsn opc, TCGReg xd, TCGReg xj, uint32_t uk1)
{
    tcg_debug_assert(xd >= 0x20 && xd <= 0x3f);
    tcg_debug_assert(xj >= 0x20 && xj <= 0x3f);
    tcg_debug_assert(uk1 <= 0x1);
    return encode_djk_slots(opc, xd & 0x1f, xj & 0x1f, uk1);
}

static int32_t __attribute__((unused))
encode_xdxjuk2_insn(LoongArchInsn opc, TCGReg xd, TCGReg xj, uint32_t uk2)
{
    tcg_debug_assert(xd >= 0x20 && xd <= 0x3f);
    tcg_debug_assert(xj >= 0x20 && xj <= 0x3f);
    tcg_debug_assert(uk2 <= 0x3);
    return encode_djk_slots(opc, xd & 0x1f, xj & 0x1f, uk2);
}

static int32_t __attribute__((unused))
encode_xdxjuk3_insn(LoongArchInsn opc, TCGReg xd, TCGReg xj, uint32_t uk3)
{
    tcg_debug_assert(xd >= 0x20 && xd <= 0x3f);
    tcg_debug_assert(xj >= 0x20 && xj <= 0x3f);
    tcg_debug_assert(uk3 <= 0x7);
    return encode_djk_slots(opc, xd & 0x1f, xj & 0x1f, uk3);
}

static int32_t __attribute__((unused))
encode_xdxjuk4_insn(LoongArchInsn opc, TCGReg xd, TCGReg xj, uint32_t uk4)
{
    tcg_debug_assert(xd >= 0x20 && xd <= 0x3f);
    tcg_debug_assert(xj >= 0x20 && xj <= 0x3f);
    tcg_debug_assert(uk4 <= 0xf);
    return encode_djk_slots(opc, xd & 0x1f, xj & 0x1f, uk4);
}

static int32_t __attribute__((unused))
encode_xdxjuk5_insn(LoongArchInsn opc, TCGReg xd, TCGReg xj, uint32_t uk5)
{
    tcg_debug_assert(xd >= 0x20 && xd <= 0x3f);
    tcg_debug_assert(xj >= 0x20 && xj <= 0x3f);
    tcg_debug_assert(uk5 <= 0x1f);
    return encode_djk_slots(opc, xd & 0x1f, xj & 0x1f, uk5);
}

static int32_t __attribute__((unused))
encode_xdxjuk6_insn(LoongArchInsn opc, TCGReg xd, TCGReg xj, uint32_t uk6)
{
    tcg_debug_assert(xd >= 0x20 && xd <= 0x3f);
    tcg_debug_assert(xj >= 0x20 && xj <= 0x3f);
    tcg_debug_assert(uk6 <= 0x3f);
    return encode_djk_slots(opc, xd & 0x1f, xj & 0x1f, uk6);
}

static int32_t __attribute__((unused))
encode_xdxjuk8_insn(LoongArchInsn opc, TCGReg xd, TCGReg xj, uint32_t uk8)
{
    tcg_debug_assert(xd >= 0x20 && xd <= 0x3f);
    tcg_debug_assert(xj >= 0x20 && xj <= 0x3f);
    tcg_debug_assert(uk8 <= 0xff);
    return encode_djk_slots(opc, xd & 0x1f, xj & 0x1f, uk8);
}

static int32_t __attribute__((unused))
encode_xdxjxk_insn(LoongArchInsn opc, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_debug_assert(xd >= 0x20 && xd <= 0x3f);
    tcg_debug_assert(xj >= 0x20 && xj <= 0x3f);
    tcg_debug_assert(xk >= 0x20 && xk <= 0x3f);
    return encode_djk_slots(opc, xd & 0x1f, xj & 0x1f, xk & 0x1f);
}

static int32_t __attribute__((unused))
encode_xdxjxkxa_insn(LoongArchInsn opc, TCGReg xd, TCGReg xj, TCGReg xk,
                     TCGReg xa)
{
    tcg_debug_assert(xd >= 0x20 && xd <= 0x3f);
    tcg_debug_assert(xj >= 0x20 && xj <= 0x3f);
    tcg_debug_assert(xk >= 0x20 && xk <= 0x3f);
    tcg_debug_assert(xa >= 0x20 && xa <= 0x3f);
    return encode_djka_slots(opc, xd & 0x1f, xj & 0x1f, xk & 0x1f, xa & 0x1f);
}

/* Emits the `movgr2scr td, j` instruction.  */
static void __attribute__((unused))
tcg_out_opc_movgr2scr(TCGContext *s, TCGReg td, TCGReg j)
{
    tcg_out32(s, encode_tdj_insn(OPC_MOVGR2SCR, td, j));
}

/* Emits the `movscr2gr d, tj` instruction.  */
static void __attribute__((unused))
tcg_out_opc_movscr2gr(TCGContext *s, TCGReg d, TCGReg tj)
{
    tcg_out32(s, encode_dtj_insn(OPC_MOVSCR2GR, d, tj));
}

/* Emits the `clz.w d, j` instruction.  */
static void __attribute__((unused))
tcg_out_opc_clz_w(TCGContext *s, TCGReg d, TCGReg j)
{
    tcg_out32(s, encode_dj_insn(OPC_CLZ_W, d, j));
}

/* Emits the `ctz.w d, j` instruction.  */
static void __attribute__((unused))
tcg_out_opc_ctz_w(TCGContext *s, TCGReg d, TCGReg j)
{
    tcg_out32(s, encode_dj_insn(OPC_CTZ_W, d, j));
}

/* Emits the `clz.d d, j` instruction.  */
static void __attribute__((unused))
tcg_out_opc_clz_d(TCGContext *s, TCGReg d, TCGReg j)
{
    tcg_out32(s, encode_dj_insn(OPC_CLZ_D, d, j));
}

/* Emits the `ctz.d d, j` instruction.  */
static void __attribute__((unused))
tcg_out_opc_ctz_d(TCGContext *s, TCGReg d, TCGReg j)
{
    tcg_out32(s, encode_dj_insn(OPC_CTZ_D, d, j));
}

/* Emits the `revb.2h d, j` instruction.  */
static void __attribute__((unused))
tcg_out_opc_revb_2h(TCGContext *s, TCGReg d, TCGReg j)
{
    tcg_out32(s, encode_dj_insn(OPC_REVB_2H, d, j));
}

/* Emits the `revb.2w d, j` instruction.  */
static void __attribute__((unused))
tcg_out_opc_revb_2w(TCGContext *s, TCGReg d, TCGReg j)
{
    tcg_out32(s, encode_dj_insn(OPC_REVB_2W, d, j));
}

/* Emits the `revb.d d, j` instruction.  */
static void __attribute__((unused))
tcg_out_opc_revb_d(TCGContext *s, TCGReg d, TCGReg j)
{
    tcg_out32(s, encode_dj_insn(OPC_REVB_D, d, j));
}

/* Emits the `sext.h d, j` instruction.  */
static void __attribute__((unused))
tcg_out_opc_sext_h(TCGContext *s, TCGReg d, TCGReg j)
{
    tcg_out32(s, encode_dj_insn(OPC_SEXT_H, d, j));
}

/* Emits the `sext.b d, j` instruction.  */
static void __attribute__((unused))
tcg_out_opc_sext_b(TCGContext *s, TCGReg d, TCGReg j)
{
    tcg_out32(s, encode_dj_insn(OPC_SEXT_B, d, j));
}

/* Emits the `add.w d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_add_w(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_ADD_W, d, j, k));
}

/* Emits the `add.d d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_add_d(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_ADD_D, d, j, k));
}

/* Emits the `sub.w d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_sub_w(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_SUB_W, d, j, k));
}

/* Emits the `sub.d d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_sub_d(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_SUB_D, d, j, k));
}

/* Emits the `slt d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_slt(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_SLT, d, j, k));
}

/* Emits the `sltu d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_sltu(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_SLTU, d, j, k));
}

/* Emits the `maskeqz d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_maskeqz(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_MASKEQZ, d, j, k));
}

/* Emits the `masknez d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_masknez(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_MASKNEZ, d, j, k));
}

/* Emits the `nor d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_nor(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_NOR, d, j, k));
}

/* Emits the `and d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_and(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_AND, d, j, k));
}

/* Emits the `or d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_or(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_OR, d, j, k));
}

/* Emits the `xor d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xor(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_XOR, d, j, k));
}

/* Emits the `orn d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_orn(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_ORN, d, j, k));
}

/* Emits the `andn d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_andn(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_ANDN, d, j, k));
}

/* Emits the `sll.w d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_sll_w(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_SLL_W, d, j, k));
}

/* Emits the `srl.w d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_srl_w(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_SRL_W, d, j, k));
}

/* Emits the `sra.w d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_sra_w(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_SRA_W, d, j, k));
}

/* Emits the `sll.d d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_sll_d(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_SLL_D, d, j, k));
}

/* Emits the `srl.d d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_srl_d(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_SRL_D, d, j, k));
}

/* Emits the `sra.d d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_sra_d(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_SRA_D, d, j, k));
}

/* Emits the `rotr.b d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_rotr_b(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_ROTR_B, d, j, k));
}

/* Emits the `rotr.h d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_rotr_h(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_ROTR_H, d, j, k));
}

/* Emits the `rotr.w d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_rotr_w(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_ROTR_W, d, j, k));
}

/* Emits the `rotr.d d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_rotr_d(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_ROTR_D, d, j, k));
}

/* Emits the `mul.w d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_mul_w(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_MUL_W, d, j, k));
}

/* Emits the `mulh.w d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_mulh_w(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_MULH_W, d, j, k));
}

/* Emits the `mulh.wu d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_mulh_wu(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_MULH_WU, d, j, k));
}

/* Emits the `mul.d d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_mul_d(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_MUL_D, d, j, k));
}

/* Emits the `mulh.d d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_mulh_d(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_MULH_D, d, j, k));
}

/* Emits the `mulh.du d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_mulh_du(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_MULH_DU, d, j, k));
}

/* Emits the `div.w d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_div_w(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_DIV_W, d, j, k));
}

/* Emits the `mod.w d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_mod_w(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_MOD_W, d, j, k));
}

/* Emits the `div.wu d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_div_wu(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_DIV_WU, d, j, k));
}

/* Emits the `mod.wu d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_mod_wu(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_MOD_WU, d, j, k));
}

/* Emits the `div.d d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_div_d(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_DIV_D, d, j, k));
}

/* Emits the `mod.d d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_mod_d(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_MOD_D, d, j, k));
}

/* Emits the `div.du d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_div_du(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_DIV_DU, d, j, k));
}

/* Emits the `mod.du d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_mod_du(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_MOD_DU, d, j, k));
}

/* Emits the `slli.w d, j, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_slli_w(TCGContext *s, TCGReg d, TCGReg j, uint32_t uk5)
{
    tcg_out32(s, encode_djuk5_insn(OPC_SLLI_W, d, j, uk5));
}

/* Emits the `slli.d d, j, uk6` instruction.  */
static void __attribute__((unused))
tcg_out_opc_slli_d(TCGContext *s, TCGReg d, TCGReg j, uint32_t uk6)
{
    tcg_out32(s, encode_djuk6_insn(OPC_SLLI_D, d, j, uk6));
}

/* Emits the `srli.w d, j, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_srli_w(TCGContext *s, TCGReg d, TCGReg j, uint32_t uk5)
{
    tcg_out32(s, encode_djuk5_insn(OPC_SRLI_W, d, j, uk5));
}

/* Emits the `srli.d d, j, uk6` instruction.  */
static void __attribute__((unused))
tcg_out_opc_srli_d(TCGContext *s, TCGReg d, TCGReg j, uint32_t uk6)
{
    tcg_out32(s, encode_djuk6_insn(OPC_SRLI_D, d, j, uk6));
}

/* Emits the `srai.w d, j, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_srai_w(TCGContext *s, TCGReg d, TCGReg j, uint32_t uk5)
{
    tcg_out32(s, encode_djuk5_insn(OPC_SRAI_W, d, j, uk5));
}

/* Emits the `srai.d d, j, uk6` instruction.  */
static void __attribute__((unused))
tcg_out_opc_srai_d(TCGContext *s, TCGReg d, TCGReg j, uint32_t uk6)
{
    tcg_out32(s, encode_djuk6_insn(OPC_SRAI_D, d, j, uk6));
}

/* Emits the `rotri.b d, j, uk3` instruction.  */
static void __attribute__((unused))
tcg_out_opc_rotri_b(TCGContext *s, TCGReg d, TCGReg j, uint32_t uk3)
{
    tcg_out32(s, encode_djuk3_insn(OPC_ROTRI_B, d, j, uk3));
}

/* Emits the `rotri.h d, j, uk4` instruction.  */
static void __attribute__((unused))
tcg_out_opc_rotri_h(TCGContext *s, TCGReg d, TCGReg j, uint32_t uk4)
{
    tcg_out32(s, encode_djuk4_insn(OPC_ROTRI_H, d, j, uk4));
}

/* Emits the `rotri.w d, j, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_rotri_w(TCGContext *s, TCGReg d, TCGReg j, uint32_t uk5)
{
    tcg_out32(s, encode_djuk5_insn(OPC_ROTRI_W, d, j, uk5));
}

/* Emits the `rotri.d d, j, uk6` instruction.  */
static void __attribute__((unused))
tcg_out_opc_rotri_d(TCGContext *s, TCGReg d, TCGReg j, uint32_t uk6)
{
    tcg_out32(s, encode_djuk6_insn(OPC_ROTRI_D, d, j, uk6));
}

/* Emits the `bstrins.w d, j, uk5, um5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_bstrins_w(TCGContext *s, TCGReg d, TCGReg j, uint32_t uk5,
                      uint32_t um5)
{
    tcg_out32(s, encode_djuk5um5_insn(OPC_BSTRINS_W, d, j, uk5, um5));
}

/* Emits the `bstrpick.w d, j, uk5, um5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_bstrpick_w(TCGContext *s, TCGReg d, TCGReg j, uint32_t uk5,
                       uint32_t um5)
{
    tcg_out32(s, encode_djuk5um5_insn(OPC_BSTRPICK_W, d, j, uk5, um5));
}

/* Emits the `bstrins.d d, j, uk6, um6` instruction.  */
static void __attribute__((unused))
tcg_out_opc_bstrins_d(TCGContext *s, TCGReg d, TCGReg j, uint32_t uk6,
                      uint32_t um6)
{
    tcg_out32(s, encode_djuk6um6_insn(OPC_BSTRINS_D, d, j, uk6, um6));
}

/* Emits the `bstrpick.d d, j, uk6, um6` instruction.  */
static void __attribute__((unused))
tcg_out_opc_bstrpick_d(TCGContext *s, TCGReg d, TCGReg j, uint32_t uk6,
                       uint32_t um6)
{
    tcg_out32(s, encode_djuk6um6_insn(OPC_BSTRPICK_D, d, j, uk6, um6));
}

/* Emits the `fmov.d fd, fj` instruction.  */
static void __attribute__((unused))
tcg_out_opc_fmov_d(TCGContext *s, TCGReg fd, TCGReg fj)
{
    tcg_out32(s, encode_fdfj_insn(OPC_FMOV_D, fd, fj));
}

/* Emits the `movgr2fr.d fd, j` instruction.  */
static void __attribute__((unused))
tcg_out_opc_movgr2fr_d(TCGContext *s, TCGReg fd, TCGReg j)
{
    tcg_out32(s, encode_fdj_insn(OPC_MOVGR2FR_D, fd, j));
}

/* Emits the `movfr2gr.d d, fj` instruction.  */
static void __attribute__((unused))
tcg_out_opc_movfr2gr_d(TCGContext *s, TCGReg d, TCGReg fj)
{
    tcg_out32(s, encode_dfj_insn(OPC_MOVFR2GR_D, d, fj));
}

/* Emits the `slti d, j, sk12` instruction.  */
static void __attribute__((unused))
tcg_out_opc_slti(TCGContext *s, TCGReg d, TCGReg j, int32_t sk12)
{
    tcg_out32(s, encode_djsk12_insn(OPC_SLTI, d, j, sk12));
}

/* Emits the `sltui d, j, sk12` instruction.  */
static void __attribute__((unused))
tcg_out_opc_sltui(TCGContext *s, TCGReg d, TCGReg j, int32_t sk12)
{
    tcg_out32(s, encode_djsk12_insn(OPC_SLTUI, d, j, sk12));
}

/* Emits the `addi.w d, j, sk12` instruction.  */
static void __attribute__((unused))
tcg_out_opc_addi_w(TCGContext *s, TCGReg d, TCGReg j, int32_t sk12)
{
    tcg_out32(s, encode_djsk12_insn(OPC_ADDI_W, d, j, sk12));
}

/* Emits the `addi.d d, j, sk12` instruction.  */
static void __attribute__((unused))
tcg_out_opc_addi_d(TCGContext *s, TCGReg d, TCGReg j, int32_t sk12)
{
    tcg_out32(s, encode_djsk12_insn(OPC_ADDI_D, d, j, sk12));
}

/* Emits the `cu52i.d d, j, sk12` instruction.  */
static void __attribute__((unused))
tcg_out_opc_cu52i_d(TCGContext *s, TCGReg d, TCGReg j, int32_t sk12)
{
    tcg_out32(s, encode_djsk12_insn(OPC_CU52I_D, d, j, sk12));
}

/* Emits the `andi d, j, uk12` instruction.  */
static void __attribute__((unused))
tcg_out_opc_andi(TCGContext *s, TCGReg d, TCGReg j, uint32_t uk12)
{
    tcg_out32(s, encode_djuk12_insn(OPC_ANDI, d, j, uk12));
}

/* Emits the `ori d, j, uk12` instruction.  */
static void __attribute__((unused))
tcg_out_opc_ori(TCGContext *s, TCGReg d, TCGReg j, uint32_t uk12)
{
    tcg_out32(s, encode_djuk12_insn(OPC_ORI, d, j, uk12));
}

/* Emits the `xori d, j, uk12` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xori(TCGContext *s, TCGReg d, TCGReg j, uint32_t uk12)
{
    tcg_out32(s, encode_djuk12_insn(OPC_XORI, d, j, uk12));
}

/* Emits the `vbitsel.v vd, vj, vk, va` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vbitsel_v(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk, TCGReg va)
{
    tcg_out32(s, encode_vdvjvkva_insn(OPC_VBITSEL_V, vd, vj, vk, va));
}

/* Emits the `xvbitsel.v xd, xj, xk, xa` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvbitsel_v(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk,
                       TCGReg xa)
{
    tcg_out32(s, encode_xdxjxkxa_insn(OPC_XVBITSEL_V, xd, xj, xk, xa));
}

/* Emits the `vshuf.b vd, vj, vk, va` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vshuf_b(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk, TCGReg va)
{
    tcg_out32(s, encode_vdvjvkva_insn(OPC_VSHUF_B, vd, vj, vk, va));
}

/* Emits the `xvshuf.b xd, xj, xk, xa` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvshuf_b(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk, TCGReg xa)
{
    tcg_out32(s, encode_xdxjxkxa_insn(OPC_XVSHUF_B, xd, xj, xk, xa));
}

/* Emits the `addu16i.d d, j, sk16` instruction.  */
static void __attribute__((unused))
tcg_out_opc_addu16i_d(TCGContext *s, TCGReg d, TCGReg j, int32_t sk16)
{
    tcg_out32(s, encode_djsk16_insn(OPC_ADDU16I_D, d, j, sk16));
}

/* Emits the `lu12i.w d, sj20` instruction.  */
static void __attribute__((unused))
tcg_out_opc_lu12i_w(TCGContext *s, TCGReg d, int32_t sj20)
{
    tcg_out32(s, encode_dsj20_insn(OPC_LU12I_W, d, sj20));
}

/* Emits the `cu32i.d d, sj20` instruction.  */
static void __attribute__((unused))
tcg_out_opc_cu32i_d(TCGContext *s, TCGReg d, int32_t sj20)
{
    tcg_out32(s, encode_dsj20_insn(OPC_CU32I_D, d, sj20));
}

/* Emits the `pcaddu2i d, sj20` instruction.  */
static void __attribute__((unused))
tcg_out_opc_pcaddu2i(TCGContext *s, TCGReg d, int32_t sj20)
{
    tcg_out32(s, encode_dsj20_insn(OPC_PCADDU2I, d, sj20));
}

/* Emits the `pcalau12i d, sj20` instruction.  */
static void __attribute__((unused))
tcg_out_opc_pcalau12i(TCGContext *s, TCGReg d, int32_t sj20)
{
    tcg_out32(s, encode_dsj20_insn(OPC_PCALAU12I, d, sj20));
}

/* Emits the `pcaddu12i d, sj20` instruction.  */
static void __attribute__((unused))
tcg_out_opc_pcaddu12i(TCGContext *s, TCGReg d, int32_t sj20)
{
    tcg_out32(s, encode_dsj20_insn(OPC_PCADDU12I, d, sj20));
}

/* Emits the `pcaddu18i d, sj20` instruction.  */
static void __attribute__((unused))
tcg_out_opc_pcaddu18i(TCGContext *s, TCGReg d, int32_t sj20)
{
    tcg_out32(s, encode_dsj20_insn(OPC_PCADDU18I, d, sj20));
}

/* Emits the `ld.b d, j, sk12` instruction.  */
static void __attribute__((unused))
tcg_out_opc_ld_b(TCGContext *s, TCGReg d, TCGReg j, int32_t sk12)
{
    tcg_out32(s, encode_djsk12_insn(OPC_LD_B, d, j, sk12));
}

/* Emits the `ld.h d, j, sk12` instruction.  */
static void __attribute__((unused))
tcg_out_opc_ld_h(TCGContext *s, TCGReg d, TCGReg j, int32_t sk12)
{
    tcg_out32(s, encode_djsk12_insn(OPC_LD_H, d, j, sk12));
}

/* Emits the `ld.w d, j, sk12` instruction.  */
static void __attribute__((unused))
tcg_out_opc_ld_w(TCGContext *s, TCGReg d, TCGReg j, int32_t sk12)
{
    tcg_out32(s, encode_djsk12_insn(OPC_LD_W, d, j, sk12));
}

/* Emits the `ld.d d, j, sk12` instruction.  */
static void __attribute__((unused))
tcg_out_opc_ld_d(TCGContext *s, TCGReg d, TCGReg j, int32_t sk12)
{
    tcg_out32(s, encode_djsk12_insn(OPC_LD_D, d, j, sk12));
}

/* Emits the `st.b d, j, sk12` instruction.  */
static void __attribute__((unused))
tcg_out_opc_st_b(TCGContext *s, TCGReg d, TCGReg j, int32_t sk12)
{
    tcg_out32(s, encode_djsk12_insn(OPC_ST_B, d, j, sk12));
}

/* Emits the `st.h d, j, sk12` instruction.  */
static void __attribute__((unused))
tcg_out_opc_st_h(TCGContext *s, TCGReg d, TCGReg j, int32_t sk12)
{
    tcg_out32(s, encode_djsk12_insn(OPC_ST_H, d, j, sk12));
}

/* Emits the `st.w d, j, sk12` instruction.  */
static void __attribute__((unused))
tcg_out_opc_st_w(TCGContext *s, TCGReg d, TCGReg j, int32_t sk12)
{
    tcg_out32(s, encode_djsk12_insn(OPC_ST_W, d, j, sk12));
}

/* Emits the `st.d d, j, sk12` instruction.  */
static void __attribute__((unused))
tcg_out_opc_st_d(TCGContext *s, TCGReg d, TCGReg j, int32_t sk12)
{
    tcg_out32(s, encode_djsk12_insn(OPC_ST_D, d, j, sk12));
}

/* Emits the `ld.bu d, j, sk12` instruction.  */
static void __attribute__((unused))
tcg_out_opc_ld_bu(TCGContext *s, TCGReg d, TCGReg j, int32_t sk12)
{
    tcg_out32(s, encode_djsk12_insn(OPC_LD_BU, d, j, sk12));
}

/* Emits the `ld.hu d, j, sk12` instruction.  */
static void __attribute__((unused))
tcg_out_opc_ld_hu(TCGContext *s, TCGReg d, TCGReg j, int32_t sk12)
{
    tcg_out32(s, encode_djsk12_insn(OPC_LD_HU, d, j, sk12));
}

/* Emits the `ld.wu d, j, sk12` instruction.  */
static void __attribute__((unused))
tcg_out_opc_ld_wu(TCGContext *s, TCGReg d, TCGReg j, int32_t sk12)
{
    tcg_out32(s, encode_djsk12_insn(OPC_LD_WU, d, j, sk12));
}

/* Emits the `fld.s fd, j, sk12` instruction.  */
static void __attribute__((unused))
tcg_out_opc_fld_s(TCGContext *s, TCGReg fd, TCGReg j, int32_t sk12)
{
    tcg_out32(s, encode_fdjsk12_insn(OPC_FLD_S, fd, j, sk12));
}

/* Emits the `fst.s fd, j, sk12` instruction.  */
static void __attribute__((unused))
tcg_out_opc_fst_s(TCGContext *s, TCGReg fd, TCGReg j, int32_t sk12)
{
    tcg_out32(s, encode_fdjsk12_insn(OPC_FST_S, fd, j, sk12));
}

/* Emits the `fld.d fd, j, sk12` instruction.  */
static void __attribute__((unused))
tcg_out_opc_fld_d(TCGContext *s, TCGReg fd, TCGReg j, int32_t sk12)
{
    tcg_out32(s, encode_fdjsk12_insn(OPC_FLD_D, fd, j, sk12));
}

/* Emits the `fst.d fd, j, sk12` instruction.  */
static void __attribute__((unused))
tcg_out_opc_fst_d(TCGContext *s, TCGReg fd, TCGReg j, int32_t sk12)
{
    tcg_out32(s, encode_fdjsk12_insn(OPC_FST_D, fd, j, sk12));
}

/* Emits the `vld vd, j, sk12` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vld(TCGContext *s, TCGReg vd, TCGReg j, int32_t sk12)
{
    tcg_out32(s, encode_vdjsk12_insn(OPC_VLD, vd, j, sk12));
}

/* Emits the `vst vd, j, sk12` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vst(TCGContext *s, TCGReg vd, TCGReg j, int32_t sk12)
{
    tcg_out32(s, encode_vdjsk12_insn(OPC_VST, vd, j, sk12));
}

/* Emits the `xvld xd, j, sk12` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvld(TCGContext *s, TCGReg xd, TCGReg j, int32_t sk12)
{
    tcg_out32(s, encode_xdjsk12_insn(OPC_XVLD, xd, j, sk12));
}

/* Emits the `xvst xd, j, sk12` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvst(TCGContext *s, TCGReg xd, TCGReg j, int32_t sk12)
{
    tcg_out32(s, encode_xdjsk12_insn(OPC_XVST, xd, j, sk12));
}

/* Emits the `vldrepl.d vd, j, sk9` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vldrepl_d(TCGContext *s, TCGReg vd, TCGReg j, int32_t sk9)
{
    tcg_out32(s, encode_vdjsk9_insn(OPC_VLDREPL_D, vd, j, sk9));
}

/* Emits the `vldrepl.w vd, j, sk10` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vldrepl_w(TCGContext *s, TCGReg vd, TCGReg j, int32_t sk10)
{
    tcg_out32(s, encode_vdjsk10_insn(OPC_VLDREPL_W, vd, j, sk10));
}

/* Emits the `vldrepl.h vd, j, sk11` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vldrepl_h(TCGContext *s, TCGReg vd, TCGReg j, int32_t sk11)
{
    tcg_out32(s, encode_vdjsk11_insn(OPC_VLDREPL_H, vd, j, sk11));
}

/* Emits the `vldrepl.b vd, j, sk12` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vldrepl_b(TCGContext *s, TCGReg vd, TCGReg j, int32_t sk12)
{
    tcg_out32(s, encode_vdjsk12_insn(OPC_VLDREPL_B, vd, j, sk12));
}

/* Emits the `vstelm.d vd, j, sk8, un1` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vstelm_d(TCGContext *s, TCGReg vd, TCGReg j, int32_t sk8,
                     uint32_t un1)
{
    tcg_out32(s, encode_vdjsk8un1_insn(OPC_VSTELM_D, vd, j, sk8, un1));
}

/* Emits the `vstelm.w vd, j, sk8, un2` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vstelm_w(TCGContext *s, TCGReg vd, TCGReg j, int32_t sk8,
                     uint32_t un2)
{
    tcg_out32(s, encode_vdjsk8un2_insn(OPC_VSTELM_W, vd, j, sk8, un2));
}

/* Emits the `vstelm.h vd, j, sk8, un3` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vstelm_h(TCGContext *s, TCGReg vd, TCGReg j, int32_t sk8,
                     uint32_t un3)
{
    tcg_out32(s, encode_vdjsk8un3_insn(OPC_VSTELM_H, vd, j, sk8, un3));
}

/* Emits the `vstelm.b vd, j, sk8, un4` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vstelm_b(TCGContext *s, TCGReg vd, TCGReg j, int32_t sk8,
                     uint32_t un4)
{
    tcg_out32(s, encode_vdjsk8un4_insn(OPC_VSTELM_B, vd, j, sk8, un4));
}

/* Emits the `xvldrepl.d xd, j, sk9` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvldrepl_d(TCGContext *s, TCGReg xd, TCGReg j, int32_t sk9)
{
    tcg_out32(s, encode_xdjsk9_insn(OPC_XVLDREPL_D, xd, j, sk9));
}

/* Emits the `xvldrepl.w xd, j, sk10` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvldrepl_w(TCGContext *s, TCGReg xd, TCGReg j, int32_t sk10)
{
    tcg_out32(s, encode_xdjsk10_insn(OPC_XVLDREPL_W, xd, j, sk10));
}

/* Emits the `xvldrepl.h xd, j, sk11` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvldrepl_h(TCGContext *s, TCGReg xd, TCGReg j, int32_t sk11)
{
    tcg_out32(s, encode_xdjsk11_insn(OPC_XVLDREPL_H, xd, j, sk11));
}

/* Emits the `xvldrepl.b xd, j, sk12` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvldrepl_b(TCGContext *s, TCGReg xd, TCGReg j, int32_t sk12)
{
    tcg_out32(s, encode_xdjsk12_insn(OPC_XVLDREPL_B, xd, j, sk12));
}

/* Emits the `xvstelm.d xd, j, sk8, un2` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvstelm_d(TCGContext *s, TCGReg xd, TCGReg j, int32_t sk8,
                      uint32_t un2)
{
    tcg_out32(s, encode_xdjsk8un2_insn(OPC_XVSTELM_D, xd, j, sk8, un2));
}

/* Emits the `xvstelm.w xd, j, sk8, un3` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvstelm_w(TCGContext *s, TCGReg xd, TCGReg j, int32_t sk8,
                      uint32_t un3)
{
    tcg_out32(s, encode_xdjsk8un3_insn(OPC_XVSTELM_W, xd, j, sk8, un3));
}

/* Emits the `xvstelm.h xd, j, sk8, un4` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvstelm_h(TCGContext *s, TCGReg xd, TCGReg j, int32_t sk8,
                      uint32_t un4)
{
    tcg_out32(s, encode_xdjsk8un4_insn(OPC_XVSTELM_H, xd, j, sk8, un4));
}

/* Emits the `xvstelm.b xd, j, sk8, un5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvstelm_b(TCGContext *s, TCGReg xd, TCGReg j, int32_t sk8,
                      uint32_t un5)
{
    tcg_out32(s, encode_xdjsk8un5_insn(OPC_XVSTELM_B, xd, j, sk8, un5));
}

/* Emits the `ldx.b d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_ldx_b(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_LDX_B, d, j, k));
}

/* Emits the `ldx.h d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_ldx_h(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_LDX_H, d, j, k));
}

/* Emits the `ldx.w d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_ldx_w(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_LDX_W, d, j, k));
}

/* Emits the `ldx.d d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_ldx_d(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_LDX_D, d, j, k));
}

/* Emits the `stx.b d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_stx_b(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_STX_B, d, j, k));
}

/* Emits the `stx.h d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_stx_h(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_STX_H, d, j, k));
}

/* Emits the `stx.w d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_stx_w(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_STX_W, d, j, k));
}

/* Emits the `stx.d d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_stx_d(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_STX_D, d, j, k));
}

/* Emits the `ldx.bu d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_ldx_bu(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_LDX_BU, d, j, k));
}

/* Emits the `ldx.hu d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_ldx_hu(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_LDX_HU, d, j, k));
}

/* Emits the `ldx.wu d, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_ldx_wu(TCGContext *s, TCGReg d, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_djk_insn(OPC_LDX_WU, d, j, k));
}

/* Emits the `fldx.s fd, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_fldx_s(TCGContext *s, TCGReg fd, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_fdjk_insn(OPC_FLDX_S, fd, j, k));
}

/* Emits the `fldx.d fd, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_fldx_d(TCGContext *s, TCGReg fd, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_fdjk_insn(OPC_FLDX_D, fd, j, k));
}

/* Emits the `fstx.s fd, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_fstx_s(TCGContext *s, TCGReg fd, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_fdjk_insn(OPC_FSTX_S, fd, j, k));
}

/* Emits the `fstx.d fd, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_fstx_d(TCGContext *s, TCGReg fd, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_fdjk_insn(OPC_FSTX_D, fd, j, k));
}

/* Emits the `vldx vd, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vldx(TCGContext *s, TCGReg vd, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_vdjk_insn(OPC_VLDX, vd, j, k));
}

/* Emits the `vstx vd, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vstx(TCGContext *s, TCGReg vd, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_vdjk_insn(OPC_VSTX, vd, j, k));
}

/* Emits the `xvldx xd, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvldx(TCGContext *s, TCGReg xd, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_xdjk_insn(OPC_XVLDX, xd, j, k));
}

/* Emits the `xvstx xd, j, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvstx(TCGContext *s, TCGReg xd, TCGReg j, TCGReg k)
{
    tcg_out32(s, encode_xdjk_insn(OPC_XVSTX, xd, j, k));
}

/* Emits the `dbar ud15` instruction.  */
static void __attribute__((unused))
tcg_out_opc_dbar(TCGContext *s, uint32_t ud15)
{
    tcg_out32(s, encode_ud15_insn(OPC_DBAR, ud15));
}

/* Emits the `jiscr0 sd5k16` instruction.  */
static void __attribute__((unused))
tcg_out_opc_jiscr0(TCGContext *s, int32_t sd5k16)
{
    tcg_out32(s, encode_sd5k16_insn(OPC_JISCR0, sd5k16));
}

/* Emits the `jiscr1 sd5k16` instruction.  */
static void __attribute__((unused))
tcg_out_opc_jiscr1(TCGContext *s, int32_t sd5k16)
{
    tcg_out32(s, encode_sd5k16_insn(OPC_JISCR1, sd5k16));
}

/* Emits the `jirl d, j, sk16` instruction.  */
static void __attribute__((unused))
tcg_out_opc_jirl(TCGContext *s, TCGReg d, TCGReg j, int32_t sk16)
{
    tcg_out32(s, encode_djsk16_insn(OPC_JIRL, d, j, sk16));
}

/* Emits the `b sd10k16` instruction.  */
static void __attribute__((unused))
tcg_out_opc_b(TCGContext *s, int32_t sd10k16)
{
    tcg_out32(s, encode_sd10k16_insn(OPC_B, sd10k16));
}

/* Emits the `bl sd10k16` instruction.  */
static void __attribute__((unused))
tcg_out_opc_bl(TCGContext *s, int32_t sd10k16)
{
    tcg_out32(s, encode_sd10k16_insn(OPC_BL, sd10k16));
}

/* Emits the `beq d, j, sk16` instruction.  */
static void __attribute__((unused))
tcg_out_opc_beq(TCGContext *s, TCGReg d, TCGReg j, int32_t sk16)
{
    tcg_out32(s, encode_djsk16_insn(OPC_BEQ, d, j, sk16));
}

/* Emits the `bne d, j, sk16` instruction.  */
static void __attribute__((unused))
tcg_out_opc_bne(TCGContext *s, TCGReg d, TCGReg j, int32_t sk16)
{
    tcg_out32(s, encode_djsk16_insn(OPC_BNE, d, j, sk16));
}

/* Emits the `bgt d, j, sk16` instruction.  */
static void __attribute__((unused))
tcg_out_opc_bgt(TCGContext *s, TCGReg d, TCGReg j, int32_t sk16)
{
    tcg_out32(s, encode_djsk16_insn(OPC_BGT, d, j, sk16));
}

/* Emits the `ble d, j, sk16` instruction.  */
static void __attribute__((unused))
tcg_out_opc_ble(TCGContext *s, TCGReg d, TCGReg j, int32_t sk16)
{
    tcg_out32(s, encode_djsk16_insn(OPC_BLE, d, j, sk16));
}

/* Emits the `bgtu d, j, sk16` instruction.  */
static void __attribute__((unused))
tcg_out_opc_bgtu(TCGContext *s, TCGReg d, TCGReg j, int32_t sk16)
{
    tcg_out32(s, encode_djsk16_insn(OPC_BGTU, d, j, sk16));
}

/* Emits the `bleu d, j, sk16` instruction.  */
static void __attribute__((unused))
tcg_out_opc_bleu(TCGContext *s, TCGReg d, TCGReg j, int32_t sk16)
{
    tcg_out32(s, encode_djsk16_insn(OPC_BLEU, d, j, sk16));
}

/* Emits the `vseq.b vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vseq_b(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSEQ_B, vd, vj, vk));
}

/* Emits the `vseq.h vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vseq_h(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSEQ_H, vd, vj, vk));
}

/* Emits the `vseq.w vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vseq_w(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSEQ_W, vd, vj, vk));
}

/* Emits the `vseq.d vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vseq_d(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSEQ_D, vd, vj, vk));
}

/* Emits the `vsle.b vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsle_b(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSLE_B, vd, vj, vk));
}

/* Emits the `vsle.h vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsle_h(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSLE_H, vd, vj, vk));
}

/* Emits the `vsle.w vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsle_w(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSLE_W, vd, vj, vk));
}

/* Emits the `vsle.d vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsle_d(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSLE_D, vd, vj, vk));
}

/* Emits the `vsle.bu vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsle_bu(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSLE_BU, vd, vj, vk));
}

/* Emits the `vsle.hu vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsle_hu(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSLE_HU, vd, vj, vk));
}

/* Emits the `vsle.wu vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsle_wu(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSLE_WU, vd, vj, vk));
}

/* Emits the `vsle.du vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsle_du(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSLE_DU, vd, vj, vk));
}

/* Emits the `vslt.b vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vslt_b(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSLT_B, vd, vj, vk));
}

/* Emits the `vslt.h vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vslt_h(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSLT_H, vd, vj, vk));
}

/* Emits the `vslt.w vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vslt_w(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSLT_W, vd, vj, vk));
}

/* Emits the `vslt.d vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vslt_d(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSLT_D, vd, vj, vk));
}

/* Emits the `vslt.bu vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vslt_bu(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSLT_BU, vd, vj, vk));
}

/* Emits the `vslt.hu vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vslt_hu(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSLT_HU, vd, vj, vk));
}

/* Emits the `vslt.wu vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vslt_wu(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSLT_WU, vd, vj, vk));
}

/* Emits the `vslt.du vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vslt_du(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSLT_DU, vd, vj, vk));
}

/* Emits the `vadd.b vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vadd_b(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VADD_B, vd, vj, vk));
}

/* Emits the `vadd.h vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vadd_h(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VADD_H, vd, vj, vk));
}

/* Emits the `vadd.w vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vadd_w(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VADD_W, vd, vj, vk));
}

/* Emits the `vadd.d vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vadd_d(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VADD_D, vd, vj, vk));
}

/* Emits the `vsub.b vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsub_b(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSUB_B, vd, vj, vk));
}

/* Emits the `vsub.h vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsub_h(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSUB_H, vd, vj, vk));
}

/* Emits the `vsub.w vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsub_w(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSUB_W, vd, vj, vk));
}

/* Emits the `vsub.d vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsub_d(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSUB_D, vd, vj, vk));
}

/* Emits the `vsadd.b vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsadd_b(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSADD_B, vd, vj, vk));
}

/* Emits the `vsadd.h vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsadd_h(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSADD_H, vd, vj, vk));
}

/* Emits the `vsadd.w vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsadd_w(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSADD_W, vd, vj, vk));
}

/* Emits the `vsadd.d vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsadd_d(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSADD_D, vd, vj, vk));
}

/* Emits the `vssub.b vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vssub_b(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSSUB_B, vd, vj, vk));
}

/* Emits the `vssub.h vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vssub_h(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSSUB_H, vd, vj, vk));
}

/* Emits the `vssub.w vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vssub_w(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSSUB_W, vd, vj, vk));
}

/* Emits the `vssub.d vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vssub_d(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSSUB_D, vd, vj, vk));
}

/* Emits the `vsadd.bu vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsadd_bu(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSADD_BU, vd, vj, vk));
}

/* Emits the `vsadd.hu vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsadd_hu(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSADD_HU, vd, vj, vk));
}

/* Emits the `vsadd.wu vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsadd_wu(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSADD_WU, vd, vj, vk));
}

/* Emits the `vsadd.du vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsadd_du(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSADD_DU, vd, vj, vk));
}

/* Emits the `vssub.bu vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vssub_bu(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSSUB_BU, vd, vj, vk));
}

/* Emits the `vssub.hu vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vssub_hu(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSSUB_HU, vd, vj, vk));
}

/* Emits the `vssub.wu vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vssub_wu(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSSUB_WU, vd, vj, vk));
}

/* Emits the `vssub.du vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vssub_du(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSSUB_DU, vd, vj, vk));
}

/* Emits the `vmax.b vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vmax_b(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VMAX_B, vd, vj, vk));
}

/* Emits the `vmax.h vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vmax_h(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VMAX_H, vd, vj, vk));
}

/* Emits the `vmax.w vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vmax_w(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VMAX_W, vd, vj, vk));
}

/* Emits the `vmax.d vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vmax_d(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VMAX_D, vd, vj, vk));
}

/* Emits the `vmin.b vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vmin_b(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VMIN_B, vd, vj, vk));
}

/* Emits the `vmin.h vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vmin_h(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VMIN_H, vd, vj, vk));
}

/* Emits the `vmin.w vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vmin_w(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VMIN_W, vd, vj, vk));
}

/* Emits the `vmin.d vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vmin_d(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VMIN_D, vd, vj, vk));
}

/* Emits the `vmax.bu vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vmax_bu(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VMAX_BU, vd, vj, vk));
}

/* Emits the `vmax.hu vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vmax_hu(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VMAX_HU, vd, vj, vk));
}

/* Emits the `vmax.wu vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vmax_wu(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VMAX_WU, vd, vj, vk));
}

/* Emits the `vmax.du vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vmax_du(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VMAX_DU, vd, vj, vk));
}

/* Emits the `vmin.bu vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vmin_bu(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VMIN_BU, vd, vj, vk));
}

/* Emits the `vmin.hu vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vmin_hu(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VMIN_HU, vd, vj, vk));
}

/* Emits the `vmin.wu vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vmin_wu(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VMIN_WU, vd, vj, vk));
}

/* Emits the `vmin.du vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vmin_du(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VMIN_DU, vd, vj, vk));
}

/* Emits the `vmul.b vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vmul_b(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VMUL_B, vd, vj, vk));
}

/* Emits the `vmul.h vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vmul_h(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VMUL_H, vd, vj, vk));
}

/* Emits the `vmul.w vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vmul_w(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VMUL_W, vd, vj, vk));
}

/* Emits the `vmul.d vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vmul_d(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VMUL_D, vd, vj, vk));
}

/* Emits the `vsll.b vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsll_b(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSLL_B, vd, vj, vk));
}

/* Emits the `vsll.h vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsll_h(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSLL_H, vd, vj, vk));
}

/* Emits the `vsll.w vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsll_w(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSLL_W, vd, vj, vk));
}

/* Emits the `vsll.d vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsll_d(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSLL_D, vd, vj, vk));
}

/* Emits the `vsrl.b vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsrl_b(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSRL_B, vd, vj, vk));
}

/* Emits the `vsrl.h vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsrl_h(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSRL_H, vd, vj, vk));
}

/* Emits the `vsrl.w vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsrl_w(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSRL_W, vd, vj, vk));
}

/* Emits the `vsrl.d vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsrl_d(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSRL_D, vd, vj, vk));
}

/* Emits the `vsra.b vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsra_b(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSRA_B, vd, vj, vk));
}

/* Emits the `vsra.h vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsra_h(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSRA_H, vd, vj, vk));
}

/* Emits the `vsra.w vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsra_w(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSRA_W, vd, vj, vk));
}

/* Emits the `vsra.d vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsra_d(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VSRA_D, vd, vj, vk));
}

/* Emits the `vrotr.b vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vrotr_b(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VROTR_B, vd, vj, vk));
}

/* Emits the `vrotr.h vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vrotr_h(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VROTR_H, vd, vj, vk));
}

/* Emits the `vrotr.w vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vrotr_w(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VROTR_W, vd, vj, vk));
}

/* Emits the `vrotr.d vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vrotr_d(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VROTR_D, vd, vj, vk));
}

/* Emits the `vreplve.b vd, vj, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vreplve_b(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg k)
{
    tcg_out32(s, encode_vdvjk_insn(OPC_VREPLVE_B, vd, vj, k));
}

/* Emits the `vreplve.h vd, vj, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vreplve_h(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg k)
{
    tcg_out32(s, encode_vdvjk_insn(OPC_VREPLVE_H, vd, vj, k));
}

/* Emits the `vreplve.w vd, vj, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vreplve_w(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg k)
{
    tcg_out32(s, encode_vdvjk_insn(OPC_VREPLVE_W, vd, vj, k));
}

/* Emits the `vreplve.d vd, vj, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vreplve_d(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg k)
{
    tcg_out32(s, encode_vdvjk_insn(OPC_VREPLVE_D, vd, vj, k));
}

/* Emits the `vand.v vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vand_v(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VAND_V, vd, vj, vk));
}

/* Emits the `vor.v vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vor_v(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VOR_V, vd, vj, vk));
}

/* Emits the `vxor.v vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vxor_v(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VXOR_V, vd, vj, vk));
}

/* Emits the `vnor.v vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vnor_v(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VNOR_V, vd, vj, vk));
}

/* Emits the `vandn.v vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vandn_v(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VANDN_V, vd, vj, vk));
}

/* Emits the `vorn.v vd, vj, vk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vorn_v(TCGContext *s, TCGReg vd, TCGReg vj, TCGReg vk)
{
    tcg_out32(s, encode_vdvjvk_insn(OPC_VORN_V, vd, vj, vk));
}

/* Emits the `vseqi.b vd, vj, sk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vseqi_b(TCGContext *s, TCGReg vd, TCGReg vj, int32_t sk5)
{
    tcg_out32(s, encode_vdvjsk5_insn(OPC_VSEQI_B, vd, vj, sk5));
}

/* Emits the `vseqi.h vd, vj, sk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vseqi_h(TCGContext *s, TCGReg vd, TCGReg vj, int32_t sk5)
{
    tcg_out32(s, encode_vdvjsk5_insn(OPC_VSEQI_H, vd, vj, sk5));
}

/* Emits the `vseqi.w vd, vj, sk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vseqi_w(TCGContext *s, TCGReg vd, TCGReg vj, int32_t sk5)
{
    tcg_out32(s, encode_vdvjsk5_insn(OPC_VSEQI_W, vd, vj, sk5));
}

/* Emits the `vseqi.d vd, vj, sk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vseqi_d(TCGContext *s, TCGReg vd, TCGReg vj, int32_t sk5)
{
    tcg_out32(s, encode_vdvjsk5_insn(OPC_VSEQI_D, vd, vj, sk5));
}

/* Emits the `vslei.b vd, vj, sk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vslei_b(TCGContext *s, TCGReg vd, TCGReg vj, int32_t sk5)
{
    tcg_out32(s, encode_vdvjsk5_insn(OPC_VSLEI_B, vd, vj, sk5));
}

/* Emits the `vslei.h vd, vj, sk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vslei_h(TCGContext *s, TCGReg vd, TCGReg vj, int32_t sk5)
{
    tcg_out32(s, encode_vdvjsk5_insn(OPC_VSLEI_H, vd, vj, sk5));
}

/* Emits the `vslei.w vd, vj, sk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vslei_w(TCGContext *s, TCGReg vd, TCGReg vj, int32_t sk5)
{
    tcg_out32(s, encode_vdvjsk5_insn(OPC_VSLEI_W, vd, vj, sk5));
}

/* Emits the `vslei.d vd, vj, sk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vslei_d(TCGContext *s, TCGReg vd, TCGReg vj, int32_t sk5)
{
    tcg_out32(s, encode_vdvjsk5_insn(OPC_VSLEI_D, vd, vj, sk5));
}

/* Emits the `vslei.bu vd, vj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vslei_bu(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk5)
{
    tcg_out32(s, encode_vdvjuk5_insn(OPC_VSLEI_BU, vd, vj, uk5));
}

/* Emits the `vslei.hu vd, vj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vslei_hu(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk5)
{
    tcg_out32(s, encode_vdvjuk5_insn(OPC_VSLEI_HU, vd, vj, uk5));
}

/* Emits the `vslei.wu vd, vj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vslei_wu(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk5)
{
    tcg_out32(s, encode_vdvjuk5_insn(OPC_VSLEI_WU, vd, vj, uk5));
}

/* Emits the `vslei.du vd, vj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vslei_du(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk5)
{
    tcg_out32(s, encode_vdvjuk5_insn(OPC_VSLEI_DU, vd, vj, uk5));
}

/* Emits the `vslti.b vd, vj, sk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vslti_b(TCGContext *s, TCGReg vd, TCGReg vj, int32_t sk5)
{
    tcg_out32(s, encode_vdvjsk5_insn(OPC_VSLTI_B, vd, vj, sk5));
}

/* Emits the `vslti.h vd, vj, sk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vslti_h(TCGContext *s, TCGReg vd, TCGReg vj, int32_t sk5)
{
    tcg_out32(s, encode_vdvjsk5_insn(OPC_VSLTI_H, vd, vj, sk5));
}

/* Emits the `vslti.w vd, vj, sk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vslti_w(TCGContext *s, TCGReg vd, TCGReg vj, int32_t sk5)
{
    tcg_out32(s, encode_vdvjsk5_insn(OPC_VSLTI_W, vd, vj, sk5));
}

/* Emits the `vslti.d vd, vj, sk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vslti_d(TCGContext *s, TCGReg vd, TCGReg vj, int32_t sk5)
{
    tcg_out32(s, encode_vdvjsk5_insn(OPC_VSLTI_D, vd, vj, sk5));
}

/* Emits the `vslti.bu vd, vj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vslti_bu(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk5)
{
    tcg_out32(s, encode_vdvjuk5_insn(OPC_VSLTI_BU, vd, vj, uk5));
}

/* Emits the `vslti.hu vd, vj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vslti_hu(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk5)
{
    tcg_out32(s, encode_vdvjuk5_insn(OPC_VSLTI_HU, vd, vj, uk5));
}

/* Emits the `vslti.wu vd, vj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vslti_wu(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk5)
{
    tcg_out32(s, encode_vdvjuk5_insn(OPC_VSLTI_WU, vd, vj, uk5));
}

/* Emits the `vslti.du vd, vj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vslti_du(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk5)
{
    tcg_out32(s, encode_vdvjuk5_insn(OPC_VSLTI_DU, vd, vj, uk5));
}

/* Emits the `vaddi.bu vd, vj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vaddi_bu(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk5)
{
    tcg_out32(s, encode_vdvjuk5_insn(OPC_VADDI_BU, vd, vj, uk5));
}

/* Emits the `vaddi.hu vd, vj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vaddi_hu(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk5)
{
    tcg_out32(s, encode_vdvjuk5_insn(OPC_VADDI_HU, vd, vj, uk5));
}

/* Emits the `vaddi.wu vd, vj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vaddi_wu(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk5)
{
    tcg_out32(s, encode_vdvjuk5_insn(OPC_VADDI_WU, vd, vj, uk5));
}

/* Emits the `vaddi.du vd, vj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vaddi_du(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk5)
{
    tcg_out32(s, encode_vdvjuk5_insn(OPC_VADDI_DU, vd, vj, uk5));
}

/* Emits the `vsubi.bu vd, vj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsubi_bu(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk5)
{
    tcg_out32(s, encode_vdvjuk5_insn(OPC_VSUBI_BU, vd, vj, uk5));
}

/* Emits the `vsubi.hu vd, vj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsubi_hu(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk5)
{
    tcg_out32(s, encode_vdvjuk5_insn(OPC_VSUBI_HU, vd, vj, uk5));
}

/* Emits the `vsubi.wu vd, vj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsubi_wu(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk5)
{
    tcg_out32(s, encode_vdvjuk5_insn(OPC_VSUBI_WU, vd, vj, uk5));
}

/* Emits the `vsubi.du vd, vj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsubi_du(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk5)
{
    tcg_out32(s, encode_vdvjuk5_insn(OPC_VSUBI_DU, vd, vj, uk5));
}

/* Emits the `vmaxi.b vd, vj, sk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vmaxi_b(TCGContext *s, TCGReg vd, TCGReg vj, int32_t sk5)
{
    tcg_out32(s, encode_vdvjsk5_insn(OPC_VMAXI_B, vd, vj, sk5));
}

/* Emits the `vmaxi.h vd, vj, sk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vmaxi_h(TCGContext *s, TCGReg vd, TCGReg vj, int32_t sk5)
{
    tcg_out32(s, encode_vdvjsk5_insn(OPC_VMAXI_H, vd, vj, sk5));
}

/* Emits the `vmaxi.w vd, vj, sk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vmaxi_w(TCGContext *s, TCGReg vd, TCGReg vj, int32_t sk5)
{
    tcg_out32(s, encode_vdvjsk5_insn(OPC_VMAXI_W, vd, vj, sk5));
}

/* Emits the `vmaxi.d vd, vj, sk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vmaxi_d(TCGContext *s, TCGReg vd, TCGReg vj, int32_t sk5)
{
    tcg_out32(s, encode_vdvjsk5_insn(OPC_VMAXI_D, vd, vj, sk5));
}

/* Emits the `vmini.b vd, vj, sk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vmini_b(TCGContext *s, TCGReg vd, TCGReg vj, int32_t sk5)
{
    tcg_out32(s, encode_vdvjsk5_insn(OPC_VMINI_B, vd, vj, sk5));
}

/* Emits the `vmini.h vd, vj, sk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vmini_h(TCGContext *s, TCGReg vd, TCGReg vj, int32_t sk5)
{
    tcg_out32(s, encode_vdvjsk5_insn(OPC_VMINI_H, vd, vj, sk5));
}

/* Emits the `vmini.w vd, vj, sk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vmini_w(TCGContext *s, TCGReg vd, TCGReg vj, int32_t sk5)
{
    tcg_out32(s, encode_vdvjsk5_insn(OPC_VMINI_W, vd, vj, sk5));
}

/* Emits the `vmini.d vd, vj, sk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vmini_d(TCGContext *s, TCGReg vd, TCGReg vj, int32_t sk5)
{
    tcg_out32(s, encode_vdvjsk5_insn(OPC_VMINI_D, vd, vj, sk5));
}

/* Emits the `vmaxi.bu vd, vj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vmaxi_bu(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk5)
{
    tcg_out32(s, encode_vdvjuk5_insn(OPC_VMAXI_BU, vd, vj, uk5));
}

/* Emits the `vmaxi.hu vd, vj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vmaxi_hu(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk5)
{
    tcg_out32(s, encode_vdvjuk5_insn(OPC_VMAXI_HU, vd, vj, uk5));
}

/* Emits the `vmaxi.wu vd, vj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vmaxi_wu(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk5)
{
    tcg_out32(s, encode_vdvjuk5_insn(OPC_VMAXI_WU, vd, vj, uk5));
}

/* Emits the `vmaxi.du vd, vj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vmaxi_du(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk5)
{
    tcg_out32(s, encode_vdvjuk5_insn(OPC_VMAXI_DU, vd, vj, uk5));
}

/* Emits the `vmini.bu vd, vj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vmini_bu(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk5)
{
    tcg_out32(s, encode_vdvjuk5_insn(OPC_VMINI_BU, vd, vj, uk5));
}

/* Emits the `vmini.hu vd, vj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vmini_hu(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk5)
{
    tcg_out32(s, encode_vdvjuk5_insn(OPC_VMINI_HU, vd, vj, uk5));
}

/* Emits the `vmini.wu vd, vj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vmini_wu(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk5)
{
    tcg_out32(s, encode_vdvjuk5_insn(OPC_VMINI_WU, vd, vj, uk5));
}

/* Emits the `vmini.du vd, vj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vmini_du(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk5)
{
    tcg_out32(s, encode_vdvjuk5_insn(OPC_VMINI_DU, vd, vj, uk5));
}

/* Emits the `vneg.b vd, vj` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vneg_b(TCGContext *s, TCGReg vd, TCGReg vj)
{
    tcg_out32(s, encode_vdvj_insn(OPC_VNEG_B, vd, vj));
}

/* Emits the `vneg.h vd, vj` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vneg_h(TCGContext *s, TCGReg vd, TCGReg vj)
{
    tcg_out32(s, encode_vdvj_insn(OPC_VNEG_H, vd, vj));
}

/* Emits the `vneg.w vd, vj` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vneg_w(TCGContext *s, TCGReg vd, TCGReg vj)
{
    tcg_out32(s, encode_vdvj_insn(OPC_VNEG_W, vd, vj));
}

/* Emits the `vneg.d vd, vj` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vneg_d(TCGContext *s, TCGReg vd, TCGReg vj)
{
    tcg_out32(s, encode_vdvj_insn(OPC_VNEG_D, vd, vj));
}

/* Emits the `vreplgr2vr.b vd, j` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vreplgr2vr_b(TCGContext *s, TCGReg vd, TCGReg j)
{
    tcg_out32(s, encode_vdj_insn(OPC_VREPLGR2VR_B, vd, j));
}

/* Emits the `vreplgr2vr.h vd, j` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vreplgr2vr_h(TCGContext *s, TCGReg vd, TCGReg j)
{
    tcg_out32(s, encode_vdj_insn(OPC_VREPLGR2VR_H, vd, j));
}

/* Emits the `vreplgr2vr.w vd, j` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vreplgr2vr_w(TCGContext *s, TCGReg vd, TCGReg j)
{
    tcg_out32(s, encode_vdj_insn(OPC_VREPLGR2VR_W, vd, j));
}

/* Emits the `vreplgr2vr.d vd, j` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vreplgr2vr_d(TCGContext *s, TCGReg vd, TCGReg j)
{
    tcg_out32(s, encode_vdj_insn(OPC_VREPLGR2VR_D, vd, j));
}

/* Emits the `vrotri.b vd, vj, uk3` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vrotri_b(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk3)
{
    tcg_out32(s, encode_vdvjuk3_insn(OPC_VROTRI_B, vd, vj, uk3));
}

/* Emits the `vrotri.h vd, vj, uk4` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vrotri_h(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk4)
{
    tcg_out32(s, encode_vdvjuk4_insn(OPC_VROTRI_H, vd, vj, uk4));
}

/* Emits the `vrotri.w vd, vj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vrotri_w(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk5)
{
    tcg_out32(s, encode_vdvjuk5_insn(OPC_VROTRI_W, vd, vj, uk5));
}

/* Emits the `vrotri.d vd, vj, uk6` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vrotri_d(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk6)
{
    tcg_out32(s, encode_vdvjuk6_insn(OPC_VROTRI_D, vd, vj, uk6));
}

/* Emits the `vinsgr2vr.b vd, j, uk4` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vinsgr2vr_b(TCGContext *s, TCGReg vd, TCGReg j, uint32_t uk4)
{
    tcg_out32(s, encode_vdjuk4_insn(OPC_VINSGR2VR_B, vd, j, uk4));
}

/* Emits the `vinsgr2vr.h vd, j, uk3` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vinsgr2vr_h(TCGContext *s, TCGReg vd, TCGReg j, uint32_t uk3)
{
    tcg_out32(s, encode_vdjuk3_insn(OPC_VINSGR2VR_H, vd, j, uk3));
}

/* Emits the `vinsgr2vr.w vd, j, uk2` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vinsgr2vr_w(TCGContext *s, TCGReg vd, TCGReg j, uint32_t uk2)
{
    tcg_out32(s, encode_vdjuk2_insn(OPC_VINSGR2VR_W, vd, j, uk2));
}

/* Emits the `vinsgr2vr.d vd, j, uk1` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vinsgr2vr_d(TCGContext *s, TCGReg vd, TCGReg j, uint32_t uk1)
{
    tcg_out32(s, encode_vdjuk1_insn(OPC_VINSGR2VR_D, vd, j, uk1));
}

/* Emits the `vpickve2gr.b d, vj, uk4` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vpickve2gr_b(TCGContext *s, TCGReg d, TCGReg vj, uint32_t uk4)
{
    tcg_out32(s, encode_dvjuk4_insn(OPC_VPICKVE2GR_B, d, vj, uk4));
}

/* Emits the `vpickve2gr.h d, vj, uk3` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vpickve2gr_h(TCGContext *s, TCGReg d, TCGReg vj, uint32_t uk3)
{
    tcg_out32(s, encode_dvjuk3_insn(OPC_VPICKVE2GR_H, d, vj, uk3));
}

/* Emits the `vpickve2gr.w d, vj, uk2` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vpickve2gr_w(TCGContext *s, TCGReg d, TCGReg vj, uint32_t uk2)
{
    tcg_out32(s, encode_dvjuk2_insn(OPC_VPICKVE2GR_W, d, vj, uk2));
}

/* Emits the `vpickve2gr.d d, vj, uk1` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vpickve2gr_d(TCGContext *s, TCGReg d, TCGReg vj, uint32_t uk1)
{
    tcg_out32(s, encode_dvjuk1_insn(OPC_VPICKVE2GR_D, d, vj, uk1));
}

/* Emits the `vpickve2gr.bu d, vj, uk4` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vpickve2gr_bu(TCGContext *s, TCGReg d, TCGReg vj, uint32_t uk4)
{
    tcg_out32(s, encode_dvjuk4_insn(OPC_VPICKVE2GR_BU, d, vj, uk4));
}

/* Emits the `vpickve2gr.hu d, vj, uk3` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vpickve2gr_hu(TCGContext *s, TCGReg d, TCGReg vj, uint32_t uk3)
{
    tcg_out32(s, encode_dvjuk3_insn(OPC_VPICKVE2GR_HU, d, vj, uk3));
}

/* Emits the `vpickve2gr.wu d, vj, uk2` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vpickve2gr_wu(TCGContext *s, TCGReg d, TCGReg vj, uint32_t uk2)
{
    tcg_out32(s, encode_dvjuk2_insn(OPC_VPICKVE2GR_WU, d, vj, uk2));
}

/* Emits the `vpickve2gr.du d, vj, uk1` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vpickve2gr_du(TCGContext *s, TCGReg d, TCGReg vj, uint32_t uk1)
{
    tcg_out32(s, encode_dvjuk1_insn(OPC_VPICKVE2GR_DU, d, vj, uk1));
}

/* Emits the `vreplvei.b vd, vj, uk4` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vreplvei_b(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk4)
{
    tcg_out32(s, encode_vdvjuk4_insn(OPC_VREPLVEI_B, vd, vj, uk4));
}

/* Emits the `vreplvei.h vd, vj, uk3` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vreplvei_h(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk3)
{
    tcg_out32(s, encode_vdvjuk3_insn(OPC_VREPLVEI_H, vd, vj, uk3));
}

/* Emits the `vreplvei.w vd, vj, uk2` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vreplvei_w(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk2)
{
    tcg_out32(s, encode_vdvjuk2_insn(OPC_VREPLVEI_W, vd, vj, uk2));
}

/* Emits the `vreplvei.d vd, vj, uk1` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vreplvei_d(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk1)
{
    tcg_out32(s, encode_vdvjuk1_insn(OPC_VREPLVEI_D, vd, vj, uk1));
}

/* Emits the `vbitclri.b vd, vj, uk3` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vbitclri_b(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk3)
{
    tcg_out32(s, encode_vdvjuk3_insn(OPC_VBITCLRI_B, vd, vj, uk3));
}

/* Emits the `vbitclri.h vd, vj, uk4` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vbitclri_h(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk4)
{
    tcg_out32(s, encode_vdvjuk4_insn(OPC_VBITCLRI_H, vd, vj, uk4));
}

/* Emits the `vbitclri.w vd, vj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vbitclri_w(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk5)
{
    tcg_out32(s, encode_vdvjuk5_insn(OPC_VBITCLRI_W, vd, vj, uk5));
}

/* Emits the `vbitclri.d vd, vj, uk6` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vbitclri_d(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk6)
{
    tcg_out32(s, encode_vdvjuk6_insn(OPC_VBITCLRI_D, vd, vj, uk6));
}

/* Emits the `vbitseti.b vd, vj, uk3` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vbitseti_b(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk3)
{
    tcg_out32(s, encode_vdvjuk3_insn(OPC_VBITSETI_B, vd, vj, uk3));
}

/* Emits the `vbitseti.h vd, vj, uk4` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vbitseti_h(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk4)
{
    tcg_out32(s, encode_vdvjuk4_insn(OPC_VBITSETI_H, vd, vj, uk4));
}

/* Emits the `vbitseti.w vd, vj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vbitseti_w(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk5)
{
    tcg_out32(s, encode_vdvjuk5_insn(OPC_VBITSETI_W, vd, vj, uk5));
}

/* Emits the `vbitseti.d vd, vj, uk6` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vbitseti_d(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk6)
{
    tcg_out32(s, encode_vdvjuk6_insn(OPC_VBITSETI_D, vd, vj, uk6));
}

/* Emits the `vbitrevi.b vd, vj, uk3` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vbitrevi_b(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk3)
{
    tcg_out32(s, encode_vdvjuk3_insn(OPC_VBITREVI_B, vd, vj, uk3));
}

/* Emits the `vbitrevi.h vd, vj, uk4` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vbitrevi_h(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk4)
{
    tcg_out32(s, encode_vdvjuk4_insn(OPC_VBITREVI_H, vd, vj, uk4));
}

/* Emits the `vbitrevi.w vd, vj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vbitrevi_w(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk5)
{
    tcg_out32(s, encode_vdvjuk5_insn(OPC_VBITREVI_W, vd, vj, uk5));
}

/* Emits the `vbitrevi.d vd, vj, uk6` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vbitrevi_d(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk6)
{
    tcg_out32(s, encode_vdvjuk6_insn(OPC_VBITREVI_D, vd, vj, uk6));
}

/* Emits the `vslli.b vd, vj, uk3` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vslli_b(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk3)
{
    tcg_out32(s, encode_vdvjuk3_insn(OPC_VSLLI_B, vd, vj, uk3));
}

/* Emits the `vslli.h vd, vj, uk4` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vslli_h(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk4)
{
    tcg_out32(s, encode_vdvjuk4_insn(OPC_VSLLI_H, vd, vj, uk4));
}

/* Emits the `vslli.w vd, vj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vslli_w(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk5)
{
    tcg_out32(s, encode_vdvjuk5_insn(OPC_VSLLI_W, vd, vj, uk5));
}

/* Emits the `vslli.d vd, vj, uk6` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vslli_d(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk6)
{
    tcg_out32(s, encode_vdvjuk6_insn(OPC_VSLLI_D, vd, vj, uk6));
}

/* Emits the `vsrli.b vd, vj, uk3` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsrli_b(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk3)
{
    tcg_out32(s, encode_vdvjuk3_insn(OPC_VSRLI_B, vd, vj, uk3));
}

/* Emits the `vsrli.h vd, vj, uk4` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsrli_h(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk4)
{
    tcg_out32(s, encode_vdvjuk4_insn(OPC_VSRLI_H, vd, vj, uk4));
}

/* Emits the `vsrli.w vd, vj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsrli_w(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk5)
{
    tcg_out32(s, encode_vdvjuk5_insn(OPC_VSRLI_W, vd, vj, uk5));
}

/* Emits the `vsrli.d vd, vj, uk6` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsrli_d(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk6)
{
    tcg_out32(s, encode_vdvjuk6_insn(OPC_VSRLI_D, vd, vj, uk6));
}

/* Emits the `vsrai.b vd, vj, uk3` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsrai_b(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk3)
{
    tcg_out32(s, encode_vdvjuk3_insn(OPC_VSRAI_B, vd, vj, uk3));
}

/* Emits the `vsrai.h vd, vj, uk4` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsrai_h(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk4)
{
    tcg_out32(s, encode_vdvjuk4_insn(OPC_VSRAI_H, vd, vj, uk4));
}

/* Emits the `vsrai.w vd, vj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsrai_w(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk5)
{
    tcg_out32(s, encode_vdvjuk5_insn(OPC_VSRAI_W, vd, vj, uk5));
}

/* Emits the `vsrai.d vd, vj, uk6` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vsrai_d(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk6)
{
    tcg_out32(s, encode_vdvjuk6_insn(OPC_VSRAI_D, vd, vj, uk6));
}

/* Emits the `vbitseli.b vd, vj, uk8` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vbitseli_b(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk8)
{
    tcg_out32(s, encode_vdvjuk8_insn(OPC_VBITSELI_B, vd, vj, uk8));
}

/* Emits the `vandi.b vd, vj, uk8` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vandi_b(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk8)
{
    tcg_out32(s, encode_vdvjuk8_insn(OPC_VANDI_B, vd, vj, uk8));
}

/* Emits the `vori.b vd, vj, uk8` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vori_b(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk8)
{
    tcg_out32(s, encode_vdvjuk8_insn(OPC_VORI_B, vd, vj, uk8));
}

/* Emits the `vxori.b vd, vj, uk8` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vxori_b(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk8)
{
    tcg_out32(s, encode_vdvjuk8_insn(OPC_VXORI_B, vd, vj, uk8));
}

/* Emits the `vnori.b vd, vj, uk8` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vnori_b(TCGContext *s, TCGReg vd, TCGReg vj, uint32_t uk8)
{
    tcg_out32(s, encode_vdvjuk8_insn(OPC_VNORI_B, vd, vj, uk8));
}

/* Emits the `vldi vd, sj13` instruction.  */
static void __attribute__((unused))
tcg_out_opc_vldi(TCGContext *s, TCGReg vd, int32_t sj13)
{
    tcg_out32(s, encode_vdsj13_insn(OPC_VLDI, vd, sj13));
}

/* Emits the `xvseq.b xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvseq_b(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSEQ_B, xd, xj, xk));
}

/* Emits the `xvseq.h xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvseq_h(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSEQ_H, xd, xj, xk));
}

/* Emits the `xvseq.w xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvseq_w(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSEQ_W, xd, xj, xk));
}

/* Emits the `xvseq.d xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvseq_d(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSEQ_D, xd, xj, xk));
}

/* Emits the `xvsle.b xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsle_b(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSLE_B, xd, xj, xk));
}

/* Emits the `xvsle.h xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsle_h(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSLE_H, xd, xj, xk));
}

/* Emits the `xvsle.w xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsle_w(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSLE_W, xd, xj, xk));
}

/* Emits the `xvsle.d xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsle_d(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSLE_D, xd, xj, xk));
}

/* Emits the `xvsle.bu xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsle_bu(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSLE_BU, xd, xj, xk));
}

/* Emits the `xvsle.hu xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsle_hu(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSLE_HU, xd, xj, xk));
}

/* Emits the `xvsle.wu xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsle_wu(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSLE_WU, xd, xj, xk));
}

/* Emits the `xvsle.du xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsle_du(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSLE_DU, xd, xj, xk));
}

/* Emits the `xvslt.b xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvslt_b(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSLT_B, xd, xj, xk));
}

/* Emits the `xvslt.h xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvslt_h(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSLT_H, xd, xj, xk));
}

/* Emits the `xvslt.w xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvslt_w(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSLT_W, xd, xj, xk));
}

/* Emits the `xvslt.d xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvslt_d(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSLT_D, xd, xj, xk));
}

/* Emits the `xvslt.bu xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvslt_bu(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSLT_BU, xd, xj, xk));
}

/* Emits the `xvslt.hu xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvslt_hu(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSLT_HU, xd, xj, xk));
}

/* Emits the `xvslt.wu xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvslt_wu(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSLT_WU, xd, xj, xk));
}

/* Emits the `xvslt.du xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvslt_du(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSLT_DU, xd, xj, xk));
}

/* Emits the `xvadd.b xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvadd_b(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVADD_B, xd, xj, xk));
}

/* Emits the `xvadd.h xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvadd_h(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVADD_H, xd, xj, xk));
}

/* Emits the `xvadd.w xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvadd_w(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVADD_W, xd, xj, xk));
}

/* Emits the `xvadd.d xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvadd_d(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVADD_D, xd, xj, xk));
}

/* Emits the `xvsub.b xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsub_b(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSUB_B, xd, xj, xk));
}

/* Emits the `xvsub.h xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsub_h(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSUB_H, xd, xj, xk));
}

/* Emits the `xvsub.w xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsub_w(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSUB_W, xd, xj, xk));
}

/* Emits the `xvsub.d xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsub_d(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSUB_D, xd, xj, xk));
}

/* Emits the `xvsadd.b xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsadd_b(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSADD_B, xd, xj, xk));
}

/* Emits the `xvsadd.h xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsadd_h(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSADD_H, xd, xj, xk));
}

/* Emits the `xvsadd.w xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsadd_w(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSADD_W, xd, xj, xk));
}

/* Emits the `xvsadd.d xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsadd_d(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSADD_D, xd, xj, xk));
}

/* Emits the `xvssub.b xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvssub_b(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSSUB_B, xd, xj, xk));
}

/* Emits the `xvssub.h xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvssub_h(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSSUB_H, xd, xj, xk));
}

/* Emits the `xvssub.w xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvssub_w(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSSUB_W, xd, xj, xk));
}

/* Emits the `xvssub.d xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvssub_d(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSSUB_D, xd, xj, xk));
}

/* Emits the `xvsadd.bu xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsadd_bu(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSADD_BU, xd, xj, xk));
}

/* Emits the `xvsadd.hu xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsadd_hu(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSADD_HU, xd, xj, xk));
}

/* Emits the `xvsadd.wu xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsadd_wu(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSADD_WU, xd, xj, xk));
}

/* Emits the `xvsadd.du xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsadd_du(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSADD_DU, xd, xj, xk));
}

/* Emits the `xvssub.bu xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvssub_bu(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSSUB_BU, xd, xj, xk));
}

/* Emits the `xvssub.hu xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvssub_hu(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSSUB_HU, xd, xj, xk));
}

/* Emits the `xvssub.wu xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvssub_wu(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSSUB_WU, xd, xj, xk));
}

/* Emits the `xvssub.du xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvssub_du(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSSUB_DU, xd, xj, xk));
}

/* Emits the `xvmax.b xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvmax_b(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVMAX_B, xd, xj, xk));
}

/* Emits the `xvmax.h xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvmax_h(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVMAX_H, xd, xj, xk));
}

/* Emits the `xvmax.w xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvmax_w(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVMAX_W, xd, xj, xk));
}

/* Emits the `xvmax.d xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvmax_d(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVMAX_D, xd, xj, xk));
}

/* Emits the `xvmin.b xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvmin_b(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVMIN_B, xd, xj, xk));
}

/* Emits the `xvmin.h xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvmin_h(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVMIN_H, xd, xj, xk));
}

/* Emits the `xvmin.w xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvmin_w(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVMIN_W, xd, xj, xk));
}

/* Emits the `xvmin.d xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvmin_d(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVMIN_D, xd, xj, xk));
}

/* Emits the `xvmax.bu xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvmax_bu(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVMAX_BU, xd, xj, xk));
}

/* Emits the `xvmax.hu xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvmax_hu(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVMAX_HU, xd, xj, xk));
}

/* Emits the `xvmax.wu xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvmax_wu(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVMAX_WU, xd, xj, xk));
}

/* Emits the `xvmax.du xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvmax_du(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVMAX_DU, xd, xj, xk));
}

/* Emits the `xvmin.bu xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvmin_bu(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVMIN_BU, xd, xj, xk));
}

/* Emits the `xvmin.hu xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvmin_hu(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVMIN_HU, xd, xj, xk));
}

/* Emits the `xvmin.wu xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvmin_wu(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVMIN_WU, xd, xj, xk));
}

/* Emits the `xvmin.du xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvmin_du(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVMIN_DU, xd, xj, xk));
}

/* Emits the `xvmul.b xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvmul_b(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVMUL_B, xd, xj, xk));
}

/* Emits the `xvmul.h xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvmul_h(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVMUL_H, xd, xj, xk));
}

/* Emits the `xvmul.w xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvmul_w(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVMUL_W, xd, xj, xk));
}

/* Emits the `xvmul.d xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvmul_d(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVMUL_D, xd, xj, xk));
}

/* Emits the `xvsll.b xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsll_b(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSLL_B, xd, xj, xk));
}

/* Emits the `xvsll.h xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsll_h(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSLL_H, xd, xj, xk));
}

/* Emits the `xvsll.w xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsll_w(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSLL_W, xd, xj, xk));
}

/* Emits the `xvsll.d xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsll_d(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSLL_D, xd, xj, xk));
}

/* Emits the `xvsrl.b xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsrl_b(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSRL_B, xd, xj, xk));
}

/* Emits the `xvsrl.h xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsrl_h(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSRL_H, xd, xj, xk));
}

/* Emits the `xvsrl.w xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsrl_w(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSRL_W, xd, xj, xk));
}

/* Emits the `xvsrl.d xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsrl_d(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSRL_D, xd, xj, xk));
}

/* Emits the `xvsra.b xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsra_b(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSRA_B, xd, xj, xk));
}

/* Emits the `xvsra.h xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsra_h(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSRA_H, xd, xj, xk));
}

/* Emits the `xvsra.w xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsra_w(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSRA_W, xd, xj, xk));
}

/* Emits the `xvsra.d xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsra_d(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVSRA_D, xd, xj, xk));
}

/* Emits the `xvrotr.b xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvrotr_b(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVROTR_B, xd, xj, xk));
}

/* Emits the `xvrotr.h xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvrotr_h(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVROTR_H, xd, xj, xk));
}

/* Emits the `xvrotr.w xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvrotr_w(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVROTR_W, xd, xj, xk));
}

/* Emits the `xvrotr.d xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvrotr_d(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVROTR_D, xd, xj, xk));
}

/* Emits the `xvreplve.b xd, xj, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvreplve_b(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg k)
{
    tcg_out32(s, encode_xdxjk_insn(OPC_XVREPLVE_B, xd, xj, k));
}

/* Emits the `xvreplve.h xd, xj, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvreplve_h(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg k)
{
    tcg_out32(s, encode_xdxjk_insn(OPC_XVREPLVE_H, xd, xj, k));
}

/* Emits the `xvreplve.w xd, xj, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvreplve_w(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg k)
{
    tcg_out32(s, encode_xdxjk_insn(OPC_XVREPLVE_W, xd, xj, k));
}

/* Emits the `xvreplve.d xd, xj, k` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvreplve_d(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg k)
{
    tcg_out32(s, encode_xdxjk_insn(OPC_XVREPLVE_D, xd, xj, k));
}

/* Emits the `xvand.v xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvand_v(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVAND_V, xd, xj, xk));
}

/* Emits the `xvor.v xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvor_v(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVOR_V, xd, xj, xk));
}

/* Emits the `xvxor.v xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvxor_v(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVXOR_V, xd, xj, xk));
}

/* Emits the `xvnor.v xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvnor_v(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVNOR_V, xd, xj, xk));
}

/* Emits the `xvandn.v xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvandn_v(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVANDN_V, xd, xj, xk));
}

/* Emits the `xvorn.v xd, xj, xk` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvorn_v(TCGContext *s, TCGReg xd, TCGReg xj, TCGReg xk)
{
    tcg_out32(s, encode_xdxjxk_insn(OPC_XVORN_V, xd, xj, xk));
}

/* Emits the `xvseqi.b xd, xj, sk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvseqi_b(TCGContext *s, TCGReg xd, TCGReg xj, int32_t sk5)
{
    tcg_out32(s, encode_xdxjsk5_insn(OPC_XVSEQI_B, xd, xj, sk5));
}

/* Emits the `xvseqi.h xd, xj, sk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvseqi_h(TCGContext *s, TCGReg xd, TCGReg xj, int32_t sk5)
{
    tcg_out32(s, encode_xdxjsk5_insn(OPC_XVSEQI_H, xd, xj, sk5));
}

/* Emits the `xvseqi.w xd, xj, sk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvseqi_w(TCGContext *s, TCGReg xd, TCGReg xj, int32_t sk5)
{
    tcg_out32(s, encode_xdxjsk5_insn(OPC_XVSEQI_W, xd, xj, sk5));
}

/* Emits the `xvseqi.d xd, xj, sk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvseqi_d(TCGContext *s, TCGReg xd, TCGReg xj, int32_t sk5)
{
    tcg_out32(s, encode_xdxjsk5_insn(OPC_XVSEQI_D, xd, xj, sk5));
}

/* Emits the `xvslei.b xd, xj, sk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvslei_b(TCGContext *s, TCGReg xd, TCGReg xj, int32_t sk5)
{
    tcg_out32(s, encode_xdxjsk5_insn(OPC_XVSLEI_B, xd, xj, sk5));
}

/* Emits the `xvslei.h xd, xj, sk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvslei_h(TCGContext *s, TCGReg xd, TCGReg xj, int32_t sk5)
{
    tcg_out32(s, encode_xdxjsk5_insn(OPC_XVSLEI_H, xd, xj, sk5));
}

/* Emits the `xvslei.w xd, xj, sk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvslei_w(TCGContext *s, TCGReg xd, TCGReg xj, int32_t sk5)
{
    tcg_out32(s, encode_xdxjsk5_insn(OPC_XVSLEI_W, xd, xj, sk5));
}

/* Emits the `xvslei.d xd, xj, sk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvslei_d(TCGContext *s, TCGReg xd, TCGReg xj, int32_t sk5)
{
    tcg_out32(s, encode_xdxjsk5_insn(OPC_XVSLEI_D, xd, xj, sk5));
}

/* Emits the `xvslei.bu xd, xj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvslei_bu(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk5)
{
    tcg_out32(s, encode_xdxjuk5_insn(OPC_XVSLEI_BU, xd, xj, uk5));
}

/* Emits the `xvslei.hu xd, xj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvslei_hu(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk5)
{
    tcg_out32(s, encode_xdxjuk5_insn(OPC_XVSLEI_HU, xd, xj, uk5));
}

/* Emits the `xvslei.wu xd, xj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvslei_wu(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk5)
{
    tcg_out32(s, encode_xdxjuk5_insn(OPC_XVSLEI_WU, xd, xj, uk5));
}

/* Emits the `xvslei.du xd, xj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvslei_du(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk5)
{
    tcg_out32(s, encode_xdxjuk5_insn(OPC_XVSLEI_DU, xd, xj, uk5));
}

/* Emits the `xvslti.b xd, xj, sk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvslti_b(TCGContext *s, TCGReg xd, TCGReg xj, int32_t sk5)
{
    tcg_out32(s, encode_xdxjsk5_insn(OPC_XVSLTI_B, xd, xj, sk5));
}

/* Emits the `xvslti.h xd, xj, sk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvslti_h(TCGContext *s, TCGReg xd, TCGReg xj, int32_t sk5)
{
    tcg_out32(s, encode_xdxjsk5_insn(OPC_XVSLTI_H, xd, xj, sk5));
}

/* Emits the `xvslti.w xd, xj, sk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvslti_w(TCGContext *s, TCGReg xd, TCGReg xj, int32_t sk5)
{
    tcg_out32(s, encode_xdxjsk5_insn(OPC_XVSLTI_W, xd, xj, sk5));
}

/* Emits the `xvslti.d xd, xj, sk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvslti_d(TCGContext *s, TCGReg xd, TCGReg xj, int32_t sk5)
{
    tcg_out32(s, encode_xdxjsk5_insn(OPC_XVSLTI_D, xd, xj, sk5));
}

/* Emits the `xvslti.bu xd, xj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvslti_bu(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk5)
{
    tcg_out32(s, encode_xdxjuk5_insn(OPC_XVSLTI_BU, xd, xj, uk5));
}

/* Emits the `xvslti.hu xd, xj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvslti_hu(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk5)
{
    tcg_out32(s, encode_xdxjuk5_insn(OPC_XVSLTI_HU, xd, xj, uk5));
}

/* Emits the `xvslti.wu xd, xj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvslti_wu(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk5)
{
    tcg_out32(s, encode_xdxjuk5_insn(OPC_XVSLTI_WU, xd, xj, uk5));
}

/* Emits the `xvslti.du xd, xj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvslti_du(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk5)
{
    tcg_out32(s, encode_xdxjuk5_insn(OPC_XVSLTI_DU, xd, xj, uk5));
}

/* Emits the `xvaddi.bu xd, xj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvaddi_bu(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk5)
{
    tcg_out32(s, encode_xdxjuk5_insn(OPC_XVADDI_BU, xd, xj, uk5));
}

/* Emits the `xvaddi.hu xd, xj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvaddi_hu(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk5)
{
    tcg_out32(s, encode_xdxjuk5_insn(OPC_XVADDI_HU, xd, xj, uk5));
}

/* Emits the `xvaddi.wu xd, xj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvaddi_wu(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk5)
{
    tcg_out32(s, encode_xdxjuk5_insn(OPC_XVADDI_WU, xd, xj, uk5));
}

/* Emits the `xvaddi.du xd, xj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvaddi_du(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk5)
{
    tcg_out32(s, encode_xdxjuk5_insn(OPC_XVADDI_DU, xd, xj, uk5));
}

/* Emits the `xvsubi.bu xd, xj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsubi_bu(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk5)
{
    tcg_out32(s, encode_xdxjuk5_insn(OPC_XVSUBI_BU, xd, xj, uk5));
}

/* Emits the `xvsubi.hu xd, xj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsubi_hu(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk5)
{
    tcg_out32(s, encode_xdxjuk5_insn(OPC_XVSUBI_HU, xd, xj, uk5));
}

/* Emits the `xvsubi.wu xd, xj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsubi_wu(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk5)
{
    tcg_out32(s, encode_xdxjuk5_insn(OPC_XVSUBI_WU, xd, xj, uk5));
}

/* Emits the `xvsubi.du xd, xj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsubi_du(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk5)
{
    tcg_out32(s, encode_xdxjuk5_insn(OPC_XVSUBI_DU, xd, xj, uk5));
}

/* Emits the `xvmaxi.b xd, xj, sk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvmaxi_b(TCGContext *s, TCGReg xd, TCGReg xj, int32_t sk5)
{
    tcg_out32(s, encode_xdxjsk5_insn(OPC_XVMAXI_B, xd, xj, sk5));
}

/* Emits the `xvmaxi.h xd, xj, sk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvmaxi_h(TCGContext *s, TCGReg xd, TCGReg xj, int32_t sk5)
{
    tcg_out32(s, encode_xdxjsk5_insn(OPC_XVMAXI_H, xd, xj, sk5));
}

/* Emits the `xvmaxi.w xd, xj, sk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvmaxi_w(TCGContext *s, TCGReg xd, TCGReg xj, int32_t sk5)
{
    tcg_out32(s, encode_xdxjsk5_insn(OPC_XVMAXI_W, xd, xj, sk5));
}

/* Emits the `xvmaxi.d xd, xj, sk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvmaxi_d(TCGContext *s, TCGReg xd, TCGReg xj, int32_t sk5)
{
    tcg_out32(s, encode_xdxjsk5_insn(OPC_XVMAXI_D, xd, xj, sk5));
}

/* Emits the `xvmini.b xd, xj, sk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvmini_b(TCGContext *s, TCGReg xd, TCGReg xj, int32_t sk5)
{
    tcg_out32(s, encode_xdxjsk5_insn(OPC_XVMINI_B, xd, xj, sk5));
}

/* Emits the `xvmini.h xd, xj, sk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvmini_h(TCGContext *s, TCGReg xd, TCGReg xj, int32_t sk5)
{
    tcg_out32(s, encode_xdxjsk5_insn(OPC_XVMINI_H, xd, xj, sk5));
}

/* Emits the `xvmini.w xd, xj, sk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvmini_w(TCGContext *s, TCGReg xd, TCGReg xj, int32_t sk5)
{
    tcg_out32(s, encode_xdxjsk5_insn(OPC_XVMINI_W, xd, xj, sk5));
}

/* Emits the `xvmini.d xd, xj, sk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvmini_d(TCGContext *s, TCGReg xd, TCGReg xj, int32_t sk5)
{
    tcg_out32(s, encode_xdxjsk5_insn(OPC_XVMINI_D, xd, xj, sk5));
}

/* Emits the `xvmaxi.bu xd, xj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvmaxi_bu(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk5)
{
    tcg_out32(s, encode_xdxjuk5_insn(OPC_XVMAXI_BU, xd, xj, uk5));
}

/* Emits the `xvmaxi.hu xd, xj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvmaxi_hu(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk5)
{
    tcg_out32(s, encode_xdxjuk5_insn(OPC_XVMAXI_HU, xd, xj, uk5));
}

/* Emits the `xvmaxi.wu xd, xj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvmaxi_wu(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk5)
{
    tcg_out32(s, encode_xdxjuk5_insn(OPC_XVMAXI_WU, xd, xj, uk5));
}

/* Emits the `xvmaxi.du xd, xj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvmaxi_du(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk5)
{
    tcg_out32(s, encode_xdxjuk5_insn(OPC_XVMAXI_DU, xd, xj, uk5));
}

/* Emits the `xvmini.bu xd, xj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvmini_bu(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk5)
{
    tcg_out32(s, encode_xdxjuk5_insn(OPC_XVMINI_BU, xd, xj, uk5));
}

/* Emits the `xvmini.hu xd, xj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvmini_hu(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk5)
{
    tcg_out32(s, encode_xdxjuk5_insn(OPC_XVMINI_HU, xd, xj, uk5));
}

/* Emits the `xvmini.wu xd, xj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvmini_wu(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk5)
{
    tcg_out32(s, encode_xdxjuk5_insn(OPC_XVMINI_WU, xd, xj, uk5));
}

/* Emits the `xvmini.du xd, xj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvmini_du(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk5)
{
    tcg_out32(s, encode_xdxjuk5_insn(OPC_XVMINI_DU, xd, xj, uk5));
}

/* Emits the `xvneg.b xd, xj` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvneg_b(TCGContext *s, TCGReg xd, TCGReg xj)
{
    tcg_out32(s, encode_xdxj_insn(OPC_XVNEG_B, xd, xj));
}

/* Emits the `xvneg.h xd, xj` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvneg_h(TCGContext *s, TCGReg xd, TCGReg xj)
{
    tcg_out32(s, encode_xdxj_insn(OPC_XVNEG_H, xd, xj));
}

/* Emits the `xvneg.w xd, xj` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvneg_w(TCGContext *s, TCGReg xd, TCGReg xj)
{
    tcg_out32(s, encode_xdxj_insn(OPC_XVNEG_W, xd, xj));
}

/* Emits the `xvneg.d xd, xj` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvneg_d(TCGContext *s, TCGReg xd, TCGReg xj)
{
    tcg_out32(s, encode_xdxj_insn(OPC_XVNEG_D, xd, xj));
}

/* Emits the `xvreplgr2vr.b xd, j` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvreplgr2vr_b(TCGContext *s, TCGReg xd, TCGReg j)
{
    tcg_out32(s, encode_xdj_insn(OPC_XVREPLGR2VR_B, xd, j));
}

/* Emits the `xvreplgr2vr.h xd, j` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvreplgr2vr_h(TCGContext *s, TCGReg xd, TCGReg j)
{
    tcg_out32(s, encode_xdj_insn(OPC_XVREPLGR2VR_H, xd, j));
}

/* Emits the `xvreplgr2vr.w xd, j` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvreplgr2vr_w(TCGContext *s, TCGReg xd, TCGReg j)
{
    tcg_out32(s, encode_xdj_insn(OPC_XVREPLGR2VR_W, xd, j));
}

/* Emits the `xvreplgr2vr.d xd, j` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvreplgr2vr_d(TCGContext *s, TCGReg xd, TCGReg j)
{
    tcg_out32(s, encode_xdj_insn(OPC_XVREPLGR2VR_D, xd, j));
}

/* Emits the `xvrotri.b xd, xj, uk3` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvrotri_b(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk3)
{
    tcg_out32(s, encode_xdxjuk3_insn(OPC_XVROTRI_B, xd, xj, uk3));
}

/* Emits the `xvrotri.h xd, xj, uk4` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvrotri_h(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk4)
{
    tcg_out32(s, encode_xdxjuk4_insn(OPC_XVROTRI_H, xd, xj, uk4));
}

/* Emits the `xvrotri.w xd, xj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvrotri_w(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk5)
{
    tcg_out32(s, encode_xdxjuk5_insn(OPC_XVROTRI_W, xd, xj, uk5));
}

/* Emits the `xvrotri.d xd, xj, uk6` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvrotri_d(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk6)
{
    tcg_out32(s, encode_xdxjuk6_insn(OPC_XVROTRI_D, xd, xj, uk6));
}

/* Emits the `xvinsgr2vr.w xd, j, uk3` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvinsgr2vr_w(TCGContext *s, TCGReg xd, TCGReg j, uint32_t uk3)
{
    tcg_out32(s, encode_xdjuk3_insn(OPC_XVINSGR2VR_W, xd, j, uk3));
}

/* Emits the `xvinsgr2vr.d xd, j, uk2` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvinsgr2vr_d(TCGContext *s, TCGReg xd, TCGReg j, uint32_t uk2)
{
    tcg_out32(s, encode_xdjuk2_insn(OPC_XVINSGR2VR_D, xd, j, uk2));
}

/* Emits the `xvpickve2gr.w d, xj, uk3` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvpickve2gr_w(TCGContext *s, TCGReg d, TCGReg xj, uint32_t uk3)
{
    tcg_out32(s, encode_dxjuk3_insn(OPC_XVPICKVE2GR_W, d, xj, uk3));
}

/* Emits the `xvpickve2gr.d d, xj, uk2` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvpickve2gr_d(TCGContext *s, TCGReg d, TCGReg xj, uint32_t uk2)
{
    tcg_out32(s, encode_dxjuk2_insn(OPC_XVPICKVE2GR_D, d, xj, uk2));
}

/* Emits the `xvpickve2gr.wu d, xj, uk3` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvpickve2gr_wu(TCGContext *s, TCGReg d, TCGReg xj, uint32_t uk3)
{
    tcg_out32(s, encode_dxjuk3_insn(OPC_XVPICKVE2GR_WU, d, xj, uk3));
}

/* Emits the `xvpickve2gr.du d, xj, uk2` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvpickve2gr_du(TCGContext *s, TCGReg d, TCGReg xj, uint32_t uk2)
{
    tcg_out32(s, encode_dxjuk2_insn(OPC_XVPICKVE2GR_DU, d, xj, uk2));
}

/* Emits the `xvrepl128vei.b xd, xj, uk4` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvrepl128vei_b(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk4)
{
    tcg_out32(s, encode_xdxjuk4_insn(OPC_XVREPL128VEI_B, xd, xj, uk4));
}

/* Emits the `xvrepl128vei.h xd, xj, uk3` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvrepl128vei_h(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk3)
{
    tcg_out32(s, encode_xdxjuk3_insn(OPC_XVREPL128VEI_H, xd, xj, uk3));
}

/* Emits the `xvrepl128vei.w xd, xj, uk2` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvrepl128vei_w(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk2)
{
    tcg_out32(s, encode_xdxjuk2_insn(OPC_XVREPL128VEI_W, xd, xj, uk2));
}

/* Emits the `xvrepl128vei.d xd, xj, uk1` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvrepl128vei_d(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk1)
{
    tcg_out32(s, encode_xdxjuk1_insn(OPC_XVREPL128VEI_D, xd, xj, uk1));
}

/* Emits the `xvreplve0.b xd, xj` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvreplve0_b(TCGContext *s, TCGReg xd, TCGReg xj)
{
    tcg_out32(s, encode_xdxj_insn(OPC_XVREPLVE0_B, xd, xj));
}

/* Emits the `xvreplve0.h xd, xj` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvreplve0_h(TCGContext *s, TCGReg xd, TCGReg xj)
{
    tcg_out32(s, encode_xdxj_insn(OPC_XVREPLVE0_H, xd, xj));
}

/* Emits the `xvreplve0.w xd, xj` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvreplve0_w(TCGContext *s, TCGReg xd, TCGReg xj)
{
    tcg_out32(s, encode_xdxj_insn(OPC_XVREPLVE0_W, xd, xj));
}

/* Emits the `xvreplve0.d xd, xj` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvreplve0_d(TCGContext *s, TCGReg xd, TCGReg xj)
{
    tcg_out32(s, encode_xdxj_insn(OPC_XVREPLVE0_D, xd, xj));
}

/* Emits the `xvreplve0.q xd, xj` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvreplve0_q(TCGContext *s, TCGReg xd, TCGReg xj)
{
    tcg_out32(s, encode_xdxj_insn(OPC_XVREPLVE0_Q, xd, xj));
}

/* Emits the `xvbitclri.b xd, xj, uk3` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvbitclri_b(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk3)
{
    tcg_out32(s, encode_xdxjuk3_insn(OPC_XVBITCLRI_B, xd, xj, uk3));
}

/* Emits the `xvbitclri.h xd, xj, uk4` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvbitclri_h(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk4)
{
    tcg_out32(s, encode_xdxjuk4_insn(OPC_XVBITCLRI_H, xd, xj, uk4));
}

/* Emits the `xvbitclri.w xd, xj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvbitclri_w(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk5)
{
    tcg_out32(s, encode_xdxjuk5_insn(OPC_XVBITCLRI_W, xd, xj, uk5));
}

/* Emits the `xvbitclri.d xd, xj, uk6` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvbitclri_d(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk6)
{
    tcg_out32(s, encode_xdxjuk6_insn(OPC_XVBITCLRI_D, xd, xj, uk6));
}

/* Emits the `xvbitseti.b xd, xj, uk3` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvbitseti_b(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk3)
{
    tcg_out32(s, encode_xdxjuk3_insn(OPC_XVBITSETI_B, xd, xj, uk3));
}

/* Emits the `xvbitseti.h xd, xj, uk4` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvbitseti_h(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk4)
{
    tcg_out32(s, encode_xdxjuk4_insn(OPC_XVBITSETI_H, xd, xj, uk4));
}

/* Emits the `xvbitseti.w xd, xj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvbitseti_w(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk5)
{
    tcg_out32(s, encode_xdxjuk5_insn(OPC_XVBITSETI_W, xd, xj, uk5));
}

/* Emits the `xvbitseti.d xd, xj, uk6` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvbitseti_d(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk6)
{
    tcg_out32(s, encode_xdxjuk6_insn(OPC_XVBITSETI_D, xd, xj, uk6));
}

/* Emits the `xvbitrevi.b xd, xj, uk3` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvbitrevi_b(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk3)
{
    tcg_out32(s, encode_xdxjuk3_insn(OPC_XVBITREVI_B, xd, xj, uk3));
}

/* Emits the `xvbitrevi.h xd, xj, uk4` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvbitrevi_h(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk4)
{
    tcg_out32(s, encode_xdxjuk4_insn(OPC_XVBITREVI_H, xd, xj, uk4));
}

/* Emits the `xvbitrevi.w xd, xj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvbitrevi_w(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk5)
{
    tcg_out32(s, encode_xdxjuk5_insn(OPC_XVBITREVI_W, xd, xj, uk5));
}

/* Emits the `xvbitrevi.d xd, xj, uk6` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvbitrevi_d(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk6)
{
    tcg_out32(s, encode_xdxjuk6_insn(OPC_XVBITREVI_D, xd, xj, uk6));
}

/* Emits the `xvslli.b xd, xj, uk3` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvslli_b(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk3)
{
    tcg_out32(s, encode_xdxjuk3_insn(OPC_XVSLLI_B, xd, xj, uk3));
}

/* Emits the `xvslli.h xd, xj, uk4` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvslli_h(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk4)
{
    tcg_out32(s, encode_xdxjuk4_insn(OPC_XVSLLI_H, xd, xj, uk4));
}

/* Emits the `xvslli.w xd, xj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvslli_w(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk5)
{
    tcg_out32(s, encode_xdxjuk5_insn(OPC_XVSLLI_W, xd, xj, uk5));
}

/* Emits the `xvslli.d xd, xj, uk6` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvslli_d(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk6)
{
    tcg_out32(s, encode_xdxjuk6_insn(OPC_XVSLLI_D, xd, xj, uk6));
}

/* Emits the `xvsrli.b xd, xj, uk3` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsrli_b(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk3)
{
    tcg_out32(s, encode_xdxjuk3_insn(OPC_XVSRLI_B, xd, xj, uk3));
}

/* Emits the `xvsrli.h xd, xj, uk4` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsrli_h(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk4)
{
    tcg_out32(s, encode_xdxjuk4_insn(OPC_XVSRLI_H, xd, xj, uk4));
}

/* Emits the `xvsrli.w xd, xj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsrli_w(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk5)
{
    tcg_out32(s, encode_xdxjuk5_insn(OPC_XVSRLI_W, xd, xj, uk5));
}

/* Emits the `xvsrli.d xd, xj, uk6` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsrli_d(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk6)
{
    tcg_out32(s, encode_xdxjuk6_insn(OPC_XVSRLI_D, xd, xj, uk6));
}

/* Emits the `xvsrai.b xd, xj, uk3` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsrai_b(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk3)
{
    tcg_out32(s, encode_xdxjuk3_insn(OPC_XVSRAI_B, xd, xj, uk3));
}

/* Emits the `xvsrai.h xd, xj, uk4` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsrai_h(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk4)
{
    tcg_out32(s, encode_xdxjuk4_insn(OPC_XVSRAI_H, xd, xj, uk4));
}

/* Emits the `xvsrai.w xd, xj, uk5` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsrai_w(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk5)
{
    tcg_out32(s, encode_xdxjuk5_insn(OPC_XVSRAI_W, xd, xj, uk5));
}

/* Emits the `xvsrai.d xd, xj, uk6` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvsrai_d(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk6)
{
    tcg_out32(s, encode_xdxjuk6_insn(OPC_XVSRAI_D, xd, xj, uk6));
}

/* Emits the `xvbitseli.b xd, xj, uk8` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvbitseli_b(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk8)
{
    tcg_out32(s, encode_xdxjuk8_insn(OPC_XVBITSELI_B, xd, xj, uk8));
}

/* Emits the `xvandi.b xd, xj, uk8` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvandi_b(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk8)
{
    tcg_out32(s, encode_xdxjuk8_insn(OPC_XVANDI_B, xd, xj, uk8));
}

/* Emits the `xvori.b xd, xj, uk8` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvori_b(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk8)
{
    tcg_out32(s, encode_xdxjuk8_insn(OPC_XVORI_B, xd, xj, uk8));
}

/* Emits the `xvxori.b xd, xj, uk8` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvxori_b(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk8)
{
    tcg_out32(s, encode_xdxjuk8_insn(OPC_XVXORI_B, xd, xj, uk8));
}

/* Emits the `xvnori.b xd, xj, uk8` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvnori_b(TCGContext *s, TCGReg xd, TCGReg xj, uint32_t uk8)
{
    tcg_out32(s, encode_xdxjuk8_insn(OPC_XVNORI_B, xd, xj, uk8));
}

/* Emits the `xvldi xd, sj13` instruction.  */
static void __attribute__((unused))
tcg_out_opc_xvldi(TCGContext *s, TCGReg xd, int32_t sj13)
{
    tcg_out32(s, encode_xdsj13_insn(OPC_XVLDI, xd, sj13));
}

/* End of generated code.  */
