(****************************************************************************)
(*                           the diy toolsuite                              *)
(*                                                                          *)
(* Jade Alglave, University College London, UK.                             *)
(* Luc Maranget, INRIA Paris-Rocquencourt, France.                          *)
(*                                                                          *)
(* Copyright 2021-present Institut National de Recherche en Informatique et *)
(* en Automatique and the authors. All rights reserved.                     *)
(*                                                                          *)
(* This software is governed by the CeCILL-B license under French law and   *)
(* abiding by the rules of distribution of free software. You can use,      *)
(* modify and/ or redistribute the software under the terms of the CeCILL-B *)
(* license as circulated by CEA, CNRS and INRIA at the following URL        *)
(* "http://www.cecill.info". We also give a copy in LICENSE.txt.            *)
(****************************************************************************)

(** Simple interface to interval timer in virtual processor time *)


(** [set_signal timeout handle] set signal handle for timer.
  * Argument timeout is an option, if [None] do nothing
  * Argument debug is default false, if [true] print timeout debug *)
val set_signal : float option -> (int -> unit) -> bool -> unit

(** [start timeout] start interval for the given period.
  * Argument timeout is an option, if [None] do nothing,
  * otherwise the option specifies the timer period. *)
val start : string -> float option -> unit

(** [stop timeout] stop interval timer.
  * Argument timeout is an option, if [None] do nothing,
  * otherwise stop timer. *)
val stop : float option -> unit
