#pragma once
/*
 *  $Id: color-dialog.h 28348 2025-08-11 16:29:06Z yeti-dn $
 *  Copyright (C) 2025 David Necas (Yeti).
 *  E-mail: yeti@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWYUI_COLOR_DIALOG_H__
#define __GWYUI_COLOR_DIALOG_H__

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define GWY_TYPE_COLOR_DIALOG            (gwy_color_dialog_get_type())
#define GWY_COLOR_DIALOG(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), GWY_TYPE_COLOR_DIALOG, GwyColorDialog))
#define GWY_COLOR_DIALOG_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), GWY_TYPE_COLOR_DIALOG, GwyColorDialogClass))
#define GWY_IS_COLOR_DIALOG(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), GWY_TYPE_COLOR_DIALOG))
#define GWY_IS_COLOR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GWY_TYPE_COLOR_DIALOG))
#define GWY_COLOR_DIALOG_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), GWY_TYPE_COLOR_DIALOG, GwyColorDialogClass))

typedef struct _GwyColorDialog             GwyColorDialog;
typedef struct _GwyColorDialogClass        GwyColorDialogClass;
typedef struct _GwyColorDialogPrivate      GwyColorDialogPrivate;

struct _GwyColorDialog {
    GtkDialog parent_instance;
    GwyColorDialogPrivate *priv;
};

struct _GwyColorDialogClass {
    GtkDialogClass parent_class;

    void (*reserved1)(void);
    void (*reserved2)(void);
    void (*reserved3)(void);
    void (*reserved4)(void);
};

GType      gwy_color_dialog_get_type  (void)                    G_GNUC_CONST;
GtkWidget* gwy_color_dialog_new       (GtkWindow *parent,
                                       gboolean modal);
GtkWidget* gwy_color_dialog_get_editor(GwyColorDialog *dialog);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
