/*
 * CLOUD API
 *
 *  IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.
 *
 * API version: 6.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionoscloud

import (
	"encoding/json"
	"fmt"
)

// KubernetesNodePoolServerType The type of server for the Kubernetes node pool can be either 'DedicatedCore' (nodes with dedicated CPU cores) or 'VCPU' (nodes with shared CPU cores). This selection corresponds to the server type for the compute engine.
type KubernetesNodePoolServerType string

// List of KubernetesNodePoolServerType
const (
	DEDICATED_CORE KubernetesNodePoolServerType = "DedicatedCore"
	VCPU           KubernetesNodePoolServerType = "VCPU"
)

func (v *KubernetesNodePoolServerType) UnmarshalJSON(src []byte) error {
	var value string
	err := json.Unmarshal(src, &value)
	if err != nil {
		return err
	}
	enumTypeValue := KubernetesNodePoolServerType(value)
	for _, existing := range []KubernetesNodePoolServerType{"DedicatedCore", "VCPU"} {
		if existing == enumTypeValue {
			*v = enumTypeValue
			return nil
		}
	}

	return fmt.Errorf("%+v is not a valid KubernetesNodePoolServerType", value)
}

// Ptr returns reference to KubernetesNodePoolServerType value
func (v KubernetesNodePoolServerType) Ptr() *KubernetesNodePoolServerType {
	return &v
}

type NullableKubernetesNodePoolServerType struct {
	value *KubernetesNodePoolServerType
	isSet bool
}

func (v NullableKubernetesNodePoolServerType) Get() *KubernetesNodePoolServerType {
	return v.value
}

func (v *NullableKubernetesNodePoolServerType) Set(val *KubernetesNodePoolServerType) {
	v.value = val
	v.isSet = true
}

func (v NullableKubernetesNodePoolServerType) IsSet() bool {
	return v.isSet
}

func (v *NullableKubernetesNodePoolServerType) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableKubernetesNodePoolServerType(val *KubernetesNodePoolServerType) *NullableKubernetesNodePoolServerType {
	return &NullableKubernetesNodePoolServerType{value: val, isSet: true}
}

func (v NullableKubernetesNodePoolServerType) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableKubernetesNodePoolServerType) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
