// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/storage/v1/storage_resources.proto

package storage

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// A set of properties to return in a response.
type CommonEnums_Projection int32

const (
	// No specified projection.
	CommonEnums_PROJECTION_UNSPECIFIED CommonEnums_Projection = 0
	// Omit `owner`, `acl`, and `defaultObjectAcl` properties.
	CommonEnums_NO_ACL CommonEnums_Projection = 1
	// Include all properties.
	CommonEnums_FULL CommonEnums_Projection = 2
)

var CommonEnums_Projection_name = map[int32]string{
	0: "PROJECTION_UNSPECIFIED",
	1: "NO_ACL",
	2: "FULL",
}

var CommonEnums_Projection_value = map[string]int32{
	"PROJECTION_UNSPECIFIED": 0,
	"NO_ACL":                 1,
	"FULL":                   2,
}

func (x CommonEnums_Projection) String() string {
	return proto.EnumName(CommonEnums_Projection_name, int32(x))
}

func (CommonEnums_Projection) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_303b257d2554d792, []int{7, 0}
}

// Predefined or "canned" aliases for sets of specific bucket ACL entries.
type CommonEnums_PredefinedBucketAcl int32

const (
	// No predefined ACL.
	CommonEnums_PREDEFINED_BUCKET_ACL_UNSPECIFIED CommonEnums_PredefinedBucketAcl = 0
	// Project team owners get `OWNER` access, and
	// `allAuthenticatedUsers` get `READER` access.
	CommonEnums_BUCKET_ACL_AUTHENTICATED_READ CommonEnums_PredefinedBucketAcl = 1
	// Project team owners get `OWNER` access.
	CommonEnums_BUCKET_ACL_PRIVATE CommonEnums_PredefinedBucketAcl = 2
	// Project team members get access according to their roles.
	CommonEnums_BUCKET_ACL_PROJECT_PRIVATE CommonEnums_PredefinedBucketAcl = 3
	// Project team owners get `OWNER` access, and
	// `allUsers` get `READER` access.
	CommonEnums_BUCKET_ACL_PUBLIC_READ CommonEnums_PredefinedBucketAcl = 4
	// Project team owners get `OWNER` access, and
	// `allUsers` get `WRITER` access.
	CommonEnums_BUCKET_ACL_PUBLIC_READ_WRITE CommonEnums_PredefinedBucketAcl = 5
)

var CommonEnums_PredefinedBucketAcl_name = map[int32]string{
	0: "PREDEFINED_BUCKET_ACL_UNSPECIFIED",
	1: "BUCKET_ACL_AUTHENTICATED_READ",
	2: "BUCKET_ACL_PRIVATE",
	3: "BUCKET_ACL_PROJECT_PRIVATE",
	4: "BUCKET_ACL_PUBLIC_READ",
	5: "BUCKET_ACL_PUBLIC_READ_WRITE",
}

var CommonEnums_PredefinedBucketAcl_value = map[string]int32{
	"PREDEFINED_BUCKET_ACL_UNSPECIFIED": 0,
	"BUCKET_ACL_AUTHENTICATED_READ":     1,
	"BUCKET_ACL_PRIVATE":                2,
	"BUCKET_ACL_PROJECT_PRIVATE":        3,
	"BUCKET_ACL_PUBLIC_READ":            4,
	"BUCKET_ACL_PUBLIC_READ_WRITE":      5,
}

func (x CommonEnums_PredefinedBucketAcl) String() string {
	return proto.EnumName(CommonEnums_PredefinedBucketAcl_name, int32(x))
}

func (CommonEnums_PredefinedBucketAcl) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_303b257d2554d792, []int{7, 1}
}

// Predefined or "canned" aliases for sets of specific object ACL entries.
type CommonEnums_PredefinedObjectAcl int32

const (
	// No predefined ACL.
	CommonEnums_PREDEFINED_OBJECT_ACL_UNSPECIFIED CommonEnums_PredefinedObjectAcl = 0
	// Object owner gets `OWNER` access, and
	// `allAuthenticatedUsers` get `READER` access.
	CommonEnums_OBJECT_ACL_AUTHENTICATED_READ CommonEnums_PredefinedObjectAcl = 1
	// Object owner gets `OWNER` access, and project team owners get
	// `OWNER` access.
	CommonEnums_OBJECT_ACL_BUCKET_OWNER_FULL_CONTROL CommonEnums_PredefinedObjectAcl = 2
	// Object owner gets `OWNER` access, and project team owners get
	// `READER` access.
	CommonEnums_OBJECT_ACL_BUCKET_OWNER_READ CommonEnums_PredefinedObjectAcl = 3
	// Object owner gets `OWNER` access.
	CommonEnums_OBJECT_ACL_PRIVATE CommonEnums_PredefinedObjectAcl = 4
	// Object owner gets `OWNER` access, and project team members get
	// access according to their roles.
	CommonEnums_OBJECT_ACL_PROJECT_PRIVATE CommonEnums_PredefinedObjectAcl = 5
	// Object owner gets `OWNER` access, and `allUsers`
	// get `READER` access.
	CommonEnums_OBJECT_ACL_PUBLIC_READ CommonEnums_PredefinedObjectAcl = 6
)

var CommonEnums_PredefinedObjectAcl_name = map[int32]string{
	0: "PREDEFINED_OBJECT_ACL_UNSPECIFIED",
	1: "OBJECT_ACL_AUTHENTICATED_READ",
	2: "OBJECT_ACL_BUCKET_OWNER_FULL_CONTROL",
	3: "OBJECT_ACL_BUCKET_OWNER_READ",
	4: "OBJECT_ACL_PRIVATE",
	5: "OBJECT_ACL_PROJECT_PRIVATE",
	6: "OBJECT_ACL_PUBLIC_READ",
}

var CommonEnums_PredefinedObjectAcl_value = map[string]int32{
	"PREDEFINED_OBJECT_ACL_UNSPECIFIED":    0,
	"OBJECT_ACL_AUTHENTICATED_READ":        1,
	"OBJECT_ACL_BUCKET_OWNER_FULL_CONTROL": 2,
	"OBJECT_ACL_BUCKET_OWNER_READ":         3,
	"OBJECT_ACL_PRIVATE":                   4,
	"OBJECT_ACL_PROJECT_PRIVATE":           5,
	"OBJECT_ACL_PUBLIC_READ":               6,
}

func (x CommonEnums_PredefinedObjectAcl) String() string {
	return proto.EnumName(CommonEnums_PredefinedObjectAcl_name, int32(x))
}

func (CommonEnums_PredefinedObjectAcl) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_303b257d2554d792, []int{7, 2}
}

// A bucket.
type Bucket struct {
	// Access controls on the bucket.
	Acl []*BucketAccessControl `protobuf:"bytes,1,rep,name=acl,proto3" json:"acl,omitempty"`
	// Default access controls to apply to new objects when no ACL is provided.
	DefaultObjectAcl []*ObjectAccessControl `protobuf:"bytes,2,rep,name=default_object_acl,json=defaultObjectAcl,proto3" json:"default_object_acl,omitempty"`
	// The bucket's lifecycle configuration. See
	// [https://developers.google.com/storage/docs/lifecycle]Lifecycle Management]
	// for more information.
	Lifecycle *Bucket_Lifecycle `protobuf:"bytes,3,opt,name=lifecycle,proto3" json:"lifecycle,omitempty"`
	// The creation time of the bucket in
	// [https://tools.ietf.org/html/rfc3339][RFC 3339] format.
	// Attempting to set this field will result in an error.
	TimeCreated *timestamp.Timestamp `protobuf:"bytes,4,opt,name=time_created,json=timeCreated,proto3" json:"time_created,omitempty"`
	// The ID of the bucket. For buckets, the `id` and `name` properties are the
	// same.
	// Attempting to update this field after the bucket is created will result in
	// an error.
	Id string `protobuf:"bytes,5,opt,name=id,proto3" json:"id,omitempty"`
	// The name of the bucket.
	// Attempting to update this field after the bucket is created will result in
	// an error.
	Name string `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	// The project number of the project the bucket belongs to.
	// Attempting to set this field will result in an error.
	ProjectNumber int64 `protobuf:"varint,7,opt,name=project_number,json=projectNumber,proto3" json:"project_number,omitempty"`
	// The metadata generation of this bucket.
	// Attempting to set this field will result in an error.
	Metageneration int64 `protobuf:"varint,8,opt,name=metageneration,proto3" json:"metageneration,omitempty"`
	// The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
	// (CORS) configuration.
	Cors []*Bucket_Cors `protobuf:"bytes,9,rep,name=cors,proto3" json:"cors,omitempty"`
	// The location of the bucket. Object data for objects in the bucket resides
	// in physical storage within this region.  Defaults to `US`. See the
	// [https://developers.google.com/storage/docs/concepts-techniques#specifyinglocations"][developer's
	// guide] for the authoritative list. Attempting to update this field after
	// the bucket is created will result in an error.
	Location string `protobuf:"bytes,10,opt,name=location,proto3" json:"location,omitempty"`
	// The bucket's default storage class, used whenever no storageClass is
	// specified for a newly-created object. This defines how objects in the
	// bucket are stored and determines the SLA and the cost of storage.
	// If this value is not specified when the bucket is created, it will default
	// to `STANDARD`. For more information, see
	// https://developers.google.com/storage/docs/storage-classes.
	StorageClass string `protobuf:"bytes,11,opt,name=storage_class,json=storageClass,proto3" json:"storage_class,omitempty"`
	// HTTP 1.1 [https://tools.ietf.org/html/rfc7232#section-2.3"]Entity tag]
	// for the bucket.
	// Attempting to set this field will result in an error.
	Etag string `protobuf:"bytes,12,opt,name=etag,proto3" json:"etag,omitempty"`
	// The modification time of the bucket.
	// Attempting to set this field will result in an error.
	Updated *timestamp.Timestamp `protobuf:"bytes,13,opt,name=updated,proto3" json:"updated,omitempty"`
	// The default value for event-based hold on newly created objects in this
	// bucket.  Event-based hold is a way to retain objects indefinitely until an
	// event occurs, signified by the
	// hold's release. After being released, such objects will be subject to
	// bucket-level retention (if any).  One sample use case of this flag is for
	// banks to hold loan documents for at least 3 years after loan is paid in
	// full. Here, bucket-level retention is 3 years and the event is loan being
	// paid in full. In this example, these objects will be held intact for any
	// number of years until the event has occurred (event-based hold on the
	// object is released) and then 3 more years after that. That means retention
	// duration of the objects begins from the moment event-based hold
	// transitioned from true to false.  Objects under event-based hold cannot be
	// deleted, overwritten or archived until the hold is removed.
	DefaultEventBasedHold bool `protobuf:"varint,14,opt,name=default_event_based_hold,json=defaultEventBasedHold,proto3" json:"default_event_based_hold,omitempty"`
	// User-provided labels, in key/value pairs.
	Labels map[string]string `protobuf:"bytes,15,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The bucket's website configuration, controlling how the service behaves
	// when accessing bucket contents as a web site. See the
	// [https://cloud.google.com/storage/docs/static-website][Static Website
	// Examples] for more information.
	Website *Bucket_Website `protobuf:"bytes,16,opt,name=website,proto3" json:"website,omitempty"`
	// The bucket's versioning configuration.
	Versioning *Bucket_Versioning `protobuf:"bytes,17,opt,name=versioning,proto3" json:"versioning,omitempty"`
	// The bucket's logging configuration, which defines the destination bucket
	// and optional name prefix for the current bucket's logs.
	Logging *Bucket_Logging `protobuf:"bytes,18,opt,name=logging,proto3" json:"logging,omitempty"`
	// The owner of the bucket. This is always the project team's owner group.
	Owner *Owner `protobuf:"bytes,19,opt,name=owner,proto3" json:"owner,omitempty"`
	// Encryption configuration for a bucket.
	Encryption *Bucket_Encryption `protobuf:"bytes,20,opt,name=encryption,proto3" json:"encryption,omitempty"`
	// The bucket's billing configuration.
	Billing *Bucket_Billing `protobuf:"bytes,21,opt,name=billing,proto3" json:"billing,omitempty"`
	// The bucket's retention policy. The retention policy enforces a minimum
	// retention time for all objects contained in the bucket, based on their
	// creation time. Any attempt to overwrite or delete objects younger than the
	// retention period will result in a PERMISSION_DENIED error.  An unlocked
	// retention policy can be modified or removed from the bucket via a
	// storage.buckets.update operation. A locked retention policy cannot be
	// removed or shortened in duration for the lifetime of the bucket.
	// Attempting to remove or decrease period of a locked retention policy will
	// result in a PERMISSION_DENIED error.
	RetentionPolicy      *Bucket_RetentionPolicy `protobuf:"bytes,22,opt,name=retention_policy,json=retentionPolicy,proto3" json:"retention_policy,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *Bucket) Reset()         { *m = Bucket{} }
func (m *Bucket) String() string { return proto.CompactTextString(m) }
func (*Bucket) ProtoMessage()    {}
func (*Bucket) Descriptor() ([]byte, []int) {
	return fileDescriptor_303b257d2554d792, []int{0}
}

func (m *Bucket) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Bucket.Unmarshal(m, b)
}
func (m *Bucket) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Bucket.Marshal(b, m, deterministic)
}
func (m *Bucket) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Bucket.Merge(m, src)
}
func (m *Bucket) XXX_Size() int {
	return xxx_messageInfo_Bucket.Size(m)
}
func (m *Bucket) XXX_DiscardUnknown() {
	xxx_messageInfo_Bucket.DiscardUnknown(m)
}

var xxx_messageInfo_Bucket proto.InternalMessageInfo

func (m *Bucket) GetAcl() []*BucketAccessControl {
	if m != nil {
		return m.Acl
	}
	return nil
}

func (m *Bucket) GetDefaultObjectAcl() []*ObjectAccessControl {
	if m != nil {
		return m.DefaultObjectAcl
	}
	return nil
}

func (m *Bucket) GetLifecycle() *Bucket_Lifecycle {
	if m != nil {
		return m.Lifecycle
	}
	return nil
}

func (m *Bucket) GetTimeCreated() *timestamp.Timestamp {
	if m != nil {
		return m.TimeCreated
	}
	return nil
}

func (m *Bucket) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Bucket) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Bucket) GetProjectNumber() int64 {
	if m != nil {
		return m.ProjectNumber
	}
	return 0
}

func (m *Bucket) GetMetageneration() int64 {
	if m != nil {
		return m.Metageneration
	}
	return 0
}

func (m *Bucket) GetCors() []*Bucket_Cors {
	if m != nil {
		return m.Cors
	}
	return nil
}

func (m *Bucket) GetLocation() string {
	if m != nil {
		return m.Location
	}
	return ""
}

func (m *Bucket) GetStorageClass() string {
	if m != nil {
		return m.StorageClass
	}
	return ""
}

func (m *Bucket) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

func (m *Bucket) GetUpdated() *timestamp.Timestamp {
	if m != nil {
		return m.Updated
	}
	return nil
}

func (m *Bucket) GetDefaultEventBasedHold() bool {
	if m != nil {
		return m.DefaultEventBasedHold
	}
	return false
}

func (m *Bucket) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Bucket) GetWebsite() *Bucket_Website {
	if m != nil {
		return m.Website
	}
	return nil
}

func (m *Bucket) GetVersioning() *Bucket_Versioning {
	if m != nil {
		return m.Versioning
	}
	return nil
}

func (m *Bucket) GetLogging() *Bucket_Logging {
	if m != nil {
		return m.Logging
	}
	return nil
}

func (m *Bucket) GetOwner() *Owner {
	if m != nil {
		return m.Owner
	}
	return nil
}

func (m *Bucket) GetEncryption() *Bucket_Encryption {
	if m != nil {
		return m.Encryption
	}
	return nil
}

func (m *Bucket) GetBilling() *Bucket_Billing {
	if m != nil {
		return m.Billing
	}
	return nil
}

func (m *Bucket) GetRetentionPolicy() *Bucket_RetentionPolicy {
	if m != nil {
		return m.RetentionPolicy
	}
	return nil
}

// Billing properties of a bucket.
type Bucket_Billing struct {
	// When set to true, Requester Pays is enabled for this bucket.
	RequesterPays        bool     `protobuf:"varint,1,opt,name=requester_pays,json=requesterPays,proto3" json:"requester_pays,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Bucket_Billing) Reset()         { *m = Bucket_Billing{} }
func (m *Bucket_Billing) String() string { return proto.CompactTextString(m) }
func (*Bucket_Billing) ProtoMessage()    {}
func (*Bucket_Billing) Descriptor() ([]byte, []int) {
	return fileDescriptor_303b257d2554d792, []int{0, 0}
}

func (m *Bucket_Billing) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Bucket_Billing.Unmarshal(m, b)
}
func (m *Bucket_Billing) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Bucket_Billing.Marshal(b, m, deterministic)
}
func (m *Bucket_Billing) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Bucket_Billing.Merge(m, src)
}
func (m *Bucket_Billing) XXX_Size() int {
	return xxx_messageInfo_Bucket_Billing.Size(m)
}
func (m *Bucket_Billing) XXX_DiscardUnknown() {
	xxx_messageInfo_Bucket_Billing.DiscardUnknown(m)
}

var xxx_messageInfo_Bucket_Billing proto.InternalMessageInfo

func (m *Bucket_Billing) GetRequesterPays() bool {
	if m != nil {
		return m.RequesterPays
	}
	return false
}

// Cross-Origin Response sharing (CORS) properties for a bucket.
// For more on GCS and CORS, see
// https://cloud.google.com/storage/docs/cross-origin.
// For more on CORS in general, see https://tools.ietf.org/html/rfc6454.
type Bucket_Cors struct {
	// The list of Origins eligible to receive CORS response headers. See
	// [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
	// Note: "*" is permitted in the list of origins, and means "any Origin".
	Origin []string `protobuf:"bytes,1,rep,name=origin,proto3" json:"origin,omitempty"`
	// The list of HTTP methods on which to include CORS response headers,
	// (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
	// methods, and means "any method".
	Method []string `protobuf:"bytes,2,rep,name=method,proto3" json:"method,omitempty"`
	// The list of HTTP headers other than the
	// [https://www.w3.org/TR/cors/#simple-response-header][simple response
	// headers] to give permission for the user-agent to share across domains.
	ResponseHeader []string `protobuf:"bytes,3,rep,name=response_header,json=responseHeader,proto3" json:"response_header,omitempty"`
	// The value, in seconds, to return in the
	// [https://www.w3.org/TR/cors/#access-control-max-age-response-header][Access-Control-Max-Age
	// header] used in preflight responses.
	MaxAgeSeconds        int32    `protobuf:"varint,4,opt,name=max_age_seconds,json=maxAgeSeconds,proto3" json:"max_age_seconds,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Bucket_Cors) Reset()         { *m = Bucket_Cors{} }
func (m *Bucket_Cors) String() string { return proto.CompactTextString(m) }
func (*Bucket_Cors) ProtoMessage()    {}
func (*Bucket_Cors) Descriptor() ([]byte, []int) {
	return fileDescriptor_303b257d2554d792, []int{0, 1}
}

func (m *Bucket_Cors) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Bucket_Cors.Unmarshal(m, b)
}
func (m *Bucket_Cors) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Bucket_Cors.Marshal(b, m, deterministic)
}
func (m *Bucket_Cors) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Bucket_Cors.Merge(m, src)
}
func (m *Bucket_Cors) XXX_Size() int {
	return xxx_messageInfo_Bucket_Cors.Size(m)
}
func (m *Bucket_Cors) XXX_DiscardUnknown() {
	xxx_messageInfo_Bucket_Cors.DiscardUnknown(m)
}

var xxx_messageInfo_Bucket_Cors proto.InternalMessageInfo

func (m *Bucket_Cors) GetOrigin() []string {
	if m != nil {
		return m.Origin
	}
	return nil
}

func (m *Bucket_Cors) GetMethod() []string {
	if m != nil {
		return m.Method
	}
	return nil
}

func (m *Bucket_Cors) GetResponseHeader() []string {
	if m != nil {
		return m.ResponseHeader
	}
	return nil
}

func (m *Bucket_Cors) GetMaxAgeSeconds() int32 {
	if m != nil {
		return m.MaxAgeSeconds
	}
	return 0
}

// Encryption properties of a bucket.
type Bucket_Encryption struct {
	// A Cloud KMS key that will be used to encrypt objects inserted into this
	// bucket, if no encryption method is specified.
	DefaultKmsKeyName    string   `protobuf:"bytes,1,opt,name=default_kms_key_name,json=defaultKmsKeyName,proto3" json:"default_kms_key_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Bucket_Encryption) Reset()         { *m = Bucket_Encryption{} }
func (m *Bucket_Encryption) String() string { return proto.CompactTextString(m) }
func (*Bucket_Encryption) ProtoMessage()    {}
func (*Bucket_Encryption) Descriptor() ([]byte, []int) {
	return fileDescriptor_303b257d2554d792, []int{0, 2}
}

func (m *Bucket_Encryption) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Bucket_Encryption.Unmarshal(m, b)
}
func (m *Bucket_Encryption) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Bucket_Encryption.Marshal(b, m, deterministic)
}
func (m *Bucket_Encryption) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Bucket_Encryption.Merge(m, src)
}
func (m *Bucket_Encryption) XXX_Size() int {
	return xxx_messageInfo_Bucket_Encryption.Size(m)
}
func (m *Bucket_Encryption) XXX_DiscardUnknown() {
	xxx_messageInfo_Bucket_Encryption.DiscardUnknown(m)
}

var xxx_messageInfo_Bucket_Encryption proto.InternalMessageInfo

func (m *Bucket_Encryption) GetDefaultKmsKeyName() string {
	if m != nil {
		return m.DefaultKmsKeyName
	}
	return ""
}

// Lifecycle properties of a bucket.
// For more information, see https://cloud.google.com/storage/docs/lifecycle.
type Bucket_Lifecycle struct {
	// A lifecycle management rule, which is made of an action to take and the
	// condition(s) under which the action will be taken.
	Rule                 []*Bucket_Lifecycle_Rule `protobuf:"bytes,1,rep,name=rule,proto3" json:"rule,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *Bucket_Lifecycle) Reset()         { *m = Bucket_Lifecycle{} }
func (m *Bucket_Lifecycle) String() string { return proto.CompactTextString(m) }
func (*Bucket_Lifecycle) ProtoMessage()    {}
func (*Bucket_Lifecycle) Descriptor() ([]byte, []int) {
	return fileDescriptor_303b257d2554d792, []int{0, 3}
}

func (m *Bucket_Lifecycle) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Bucket_Lifecycle.Unmarshal(m, b)
}
func (m *Bucket_Lifecycle) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Bucket_Lifecycle.Marshal(b, m, deterministic)
}
func (m *Bucket_Lifecycle) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Bucket_Lifecycle.Merge(m, src)
}
func (m *Bucket_Lifecycle) XXX_Size() int {
	return xxx_messageInfo_Bucket_Lifecycle.Size(m)
}
func (m *Bucket_Lifecycle) XXX_DiscardUnknown() {
	xxx_messageInfo_Bucket_Lifecycle.DiscardUnknown(m)
}

var xxx_messageInfo_Bucket_Lifecycle proto.InternalMessageInfo

func (m *Bucket_Lifecycle) GetRule() []*Bucket_Lifecycle_Rule {
	if m != nil {
		return m.Rule
	}
	return nil
}

// A lifecycle Rule, combining an action to take on an object and a
// condition which will trigger that action.
type Bucket_Lifecycle_Rule struct {
	// The action to take.
	Action *Bucket_Lifecycle_Rule_Action `protobuf:"bytes,1,opt,name=action,proto3" json:"action,omitempty"`
	// The condition(s) under which the action will be taken.
	Condition            *Bucket_Lifecycle_Rule_Condition `protobuf:"bytes,2,opt,name=condition,proto3" json:"condition,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                         `json:"-"`
	XXX_unrecognized     []byte                           `json:"-"`
	XXX_sizecache        int32                            `json:"-"`
}

func (m *Bucket_Lifecycle_Rule) Reset()         { *m = Bucket_Lifecycle_Rule{} }
func (m *Bucket_Lifecycle_Rule) String() string { return proto.CompactTextString(m) }
func (*Bucket_Lifecycle_Rule) ProtoMessage()    {}
func (*Bucket_Lifecycle_Rule) Descriptor() ([]byte, []int) {
	return fileDescriptor_303b257d2554d792, []int{0, 3, 0}
}

func (m *Bucket_Lifecycle_Rule) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Bucket_Lifecycle_Rule.Unmarshal(m, b)
}
func (m *Bucket_Lifecycle_Rule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Bucket_Lifecycle_Rule.Marshal(b, m, deterministic)
}
func (m *Bucket_Lifecycle_Rule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Bucket_Lifecycle_Rule.Merge(m, src)
}
func (m *Bucket_Lifecycle_Rule) XXX_Size() int {
	return xxx_messageInfo_Bucket_Lifecycle_Rule.Size(m)
}
func (m *Bucket_Lifecycle_Rule) XXX_DiscardUnknown() {
	xxx_messageInfo_Bucket_Lifecycle_Rule.DiscardUnknown(m)
}

var xxx_messageInfo_Bucket_Lifecycle_Rule proto.InternalMessageInfo

func (m *Bucket_Lifecycle_Rule) GetAction() *Bucket_Lifecycle_Rule_Action {
	if m != nil {
		return m.Action
	}
	return nil
}

func (m *Bucket_Lifecycle_Rule) GetCondition() *Bucket_Lifecycle_Rule_Condition {
	if m != nil {
		return m.Condition
	}
	return nil
}

// An action to take on an object.
type Bucket_Lifecycle_Rule_Action struct {
	// Type of the action. Currently, only `Delete` and
	// `SetStorageClass` are supported.
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// Target storage class. Required iff the type of the action is
	// SetStorageClass.
	StorageClass         string   `protobuf:"bytes,2,opt,name=storage_class,json=storageClass,proto3" json:"storage_class,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Bucket_Lifecycle_Rule_Action) Reset()         { *m = Bucket_Lifecycle_Rule_Action{} }
func (m *Bucket_Lifecycle_Rule_Action) String() string { return proto.CompactTextString(m) }
func (*Bucket_Lifecycle_Rule_Action) ProtoMessage()    {}
func (*Bucket_Lifecycle_Rule_Action) Descriptor() ([]byte, []int) {
	return fileDescriptor_303b257d2554d792, []int{0, 3, 0, 0}
}

func (m *Bucket_Lifecycle_Rule_Action) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Bucket_Lifecycle_Rule_Action.Unmarshal(m, b)
}
func (m *Bucket_Lifecycle_Rule_Action) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Bucket_Lifecycle_Rule_Action.Marshal(b, m, deterministic)
}
func (m *Bucket_Lifecycle_Rule_Action) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Bucket_Lifecycle_Rule_Action.Merge(m, src)
}
func (m *Bucket_Lifecycle_Rule_Action) XXX_Size() int {
	return xxx_messageInfo_Bucket_Lifecycle_Rule_Action.Size(m)
}
func (m *Bucket_Lifecycle_Rule_Action) XXX_DiscardUnknown() {
	xxx_messageInfo_Bucket_Lifecycle_Rule_Action.DiscardUnknown(m)
}

var xxx_messageInfo_Bucket_Lifecycle_Rule_Action proto.InternalMessageInfo

func (m *Bucket_Lifecycle_Rule_Action) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Bucket_Lifecycle_Rule_Action) GetStorageClass() string {
	if m != nil {
		return m.StorageClass
	}
	return ""
}

// A condition of an object which triggers some action.
type Bucket_Lifecycle_Rule_Condition struct {
	// Age of an object (in days). This condition is satisfied when an
	// object reaches the specified age.
	Age int32 `protobuf:"varint,1,opt,name=age,proto3" json:"age,omitempty"`
	// A date in [RFC 3339][1] format with only the date part (for
	// instance, "2013-01-15"). This condition is satisfied when an
	// object is created before midnight of the specified date in UTC.
	// [1]: https://tools.ietf.org/html/rfc3339
	CreatedBefore *timestamp.Timestamp `protobuf:"bytes,2,opt,name=created_before,json=createdBefore,proto3" json:"created_before,omitempty"`
	// Relevant only for versioned objects. If the value is
	// `true`, this condition matches live objects; if the value
	// is `false`, it matches archived objects.
	IsLive *wrappers.BoolValue `protobuf:"bytes,3,opt,name=is_live,json=isLive,proto3" json:"is_live,omitempty"`
	// Relevant only for versioned objects. If the value is N, this
	// condition is satisfied when there are at least N versions (including
	// the live version) newer than this version of the object.
	NumNewerVersions int32 `protobuf:"varint,4,opt,name=num_newer_versions,json=numNewerVersions,proto3" json:"num_newer_versions,omitempty"`
	// Objects having any of the storage classes specified by this condition
	// will be matched. Values include `MULTI_REGIONAL`, `REGIONAL`,
	// `NEARLINE`, `COLDLINE`, `STANDARD`, and
	// `DURABLE_REDUCED_AVAILABILITY`.
	MatchesStorageClass []string `protobuf:"bytes,5,rep,name=matches_storage_class,json=matchesStorageClass,proto3" json:"matches_storage_class,omitempty"`
	// A regular expression that satisfies the RE2 syntax. This condition is
	// satisfied when the name of the object matches the RE2 pattern.  Note:
	// This feature is currently in the "Early Access" launch stage and is
	// only available to a whitelisted set of users; that means that this
	// feature may be changed in backward-incompatible ways and that it is
	// not guaranteed to be released.
	MatchesPattern       string   `protobuf:"bytes,6,opt,name=matches_pattern,json=matchesPattern,proto3" json:"matches_pattern,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Bucket_Lifecycle_Rule_Condition) Reset()         { *m = Bucket_Lifecycle_Rule_Condition{} }
func (m *Bucket_Lifecycle_Rule_Condition) String() string { return proto.CompactTextString(m) }
func (*Bucket_Lifecycle_Rule_Condition) ProtoMessage()    {}
func (*Bucket_Lifecycle_Rule_Condition) Descriptor() ([]byte, []int) {
	return fileDescriptor_303b257d2554d792, []int{0, 3, 0, 1}
}

func (m *Bucket_Lifecycle_Rule_Condition) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Bucket_Lifecycle_Rule_Condition.Unmarshal(m, b)
}
func (m *Bucket_Lifecycle_Rule_Condition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Bucket_Lifecycle_Rule_Condition.Marshal(b, m, deterministic)
}
func (m *Bucket_Lifecycle_Rule_Condition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Bucket_Lifecycle_Rule_Condition.Merge(m, src)
}
func (m *Bucket_Lifecycle_Rule_Condition) XXX_Size() int {
	return xxx_messageInfo_Bucket_Lifecycle_Rule_Condition.Size(m)
}
func (m *Bucket_Lifecycle_Rule_Condition) XXX_DiscardUnknown() {
	xxx_messageInfo_Bucket_Lifecycle_Rule_Condition.DiscardUnknown(m)
}

var xxx_messageInfo_Bucket_Lifecycle_Rule_Condition proto.InternalMessageInfo

func (m *Bucket_Lifecycle_Rule_Condition) GetAge() int32 {
	if m != nil {
		return m.Age
	}
	return 0
}

func (m *Bucket_Lifecycle_Rule_Condition) GetCreatedBefore() *timestamp.Timestamp {
	if m != nil {
		return m.CreatedBefore
	}
	return nil
}

func (m *Bucket_Lifecycle_Rule_Condition) GetIsLive() *wrappers.BoolValue {
	if m != nil {
		return m.IsLive
	}
	return nil
}

func (m *Bucket_Lifecycle_Rule_Condition) GetNumNewerVersions() int32 {
	if m != nil {
		return m.NumNewerVersions
	}
	return 0
}

func (m *Bucket_Lifecycle_Rule_Condition) GetMatchesStorageClass() []string {
	if m != nil {
		return m.MatchesStorageClass
	}
	return nil
}

func (m *Bucket_Lifecycle_Rule_Condition) GetMatchesPattern() string {
	if m != nil {
		return m.MatchesPattern
	}
	return ""
}

// Logging-related properties of a bucket.
type Bucket_Logging struct {
	// The destination bucket where the current bucket's logs should be placed.
	LogBucket string `protobuf:"bytes,1,opt,name=log_bucket,json=logBucket,proto3" json:"log_bucket,omitempty"`
	// A prefix for log object names.
	LogObjectPrefix      string   `protobuf:"bytes,2,opt,name=log_object_prefix,json=logObjectPrefix,proto3" json:"log_object_prefix,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Bucket_Logging) Reset()         { *m = Bucket_Logging{} }
func (m *Bucket_Logging) String() string { return proto.CompactTextString(m) }
func (*Bucket_Logging) ProtoMessage()    {}
func (*Bucket_Logging) Descriptor() ([]byte, []int) {
	return fileDescriptor_303b257d2554d792, []int{0, 4}
}

func (m *Bucket_Logging) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Bucket_Logging.Unmarshal(m, b)
}
func (m *Bucket_Logging) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Bucket_Logging.Marshal(b, m, deterministic)
}
func (m *Bucket_Logging) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Bucket_Logging.Merge(m, src)
}
func (m *Bucket_Logging) XXX_Size() int {
	return xxx_messageInfo_Bucket_Logging.Size(m)
}
func (m *Bucket_Logging) XXX_DiscardUnknown() {
	xxx_messageInfo_Bucket_Logging.DiscardUnknown(m)
}

var xxx_messageInfo_Bucket_Logging proto.InternalMessageInfo

func (m *Bucket_Logging) GetLogBucket() string {
	if m != nil {
		return m.LogBucket
	}
	return ""
}

func (m *Bucket_Logging) GetLogObjectPrefix() string {
	if m != nil {
		return m.LogObjectPrefix
	}
	return ""
}

// Retention policy properties of a bucket.
type Bucket_RetentionPolicy struct {
	// Server-determined value that indicates the time from which policy was
	// enforced and effective. This value is in
	// [https://tools.ietf.org/html/rfc3339][RFC 3339] format.
	EffectiveTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=effective_time,json=effectiveTime,proto3" json:"effective_time,omitempty"`
	// Once locked, an object retention policy cannot be modified.
	IsLocked bool `protobuf:"varint,2,opt,name=is_locked,json=isLocked,proto3" json:"is_locked,omitempty"`
	// The duration in seconds that objects need to be retained. Retention
	// duration must be greater than zero and less than 100 years. Note that
	// enforcement of retention periods less than a day is not guaranteed. Such
	// periods should only be used for testing purposes.
	RetentionPeriod      int64    `protobuf:"varint,3,opt,name=retention_period,json=retentionPeriod,proto3" json:"retention_period,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Bucket_RetentionPolicy) Reset()         { *m = Bucket_RetentionPolicy{} }
func (m *Bucket_RetentionPolicy) String() string { return proto.CompactTextString(m) }
func (*Bucket_RetentionPolicy) ProtoMessage()    {}
func (*Bucket_RetentionPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_303b257d2554d792, []int{0, 5}
}

func (m *Bucket_RetentionPolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Bucket_RetentionPolicy.Unmarshal(m, b)
}
func (m *Bucket_RetentionPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Bucket_RetentionPolicy.Marshal(b, m, deterministic)
}
func (m *Bucket_RetentionPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Bucket_RetentionPolicy.Merge(m, src)
}
func (m *Bucket_RetentionPolicy) XXX_Size() int {
	return xxx_messageInfo_Bucket_RetentionPolicy.Size(m)
}
func (m *Bucket_RetentionPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_Bucket_RetentionPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_Bucket_RetentionPolicy proto.InternalMessageInfo

func (m *Bucket_RetentionPolicy) GetEffectiveTime() *timestamp.Timestamp {
	if m != nil {
		return m.EffectiveTime
	}
	return nil
}

func (m *Bucket_RetentionPolicy) GetIsLocked() bool {
	if m != nil {
		return m.IsLocked
	}
	return false
}

func (m *Bucket_RetentionPolicy) GetRetentionPeriod() int64 {
	if m != nil {
		return m.RetentionPeriod
	}
	return 0
}

// Properties of a bucket related to versioning.
// For more on GCS versioning, see
// https://cloud.google.com/storage/docs/object-versioning.
type Bucket_Versioning struct {
	// While set to true, versioning is fully enabled for this bucket.
	Enabled              bool     `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Bucket_Versioning) Reset()         { *m = Bucket_Versioning{} }
func (m *Bucket_Versioning) String() string { return proto.CompactTextString(m) }
func (*Bucket_Versioning) ProtoMessage()    {}
func (*Bucket_Versioning) Descriptor() ([]byte, []int) {
	return fileDescriptor_303b257d2554d792, []int{0, 6}
}

func (m *Bucket_Versioning) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Bucket_Versioning.Unmarshal(m, b)
}
func (m *Bucket_Versioning) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Bucket_Versioning.Marshal(b, m, deterministic)
}
func (m *Bucket_Versioning) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Bucket_Versioning.Merge(m, src)
}
func (m *Bucket_Versioning) XXX_Size() int {
	return xxx_messageInfo_Bucket_Versioning.Size(m)
}
func (m *Bucket_Versioning) XXX_DiscardUnknown() {
	xxx_messageInfo_Bucket_Versioning.DiscardUnknown(m)
}

var xxx_messageInfo_Bucket_Versioning proto.InternalMessageInfo

func (m *Bucket_Versioning) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

// Properties of a bucket related to accessing the contents as a static
// website. For more on hosting a static website via GCS, see
// https://cloud.google.com/storage/docs/hosting-static-website.
type Bucket_Website struct {
	// If the requested object path is missing, the service will ensure the path
	// has a trailing '/', append this suffix, and attempt to retrieve the
	// resulting object. This allows the creation of `index.html`
	// objects to represent directory pages.
	MainPageSuffix string `protobuf:"bytes,1,opt,name=main_page_suffix,json=mainPageSuffix,proto3" json:"main_page_suffix,omitempty"`
	// If the requested object path is missing, and any
	// `mainPageSuffix` object is missing, if applicable, the service
	// will return the named object from this bucket as the content for a
	// [https://tools.ietf.org/html/rfc7231#section-6.5.4][404 Not Found]
	// result.
	NotFoundPage         string   `protobuf:"bytes,2,opt,name=not_found_page,json=notFoundPage,proto3" json:"not_found_page,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Bucket_Website) Reset()         { *m = Bucket_Website{} }
func (m *Bucket_Website) String() string { return proto.CompactTextString(m) }
func (*Bucket_Website) ProtoMessage()    {}
func (*Bucket_Website) Descriptor() ([]byte, []int) {
	return fileDescriptor_303b257d2554d792, []int{0, 7}
}

func (m *Bucket_Website) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Bucket_Website.Unmarshal(m, b)
}
func (m *Bucket_Website) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Bucket_Website.Marshal(b, m, deterministic)
}
func (m *Bucket_Website) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Bucket_Website.Merge(m, src)
}
func (m *Bucket_Website) XXX_Size() int {
	return xxx_messageInfo_Bucket_Website.Size(m)
}
func (m *Bucket_Website) XXX_DiscardUnknown() {
	xxx_messageInfo_Bucket_Website.DiscardUnknown(m)
}

var xxx_messageInfo_Bucket_Website proto.InternalMessageInfo

func (m *Bucket_Website) GetMainPageSuffix() string {
	if m != nil {
		return m.MainPageSuffix
	}
	return ""
}

func (m *Bucket_Website) GetNotFoundPage() string {
	if m != nil {
		return m.NotFoundPage
	}
	return ""
}

// An access-control entry.
type BucketAccessControl struct {
	// The access permission for the entity.
	Role string `protobuf:"bytes,1,opt,name=role,proto3" json:"role,omitempty"`
	// HTTP 1.1 ["https://tools.ietf.org/html/rfc7232#section-2.3][Entity tag]
	// for the access-control entry.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
	// The ID of the access-control entry.
	Id string `protobuf:"bytes,3,opt,name=id,proto3" json:"id,omitempty"`
	// The name of the bucket.
	Bucket string `protobuf:"bytes,4,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// The entity holding the permission, in one of the following forms:
	// * `user-{userid}`
	// * `user-{email}`
	// * `group-{groupid}`
	// * `group-{email}`
	// * `domain-{domain}`
	// * `project-{team-projectid}`
	// * `allUsers`
	// * `allAuthenticatedUsers`
	// Examples:
	// * The user `liz@example.com` would be `user-liz@example.com`.
	// * The group `example@googlegroups.com` would be
	// `group-example@googlegroups.com`
	// * All members of the Google Apps for Business domain `example.com` would be
	// `domain-example.com`
	Entity string `protobuf:"bytes,6,opt,name=entity,proto3" json:"entity,omitempty"`
	// The ID for the entity, if any.
	EntityId string `protobuf:"bytes,7,opt,name=entity_id,json=entityId,proto3" json:"entity_id,omitempty"`
	// The email address associated with the entity, if any.
	Email string `protobuf:"bytes,8,opt,name=email,proto3" json:"email,omitempty"`
	// The domain associated with the entity, if any.
	Domain string `protobuf:"bytes,9,opt,name=domain,proto3" json:"domain,omitempty"`
	// The project team associated with the entity, if any.
	ProjectTeam          *ProjectTeam `protobuf:"bytes,10,opt,name=project_team,json=projectTeam,proto3" json:"project_team,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *BucketAccessControl) Reset()         { *m = BucketAccessControl{} }
func (m *BucketAccessControl) String() string { return proto.CompactTextString(m) }
func (*BucketAccessControl) ProtoMessage()    {}
func (*BucketAccessControl) Descriptor() ([]byte, []int) {
	return fileDescriptor_303b257d2554d792, []int{1}
}

func (m *BucketAccessControl) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BucketAccessControl.Unmarshal(m, b)
}
func (m *BucketAccessControl) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BucketAccessControl.Marshal(b, m, deterministic)
}
func (m *BucketAccessControl) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BucketAccessControl.Merge(m, src)
}
func (m *BucketAccessControl) XXX_Size() int {
	return xxx_messageInfo_BucketAccessControl.Size(m)
}
func (m *BucketAccessControl) XXX_DiscardUnknown() {
	xxx_messageInfo_BucketAccessControl.DiscardUnknown(m)
}

var xxx_messageInfo_BucketAccessControl proto.InternalMessageInfo

func (m *BucketAccessControl) GetRole() string {
	if m != nil {
		return m.Role
	}
	return ""
}

func (m *BucketAccessControl) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

func (m *BucketAccessControl) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *BucketAccessControl) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *BucketAccessControl) GetEntity() string {
	if m != nil {
		return m.Entity
	}
	return ""
}

func (m *BucketAccessControl) GetEntityId() string {
	if m != nil {
		return m.EntityId
	}
	return ""
}

func (m *BucketAccessControl) GetEmail() string {
	if m != nil {
		return m.Email
	}
	return ""
}

func (m *BucketAccessControl) GetDomain() string {
	if m != nil {
		return m.Domain
	}
	return ""
}

func (m *BucketAccessControl) GetProjectTeam() *ProjectTeam {
	if m != nil {
		return m.ProjectTeam
	}
	return nil
}

// The response to a call to BucketAccessControls.ListBucketAccessControls.
type ListBucketAccessControlsResponse struct {
	// The list of items.
	Items                []*BucketAccessControl `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *ListBucketAccessControlsResponse) Reset()         { *m = ListBucketAccessControlsResponse{} }
func (m *ListBucketAccessControlsResponse) String() string { return proto.CompactTextString(m) }
func (*ListBucketAccessControlsResponse) ProtoMessage()    {}
func (*ListBucketAccessControlsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_303b257d2554d792, []int{2}
}

func (m *ListBucketAccessControlsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListBucketAccessControlsResponse.Unmarshal(m, b)
}
func (m *ListBucketAccessControlsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListBucketAccessControlsResponse.Marshal(b, m, deterministic)
}
func (m *ListBucketAccessControlsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListBucketAccessControlsResponse.Merge(m, src)
}
func (m *ListBucketAccessControlsResponse) XXX_Size() int {
	return xxx_messageInfo_ListBucketAccessControlsResponse.Size(m)
}
func (m *ListBucketAccessControlsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListBucketAccessControlsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListBucketAccessControlsResponse proto.InternalMessageInfo

func (m *ListBucketAccessControlsResponse) GetItems() []*BucketAccessControl {
	if m != nil {
		return m.Items
	}
	return nil
}

// The result of a call to Buckets.ListBuckets
type ListBucketsResponse struct {
	// The list of items.
	Items []*Bucket `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	// The continuation token, used to page through large result sets. Provide
	// this value in a subsequent request to return the next page of results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListBucketsResponse) Reset()         { *m = ListBucketsResponse{} }
func (m *ListBucketsResponse) String() string { return proto.CompactTextString(m) }
func (*ListBucketsResponse) ProtoMessage()    {}
func (*ListBucketsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_303b257d2554d792, []int{3}
}

func (m *ListBucketsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListBucketsResponse.Unmarshal(m, b)
}
func (m *ListBucketsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListBucketsResponse.Marshal(b, m, deterministic)
}
func (m *ListBucketsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListBucketsResponse.Merge(m, src)
}
func (m *ListBucketsResponse) XXX_Size() int {
	return xxx_messageInfo_ListBucketsResponse.Size(m)
}
func (m *ListBucketsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListBucketsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListBucketsResponse proto.InternalMessageInfo

func (m *ListBucketsResponse) GetItems() []*Bucket {
	if m != nil {
		return m.Items
	}
	return nil
}

func (m *ListBucketsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// An notification channel used to watch for resource changes.
type Channel struct {
	// A UUID or similar unique string that identifies this channel.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// An opaque ID that identifies the resource being watched on this channel.
	// Stable across different API versions.
	ResourceId string `protobuf:"bytes,2,opt,name=resource_id,json=resourceId,proto3" json:"resource_id,omitempty"`
	// A version-specific identifier for the watched resource.
	ResourceUri string `protobuf:"bytes,3,opt,name=resource_uri,json=resourceUri,proto3" json:"resource_uri,omitempty"`
	// An arbitrary string delivered to the target address with each notification
	// delivered over this channel. Optional.
	Token string `protobuf:"bytes,4,opt,name=token,proto3" json:"token,omitempty"`
	// Date and time of notification channel expiration. Optional.
	Expiration *timestamp.Timestamp `protobuf:"bytes,5,opt,name=expiration,proto3" json:"expiration,omitempty"`
	// The type of delivery mechanism used for this channel.
	Type string `protobuf:"bytes,6,opt,name=type,proto3" json:"type,omitempty"`
	// The address where notifications are delivered for this channel.
	Address string `protobuf:"bytes,7,opt,name=address,proto3" json:"address,omitempty"`
	// Additional parameters controlling delivery channel behavior. Optional.
	Params map[string]string `protobuf:"bytes,8,rep,name=params,proto3" json:"params,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// A Boolean value to indicate whether payload is wanted. Optional.
	Payload              bool     `protobuf:"varint,9,opt,name=payload,proto3" json:"payload,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Channel) Reset()         { *m = Channel{} }
func (m *Channel) String() string { return proto.CompactTextString(m) }
func (*Channel) ProtoMessage()    {}
func (*Channel) Descriptor() ([]byte, []int) {
	return fileDescriptor_303b257d2554d792, []int{4}
}

func (m *Channel) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Channel.Unmarshal(m, b)
}
func (m *Channel) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Channel.Marshal(b, m, deterministic)
}
func (m *Channel) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Channel.Merge(m, src)
}
func (m *Channel) XXX_Size() int {
	return xxx_messageInfo_Channel.Size(m)
}
func (m *Channel) XXX_DiscardUnknown() {
	xxx_messageInfo_Channel.DiscardUnknown(m)
}

var xxx_messageInfo_Channel proto.InternalMessageInfo

func (m *Channel) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Channel) GetResourceId() string {
	if m != nil {
		return m.ResourceId
	}
	return ""
}

func (m *Channel) GetResourceUri() string {
	if m != nil {
		return m.ResourceUri
	}
	return ""
}

func (m *Channel) GetToken() string {
	if m != nil {
		return m.Token
	}
	return ""
}

func (m *Channel) GetExpiration() *timestamp.Timestamp {
	if m != nil {
		return m.Expiration
	}
	return nil
}

func (m *Channel) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Channel) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

func (m *Channel) GetParams() map[string]string {
	if m != nil {
		return m.Params
	}
	return nil
}

func (m *Channel) GetPayload() bool {
	if m != nil {
		return m.Payload
	}
	return false
}

// Message used to convey content being read or written, along with its
// checksum.
type ChecksummedData struct {
	// The data.
	Content []byte `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
	// CRC32C digest of the contents.
	Crc32C               *wrappers.UInt32Value `protobuf:"bytes,2,opt,name=crc32c,proto3" json:"crc32c,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ChecksummedData) Reset()         { *m = ChecksummedData{} }
func (m *ChecksummedData) String() string { return proto.CompactTextString(m) }
func (*ChecksummedData) ProtoMessage()    {}
func (*ChecksummedData) Descriptor() ([]byte, []int) {
	return fileDescriptor_303b257d2554d792, []int{5}
}

func (m *ChecksummedData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ChecksummedData.Unmarshal(m, b)
}
func (m *ChecksummedData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ChecksummedData.Marshal(b, m, deterministic)
}
func (m *ChecksummedData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ChecksummedData.Merge(m, src)
}
func (m *ChecksummedData) XXX_Size() int {
	return xxx_messageInfo_ChecksummedData.Size(m)
}
func (m *ChecksummedData) XXX_DiscardUnknown() {
	xxx_messageInfo_ChecksummedData.DiscardUnknown(m)
}

var xxx_messageInfo_ChecksummedData proto.InternalMessageInfo

func (m *ChecksummedData) GetContent() []byte {
	if m != nil {
		return m.Content
	}
	return nil
}

func (m *ChecksummedData) GetCrc32C() *wrappers.UInt32Value {
	if m != nil {
		return m.Crc32C
	}
	return nil
}

// Message used for storing full (not subrange) object checksums.
type ObjectChecksums struct {
	// CRC32C digest of the object data. Computed by the GCS service for
	// all written objects, and validated by the GCS service against
	// client-supplied values if present in an InsertObjectRequest.
	Crc32C *wrappers.UInt32Value `protobuf:"bytes,1,opt,name=crc32c,proto3" json:"crc32c,omitempty"`
	// Hex-encoded MD5 hash of the object data (hexdigest). Whether/how this
	// checksum is provided and validated is service-dependent.
	Md5Hash              string   `protobuf:"bytes,2,opt,name=md5_hash,json=md5Hash,proto3" json:"md5_hash,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ObjectChecksums) Reset()         { *m = ObjectChecksums{} }
func (m *ObjectChecksums) String() string { return proto.CompactTextString(m) }
func (*ObjectChecksums) ProtoMessage()    {}
func (*ObjectChecksums) Descriptor() ([]byte, []int) {
	return fileDescriptor_303b257d2554d792, []int{6}
}

func (m *ObjectChecksums) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ObjectChecksums.Unmarshal(m, b)
}
func (m *ObjectChecksums) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ObjectChecksums.Marshal(b, m, deterministic)
}
func (m *ObjectChecksums) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ObjectChecksums.Merge(m, src)
}
func (m *ObjectChecksums) XXX_Size() int {
	return xxx_messageInfo_ObjectChecksums.Size(m)
}
func (m *ObjectChecksums) XXX_DiscardUnknown() {
	xxx_messageInfo_ObjectChecksums.DiscardUnknown(m)
}

var xxx_messageInfo_ObjectChecksums proto.InternalMessageInfo

func (m *ObjectChecksums) GetCrc32C() *wrappers.UInt32Value {
	if m != nil {
		return m.Crc32C
	}
	return nil
}

func (m *ObjectChecksums) GetMd5Hash() string {
	if m != nil {
		return m.Md5Hash
	}
	return ""
}

// A collection of enums used in multiple places throughout the API.
type CommonEnums struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommonEnums) Reset()         { *m = CommonEnums{} }
func (m *CommonEnums) String() string { return proto.CompactTextString(m) }
func (*CommonEnums) ProtoMessage()    {}
func (*CommonEnums) Descriptor() ([]byte, []int) {
	return fileDescriptor_303b257d2554d792, []int{7}
}

func (m *CommonEnums) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommonEnums.Unmarshal(m, b)
}
func (m *CommonEnums) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommonEnums.Marshal(b, m, deterministic)
}
func (m *CommonEnums) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommonEnums.Merge(m, src)
}
func (m *CommonEnums) XXX_Size() int {
	return xxx_messageInfo_CommonEnums.Size(m)
}
func (m *CommonEnums) XXX_DiscardUnknown() {
	xxx_messageInfo_CommonEnums.DiscardUnknown(m)
}

var xxx_messageInfo_CommonEnums proto.InternalMessageInfo

// Specifies a requested range of bytes to download.
type ContentRange struct {
	// The starting offset of the object data.
	Start int64 `protobuf:"varint,1,opt,name=start,proto3" json:"start,omitempty"`
	// The ending offset of the object data.
	End int64 `protobuf:"varint,2,opt,name=end,proto3" json:"end,omitempty"`
	// The complete length of the object data.
	CompleteLength       int64    `protobuf:"varint,3,opt,name=complete_length,json=completeLength,proto3" json:"complete_length,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ContentRange) Reset()         { *m = ContentRange{} }
func (m *ContentRange) String() string { return proto.CompactTextString(m) }
func (*ContentRange) ProtoMessage()    {}
func (*ContentRange) Descriptor() ([]byte, []int) {
	return fileDescriptor_303b257d2554d792, []int{8}
}

func (m *ContentRange) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ContentRange.Unmarshal(m, b)
}
func (m *ContentRange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ContentRange.Marshal(b, m, deterministic)
}
func (m *ContentRange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContentRange.Merge(m, src)
}
func (m *ContentRange) XXX_Size() int {
	return xxx_messageInfo_ContentRange.Size(m)
}
func (m *ContentRange) XXX_DiscardUnknown() {
	xxx_messageInfo_ContentRange.DiscardUnknown(m)
}

var xxx_messageInfo_ContentRange proto.InternalMessageInfo

func (m *ContentRange) GetStart() int64 {
	if m != nil {
		return m.Start
	}
	return 0
}

func (m *ContentRange) GetEnd() int64 {
	if m != nil {
		return m.End
	}
	return 0
}

func (m *ContentRange) GetCompleteLength() int64 {
	if m != nil {
		return m.CompleteLength
	}
	return 0
}

// A subscription to receive Google PubSub notifications.
type Notification struct {
	// The Cloud PubSub topic to which this subscription publishes. Formatted as:
	// '//pubsub.googleapis.com/projects/{project-identifier}/topics/{my-topic}'
	Topic string `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	// If present, only send notifications about listed event types. If empty,
	// sent notifications for all event types.
	EventTypes []string `protobuf:"bytes,2,rep,name=event_types,json=eventTypes,proto3" json:"event_types,omitempty"`
	// An optional list of additional attributes to attach to each Cloud PubSub
	// message published for this notification subscription.
	CustomAttributes map[string]string `protobuf:"bytes,3,rep,name=custom_attributes,json=customAttributes,proto3" json:"custom_attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// HTTP 1.1 [https://tools.ietf.org/html/rfc7232#section-2.3][Entity tag]
	// for this subscription notification.
	Etag string `protobuf:"bytes,4,opt,name=etag,proto3" json:"etag,omitempty"`
	// If present, only apply this notification configuration to object names that
	// begin with this prefix.
	ObjectNamePrefix string `protobuf:"bytes,5,opt,name=object_name_prefix,json=objectNamePrefix,proto3" json:"object_name_prefix,omitempty"`
	// The desired content of the Payload.
	PayloadFormat string `protobuf:"bytes,6,opt,name=payload_format,json=payloadFormat,proto3" json:"payload_format,omitempty"`
	// The ID of the notification.
	Id                   string   `protobuf:"bytes,7,opt,name=id,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Notification) Reset()         { *m = Notification{} }
func (m *Notification) String() string { return proto.CompactTextString(m) }
func (*Notification) ProtoMessage()    {}
func (*Notification) Descriptor() ([]byte, []int) {
	return fileDescriptor_303b257d2554d792, []int{9}
}

func (m *Notification) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Notification.Unmarshal(m, b)
}
func (m *Notification) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Notification.Marshal(b, m, deterministic)
}
func (m *Notification) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Notification.Merge(m, src)
}
func (m *Notification) XXX_Size() int {
	return xxx_messageInfo_Notification.Size(m)
}
func (m *Notification) XXX_DiscardUnknown() {
	xxx_messageInfo_Notification.DiscardUnknown(m)
}

var xxx_messageInfo_Notification proto.InternalMessageInfo

func (m *Notification) GetTopic() string {
	if m != nil {
		return m.Topic
	}
	return ""
}

func (m *Notification) GetEventTypes() []string {
	if m != nil {
		return m.EventTypes
	}
	return nil
}

func (m *Notification) GetCustomAttributes() map[string]string {
	if m != nil {
		return m.CustomAttributes
	}
	return nil
}

func (m *Notification) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

func (m *Notification) GetObjectNamePrefix() string {
	if m != nil {
		return m.ObjectNamePrefix
	}
	return ""
}

func (m *Notification) GetPayloadFormat() string {
	if m != nil {
		return m.PayloadFormat
	}
	return ""
}

func (m *Notification) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

// The result of a call to Notifications.ListNotifications
type ListNotificationsResponse struct {
	// The list of items.
	Items                []*Notification `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *ListNotificationsResponse) Reset()         { *m = ListNotificationsResponse{} }
func (m *ListNotificationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListNotificationsResponse) ProtoMessage()    {}
func (*ListNotificationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_303b257d2554d792, []int{10}
}

func (m *ListNotificationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListNotificationsResponse.Unmarshal(m, b)
}
func (m *ListNotificationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListNotificationsResponse.Marshal(b, m, deterministic)
}
func (m *ListNotificationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListNotificationsResponse.Merge(m, src)
}
func (m *ListNotificationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListNotificationsResponse.Size(m)
}
func (m *ListNotificationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListNotificationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListNotificationsResponse proto.InternalMessageInfo

func (m *ListNotificationsResponse) GetItems() []*Notification {
	if m != nil {
		return m.Items
	}
	return nil
}

// An object.
type Object struct {
	// Content-Encoding of the object data, matching
	// [https://tools.ietf.org/html/rfc7231#section-3.1.2.2][RFC 7231 §3.1.2.2]
	ContentEncoding string `protobuf:"bytes,1,opt,name=content_encoding,json=contentEncoding,proto3" json:"content_encoding,omitempty"`
	// Content-Disposition of the object data, matching
	// [https://tools.ietf.org/html/rfc6266][RFC 6266].
	ContentDisposition string `protobuf:"bytes,2,opt,name=content_disposition,json=contentDisposition,proto3" json:"content_disposition,omitempty"`
	// Cache-Control directive for the object data, matching
	// [https://tools.ietf.org/html/rfc7234#section-5.2"][RFC 7234 §5.2].
	// If omitted, and the object is accessible to all anonymous users, the
	// default will be `public, max-age=3600`.
	CacheControl string `protobuf:"bytes,3,opt,name=cache_control,json=cacheControl,proto3" json:"cache_control,omitempty"`
	// Access controls on the object.
	Acl []*ObjectAccessControl `protobuf:"bytes,4,rep,name=acl,proto3" json:"acl,omitempty"`
	// Content-Language of the object data, matching
	// [https://tools.ietf.org/html/rfc7231#section-3.1.3.2][RFC 7231 §3.1.3.2].
	ContentLanguage string `protobuf:"bytes,5,opt,name=content_language,json=contentLanguage,proto3" json:"content_language,omitempty"`
	// The version of the metadata for this object at this generation. Used for
	// preconditions and for detecting changes in metadata. A metageneration
	// number is only meaningful in the context of a particular generation of a
	// particular object.
	// Attempting to set this field will result in an error.
	Metageneration int64 `protobuf:"varint,6,opt,name=metageneration,proto3" json:"metageneration,omitempty"`
	// The deletion time of the object. Will be returned if and only if this
	// version of the object has been deleted.
	// Attempting to set this field will result in an error.
	TimeDeleted *timestamp.Timestamp `protobuf:"bytes,7,opt,name=time_deleted,json=timeDeleted,proto3" json:"time_deleted,omitempty"`
	// Content-Type of the object data, matching
	// [https://tools.ietf.org/html/rfc7231#section-3.1.1.5][RFC 7231 §3.1.1.5].
	// If an object is stored without a Content-Type, it is served as
	// `application/octet-stream`.
	ContentType string `protobuf:"bytes,8,opt,name=content_type,json=contentType,proto3" json:"content_type,omitempty"`
	// Content-Length of the object data in bytes, matching
	// [https://tools.ietf.org/html/rfc7230#section-3.3.2][RFC 7230 §3.3.2].
	// Attempting to set this field will result in an error.
	Size int64 `protobuf:"varint,9,opt,name=size,proto3" json:"size,omitempty"`
	// The creation time of the object.
	// Attempting to set this field will result in an error.
	TimeCreated *timestamp.Timestamp `protobuf:"bytes,10,opt,name=time_created,json=timeCreated,proto3" json:"time_created,omitempty"`
	// CRC32c checksum. For more information about using the CRC32c
	// checksum, see
	// [https://cloud.google.com/storage/docs/hashes-etags#_JSONAPI][Hashes and
	// ETags: Best Practices]. This is a server determined value and should not be
	// supplied by the user when sending an Object. The server will ignore any
	// value provided. Users should instead use the object_checksums field on the
	// InsertObjectRequest when uploading an object.
	Crc32C *wrappers.UInt32Value `protobuf:"bytes,11,opt,name=crc32c,proto3" json:"crc32c,omitempty"`
	// Number of underlying components that make up this object. Components are
	// accumulated by compose operations.
	// Attempting to set this field will result in an error.
	ComponentCount int32 `protobuf:"varint,12,opt,name=component_count,json=componentCount,proto3" json:"component_count,omitempty"`
	// MD5 hash of the data; encoded using base64 as per
	// [https://tools.ietf.org/html/rfc4648#section-4][RFC 4648 §4]. For more
	// information about using the MD5 hash, see
	// [https://cloud.google.com/storage/docs/hashes-etags#_JSONAPI][Hashes and
	// ETags: Best Practices]. This is a server determined value and should not be
	// supplied by the user when sending an Object. The server will ignore any
	// value provided. Users should instead use the object_checksums field on the
	// InsertObjectRequest when uploading an object.
	Md5Hash string `protobuf:"bytes,13,opt,name=md5_hash,json=md5Hash,proto3" json:"md5_hash,omitempty"`
	// HTTP 1.1 Entity tag for the object. See
	// [https://tools.ietf.org/html/rfc7232#section-2.3][RFC 7232 §2.3].
	// Attempting to set this field will result in an error.
	Etag string `protobuf:"bytes,14,opt,name=etag,proto3" json:"etag,omitempty"`
	// The modification time of the object metadata.
	// Attempting to set this field will result in an error.
	Updated *timestamp.Timestamp `protobuf:"bytes,15,opt,name=updated,proto3" json:"updated,omitempty"`
	// Storage class of the object.
	StorageClass string `protobuf:"bytes,16,opt,name=storage_class,json=storageClass,proto3" json:"storage_class,omitempty"`
	// Cloud KMS Key used to encrypt this object, if the object is encrypted by
	// such a key.
	KmsKeyName string `protobuf:"bytes,17,opt,name=kms_key_name,json=kmsKeyName,proto3" json:"kms_key_name,omitempty"`
	// The time at which the object's storage class was last changed. When the
	// object is initially created, it will be set to time_created.
	// Attempting to set this field will result in an error.
	TimeStorageClassUpdated *timestamp.Timestamp `protobuf:"bytes,18,opt,name=time_storage_class_updated,json=timeStorageClassUpdated,proto3" json:"time_storage_class_updated,omitempty"`
	// Whether an object is under temporary hold. While this flag is set to true,
	// the object is protected against deletion and overwrites.  A common use case
	// of this flag is regulatory investigations where objects need to be retained
	// while the investigation is ongoing. Note that unlike event-based hold,
	// temporary hold does not impact retention expiration time of an object.
	TemporaryHold bool `protobuf:"varint,19,opt,name=temporary_hold,json=temporaryHold,proto3" json:"temporary_hold,omitempty"`
	// A server-determined value that specifies the earliest time that the
	// object's retention period expires. This value is in
	// [https://tools.ietf.org/html/rfc3339][RFC 3339] format.
	// Note 1: This field is not provided for objects with an active event-based
	// hold, since retention expiration is unknown until the hold is removed.
	// Note 2: This value can be provided even when temporary hold is set (so that
	// the user can reason about policy without having to first unset the
	// temporary hold).
	RetentionExpirationTime *timestamp.Timestamp `protobuf:"bytes,20,opt,name=retention_expiration_time,json=retentionExpirationTime,proto3" json:"retention_expiration_time,omitempty"`
	// User-provided metadata, in key/value pairs.
	Metadata map[string]string `protobuf:"bytes,21,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Whether an object is under event-based hold. Event-based hold is a way to
	// retain objects until an event occurs, which is signified by the
	// hold's release (i.e. this value is set to false). After being released (set
	// to false), such objects will be subject to bucket-level retention (if any).
	// One sample use case of this flag is for banks to hold loan documents for at
	// least 3 years after loan is paid in full. Here, bucket-level retention is 3
	// years and the event is the loan being paid in full. In this example, these
	// objects will be held intact for any number of years until the event has
	// occurred (event-based hold on the object is released) and then 3 more years
	// after that. That means retention duration of the objects begins from the
	// moment event-based hold transitioned from true to false.
	EventBasedHold *wrappers.BoolValue `protobuf:"bytes,29,opt,name=event_based_hold,json=eventBasedHold,proto3" json:"event_based_hold,omitempty"`
	// The name of the object. Required if not specified by URL parameter.
	// Attempting to update this field after the object is created will result in
	// an error.
	Name string `protobuf:"bytes,23,opt,name=name,proto3" json:"name,omitempty"`
	// The ID of the object, including the bucket name, object name, and
	// generation number.
	// Attempting to update this field after the object is created will result in
	// an error.
	Id string `protobuf:"bytes,24,opt,name=id,proto3" json:"id,omitempty"`
	// The name of the bucket containing this object.
	// Attempting to update this field after the object is created will result in
	// an error.
	Bucket string `protobuf:"bytes,25,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// The content generation of this object. Used for object versioning.
	// Attempting to set this field will result in an error.
	Generation int64 `protobuf:"varint,26,opt,name=generation,proto3" json:"generation,omitempty"`
	// The owner of the object. This will always be the uploader of the object.
	// Attempting to set this field will result in an error.
	Owner *Owner `protobuf:"bytes,27,opt,name=owner,proto3" json:"owner,omitempty"`
	// Metadata of customer-supplied encryption key, if the object is encrypted by
	// such a key.
	CustomerEncryption   *Object_CustomerEncryption `protobuf:"bytes,28,opt,name=customer_encryption,json=customerEncryption,proto3" json:"customer_encryption,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *Object) Reset()         { *m = Object{} }
func (m *Object) String() string { return proto.CompactTextString(m) }
func (*Object) ProtoMessage()    {}
func (*Object) Descriptor() ([]byte, []int) {
	return fileDescriptor_303b257d2554d792, []int{11}
}

func (m *Object) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Object.Unmarshal(m, b)
}
func (m *Object) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Object.Marshal(b, m, deterministic)
}
func (m *Object) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Object.Merge(m, src)
}
func (m *Object) XXX_Size() int {
	return xxx_messageInfo_Object.Size(m)
}
func (m *Object) XXX_DiscardUnknown() {
	xxx_messageInfo_Object.DiscardUnknown(m)
}

var xxx_messageInfo_Object proto.InternalMessageInfo

func (m *Object) GetContentEncoding() string {
	if m != nil {
		return m.ContentEncoding
	}
	return ""
}

func (m *Object) GetContentDisposition() string {
	if m != nil {
		return m.ContentDisposition
	}
	return ""
}

func (m *Object) GetCacheControl() string {
	if m != nil {
		return m.CacheControl
	}
	return ""
}

func (m *Object) GetAcl() []*ObjectAccessControl {
	if m != nil {
		return m.Acl
	}
	return nil
}

func (m *Object) GetContentLanguage() string {
	if m != nil {
		return m.ContentLanguage
	}
	return ""
}

func (m *Object) GetMetageneration() int64 {
	if m != nil {
		return m.Metageneration
	}
	return 0
}

func (m *Object) GetTimeDeleted() *timestamp.Timestamp {
	if m != nil {
		return m.TimeDeleted
	}
	return nil
}

func (m *Object) GetContentType() string {
	if m != nil {
		return m.ContentType
	}
	return ""
}

func (m *Object) GetSize() int64 {
	if m != nil {
		return m.Size
	}
	return 0
}

func (m *Object) GetTimeCreated() *timestamp.Timestamp {
	if m != nil {
		return m.TimeCreated
	}
	return nil
}

func (m *Object) GetCrc32C() *wrappers.UInt32Value {
	if m != nil {
		return m.Crc32C
	}
	return nil
}

func (m *Object) GetComponentCount() int32 {
	if m != nil {
		return m.ComponentCount
	}
	return 0
}

func (m *Object) GetMd5Hash() string {
	if m != nil {
		return m.Md5Hash
	}
	return ""
}

func (m *Object) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

func (m *Object) GetUpdated() *timestamp.Timestamp {
	if m != nil {
		return m.Updated
	}
	return nil
}

func (m *Object) GetStorageClass() string {
	if m != nil {
		return m.StorageClass
	}
	return ""
}

func (m *Object) GetKmsKeyName() string {
	if m != nil {
		return m.KmsKeyName
	}
	return ""
}

func (m *Object) GetTimeStorageClassUpdated() *timestamp.Timestamp {
	if m != nil {
		return m.TimeStorageClassUpdated
	}
	return nil
}

func (m *Object) GetTemporaryHold() bool {
	if m != nil {
		return m.TemporaryHold
	}
	return false
}

func (m *Object) GetRetentionExpirationTime() *timestamp.Timestamp {
	if m != nil {
		return m.RetentionExpirationTime
	}
	return nil
}

func (m *Object) GetMetadata() map[string]string {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Object) GetEventBasedHold() *wrappers.BoolValue {
	if m != nil {
		return m.EventBasedHold
	}
	return nil
}

func (m *Object) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Object) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Object) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *Object) GetGeneration() int64 {
	if m != nil {
		return m.Generation
	}
	return 0
}

func (m *Object) GetOwner() *Owner {
	if m != nil {
		return m.Owner
	}
	return nil
}

func (m *Object) GetCustomerEncryption() *Object_CustomerEncryption {
	if m != nil {
		return m.CustomerEncryption
	}
	return nil
}

// Describes the customer-specified mechanism used to store the data at rest.
type Object_CustomerEncryption struct {
	// The encryption algorithm.
	EncryptionAlgorithm string `protobuf:"bytes,1,opt,name=encryption_algorithm,json=encryptionAlgorithm,proto3" json:"encryption_algorithm,omitempty"`
	// SHA256 hash value of the encryption key.
	KeySha256            string   `protobuf:"bytes,2,opt,name=key_sha256,json=keySha256,proto3" json:"key_sha256,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Object_CustomerEncryption) Reset()         { *m = Object_CustomerEncryption{} }
func (m *Object_CustomerEncryption) String() string { return proto.CompactTextString(m) }
func (*Object_CustomerEncryption) ProtoMessage()    {}
func (*Object_CustomerEncryption) Descriptor() ([]byte, []int) {
	return fileDescriptor_303b257d2554d792, []int{11, 0}
}

func (m *Object_CustomerEncryption) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Object_CustomerEncryption.Unmarshal(m, b)
}
func (m *Object_CustomerEncryption) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Object_CustomerEncryption.Marshal(b, m, deterministic)
}
func (m *Object_CustomerEncryption) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Object_CustomerEncryption.Merge(m, src)
}
func (m *Object_CustomerEncryption) XXX_Size() int {
	return xxx_messageInfo_Object_CustomerEncryption.Size(m)
}
func (m *Object_CustomerEncryption) XXX_DiscardUnknown() {
	xxx_messageInfo_Object_CustomerEncryption.DiscardUnknown(m)
}

var xxx_messageInfo_Object_CustomerEncryption proto.InternalMessageInfo

func (m *Object_CustomerEncryption) GetEncryptionAlgorithm() string {
	if m != nil {
		return m.EncryptionAlgorithm
	}
	return ""
}

func (m *Object_CustomerEncryption) GetKeySha256() string {
	if m != nil {
		return m.KeySha256
	}
	return ""
}

// An access-control entry.
type ObjectAccessControl struct {
	// The access permission for the entity.
	Role string `protobuf:"bytes,1,opt,name=role,proto3" json:"role,omitempty"`
	// HTTP 1.1 Entity tag for the access-control entry.
	// See [https://tools.ietf.org/html/rfc7232#section-2.3][RFC 7232 §2.3].
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
	// The ID of the access-control entry.
	Id string `protobuf:"bytes,3,opt,name=id,proto3" json:"id,omitempty"`
	// The name of the bucket.
	Bucket string `protobuf:"bytes,4,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// The name of the object, if applied to an object.
	Object string `protobuf:"bytes,5,opt,name=object,proto3" json:"object,omitempty"`
	// The content generation of the object, if applied to an object.
	Generation int64 `protobuf:"varint,6,opt,name=generation,proto3" json:"generation,omitempty"`
	// The entity holding the permission, in one of the following forms:
	// * `user-{userid}`
	// * `user-{email}`
	// * `group-{groupid}`
	// * `group-{email}`
	// * `domain-{domain}`
	// * `project-{team-projectid}`
	// * `allUsers`
	// * `allAuthenticatedUsers`
	// Examples:
	// * The user `liz@example.com` would be `user-liz@example.com`.
	// * The group `example@googlegroups.com` would be
	// `group-example@googlegroups.com`.
	// * All members of the Google Apps for Business domain `example.com` would be
	// `domain-example.com`.
	Entity string `protobuf:"bytes,7,opt,name=entity,proto3" json:"entity,omitempty"`
	// The ID for the entity, if any.
	EntityId string `protobuf:"bytes,8,opt,name=entity_id,json=entityId,proto3" json:"entity_id,omitempty"`
	// The email address associated with the entity, if any.
	Email string `protobuf:"bytes,9,opt,name=email,proto3" json:"email,omitempty"`
	// The domain associated with the entity, if any.
	Domain string `protobuf:"bytes,10,opt,name=domain,proto3" json:"domain,omitempty"`
	// The project team associated with the entity, if any.
	ProjectTeam          *ProjectTeam `protobuf:"bytes,11,opt,name=project_team,json=projectTeam,proto3" json:"project_team,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *ObjectAccessControl) Reset()         { *m = ObjectAccessControl{} }
func (m *ObjectAccessControl) String() string { return proto.CompactTextString(m) }
func (*ObjectAccessControl) ProtoMessage()    {}
func (*ObjectAccessControl) Descriptor() ([]byte, []int) {
	return fileDescriptor_303b257d2554d792, []int{12}
}

func (m *ObjectAccessControl) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ObjectAccessControl.Unmarshal(m, b)
}
func (m *ObjectAccessControl) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ObjectAccessControl.Marshal(b, m, deterministic)
}
func (m *ObjectAccessControl) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ObjectAccessControl.Merge(m, src)
}
func (m *ObjectAccessControl) XXX_Size() int {
	return xxx_messageInfo_ObjectAccessControl.Size(m)
}
func (m *ObjectAccessControl) XXX_DiscardUnknown() {
	xxx_messageInfo_ObjectAccessControl.DiscardUnknown(m)
}

var xxx_messageInfo_ObjectAccessControl proto.InternalMessageInfo

func (m *ObjectAccessControl) GetRole() string {
	if m != nil {
		return m.Role
	}
	return ""
}

func (m *ObjectAccessControl) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

func (m *ObjectAccessControl) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ObjectAccessControl) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *ObjectAccessControl) GetObject() string {
	if m != nil {
		return m.Object
	}
	return ""
}

func (m *ObjectAccessControl) GetGeneration() int64 {
	if m != nil {
		return m.Generation
	}
	return 0
}

func (m *ObjectAccessControl) GetEntity() string {
	if m != nil {
		return m.Entity
	}
	return ""
}

func (m *ObjectAccessControl) GetEntityId() string {
	if m != nil {
		return m.EntityId
	}
	return ""
}

func (m *ObjectAccessControl) GetEmail() string {
	if m != nil {
		return m.Email
	}
	return ""
}

func (m *ObjectAccessControl) GetDomain() string {
	if m != nil {
		return m.Domain
	}
	return ""
}

func (m *ObjectAccessControl) GetProjectTeam() *ProjectTeam {
	if m != nil {
		return m.ProjectTeam
	}
	return nil
}

// The result of a call to ObjectAccessControls.ListObjectAccessControls.
type ListObjectAccessControlsResponse struct {
	// The list of items.
	Items                []*ObjectAccessControl `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *ListObjectAccessControlsResponse) Reset()         { *m = ListObjectAccessControlsResponse{} }
func (m *ListObjectAccessControlsResponse) String() string { return proto.CompactTextString(m) }
func (*ListObjectAccessControlsResponse) ProtoMessage()    {}
func (*ListObjectAccessControlsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_303b257d2554d792, []int{13}
}

func (m *ListObjectAccessControlsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListObjectAccessControlsResponse.Unmarshal(m, b)
}
func (m *ListObjectAccessControlsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListObjectAccessControlsResponse.Marshal(b, m, deterministic)
}
func (m *ListObjectAccessControlsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListObjectAccessControlsResponse.Merge(m, src)
}
func (m *ListObjectAccessControlsResponse) XXX_Size() int {
	return xxx_messageInfo_ListObjectAccessControlsResponse.Size(m)
}
func (m *ListObjectAccessControlsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListObjectAccessControlsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListObjectAccessControlsResponse proto.InternalMessageInfo

func (m *ListObjectAccessControlsResponse) GetItems() []*ObjectAccessControl {
	if m != nil {
		return m.Items
	}
	return nil
}

// The result of a call to Objects.ListObjects
type ListObjectsResponse struct {
	// The list of prefixes of objects matching-but-not-listed up to and including
	// the requested delimiter.
	Prefixes []string `protobuf:"bytes,1,rep,name=prefixes,proto3" json:"prefixes,omitempty"`
	// The list of items.
	Items []*Object `protobuf:"bytes,2,rep,name=items,proto3" json:"items,omitempty"`
	// The continuation token, used to page through large result sets. Provide
	// this value in a subsequent request to return the next page of results.
	NextPageToken        string   `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListObjectsResponse) Reset()         { *m = ListObjectsResponse{} }
func (m *ListObjectsResponse) String() string { return proto.CompactTextString(m) }
func (*ListObjectsResponse) ProtoMessage()    {}
func (*ListObjectsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_303b257d2554d792, []int{14}
}

func (m *ListObjectsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListObjectsResponse.Unmarshal(m, b)
}
func (m *ListObjectsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListObjectsResponse.Marshal(b, m, deterministic)
}
func (m *ListObjectsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListObjectsResponse.Merge(m, src)
}
func (m *ListObjectsResponse) XXX_Size() int {
	return xxx_messageInfo_ListObjectsResponse.Size(m)
}
func (m *ListObjectsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListObjectsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListObjectsResponse proto.InternalMessageInfo

func (m *ListObjectsResponse) GetPrefixes() []string {
	if m != nil {
		return m.Prefixes
	}
	return nil
}

func (m *ListObjectsResponse) GetItems() []*Object {
	if m != nil {
		return m.Items
	}
	return nil
}

func (m *ListObjectsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Represents the Viewers, Editors, or Owners of a given project.
type ProjectTeam struct {
	// The project number.
	ProjectNumber string `protobuf:"bytes,1,opt,name=project_number,json=projectNumber,proto3" json:"project_number,omitempty"`
	// The team.
	Team                 string   `protobuf:"bytes,2,opt,name=team,proto3" json:"team,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ProjectTeam) Reset()         { *m = ProjectTeam{} }
func (m *ProjectTeam) String() string { return proto.CompactTextString(m) }
func (*ProjectTeam) ProtoMessage()    {}
func (*ProjectTeam) Descriptor() ([]byte, []int) {
	return fileDescriptor_303b257d2554d792, []int{15}
}

func (m *ProjectTeam) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProjectTeam.Unmarshal(m, b)
}
func (m *ProjectTeam) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProjectTeam.Marshal(b, m, deterministic)
}
func (m *ProjectTeam) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProjectTeam.Merge(m, src)
}
func (m *ProjectTeam) XXX_Size() int {
	return xxx_messageInfo_ProjectTeam.Size(m)
}
func (m *ProjectTeam) XXX_DiscardUnknown() {
	xxx_messageInfo_ProjectTeam.DiscardUnknown(m)
}

var xxx_messageInfo_ProjectTeam proto.InternalMessageInfo

func (m *ProjectTeam) GetProjectNumber() string {
	if m != nil {
		return m.ProjectNumber
	}
	return ""
}

func (m *ProjectTeam) GetTeam() string {
	if m != nil {
		return m.Team
	}
	return ""
}

// A subscription to receive Google PubSub notifications.
type ServiceAccount struct {
	// The ID of the notification.
	EmailAddress         string   `protobuf:"bytes,1,opt,name=email_address,json=emailAddress,proto3" json:"email_address,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ServiceAccount) Reset()         { *m = ServiceAccount{} }
func (m *ServiceAccount) String() string { return proto.CompactTextString(m) }
func (*ServiceAccount) ProtoMessage()    {}
func (*ServiceAccount) Descriptor() ([]byte, []int) {
	return fileDescriptor_303b257d2554d792, []int{16}
}

func (m *ServiceAccount) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ServiceAccount.Unmarshal(m, b)
}
func (m *ServiceAccount) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ServiceAccount.Marshal(b, m, deterministic)
}
func (m *ServiceAccount) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServiceAccount.Merge(m, src)
}
func (m *ServiceAccount) XXX_Size() int {
	return xxx_messageInfo_ServiceAccount.Size(m)
}
func (m *ServiceAccount) XXX_DiscardUnknown() {
	xxx_messageInfo_ServiceAccount.DiscardUnknown(m)
}

var xxx_messageInfo_ServiceAccount proto.InternalMessageInfo

func (m *ServiceAccount) GetEmailAddress() string {
	if m != nil {
		return m.EmailAddress
	}
	return ""
}

// The owner of a specific resource.
type Owner struct {
	// The entity, in the form `user-`*userId*.
	Entity string `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	// The ID for the entity.
	EntityId             string   `protobuf:"bytes,2,opt,name=entity_id,json=entityId,proto3" json:"entity_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Owner) Reset()         { *m = Owner{} }
func (m *Owner) String() string { return proto.CompactTextString(m) }
func (*Owner) ProtoMessage()    {}
func (*Owner) Descriptor() ([]byte, []int) {
	return fileDescriptor_303b257d2554d792, []int{17}
}

func (m *Owner) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Owner.Unmarshal(m, b)
}
func (m *Owner) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Owner.Marshal(b, m, deterministic)
}
func (m *Owner) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Owner.Merge(m, src)
}
func (m *Owner) XXX_Size() int {
	return xxx_messageInfo_Owner.Size(m)
}
func (m *Owner) XXX_DiscardUnknown() {
	xxx_messageInfo_Owner.DiscardUnknown(m)
}

var xxx_messageInfo_Owner proto.InternalMessageInfo

func (m *Owner) GetEntity() string {
	if m != nil {
		return m.Entity
	}
	return ""
}

func (m *Owner) GetEntityId() string {
	if m != nil {
		return m.EntityId
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.storage.v1.CommonEnums_Projection", CommonEnums_Projection_name, CommonEnums_Projection_value)
	proto.RegisterEnum("google.storage.v1.CommonEnums_PredefinedBucketAcl", CommonEnums_PredefinedBucketAcl_name, CommonEnums_PredefinedBucketAcl_value)
	proto.RegisterEnum("google.storage.v1.CommonEnums_PredefinedObjectAcl", CommonEnums_PredefinedObjectAcl_name, CommonEnums_PredefinedObjectAcl_value)
	proto.RegisterType((*Bucket)(nil), "google.storage.v1.Bucket")
	proto.RegisterMapType((map[string]string)(nil), "google.storage.v1.Bucket.LabelsEntry")
	proto.RegisterType((*Bucket_Billing)(nil), "google.storage.v1.Bucket.Billing")
	proto.RegisterType((*Bucket_Cors)(nil), "google.storage.v1.Bucket.Cors")
	proto.RegisterType((*Bucket_Encryption)(nil), "google.storage.v1.Bucket.Encryption")
	proto.RegisterType((*Bucket_Lifecycle)(nil), "google.storage.v1.Bucket.Lifecycle")
	proto.RegisterType((*Bucket_Lifecycle_Rule)(nil), "google.storage.v1.Bucket.Lifecycle.Rule")
	proto.RegisterType((*Bucket_Lifecycle_Rule_Action)(nil), "google.storage.v1.Bucket.Lifecycle.Rule.Action")
	proto.RegisterType((*Bucket_Lifecycle_Rule_Condition)(nil), "google.storage.v1.Bucket.Lifecycle.Rule.Condition")
	proto.RegisterType((*Bucket_Logging)(nil), "google.storage.v1.Bucket.Logging")
	proto.RegisterType((*Bucket_RetentionPolicy)(nil), "google.storage.v1.Bucket.RetentionPolicy")
	proto.RegisterType((*Bucket_Versioning)(nil), "google.storage.v1.Bucket.Versioning")
	proto.RegisterType((*Bucket_Website)(nil), "google.storage.v1.Bucket.Website")
	proto.RegisterType((*BucketAccessControl)(nil), "google.storage.v1.BucketAccessControl")
	proto.RegisterType((*ListBucketAccessControlsResponse)(nil), "google.storage.v1.ListBucketAccessControlsResponse")
	proto.RegisterType((*ListBucketsResponse)(nil), "google.storage.v1.ListBucketsResponse")
	proto.RegisterType((*Channel)(nil), "google.storage.v1.Channel")
	proto.RegisterMapType((map[string]string)(nil), "google.storage.v1.Channel.ParamsEntry")
	proto.RegisterType((*ChecksummedData)(nil), "google.storage.v1.ChecksummedData")
	proto.RegisterType((*ObjectChecksums)(nil), "google.storage.v1.ObjectChecksums")
	proto.RegisterType((*CommonEnums)(nil), "google.storage.v1.CommonEnums")
	proto.RegisterType((*ContentRange)(nil), "google.storage.v1.ContentRange")
	proto.RegisterType((*Notification)(nil), "google.storage.v1.Notification")
	proto.RegisterMapType((map[string]string)(nil), "google.storage.v1.Notification.CustomAttributesEntry")
	proto.RegisterType((*ListNotificationsResponse)(nil), "google.storage.v1.ListNotificationsResponse")
	proto.RegisterType((*Object)(nil), "google.storage.v1.Object")
	proto.RegisterMapType((map[string]string)(nil), "google.storage.v1.Object.MetadataEntry")
	proto.RegisterType((*Object_CustomerEncryption)(nil), "google.storage.v1.Object.CustomerEncryption")
	proto.RegisterType((*ObjectAccessControl)(nil), "google.storage.v1.ObjectAccessControl")
	proto.RegisterType((*ListObjectAccessControlsResponse)(nil), "google.storage.v1.ListObjectAccessControlsResponse")
	proto.RegisterType((*ListObjectsResponse)(nil), "google.storage.v1.ListObjectsResponse")
	proto.RegisterType((*ProjectTeam)(nil), "google.storage.v1.ProjectTeam")
	proto.RegisterType((*ServiceAccount)(nil), "google.storage.v1.ServiceAccount")
	proto.RegisterType((*Owner)(nil), "google.storage.v1.Owner")
}

func init() {
	proto.RegisterFile("google/storage/v1/storage_resources.proto", fileDescriptor_303b257d2554d792)
}

var fileDescriptor_303b257d2554d792 = []byte{
	// 2591 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x19, 0x4d, 0x6f, 0xdb, 0xc8,
	0xb5, 0xfa, 0x96, 0x9e, 0x6c, 0x59, 0x1e, 0x27, 0x59, 0x86, 0x9b, 0xcd, 0x3a, 0xda, 0x4d, 0xd6,
	0x5b, 0x04, 0x72, 0xe3, 0xac, 0xdb, 0x74, 0x93, 0x2c, 0x20, 0xcb, 0x4a, 0xe3, 0x46, 0xb5, 0x05,
	0x5a, 0x4e, 0xd0, 0x02, 0x05, 0x3b, 0x22, 0x47, 0x12, 0x6b, 0x92, 0xc3, 0x72, 0x28, 0x27, 0xea,
	0x1f, 0x58, 0xa0, 0x3d, 0xf5, 0xde, 0x43, 0x6f, 0xfd, 0x21, 0x3d, 0xf5, 0x5c, 0xf4, 0x37, 0xf4,
	0xde, 0x3f, 0xd0, 0x62, 0x3e, 0x48, 0x51, 0x96, 0x14, 0xdb, 0x05, 0x7a, 0xe3, 0xbc, 0x79, 0xef,
	0xcd, 0x9b, 0x37, 0xef, 0x9b, 0xf0, 0xf5, 0x88, 0xd2, 0x91, 0x4b, 0x76, 0x59, 0x44, 0x43, 0x3c,
	0x22, 0xbb, 0x17, 0x4f, 0xe2, 0x4f, 0x33, 0x24, 0x8c, 0x4e, 0x42, 0x8b, 0xb0, 0x66, 0x10, 0xd2,
	0x88, 0xa2, 0x4d, 0x89, 0xda, 0x54, 0xfb, 0xcd, 0x8b, 0x27, 0xfa, 0xe7, 0x8a, 0x5a, 0x20, 0x0c,
	0x26, 0xc3, 0xdd, 0xc8, 0xf1, 0x08, 0x8b, 0xb0, 0x17, 0x48, 0x1a, 0xfd, 0xfe, 0x65, 0x84, 0xf7,
	0x21, 0x0e, 0x02, 0x12, 0x2a, 0x9e, 0x8d, 0x3f, 0x6d, 0x41, 0xf1, 0x60, 0x62, 0x9d, 0x93, 0x08,
	0x3d, 0x83, 0x1c, 0xb6, 0x5c, 0x2d, 0xb3, 0x9d, 0xdb, 0xa9, 0xee, 0x3d, 0x6a, 0x2e, 0x1c, 0xd6,
	0x94, 0x78, 0x2d, 0xcb, 0x22, 0x8c, 0xb5, 0xa9, 0x1f, 0x85, 0xd4, 0x35, 0x38, 0x09, 0xea, 0x03,
	0xb2, 0xc9, 0x10, 0x4f, 0xdc, 0xc8, 0xa4, 0x83, 0xdf, 0x12, 0x2b, 0x32, 0x39, 0xa3, 0xec, 0x4a,
	0x46, 0x27, 0x02, 0x69, 0x9e, 0x51, 0x5d, 0x71, 0x88, 0xf7, 0x5c, 0xd4, 0x82, 0x8a, 0xeb, 0x0c,
	0x89, 0x35, 0xb5, 0x5c, 0xa2, 0xe5, 0xb6, 0x33, 0x3b, 0xd5, 0xbd, 0x2f, 0x56, 0x4a, 0xd5, 0xec,
	0xc6, 0xa8, 0xc6, 0x8c, 0x0a, 0xbd, 0x84, 0x35, 0xae, 0x10, 0xd3, 0x0a, 0x09, 0x8e, 0x88, 0xad,
	0xe5, 0x05, 0x17, 0x3d, 0xe6, 0x12, 0x2b, 0xa5, 0xd9, 0x8f, 0xb5, 0x66, 0x54, 0x39, 0x7e, 0x5b,
	0xa2, 0xa3, 0x1a, 0x64, 0x1d, 0x5b, 0x2b, 0x6c, 0x67, 0x76, 0x2a, 0x46, 0xd6, 0xb1, 0x11, 0x82,
	0xbc, 0x8f, 0x3d, 0xa2, 0x15, 0x05, 0x44, 0x7c, 0xa3, 0x87, 0x50, 0x0b, 0x42, 0x2a, 0x2e, 0xed,
	0x4f, 0xbc, 0x01, 0x09, 0xb5, 0xd2, 0x76, 0x66, 0x27, 0x67, 0xac, 0x2b, 0xe8, 0xb1, 0x00, 0xa2,
	0x47, 0x50, 0xf3, 0x48, 0x84, 0x47, 0xc4, 0x27, 0x21, 0x8e, 0x1c, 0xea, 0x6b, 0x65, 0x81, 0x76,
	0x09, 0x8a, 0xf6, 0x20, 0x6f, 0xd1, 0x90, 0x69, 0x15, 0xa1, 0xbc, 0xfb, 0xab, 0xef, 0xdb, 0xa6,
	0x21, 0x33, 0x04, 0x2e, 0xd2, 0xa1, 0xec, 0x52, 0x4b, 0x72, 0x05, 0x21, 0x5a, 0xb2, 0x46, 0x5f,
	0xc0, 0x7a, 0x6c, 0x4e, 0x96, 0x8b, 0x19, 0xd3, 0xaa, 0x02, 0x61, 0x4d, 0x01, 0xdb, 0x1c, 0xc6,
	0xef, 0xc5, 0xa5, 0xd0, 0xd6, 0xe4, 0xbd, 0xf8, 0x37, 0xfa, 0x06, 0x4a, 0x93, 0xc0, 0x16, 0x5a,
	0x5b, 0xbf, 0x52, 0x6b, 0x31, 0x2a, 0xfa, 0x09, 0x68, 0xb1, 0x25, 0x90, 0x0b, 0xe2, 0x47, 0xe6,
	0x00, 0x33, 0x62, 0x9b, 0x63, 0xea, 0xda, 0x5a, 0x6d, 0x3b, 0xb3, 0x53, 0x36, 0x6e, 0xab, 0xfd,
	0x0e, 0xdf, 0x3e, 0xe0, 0xbb, 0xaf, 0xa9, 0x6b, 0xa3, 0x97, 0x50, 0x74, 0xf1, 0x80, 0xb8, 0x4c,
	0xdb, 0x10, 0x37, 0x7f, 0xf8, 0x91, 0x97, 0x16, 0x78, 0x1d, 0x3f, 0x0a, 0xa7, 0x86, 0x22, 0x42,
	0xcf, 0xa1, 0xf4, 0x9e, 0x0c, 0x98, 0x13, 0x11, 0xad, 0x2e, 0xa4, 0x7d, 0xb0, 0x9a, 0xfe, 0x9d,
	0x44, 0x34, 0x62, 0x0a, 0x74, 0x08, 0x70, 0x41, 0x42, 0xe6, 0x50, 0xdf, 0xf1, 0x47, 0xda, 0xa6,
	0xa0, 0xff, 0x72, 0x35, 0xfd, 0xdb, 0x04, 0xd7, 0x48, 0xd1, 0x71, 0x11, 0x5c, 0x3a, 0x1a, 0x71,
	0x16, 0xe8, 0x2a, 0x11, 0xba, 0x12, 0xd1, 0x88, 0x29, 0x50, 0x13, 0x0a, 0xf4, 0xbd, 0x4f, 0x42,
	0x6d, 0x4b, 0x90, 0x6a, 0xcb, 0x9c, 0x86, 0xef, 0x1b, 0x12, 0x8d, 0x8b, 0x4c, 0x7c, 0x2b, 0x9c,
	0x06, 0xe2, 0xd1, 0x6f, 0x5d, 0x25, 0x72, 0x27, 0xc1, 0x35, 0x52, 0x74, 0x5c, 0xe4, 0x81, 0xe3,
	0xba, 0x5c, 0xe4, 0xdb, 0x57, 0x89, 0x7c, 0x20, 0x11, 0x8d, 0x98, 0x02, 0xf5, 0xa1, 0x1e, 0x92,
	0x88, 0xf8, 0x9c, 0x93, 0x19, 0x50, 0xd7, 0xb1, 0xa6, 0xda, 0x1d, 0xc1, 0xe5, 0xeb, 0xd5, 0x5c,
	0x8c, 0x98, 0xa2, 0x27, 0x08, 0x8c, 0x8d, 0x70, 0x1e, 0xa0, 0xff, 0x08, 0x4a, 0xea, 0x24, 0xee,
	0x59, 0x21, 0xf9, 0xdd, 0x84, 0xb0, 0x88, 0x84, 0x66, 0x80, 0xa7, 0x4c, 0xcb, 0x08, 0x0b, 0x5a,
	0x4f, 0xa0, 0x3d, 0x3c, 0x65, 0xfa, 0xf7, 0x19, 0xc8, 0x73, 0x67, 0x40, 0x77, 0xa0, 0x48, 0x43,
	0x67, 0xe4, 0xf8, 0x22, 0x84, 0x55, 0x0c, 0xb5, 0xe2, 0x70, 0x8f, 0x44, 0x63, 0x6a, 0x8b, 0x88,
	0x54, 0x31, 0xd4, 0x0a, 0x7d, 0x05, 0x1b, 0x21, 0x61, 0x01, 0xf5, 0x19, 0x31, 0xc7, 0x04, 0xdb,
	0x24, 0xd4, 0x72, 0x02, 0xa1, 0x16, 0x83, 0x5f, 0x0b, 0x28, 0x7a, 0x04, 0x1b, 0x1e, 0xfe, 0x60,
	0x72, 0x1f, 0x62, 0xc4, 0xa2, 0xbe, 0xcd, 0x44, 0x20, 0x29, 0x18, 0xeb, 0x1e, 0xfe, 0xd0, 0x1a,
	0x91, 0x53, 0x09, 0xd4, 0x5f, 0x02, 0xcc, 0x14, 0x8d, 0x76, 0xe1, 0x56, 0xec, 0x0a, 0xe7, 0x1e,
	0x33, 0xcf, 0xc9, 0xd4, 0x14, 0xc1, 0x23, 0x23, 0x9c, 0x6c, 0x53, 0xed, 0xbd, 0xf1, 0xd8, 0x1b,
	0x32, 0x3d, 0xc6, 0x1e, 0xd1, 0xff, 0x91, 0x87, 0x4a, 0x12, 0xc5, 0xd0, 0x0b, 0xc8, 0x87, 0x13,
	0x97, 0xa8, 0x70, 0xbc, 0x73, 0x8d, 0xc0, 0xd7, 0x34, 0x26, 0x2e, 0x31, 0x04, 0x95, 0xfe, 0x7d,
	0x1e, 0xf2, 0x7c, 0x89, 0x7e, 0x06, 0x45, 0x6c, 0x09, 0x23, 0xc9, 0x88, 0xb7, 0xd9, 0xbd, 0x2e,
	0xa3, 0x66, 0x4b, 0x90, 0x19, 0x8a, 0x1c, 0xf5, 0xa0, 0xc2, 0x6f, 0xe9, 0x08, 0x5e, 0x59, 0xc1,
	0x6b, 0xef, 0xda, 0xbc, 0xda, 0x31, 0xa5, 0x31, 0x63, 0xa2, 0xb7, 0xa0, 0x28, 0xcf, 0xe0, 0xf1,
	0x27, 0x9a, 0x06, 0xb1, 0x6a, 0xc4, 0xf7, 0x62, 0xe0, 0xca, 0x2e, 0x06, 0x2e, 0xfd, 0x2f, 0x59,
	0xa8, 0x24, 0xbc, 0x51, 0x1d, 0x72, 0x78, 0x24, 0xb9, 0x14, 0x0c, 0xfe, 0x89, 0x5a, 0x50, 0x53,
	0xa1, 0xdf, 0x1c, 0x90, 0x21, 0x0d, 0x89, 0x92, 0xfc, 0x63, 0xb1, 0x6c, 0x5d, 0x51, 0x1c, 0x08,
	0x02, 0xf4, 0x14, 0x4a, 0x0e, 0x33, 0x5d, 0xe7, 0x22, 0xce, 0x41, 0x8b, 0xb4, 0x07, 0x94, 0xba,
	0x6f, 0xb1, 0x3b, 0x21, 0x46, 0xd1, 0x61, 0x5d, 0xe7, 0x82, 0xa0, 0xc7, 0x80, 0xfc, 0x89, 0x67,
	0xfa, 0xe4, 0x3d, 0x09, 0x4d, 0x15, 0x23, 0x62, 0xa3, 0xa9, 0xfb, 0x13, 0xef, 0x98, 0x6f, 0xa8,
	0x38, 0xc2, 0xd0, 0x1e, 0xdc, 0xf6, 0x70, 0x64, 0x8d, 0x09, 0x33, 0xe7, 0xaf, 0x5c, 0x10, 0xe6,
	0xb8, 0xa5, 0x36, 0x4f, 0xd3, 0x21, 0xfb, 0x2b, 0x6e, 0x93, 0x92, 0x26, 0xc0, 0x51, 0x44, 0x42,
	0x5f, 0x65, 0xa5, 0x9a, 0x02, 0xf7, 0x24, 0x54, 0xef, 0x43, 0x49, 0x45, 0x1b, 0xf4, 0x19, 0x80,
	0x4b, 0x47, 0xe6, 0x40, 0x3c, 0x91, 0x52, 0x76, 0xc5, 0xa5, 0x23, 0x95, 0xff, 0x7f, 0x08, 0x9b,
	0x7c, 0x5b, 0x65, 0xf0, 0x20, 0x24, 0x43, 0xe7, 0x83, 0xd2, 0xfa, 0x86, 0x4b, 0x47, 0x32, 0x31,
	0xf7, 0x04, 0x58, 0xff, 0x73, 0x06, 0x36, 0x2e, 0xf9, 0x32, 0x57, 0x36, 0x19, 0x0e, 0x89, 0x15,
	0x39, 0x17, 0xc4, 0xe4, 0x69, 0x54, 0x99, 0xdc, 0x47, 0x95, 0x9d, 0x50, 0x70, 0x18, 0xfa, 0x14,
	0x2a, 0x5c, 0xd9, 0xd4, 0x3a, 0x27, 0xb6, 0x38, 0xba, 0x6c, 0x94, 0x1d, 0xd6, 0x15, 0x6b, 0xf4,
	0xf5, 0x5c, 0xc0, 0x21, 0xa1, 0x43, 0x6d, 0xf1, 0x24, 0xb9, 0x74, 0x14, 0x11, 0x60, 0xfd, 0x11,
	0xc0, 0x2c, 0x4a, 0x23, 0x0d, 0x4a, 0xc4, 0xc7, 0x03, 0x97, 0xd8, 0x2a, 0x82, 0xc4, 0x4b, 0xfd,
	0x97, 0x50, 0x52, 0xd9, 0x00, 0xed, 0x40, 0xdd, 0xc3, 0x8e, 0x6f, 0x06, 0xc2, 0xcd, 0x27, 0x43,
	0x7e, 0xf9, 0x4c, 0xac, 0x51, 0xc7, 0xef, 0xe1, 0x11, 0x39, 0x15, 0x50, 0xf4, 0x25, 0xd4, 0x7c,
	0x1a, 0x99, 0x43, 0x3a, 0xf1, 0x6d, 0x81, 0x1e, 0x9b, 0xa6, 0x4f, 0xa3, 0x57, 0x1c, 0xc8, 0x71,
	0xf5, 0x9f, 0x42, 0x35, 0x95, 0xa8, 0xb8, 0x6d, 0x9e, 0x93, 0xa9, 0xe2, 0xc8, 0x3f, 0xd1, 0x2d,
	0x28, 0x5c, 0x70, 0xa3, 0x51, 0xd4, 0x72, 0xf1, 0x6d, 0xf6, 0x59, 0xa6, 0xf1, 0xc7, 0x2c, 0x6c,
	0x2d, 0xa9, 0xb5, 0xb8, 0x9b, 0x84, 0xd4, 0x4d, 0xdc, 0x84, 0x7f, 0x27, 0xa9, 0x3b, 0x9b, 0x4a,
	0xdd, 0xb2, 0x6c, 0xc9, 0x25, 0x65, 0xcb, 0x1d, 0x28, 0xaa, 0x37, 0xcf, 0x0b, 0x98, 0x5a, 0x71,
	0x38, 0xd7, 0x5a, 0x34, 0x55, 0xa6, 0xa3, 0x56, 0xfc, 0x15, 0xe4, 0x97, 0xe9, 0xd8, 0xa2, 0x9a,
	0xa9, 0x18, 0x65, 0x09, 0x38, 0xb2, 0xb9, 0xd8, 0xc4, 0xc3, 0x8e, 0x2b, 0xea, 0x97, 0x8a, 0x21,
	0x17, 0x9c, 0x95, 0x4d, 0xb9, 0x9e, 0xb4, 0x8a, 0x64, 0x25, 0x57, 0xa8, 0x05, 0x6b, 0x71, 0x75,
	0x14, 0x11, 0xec, 0x89, 0xf2, 0x64, 0x79, 0x59, 0xd3, 0x93, 0x68, 0x7d, 0x82, 0x3d, 0xa3, 0x1a,
	0xcc, 0x16, 0x8d, 0xdf, 0xc0, 0x76, 0xd7, 0x61, 0xd1, 0x12, 0x85, 0x30, 0x43, 0xc5, 0x69, 0xf4,
	0x02, 0x0a, 0x4e, 0x44, 0x3c, 0x76, 0xc3, 0xe2, 0x55, 0x12, 0x35, 0x7c, 0xd8, 0x9a, 0x9d, 0x30,
	0x63, 0xba, 0x3b, 0xcf, 0xf4, 0xee, 0x4a, 0xa6, 0x8a, 0x0f, 0xcf, 0x13, 0x3e, 0xf9, 0x10, 0x49,
	0x13, 0x8a, 0xe8, 0x39, 0xf1, 0xd5, 0xb3, 0xac, 0x73, 0x30, 0xb7, 0x8a, 0x3e, 0x07, 0x36, 0xfe,
	0x9d, 0x85, 0x52, 0x7b, 0x8c, 0x7d, 0x9f, 0xb8, 0xea, 0xad, 0x32, 0xc9, 0x5b, 0x7d, 0x0e, 0xd5,
	0xb8, 0xec, 0xe7, 0xda, 0x97, 0xf4, 0x10, 0x83, 0x8e, 0x6c, 0xf4, 0x00, 0xd6, 0x12, 0x84, 0x49,
	0xe8, 0xa8, 0x67, 0x4e, 0x88, 0xce, 0x42, 0x87, 0x3f, 0x91, 0x3c, 0x5d, 0x3e, 0xb7, 0x5c, 0xa0,
	0x6f, 0x01, 0xc8, 0x87, 0xc0, 0x51, 0xd5, 0x67, 0xe1, 0x4a, 0xd7, 0x4c, 0x61, 0x27, 0x01, 0xba,
	0x98, 0x0a, 0xd0, 0x1a, 0x94, 0xb0, 0x6d, 0x87, 0x84, 0x31, 0x65, 0x23, 0xf1, 0x12, 0x7d, 0x07,
	0xc5, 0x00, 0x87, 0xd8, 0x63, 0x5a, 0x79, 0xe5, 0x73, 0xa8, 0xfb, 0x37, 0x7b, 0x02, 0x51, 0x15,
	0x73, 0x92, 0x8a, 0x73, 0x0e, 0xf0, 0xd4, 0xa5, 0xd8, 0x16, 0xd6, 0x54, 0x36, 0xe2, 0x25, 0x77,
	0xaa, 0x14, 0xc1, 0x8d, 0x9c, 0x0a, 0xc3, 0x46, 0x7b, 0x4c, 0xac, 0x73, 0x36, 0xf1, 0x3c, 0x62,
	0x1f, 0xe2, 0x08, 0xf3, 0x73, 0x2c, 0xea, 0xf3, 0xc8, 0x21, 0x58, 0xac, 0x19, 0xf1, 0x12, 0x7d,
	0x03, 0x45, 0x2b, 0xb4, 0x9e, 0xee, 0x59, 0x2a, 0x5f, 0xdc, 0x5b, 0xd0, 0xd3, 0xd9, 0x91, 0x1f,
	0x3d, 0xdd, 0x53, 0x51, 0x5f, 0xe2, 0x36, 0x06, 0xb0, 0x21, 0x83, 0x64, 0x7c, 0x10, 0x4b, 0x31,
	0xca, 0x5c, 0x9f, 0x11, 0xba, 0x0b, 0x65, 0xcf, 0xde, 0x37, 0xc7, 0x98, 0x8d, 0xd5, 0x45, 0x4a,
	0x9e, 0xbd, 0xff, 0x1a, 0xb3, 0x71, 0xe3, 0xaf, 0x79, 0xa8, 0xb6, 0xa9, 0xe7, 0x51, 0xbf, 0xe3,
	0x4f, 0x3c, 0xd6, 0xf8, 0x0e, 0x40, 0x79, 0x0e, 0x7f, 0x27, 0x1d, 0xee, 0xf4, 0x8c, 0x93, 0x9f,
	0x77, 0xda, 0xfd, 0xa3, 0x93, 0x63, 0xf3, 0xec, 0xf8, 0xb4, 0xd7, 0x69, 0x1f, 0xbd, 0x3a, 0xea,
	0x1c, 0xd6, 0x7f, 0x80, 0x00, 0x8a, 0xc7, 0x27, 0x66, 0xab, 0xdd, 0xad, 0x67, 0x50, 0x19, 0xf2,
	0xaf, 0xce, 0xba, 0xdd, 0x7a, 0xb6, 0xf1, 0xcf, 0x0c, 0x6c, 0xf5, 0x42, 0x62, 0x93, 0xa1, 0xe3,
	0x13, 0x3b, 0x76, 0x12, 0x17, 0x3d, 0x84, 0x07, 0x3d, 0xa3, 0x73, 0xd8, 0x79, 0x75, 0x74, 0xdc,
	0x39, 0x34, 0x0f, 0xce, 0xda, 0x6f, 0x3a, 0x7d, 0x4e, 0x7c, 0x89, 0xe9, 0x03, 0xf8, 0x2c, 0xb5,
	0xd7, 0x3a, 0xeb, 0xbf, 0xee, 0x1c, 0xf7, 0x8f, 0xda, 0xad, 0x7e, 0xe7, 0xd0, 0x34, 0x3a, 0xad,
	0xc3, 0x7a, 0x06, 0xdd, 0x01, 0x94, 0x42, 0xe9, 0x19, 0x47, 0x6f, 0x5b, 0xfd, 0x4e, 0x3d, 0x8b,
	0xee, 0x83, 0x3e, 0x07, 0x17, 0x62, 0x27, 0xfb, 0x39, 0x7e, 0x97, 0xf4, 0xfe, 0xd9, 0x41, 0xf7,
	0xa8, 0x2d, 0x79, 0xe6, 0xd1, 0x36, 0xdc, 0x5b, 0xbe, 0x67, 0xbe, 0x33, 0x8e, 0xfa, 0x9d, 0x7a,
	0xa1, 0xf1, 0x9f, 0xb9, 0x7b, 0xcd, 0x9a, 0xca, 0xf9, 0x7b, 0x9d, 0x1c, 0x88, 0x43, 0x97, 0xde,
	0x2b, 0xb5, 0xb7, 0xf4, 0x5e, 0x3b, 0xf0, 0x65, 0x0a, 0x45, 0x89, 0x73, 0xf2, 0xee, 0xb8, 0x63,
	0x98, 0x5c, 0xb7, 0x66, 0xfb, 0xe4, 0xb8, 0x6f, 0x9c, 0x74, 0xeb, 0x59, 0x2e, 0xed, 0x2a, 0x4c,
	0xc1, 0x2b, 0xc7, 0x75, 0x94, 0xc2, 0x88, 0x75, 0x90, 0xe7, 0x3a, 0x9a, 0x83, 0xcf, 0xeb, 0xa8,
	0xc0, 0x75, 0x94, 0xde, 0x4f, 0xe9, 0xa8, 0xd8, 0x30, 0x61, 0xad, 0x2d, 0xcd, 0xd9, 0xc0, 0xfe,
	0x88, 0x70, 0xd7, 0x60, 0x11, 0x0e, 0xa5, 0xad, 0xe7, 0x0c, 0xb9, 0xe0, 0x2e, 0x44, 0x7c, 0x19,
	0x67, 0x72, 0x06, 0xff, 0xe4, 0x95, 0x85, 0x45, 0xbd, 0xc0, 0x25, 0x11, 0x31, 0x5d, 0xe2, 0x8f,
	0xa2, 0xb1, 0xca, 0xb2, 0xb5, 0x18, 0xdc, 0x15, 0xd0, 0xc6, 0xbf, 0xb2, 0xb0, 0x76, 0x4c, 0x23,
	0x67, 0xe8, 0xa8, 0x5e, 0x53, 0xc4, 0x9d, 0xc0, 0xb1, 0x94, 0x43, 0xca, 0x05, 0x8f, 0x68, 0xb2,
	0x15, 0xe4, 0x51, 0x83, 0xa9, 0x1a, 0x1c, 0x04, 0xa8, 0xcf, 0x21, 0x68, 0x00, 0x9b, 0xd6, 0x84,
	0x45, 0xd4, 0x33, 0x71, 0x14, 0x85, 0xce, 0x60, 0x12, 0x11, 0x26, 0x2a, 0xf1, 0xea, 0xde, 0xfe,
	0x92, 0xc8, 0x91, 0x3e, 0xb2, 0xd9, 0x16, 0x84, 0xad, 0x84, 0x4e, 0x06, 0x92, 0xba, 0x75, 0x09,
	0x9c, 0xa4, 0xc9, 0x7c, 0x2a, 0x4d, 0x3e, 0x06, 0xa4, 0x6a, 0x1d, 0x5e, 0x97, 0xc7, 0x05, 0x8f,
	0xec, 0xf6, 0xeb, 0x72, 0x87, 0xd7, 0xe5, 0xb2, 0xe2, 0x11, 0x7d, 0xbe, 0x8c, 0x42, 0xe6, 0x90,
	0x86, 0x1e, 0x8e, 0x54, 0x30, 0x5c, 0x57, 0xd0, 0x57, 0x02, 0xa8, 0xe2, 0x79, 0x29, 0x8e, 0xe7,
	0x7a, 0x1b, 0x6e, 0x2f, 0x95, 0xf1, 0x46, 0xb1, 0xcb, 0x80, 0xbb, 0x3c, 0x41, 0xa5, 0x6f, 0x3e,
	0x4b, 0x53, 0xfb, 0xf3, 0x69, 0xea, 0xf3, 0x2b, 0x54, 0x16, 0x27, 0xbd, 0xbf, 0x57, 0xa1, 0x28,
	0xdd, 0x82, 0x17, 0x56, 0x2a, 0xf0, 0x99, 0xc4, 0xb7, 0xa8, 0xcd, 0xfb, 0x41, 0x29, 0xd7, 0x86,
	0x82, 0x77, 0x14, 0x18, 0xed, 0xc2, 0x56, 0x8c, 0x6a, 0x3b, 0x2c, 0xa0, 0x6c, 0xd6, 0x0f, 0x54,
	0x0c, 0xa4, 0xb6, 0x0e, 0x67, 0x3b, 0xbc, 0x8c, 0xb7, 0xb0, 0x35, 0x26, 0xa6, 0x25, 0x73, 0xae,
	0xca, 0x57, 0x6b, 0x02, 0x18, 0x17, 0x36, 0x6a, 0xf2, 0x94, 0xbf, 0xd1, 0xc0, 0x48, 0x4c, 0x9e,
	0x52, 0xa2, 0xbb, 0xd8, 0x1f, 0x4d, 0x78, 0x35, 0x56, 0x98, 0x13, 0xbd, 0xab, 0xc0, 0x4b, 0x26,
	0x30, 0xc5, 0xa5, 0x13, 0x98, 0x78, 0x66, 0x64, 0x13, 0x6e, 0xeb, 0xf2, 0x2d, 0xaf, 0x31, 0x33,
	0x3a, 0x94, 0xe8, 0x3c, 0x3f, 0xc7, 0x12, 0x89, 0x94, 0x29, 0xcb, 0xa4, 0xaa, 0x82, 0x71, 0x8b,
	0xe7, 0xc6, 0xc8, 0x9c, 0xdf, 0x13, 0x91, 0xdc, 0x72, 0x86, 0xf8, 0x5e, 0x98, 0x54, 0xc1, 0xcd,
	0x26, 0x55, 0xb3, 0x3c, 0x53, 0xbd, 0x41, 0x9e, 0x51, 0xae, 0x4e, 0x7d, 0x2e, 0xad, 0x45, 0x27,
	0x7e, 0x24, 0x46, 0x40, 0x05, 0xe9, 0xea, 0x02, 0xdc, 0xe6, 0xd0, 0xb9, 0x84, 0xb4, 0x3e, 0x97,
	0x90, 0x12, 0xcf, 0xaa, 0x2d, 0x9f, 0x1d, 0x6d, 0x5c, 0x7f, 0x76, 0xb4, 0xd0, 0xf1, 0xd5, 0x97,
	0x8c, 0xaa, 0xb6, 0x61, 0x6d, 0xae, 0x9b, 0xde, 0x94, 0x05, 0xd2, 0x79, 0xd2, 0x46, 0xa3, 0x77,
	0xa0, 0x0b, 0x4d, 0xce, 0xf1, 0x32, 0x63, 0x79, 0xd0, 0x95, 0xf2, 0x7c, 0xc2, 0xa9, 0xd3, 0xbd,
	0xd6, 0x99, 0x92, 0xef, 0x21, 0xd4, 0x22, 0xe2, 0x05, 0x34, 0xc4, 0xe1, 0x54, 0x4e, 0xb4, 0xb6,
	0xe4, 0x3c, 0x22, 0x81, 0x8a, 0x49, 0xd6, 0x5b, 0xb8, 0x3b, 0x6b, 0x53, 0x66, 0x35, 0x94, 0xec,
	0x88, 0x6e, 0x5d, 0x7d, 0x7c, 0x42, 0xdc, 0x49, 0x68, 0x45, 0x6f, 0xd4, 0x86, 0x32, 0xb7, 0x54,
	0x1b, 0x47, 0x58, 0xbb, 0x2d, 0x3c, 0xe5, 0xab, 0x95, 0x9e, 0xd2, 0xfc, 0x85, 0xc2, 0x94, 0xf1,
	0x30, 0x21, 0x44, 0x87, 0x50, 0x5f, 0x98, 0xcb, 0x7d, 0x76, 0x65, 0x5b, 0x5b, 0x23, 0xf3, 0xc3,
	0xba, 0x78, 0x0e, 0xfa, 0x49, 0x6a, 0x0e, 0x2a, 0x03, 0x9f, 0xb6, 0xa4, 0xe9, 0xb8, 0x3b, 0xd7,
	0x74, 0xdc, 0x07, 0x48, 0xb9, 0xa0, 0x2e, 0x5c, 0x20, 0x05, 0x99, 0x4d, 0xc2, 0x3e, 0xbd, 0xde,
	0x24, 0xec, 0xd7, 0xb0, 0x25, 0xa3, 0x3d, 0x09, 0xcd, 0xd4, 0x48, 0xec, 0x9e, 0xa0, 0x7e, 0xbc,
	0x5a, 0x43, 0x6d, 0x45, 0x94, 0x1a, 0x8d, 0x21, 0x6b, 0x01, 0xa6, 0x0f, 0x01, 0x2d, 0x62, 0xa2,
	0x27, 0x70, 0x6b, 0x76, 0x96, 0x89, 0xdd, 0x11, 0x0d, 0x9d, 0x68, 0xec, 0xa9, 0xa8, 0xb9, 0x35,
	0xdb, 0x6b, 0xc5, 0x5b, 0xbc, 0xf9, 0xe6, 0x46, 0xcb, 0xc6, 0x78, 0x6f, 0xff, 0xc7, 0x2a, 0x60,
	0x56, 0xce, 0xc9, 0xf4, 0x54, 0x00, 0xf4, 0xe7, 0xb0, 0x3e, 0xf7, 0x66, 0x37, 0xca, 0x0f, 0x7f,
	0xcb, 0xc2, 0xd6, 0x92, 0x10, 0xf9, 0xff, 0x68, 0x18, 0x65, 0x5e, 0x54, 0x31, 0x56, 0xad, 0x2e,
	0xbd, 0x69, 0x71, 0xe1, 0x4d, 0x67, 0x8d, 0x66, 0x69, 0x75, 0xa3, 0x59, 0x5e, 0xd5, 0x68, 0x56,
	0x96, 0x37, 0x9a, 0xf0, 0xd1, 0x46, 0xb3, 0xfa, 0x3f, 0x37, 0x9a, 0x4b, 0x14, 0x79, 0xa3, 0x46,
	0x73, 0x59, 0xae, 0x52, 0x39, 0xf7, 0x0f, 0x19, 0xd9, 0x69, 0x4a, 0x94, 0x19, 0x57, 0x1d, 0xca,
	0xb2, 0xfa, 0x20, 0x4c, 0xcd, 0x2e, 0x93, 0xf5, 0xac, 0x0b, 0xcd, 0xae, 0xec, 0x42, 0x25, 0xbb,
	0x8f, 0x74, 0xa1, 0xb9, 0x65, 0x5d, 0xe8, 0x6b, 0xa8, 0xa6, 0x54, 0xb1, 0xe4, 0x3f, 0x46, 0x46,
	0xd5, 0x37, 0x73, 0xff, 0x31, 0x78, 0x27, 0xc8, 0xf5, 0xab, 0xcc, 0x87, 0x7f, 0x37, 0xf6, 0xa1,
	0x76, 0x4a, 0xc2, 0x0b, 0xc7, 0x22, 0x2d, 0x4b, 0x64, 0x11, 0x1e, 0xca, 0xc5, 0x73, 0x99, 0x71,
	0x87, 0x28, 0x79, 0xad, 0x09, 0x60, 0x4b, 0xc2, 0x1a, 0x2f, 0xa0, 0x20, 0x3c, 0x39, 0x65, 0x1e,
	0x99, 0xd5, 0xe6, 0x91, 0x9d, 0x37, 0x8f, 0x83, 0x0b, 0xb8, 0x67, 0x51, 0x2f, 0xd6, 0xc6, 0x82,
	0x52, 0x0e, 0xf4, 0xb6, 0x4b, 0x27, 0xb6, 0x8a, 0xe3, 0x46, 0xfc, 0x27, 0xad, 0xc7, 0x83, 0x5b,
	0x2f, 0xf3, 0xab, 0x67, 0x09, 0x1d, 0x2f, 0x1b, 0x9a, 0x34, 0x1c, 0xed, 0x8e, 0x88, 0x2f, 0x42,
	0xdf, 0xae, 0xdc, 0xc2, 0x81, 0xc3, 0x52, 0x3f, 0xe5, 0x9e, 0xab, 0xcf, 0x41, 0x51, 0x20, 0x3d,
	0xfd, 0x6f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x43, 0x62, 0xd1, 0xd7, 0xb8, 0x1b, 0x00, 0x00,
}
