//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsecuritydevops

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewAzureDevOpsConnectorClient creates a new instance of AzureDevOpsConnectorClient.
func (c *ClientFactory) NewAzureDevOpsConnectorClient() *AzureDevOpsConnectorClient {
	subClient, _ := NewAzureDevOpsConnectorClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewAzureDevOpsConnectorStatsClient creates a new instance of AzureDevOpsConnectorStatsClient.
func (c *ClientFactory) NewAzureDevOpsConnectorStatsClient() *AzureDevOpsConnectorStatsClient {
	subClient, _ := NewAzureDevOpsConnectorStatsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewAzureDevOpsOrgClient creates a new instance of AzureDevOpsOrgClient.
func (c *ClientFactory) NewAzureDevOpsOrgClient() *AzureDevOpsOrgClient {
	subClient, _ := NewAzureDevOpsOrgClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewAzureDevOpsProjectClient creates a new instance of AzureDevOpsProjectClient.
func (c *ClientFactory) NewAzureDevOpsProjectClient() *AzureDevOpsProjectClient {
	subClient, _ := NewAzureDevOpsProjectClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewAzureDevOpsRepoClient creates a new instance of AzureDevOpsRepoClient.
func (c *ClientFactory) NewAzureDevOpsRepoClient() *AzureDevOpsRepoClient {
	subClient, _ := NewAzureDevOpsRepoClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewGitHubConnectorClient creates a new instance of GitHubConnectorClient.
func (c *ClientFactory) NewGitHubConnectorClient() *GitHubConnectorClient {
	subClient, _ := NewGitHubConnectorClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewGitHubConnectorStatsClient creates a new instance of GitHubConnectorStatsClient.
func (c *ClientFactory) NewGitHubConnectorStatsClient() *GitHubConnectorStatsClient {
	subClient, _ := NewGitHubConnectorStatsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewGitHubOwnerClient creates a new instance of GitHubOwnerClient.
func (c *ClientFactory) NewGitHubOwnerClient() *GitHubOwnerClient {
	subClient, _ := NewGitHubOwnerClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewGitHubRepoClient creates a new instance of GitHubRepoClient.
func (c *ClientFactory) NewGitHubRepoClient() *GitHubRepoClient {
	subClient, _ := NewGitHubRepoClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}
