//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdesktopvirtualization

import "time"

// AgentUpdatePatchProperties - The session host configuration for updating agent, monitoring agent, and stack component.
type AgentUpdatePatchProperties struct {
	// Time zone for maintenance as defined in https://docs.microsoft.com/en-us/dotnet/api/system.timezoneinfo.findsystemtimezonebyid?view=net-5.0.
	// Must be set if useLocalTime is true.
	MaintenanceWindowTimeZone *string

	// List of maintenance windows. Maintenance windows are 2 hours long.
	MaintenanceWindows []*MaintenanceWindowPatchProperties

	// The type of maintenance for session host components.
	Type *SessionHostComponentUpdateType

	// Whether to use localTime of the virtual machine.
	UseSessionHostLocalTime *bool
}

// AgentUpdateProperties - The session host configuration for updating agent, monitoring agent, and stack component.
type AgentUpdateProperties struct {
	// Time zone for maintenance as defined in https://docs.microsoft.com/en-us/dotnet/api/system.timezoneinfo.findsystemtimezonebyid?view=net-5.0.
	// Must be set if useLocalTime is true.
	MaintenanceWindowTimeZone *string

	// List of maintenance windows. Maintenance windows are 2 hours long.
	MaintenanceWindows []*MaintenanceWindowProperties

	// The type of maintenance for session host components.
	Type *SessionHostComponentUpdateType

	// Whether to use localTime of the virtual machine.
	UseSessionHostLocalTime *bool
}

// Application - Schema for Application properties.
type Application struct {
	// REQUIRED; Detailed properties for Application
	Properties *ApplicationProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ApplicationGroup - Represents a ApplicationGroup definition.
type ApplicationGroup struct {
	// REQUIRED; Detailed properties for ApplicationGroup
	Properties *ApplicationGroupProperties
	Identity   *ResourceModelWithAllowedPropertySetIdentity

	// Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are
	// a kind of Microsoft.Web/sites type. If supported, the resource provider must
	// validate and persist this value.
	Kind *string

	// The geo-location where the resource lives
	Location *string

	// The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another
	// Azure resource. If this is present, complete mode deployment will not
	// delete the resource if it is removed from the template since it is managed by another resource.
	ManagedBy *string
	Plan      *ResourceModelWithAllowedPropertySetPlan
	SKU       *ResourceModelWithAllowedPropertySetSKU

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; The etag field is not required. If it is provided in the response body, it must also be provided as a header
	// per the normal etag convention. Entity tags are used for comparing two or more entities
	// from the same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match
	// (section 14.26), and If-Range (section 14.27) header fields.
	Etag *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ApplicationGroupList - List of ApplicationGroup definitions.
type ApplicationGroupList struct {
	// List of ApplicationGroup definitions.
	Value []*ApplicationGroup

	// READ-ONLY; Link to the next page of results.
	NextLink *string
}

// ApplicationGroupPatch - ApplicationGroup properties that can be patched.
type ApplicationGroupPatch struct {
	// ApplicationGroup properties that can be patched.
	Properties *ApplicationGroupPatchProperties

	// tags to be updated
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ApplicationGroupPatchProperties - ApplicationGroup properties that can be patched.
type ApplicationGroupPatchProperties struct {
	// Description of ApplicationGroup.
	Description *string

	// Friendly name of ApplicationGroup.
	FriendlyName *string

	// Boolean representing whether the applicationGroup is show in the feed.
	ShowInFeed *bool
}

// ApplicationGroupProperties - Schema for ApplicationGroup properties.
type ApplicationGroupProperties struct {
	// REQUIRED; Resource Type of ApplicationGroup.
	ApplicationGroupType *ApplicationGroupType

	// REQUIRED; HostPool arm path of ApplicationGroup.
	HostPoolArmPath *string

	// Description of ApplicationGroup.
	Description *string

	// Friendly name of ApplicationGroup.
	FriendlyName *string

	// Boolean representing whether the applicationGroup is show in the feed.
	ShowInFeed *bool

	// READ-ONLY; Is cloud pc resource.
	CloudPcResource *bool

	// READ-ONLY; ObjectId of ApplicationGroup. (internal use)
	ObjectID *string

	// READ-ONLY; Workspace arm path of ApplicationGroup.
	WorkspaceArmPath *string
}

// ApplicationList - List of Application definitions.
type ApplicationList struct {
	// List of Application definitions.
	Value []*Application

	// READ-ONLY; Link to the next page of results.
	NextLink *string
}

// ApplicationPatch - Application properties that can be patched.
type ApplicationPatch struct {
	// Detailed properties for Application
	Properties *ApplicationPatchProperties

	// tags to be updated
	Tags map[string]*string
}

// ApplicationPatchProperties - Application properties that can be patched.
type ApplicationPatchProperties struct {
	// Resource Type of Application.
	ApplicationType *RemoteApplicationType

	// Command Line Arguments for Application.
	CommandLineArguments *string

	// Specifies whether this published application can be launched with command line arguments provided by the client, command
	// line arguments specified at publish time, or no command line arguments at all.
	CommandLineSetting *CommandLineSetting

	// Description of Application.
	Description *string

	// Specifies a path for the executable file for the application.
	FilePath *string

	// Friendly name of Application.
	FriendlyName *string

	// Index of the icon.
	IconIndex *int32

	// Path to icon.
	IconPath *string

	// Specifies the package application Id for MSIX applications
	MsixPackageApplicationID *string

	// Specifies the package family name for MSIX applications
	MsixPackageFamilyName *string

	// Specifies whether to show the RemoteApp program in the RD Web Access server.
	ShowInPortal *bool
}

// ApplicationProperties - Schema for Application properties.
type ApplicationProperties struct {
	// REQUIRED; Specifies whether this published application can be launched with command line arguments provided by the client,
	// command line arguments specified at publish time, or no command line arguments at all.
	CommandLineSetting *CommandLineSetting

	// Resource Type of Application.
	ApplicationType *RemoteApplicationType

	// Command Line Arguments for Application.
	CommandLineArguments *string

	// Description of Application.
	Description *string

	// Specifies a path for the executable file for the application.
	FilePath *string

	// Friendly name of Application.
	FriendlyName *string

	// Index of the icon.
	IconIndex *int32

	// Path to icon.
	IconPath *string

	// Specifies the package application Id for MSIX applications
	MsixPackageApplicationID *string

	// Specifies the package family name for MSIX applications
	MsixPackageFamilyName *string

	// Specifies whether to show the RemoteApp program in the RD Web Access server.
	ShowInPortal *bool

	// READ-ONLY; the icon a 64 bit string as a byte array.
	IconContent []byte

	// READ-ONLY; Hash of the icon.
	IconHash *string

	// READ-ONLY; ObjectId of Application. (internal use)
	ObjectID *string
}

// Desktop - Schema for Desktop properties.
type Desktop struct {
	// Detailed properties for Desktop
	Properties *DesktopProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// DesktopList - List of Desktop definitions.
type DesktopList struct {
	// List of Desktop definitions.
	Value []*Desktop

	// READ-ONLY; Link to the next page of results.
	NextLink *string
}

// DesktopPatch - Desktop properties that can be patched.
type DesktopPatch struct {
	// Detailed properties for Desktop
	Properties *DesktopPatchProperties

	// tags to be updated
	Tags map[string]*string
}

// DesktopPatchProperties - Desktop properties that can be patched.
type DesktopPatchProperties struct {
	// Description of Desktop.
	Description *string

	// Friendly name of Desktop.
	FriendlyName *string
}

// DesktopProperties - Schema for Desktop properties.
type DesktopProperties struct {
	// Description of Desktop.
	Description *string

	// Friendly name of Desktop.
	FriendlyName *string

	// READ-ONLY; The icon a 64 bit string as a byte array.
	IconContent []byte

	// READ-ONLY; Hash of the icon.
	IconHash *string

	// READ-ONLY; ObjectId of Desktop. (internal use)
	ObjectID *string
}

// ExpandMsixImage - Represents the definition of contents retrieved after expanding the MSIX Image.
type ExpandMsixImage struct {
	// Detailed properties for ExpandMsixImage
	Properties *ExpandMsixImageProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ExpandMsixImageList - List of MSIX package properties retrieved from MSIX Image expansion.
type ExpandMsixImageList struct {
	// List of MSIX package properties from give MSIX Image.
	Value []*ExpandMsixImage

	// READ-ONLY; Link to the next page of results.
	NextLink *string
}

// ExpandMsixImageProperties - Schema for Expand MSIX Image properties.
type ExpandMsixImageProperties struct {
	// User friendly Name to be displayed in the portal.
	DisplayName *string

	// VHD/CIM image path on Network Share.
	ImagePath *string

	// Make this version of the package the active one across the hostpool.
	IsActive *bool

	// Specifies how to register Package in feed.
	IsRegularRegistration *bool

	// Date Package was last updated, found in the appxmanifest.xml.
	LastUpdated *time.Time

	// Alias of MSIX Package.
	PackageAlias *string

	// List of package applications.
	PackageApplications []*MsixPackageApplications

	// List of package dependencies.
	PackageDependencies []*MsixPackageDependencies

	// Package Family Name from appxmanifest.xml. Contains Package Name and Publisher name.
	PackageFamilyName *string

	// Package Full Name from appxmanifest.xml.
	PackageFullName *string

	// Package Name from appxmanifest.xml.
	PackageName *string

	// Relative Path to the package inside the image.
	PackageRelativePath *string

	// Package Version found in the appxmanifest.xml.
	Version *string
}

// HostPool - Represents a HostPool definition.
type HostPool struct {
	// REQUIRED; Detailed properties for HostPool
	Properties *HostPoolProperties
	Identity   *ResourceModelWithAllowedPropertySetIdentity

	// Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are
	// a kind of Microsoft.Web/sites type. If supported, the resource provider must
	// validate and persist this value.
	Kind *string

	// The geo-location where the resource lives
	Location *string

	// The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another
	// Azure resource. If this is present, complete mode deployment will not
	// delete the resource if it is removed from the template since it is managed by another resource.
	ManagedBy *string
	Plan      *ResourceModelWithAllowedPropertySetPlan
	SKU       *ResourceModelWithAllowedPropertySetSKU

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; The etag field is not required. If it is provided in the response body, it must also be provided as a header
	// per the normal etag convention. Entity tags are used for comparing two or more entities
	// from the same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match
	// (section 14.26), and If-Range (section 14.27) header fields.
	Etag *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// HostPoolList - List of HostPool definitions.
type HostPoolList struct {
	// List of HostPool definitions.
	Value []*HostPool

	// READ-ONLY; Link to the next page of results.
	NextLink *string
}

// HostPoolPatch - HostPool properties that can be patched.
type HostPoolPatch struct {
	// HostPool properties that can be patched.
	Properties *HostPoolPatchProperties

	// tags to be updated
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// HostPoolPatchProperties - Properties of HostPool.
type HostPoolPatchProperties struct {
	// The session host configuration for updating agent, monitoring agent, and stack component.
	AgentUpdate *AgentUpdatePatchProperties

	// Custom rdp property of HostPool.
	CustomRdpProperty *string

	// Description of HostPool.
	Description *string

	// Friendly name of HostPool.
	FriendlyName *string

	// The type of the load balancer.
	LoadBalancerType *LoadBalancerType

	// The max session limit of HostPool.
	MaxSessionLimit *int32

	// PersonalDesktopAssignment type for HostPool.
	PersonalDesktopAssignmentType *PersonalDesktopAssignmentType

	// The type of preferred application group type, default to Desktop Application Group
	PreferredAppGroupType *PreferredAppGroupType

	// Enabled to allow this resource to be access from the public network
	PublicNetworkAccess *HostpoolPublicNetworkAccess

	// The registration info of HostPool.
	RegistrationInfo *RegistrationInfoPatch

	// The ring number of HostPool.
	Ring *int32

	// ClientId for the registered Relying Party used to issue WVD SSO certificates.
	SsoClientID *string

	// Path to Azure KeyVault storing the secret used for communication to ADFS.
	SsoClientSecretKeyVaultPath *string

	// The type of single sign on Secret Type.
	SsoSecretType *SSOSecretType

	// URL to customer ADFS server for signing WVD SSO certificates.
	SsoadfsAuthority *string

	// The flag to turn on/off StartVMOnConnect feature.
	StartVMOnConnect *bool

	// VM template for sessionhosts configuration within hostpool.
	VMTemplate *string

	// Is validation environment.
	ValidationEnvironment *bool
}

// HostPoolProperties - Properties of HostPool.
type HostPoolProperties struct {
	// REQUIRED; HostPool type for desktop.
	HostPoolType *HostPoolType

	// REQUIRED; The type of the load balancer.
	LoadBalancerType *LoadBalancerType

	// REQUIRED; The type of preferred application group type, default to Desktop Application Group
	PreferredAppGroupType *PreferredAppGroupType

	// The session host configuration for updating agent, monitoring agent, and stack component.
	AgentUpdate *AgentUpdateProperties

	// Custom rdp property of HostPool.
	CustomRdpProperty *string

	// Description of HostPool.
	Description *string

	// Friendly name of HostPool.
	FriendlyName *string

	// The max session limit of HostPool.
	MaxSessionLimit *int32

	// PersonalDesktopAssignment type for HostPool.
	PersonalDesktopAssignmentType *PersonalDesktopAssignmentType

	// Enabled allows this resource to be accessed from both public and private networks, Disabled allows this resource to only
	// be accessed via private endpoints
	PublicNetworkAccess *HostpoolPublicNetworkAccess

	// The registration info of HostPool.
	RegistrationInfo *RegistrationInfo

	// The ring number of HostPool.
	Ring *int32

	// ClientId for the registered Relying Party used to issue WVD SSO certificates.
	SsoClientID *string

	// Path to Azure KeyVault storing the secret used for communication to ADFS.
	SsoClientSecretKeyVaultPath *string

	// The type of single sign on Secret Type.
	SsoSecretType *SSOSecretType

	// URL to customer ADFS server for signing WVD SSO certificates.
	SsoadfsAuthority *string

	// The flag to turn on/off StartVMOnConnect feature.
	StartVMOnConnect *bool

	// VM template for sessionhosts configuration within hostpool.
	VMTemplate *string

	// Is validation environment.
	ValidationEnvironment *bool

	// READ-ONLY; List of applicationGroup links.
	ApplicationGroupReferences []*string

	// READ-ONLY; Is cloud pc resource.
	CloudPcResource *bool

	// READ-ONLY; ObjectId of HostPool. (internal use)
	ObjectID *string

	// READ-ONLY; List of private endpoint connection associated with the specified resource
	PrivateEndpointConnections []*PrivateEndpointConnection
}

// LogSpecification - Specifications of the Log for Azure Monitoring
type LogSpecification struct {
	// Blob duration of the log
	BlobDuration *string

	// Localized friendly display name of the log
	DisplayName *string

	// Name of the log
	Name *string
}

// MSIXImageURI - Represents URI referring to MSIX Image
type MSIXImageURI struct {
	// URI to Image
	URI *string
}

// MSIXPackage - Schema for MSIX Package properties.
type MSIXPackage struct {
	// REQUIRED; Detailed properties for MSIX Package
	Properties *MSIXPackageProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// MSIXPackageList - List of MSIX Package definitions.
type MSIXPackageList struct {
	// List of MSIX Package definitions.
	Value []*MSIXPackage

	// READ-ONLY; Link to the next page of results.
	NextLink *string
}

// MSIXPackagePatch - MSIX Package properties that can be patched.
type MSIXPackagePatch struct {
	// Detailed properties for MSIX Package
	Properties *MSIXPackagePatchProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// MSIXPackagePatchProperties - MSIX Package properties that can be patched.
type MSIXPackagePatchProperties struct {
	// Display name for MSIX Package.
	DisplayName *string

	// Set a version of the package to be active across hostpool.
	IsActive *bool

	// Set Registration mode. Regular or Delayed.
	IsRegularRegistration *bool
}

// MSIXPackageProperties - Schema for MSIX Package properties.
type MSIXPackageProperties struct {
	// User friendly Name to be displayed in the portal.
	DisplayName *string

	// VHD/CIM image path on Network Share.
	ImagePath *string

	// Make this version of the package the active one across the hostpool.
	IsActive *bool

	// Specifies how to register Package in feed.
	IsRegularRegistration *bool

	// Date Package was last updated, found in the appxmanifest.xml.
	LastUpdated *time.Time

	// List of package applications.
	PackageApplications []*MsixPackageApplications

	// List of package dependencies.
	PackageDependencies []*MsixPackageDependencies

	// Package Family Name from appxmanifest.xml. Contains Package Name and Publisher name.
	PackageFamilyName *string

	// Package Name from appxmanifest.xml.
	PackageName *string

	// Relative Path to the package inside the image.
	PackageRelativePath *string

	// Package Version found in the appxmanifest.xml.
	Version *string
}

// MaintenanceWindowPatchProperties - Maintenance window starting hour and day of week.
type MaintenanceWindowPatchProperties struct {
	// Day of the week.
	DayOfWeek *DayOfWeek

	// The update start hour of the day. (0 - 23)
	Hour *int32
}

// MaintenanceWindowProperties - Maintenance window starting hour and day of week.
type MaintenanceWindowProperties struct {
	// Day of the week.
	DayOfWeek *DayOfWeek

	// The update start hour of the day. (0 - 23)
	Hour *int32
}

// MsixPackageApplications - Schema for MSIX Package Application properties.
type MsixPackageApplications struct {
	// Package Application Id, found in appxmanifest.xml.
	AppID *string

	// Used to activate Package Application. Consists of Package Name and ApplicationID. Found in appxmanifest.xml.
	AppUserModelID *string

	// Description of Package Application.
	Description *string

	// User friendly name.
	FriendlyName *string

	// User friendly name.
	IconImageName *string

	// the icon a 64 bit string as a byte array.
	RawIcon []byte

	// the icon a 64 bit string as a byte array.
	RawPNG []byte
}

// MsixPackageDependencies - Schema for MSIX Package Dependencies properties.
type MsixPackageDependencies struct {
	// Name of package dependency.
	DependencyName *string

	// Dependency version required.
	MinVersion *string

	// Name of dependency publisher.
	Publisher *string
}

// OperationProperties - Properties of the operation
type OperationProperties struct {
	// Service specification payload
	ServiceSpecification *ServiceSpecification
}

// PrivateEndpoint - The Private Endpoint resource.
type PrivateEndpoint struct {
	// READ-ONLY; The ARM identifier for Private Endpoint
	ID *string
}

// PrivateEndpointConnection - The Private Endpoint Connection resource.
type PrivateEndpointConnection struct {
	// Resource properties.
	Properties *PrivateEndpointConnectionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrivateEndpointConnectionListResultWithSystemData - List of private endpoint connection associated with the specified storage
// account
type PrivateEndpointConnectionListResultWithSystemData struct {
	// Array of private endpoint connections
	Value []*PrivateEndpointConnectionWithSystemData

	// READ-ONLY; Link to the next page of results.
	NextLink *string
}

// PrivateEndpointConnectionProperties - Properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// REQUIRED; A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState

	// The resource of private end point.
	PrivateEndpoint *PrivateEndpoint

	// READ-ONLY; The provisioning state of the private endpoint connection resource.
	ProvisioningState *PrivateEndpointConnectionProvisioningState
}

// PrivateEndpointConnectionWithSystemData - The Private Endpoint Connection resource.
type PrivateEndpointConnectionWithSystemData struct {
	// Resource properties.
	Properties *PrivateEndpointConnectionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// Resource properties.
	Properties *PrivateLinkResourceProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// Array of private link resources
	Value []*PrivateLinkResource

	// READ-ONLY; Link to the next page of results.
	NextLink *string
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// The private link resource Private link DNS zone name.
	RequiredZoneNames []*string

	// READ-ONLY; The private link resource group id.
	GroupID *string

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string
}

// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer
// and provider.
type PrivateLinkServiceConnectionState struct {
	// A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string

	// The reason for approval/rejection of the connection.
	Description *string

	// Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
	Status *PrivateEndpointServiceConnectionStatus
}

// RegistrationInfo - Represents a RegistrationInfo definition.
type RegistrationInfo struct {
	// Expiration time of registration token.
	ExpirationTime *time.Time

	// The type of resetting the token.
	RegistrationTokenOperation *RegistrationTokenOperation

	// The registration token base64 encoded string.
	Token *string
}

// RegistrationInfoPatch - Represents a RegistrationInfo definition.
type RegistrationInfoPatch struct {
	// Expiration time of registration token.
	ExpirationTime *time.Time

	// The type of resetting the token.
	RegistrationTokenOperation *RegistrationTokenOperation
}

type ResourceModelWithAllowedPropertySetIdentity struct {
	// The identity type.
	Type *string

	// READ-ONLY; The principal ID of resource identity.
	PrincipalID *string

	// READ-ONLY; The tenant ID of resource.
	TenantID *string
}

type ResourceModelWithAllowedPropertySetPlan struct {
	// REQUIRED; A user defined name of the 3rd Party Artifact that is being procured.
	Name *string

	// REQUIRED; The 3rd Party artifact that is being procured. E.g. NewRelic. Product maps to the OfferID specified for the artifact
	// at the time of Data Market onboarding.
	Product *string

	// REQUIRED; The publisher of the 3rd Party Artifact that is being bought. E.g. NewRelic
	Publisher *string

	// A publisher provided promotion code as provisioned in Data Market for the said product/artifact.
	PromotionCode *string

	// The version of the desired product/artifact.
	Version *string
}

type ResourceModelWithAllowedPropertySetSKU struct {
	// REQUIRED; The name of the SKU. Ex - P3. It is typically a letter+number code
	Name *string

	// If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the
	// resource this may be omitted.
	Capacity *int32

	// If the service has different generations of hardware, for the same SKU, then that can be captured here.
	Family *string

	// The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
	Size *string

	// This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required
	// on a PUT.
	Tier *SKUTier
}

// ResourceProviderOperation - Supported operation of this resource provider.
type ResourceProviderOperation struct {
	// Display metadata associated with the operation.
	Display *ResourceProviderOperationDisplay

	// Is a data action.
	IsDataAction *bool

	// Operation name, in format of {provider}/{resource}/{operation}
	Name *string

	// Properties of the operation
	Properties *OperationProperties
}

// ResourceProviderOperationDisplay - Display metadata associated with the operation.
type ResourceProviderOperationDisplay struct {
	// Description of this operation.
	Description *string

	// Type of operation: get, read, delete, etc.
	Operation *string

	// Resource provider: Microsoft Desktop Virtualization.
	Provider *string

	// Resource on which the operation is performed.
	Resource *string
}

// ResourceProviderOperationList - Result of the request to list operations.
type ResourceProviderOperationList struct {
	// List of operations supported by this resource provider.
	Value []*ResourceProviderOperation

	// READ-ONLY; Link to the next page of results.
	NextLink *string
}

// ScalingHostPoolReference - Scaling plan reference to hostpool.
type ScalingHostPoolReference struct {
	// Arm path of referenced hostpool.
	HostPoolArmPath *string

	// Is the scaling plan enabled for this hostpool.
	ScalingPlanEnabled *bool
}

// ScalingPlan - Represents a scaling plan definition.
type ScalingPlan struct {
	// REQUIRED; Detailed properties for scaling plan.
	Properties *ScalingPlanProperties
	Identity   *ResourceModelWithAllowedPropertySetIdentity

	// Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are
	// a kind of Microsoft.Web/sites type. If supported, the resource provider must
	// validate and persist this value.
	Kind *string

	// The geo-location where the resource lives
	Location *string

	// The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another
	// Azure resource. If this is present, complete mode deployment will not
	// delete the resource if it is removed from the template since it is managed by another resource.
	ManagedBy *string
	Plan      *ResourceModelWithAllowedPropertySetPlan
	SKU       *ResourceModelWithAllowedPropertySetSKU

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; The etag field is not required. If it is provided in the response body, it must also be provided as a header
	// per the normal etag convention. Entity tags are used for comparing two or more entities
	// from the same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match
	// (section 14.26), and If-Range (section 14.27) header fields.
	Etag *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ScalingPlanList - List of scaling plan definitions.
type ScalingPlanList struct {
	// List of scaling plan definitions.
	Value []*ScalingPlan

	// READ-ONLY; Link to the next page of results.
	NextLink *string
}

// ScalingPlanPatch - Scaling plan properties that can be patched.
type ScalingPlanPatch struct {
	// Detailed properties for scaling plan
	Properties *ScalingPlanPatchProperties

	// tags to be updated
	Tags map[string]*string
}

// ScalingPlanPatchProperties - Scaling plan properties.
type ScalingPlanPatchProperties struct {
	// Description of scaling plan.
	Description *string

	// Exclusion tag for scaling plan.
	ExclusionTag *string

	// User friendly name of scaling plan.
	FriendlyName *string

	// List of ScalingHostPoolReference definitions.
	HostPoolReferences []*ScalingHostPoolReference

	// List of ScalingSchedule definitions.
	Schedules []*ScalingSchedule

	// Timezone of the scaling plan.
	TimeZone *string
}

// ScalingPlanPersonalSchedule - Represents a ScalingPlanPersonalSchedule definition.
type ScalingPlanPersonalSchedule struct {
	// REQUIRED; Detailed properties for ScalingPlanPersonalSchedule
	Properties *ScalingPlanPersonalScheduleProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ScalingPlanPersonalScheduleList - List of ScalingPlanPersonalSchedule definitions.
type ScalingPlanPersonalScheduleList struct {
	// List of ScalingPlanPersonalSchedule definitions.
	Value []*ScalingPlanPersonalSchedule

	// READ-ONLY; Link to the next page of results.
	NextLink *string
}

// ScalingPlanPersonalSchedulePatch - ScalingPlanPersonalSchedule properties that can be patched.
type ScalingPlanPersonalSchedulePatch struct {
	// Detailed properties for ScalingPlanPersonalSchedule
	Properties *ScalingPlanPersonalScheduleProperties
}

// ScalingPlanPersonalScheduleProperties - A ScalingPlanPersonalSchedule.
type ScalingPlanPersonalScheduleProperties struct {
	// Set of days of the week on which this schedule is active.
	DaysOfWeek []*DayOfWeek

	// Action to be taken after a user disconnect during the off-peak period.
	OffPeakActionOnDisconnect *SessionHandlingOperation

	// Action to be taken after a logoff during the off-peak period.
	OffPeakActionOnLogoff *SessionHandlingOperation

	// The time in minutes to wait before performing the desired session handling action when a user disconnects during the off-peak
	// period.
	OffPeakMinutesToWaitOnDisconnect *int32

	// The time in minutes to wait before performing the desired session handling action when a user logs off during the off-peak
	// period.
	OffPeakMinutesToWaitOnLogoff *int32

	// Starting time for off-peak period.
	OffPeakStartTime *Time

	// The desired configuration of Start VM On Connect for the hostpool during the off-peak phase.
	OffPeakStartVMOnConnect *SetStartVMOnConnect

	// Action to be taken after a user disconnect during the peak period.
	PeakActionOnDisconnect *SessionHandlingOperation

	// Action to be taken after a logoff during the peak period.
	PeakActionOnLogoff *SessionHandlingOperation

	// The time in minutes to wait before performing the desired session handling action when a user disconnects during the peak
	// period.
	PeakMinutesToWaitOnDisconnect *int32

	// The time in minutes to wait before performing the desired session handling action when a user logs off during the peak
	// period.
	PeakMinutesToWaitOnLogoff *int32

	// Starting time for peak period.
	PeakStartTime *Time

	// The desired configuration of Start VM On Connect for the hostpool during the peak phase.
	PeakStartVMOnConnect *SetStartVMOnConnect

	// Action to be taken after a user disconnect during the ramp down period.
	RampDownActionOnDisconnect *SessionHandlingOperation

	// Action to be taken after a logoff during the ramp down period.
	RampDownActionOnLogoff *SessionHandlingOperation

	// The time in minutes to wait before performing the desired session handling action when a user disconnects during the ramp
	// down period.
	RampDownMinutesToWaitOnDisconnect *int32

	// The time in minutes to wait before performing the desired session handling action when a user logs off during the ramp
	// down period.
	RampDownMinutesToWaitOnLogoff *int32

	// Starting time for ramp down period.
	RampDownStartTime *Time

	// The desired configuration of Start VM On Connect for the hostpool during the ramp down phase.
	RampDownStartVMOnConnect *SetStartVMOnConnect

	// Action to be taken after a user disconnect during the ramp up period.
	RampUpActionOnDisconnect *SessionHandlingOperation

	// Action to be taken after a logoff during the ramp up period.
	RampUpActionOnLogoff *SessionHandlingOperation

	// The desired startup behavior during the ramp up period for personal vms in the hostpool.
	RampUpAutoStartHosts *StartupBehavior

	// The time in minutes to wait before performing the desired session handling action when a user disconnects during the ramp
	// up period.
	RampUpMinutesToWaitOnDisconnect *int32

	// The time in minutes to wait before performing the desired session handling action when a user logs off during the ramp
	// up period.
	RampUpMinutesToWaitOnLogoff *int32

	// Starting time for ramp up period.
	RampUpStartTime *Time

	// The desired configuration of Start VM On Connect for the hostpool during the ramp up phase. If this is disabled, session
	// hosts must be turned on using rampUpAutoStartHosts or by turning them on
	// manually.
	RampUpStartVMOnConnect *SetStartVMOnConnect
}

// ScalingPlanPooledSchedule - Represents a ScalingPlanPooledSchedule definition.
type ScalingPlanPooledSchedule struct {
	// REQUIRED; Detailed properties for ScalingPlanPooledSchedule
	Properties *ScalingPlanPooledScheduleProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ScalingPlanPooledScheduleList - List of ScalingPlanPooledSchedule definitions.
type ScalingPlanPooledScheduleList struct {
	// List of ScalingPlanPooledSchedule definitions.
	Value []*ScalingPlanPooledSchedule

	// READ-ONLY; Link to the next page of results.
	NextLink *string
}

// ScalingPlanPooledSchedulePatch - ScalingPlanPooledSchedule properties that can be patched.
type ScalingPlanPooledSchedulePatch struct {
	// Detailed properties for ScalingPlanPooledSchedule
	Properties *ScalingPlanPooledScheduleProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ScalingPlanPooledScheduleProperties - A ScalingPlanPooledSchedule.
type ScalingPlanPooledScheduleProperties struct {
	// Set of days of the week on which this schedule is active.
	DaysOfWeek []*DayOfWeek

	// Load balancing algorithm for off-peak period.
	OffPeakLoadBalancingAlgorithm *SessionHostLoadBalancingAlgorithm

	// Starting time for off-peak period.
	OffPeakStartTime *Time

	// Load balancing algorithm for peak period.
	PeakLoadBalancingAlgorithm *SessionHostLoadBalancingAlgorithm

	// Starting time for peak period.
	PeakStartTime *Time

	// Capacity threshold for ramp down period.
	RampDownCapacityThresholdPct *int32

	// Should users be logged off forcefully from hosts.
	RampDownForceLogoffUsers *bool

	// Load balancing algorithm for ramp down period.
	RampDownLoadBalancingAlgorithm *SessionHostLoadBalancingAlgorithm

	// Minimum host percentage for ramp down period.
	RampDownMinimumHostsPct *int32

	// Notification message for users during ramp down period.
	RampDownNotificationMessage *string

	// Starting time for ramp down period.
	RampDownStartTime *Time

	// Specifies when to stop hosts during ramp down period.
	RampDownStopHostsWhen *StopHostsWhen

	// Number of minutes to wait to stop hosts during ramp down period.
	RampDownWaitTimeMinutes *int32

	// Capacity threshold for ramp up period.
	RampUpCapacityThresholdPct *int32

	// Load balancing algorithm for ramp up period.
	RampUpLoadBalancingAlgorithm *SessionHostLoadBalancingAlgorithm

	// Minimum host percentage for ramp up period.
	RampUpMinimumHostsPct *int32

	// Starting time for ramp up period.
	RampUpStartTime *Time
}

// ScalingPlanProperties - Scaling plan properties.
type ScalingPlanProperties struct {
	// REQUIRED; Timezone of the scaling plan.
	TimeZone *string

	// Description of scaling plan.
	Description *string

	// Exclusion tag for scaling plan.
	ExclusionTag *string

	// User friendly name of scaling plan.
	FriendlyName *string

	// List of ScalingHostPoolReference definitions.
	HostPoolReferences []*ScalingHostPoolReference

	// HostPool type for desktop.
	HostPoolType *ScalingHostPoolType

	// List of ScalingPlanPooledSchedule definitions.
	Schedules []*ScalingSchedule

	// READ-ONLY; ObjectId of scaling plan. (internal use)
	ObjectID *string
}

// ScalingSchedule - A ScalingPlanPooledSchedule.
type ScalingSchedule struct {
	// Set of days of the week on which this schedule is active.
	DaysOfWeek []*ScalingScheduleDaysOfWeekItem

	// Name of the ScalingPlanPooledSchedule.
	Name *string

	// Load balancing algorithm for off-peak period.
	OffPeakLoadBalancingAlgorithm *SessionHostLoadBalancingAlgorithm

	// Starting time for off-peak period.
	OffPeakStartTime *Time

	// Load balancing algorithm for peak period.
	PeakLoadBalancingAlgorithm *SessionHostLoadBalancingAlgorithm

	// Starting time for peak period.
	PeakStartTime *Time

	// Capacity threshold for ramp down period.
	RampDownCapacityThresholdPct *int32

	// Should users be logged off forcefully from hosts.
	RampDownForceLogoffUsers *bool

	// Load balancing algorithm for ramp down period.
	RampDownLoadBalancingAlgorithm *SessionHostLoadBalancingAlgorithm

	// Minimum host percentage for ramp down period.
	RampDownMinimumHostsPct *int32

	// Notification message for users during ramp down period.
	RampDownNotificationMessage *string

	// Starting time for ramp down period.
	RampDownStartTime *Time

	// Specifies when to stop hosts during ramp down period.
	RampDownStopHostsWhen *StopHostsWhen

	// Number of minutes to wait to stop hosts during ramp down period.
	RampDownWaitTimeMinutes *int32

	// Capacity threshold for ramp up period.
	RampUpCapacityThresholdPct *int32

	// Load balancing algorithm for ramp up period.
	RampUpLoadBalancingAlgorithm *SessionHostLoadBalancingAlgorithm

	// Minimum host percentage for ramp up period.
	RampUpMinimumHostsPct *int32

	// Starting time for ramp up period.
	RampUpStartTime *Time
}

// SendMessage - Represents message sent to a UserSession.
type SendMessage struct {
	// Body of message.
	MessageBody *string

	// Title of message.
	MessageTitle *string
}

// ServiceSpecification - Service specification payload
type ServiceSpecification struct {
	// Specifications of the Log for Azure Monitoring
	LogSpecifications []*LogSpecification
}

// SessionHost - Represents a SessionHost definition.
type SessionHost struct {
	// Detailed properties for SessionHost
	Properties *SessionHostProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SessionHostHealthCheckFailureDetails - Contains details on the failure.
type SessionHostHealthCheckFailureDetails struct {
	// READ-ONLY; Error code corresponding for the failure.
	ErrorCode *int32

	// READ-ONLY; The timestamp of the last update.
	LastHealthCheckDateTime *time.Time

	// READ-ONLY; Failure message: hints on what is wrong and how to recover.
	Message *string
}

// SessionHostHealthCheckReport - The report for session host information.
type SessionHostHealthCheckReport struct {
	// READ-ONLY; Additional detailed information on the failure.
	AdditionalFailureDetails *SessionHostHealthCheckFailureDetails

	// READ-ONLY; Represents the name of the health check operation performed.
	HealthCheckName *HealthCheckName

	// READ-ONLY; Represents the Health state of the health check we performed.
	HealthCheckResult *HealthCheckResult
}

// SessionHostList - List of SessionHost definitions.
type SessionHostList struct {
	// List of SessionHost definitions.
	Value []*SessionHost

	// READ-ONLY; Link to the next page of results.
	NextLink *string
}

// SessionHostPatch - SessionHost properties that can be patched.
type SessionHostPatch struct {
	// Detailed properties for SessionHost
	Properties *SessionHostPatchProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SessionHostPatchProperties - SessionHost properties that can be patched.
type SessionHostPatchProperties struct {
	// Allow a new session.
	AllowNewSession *bool

	// User assigned to SessionHost.
	AssignedUser *string

	// Friendly name of SessionHost
	FriendlyName *string
}

// SessionHostProperties - Schema for SessionHost properties.
type SessionHostProperties struct {
	// Version of agent on SessionHost.
	AgentVersion *string

	// Allow a new session.
	AllowNewSession *bool

	// User assigned to SessionHost.
	AssignedUser *string

	// Friendly name of SessionHost
	FriendlyName *string

	// Last heart beat from SessionHost.
	LastHeartBeat *time.Time

	// The version of the OS on the session host.
	OSVersion *string

	// Number of sessions on SessionHost.
	Sessions *int32

	// Status for a SessionHost.
	Status *Status

	// The version of the side by side stack on the session host.
	SxSStackVersion *string

	// The error message.
	UpdateErrorMessage *string

	// Update state of a SessionHost.
	UpdateState *UpdateState

	// READ-ONLY; The timestamp of the last update.
	LastUpdateTime *time.Time

	// READ-ONLY; ObjectId of SessionHost. (internal use)
	ObjectID *string

	// READ-ONLY; Resource Id of SessionHost's underlying virtual machine.
	ResourceID *string

	// READ-ONLY; List of SessionHostHealthCheckReports
	SessionHostHealthCheckResults []*SessionHostHealthCheckReport

	// READ-ONLY; The timestamp of the status.
	StatusTimestamp *time.Time

	// READ-ONLY; Virtual Machine Id of SessionHost's underlying virtual machine.
	VirtualMachineID *string
}

// StartMenuItem - Represents a StartMenuItem definition.
type StartMenuItem struct {
	// Detailed properties for StartMenuItem
	Properties *StartMenuItemProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// StartMenuItemList - List of StartMenuItem definitions.
type StartMenuItemList struct {
	// List of StartMenuItem definitions.
	Value []*StartMenuItem

	// READ-ONLY; Link to the next page of results.
	NextLink *string
}

// StartMenuItemProperties - Schema for StartMenuItem properties.
type StartMenuItemProperties struct {
	// Alias of StartMenuItem.
	AppAlias *string

	// Command line arguments for StartMenuItem.
	CommandLineArguments *string

	// Path to the file of StartMenuItem.
	FilePath *string

	// Index of the icon.
	IconIndex *int32

	// Path to the icon.
	IconPath *string
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// Time - The time for a scaling action to occur.
type Time struct {
	// REQUIRED; The hour.
	Hour *int32

	// REQUIRED; The minute.
	Minute *int32
}

// UserSession - Represents a UserSession definition.
type UserSession struct {
	// Detailed properties for UserSession
	Properties *UserSessionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// UserSessionList - List of UserSession definitions.
type UserSessionList struct {
	// List of UserSession definitions.
	Value []*UserSession

	// READ-ONLY; Link to the next page of results.
	NextLink *string
}

// UserSessionProperties - Schema for UserSession properties.
type UserSessionProperties struct {
	// The active directory user name.
	ActiveDirectoryUserName *string

	// Application type of application.
	ApplicationType *ApplicationType

	// The timestamp of the user session create.
	CreateTime *time.Time

	// State of user session.
	SessionState *SessionState

	// The user principal name.
	UserPrincipalName *string

	// READ-ONLY; ObjectId of user session. (internal use)
	ObjectID *string
}

// Workspace - Represents a Workspace definition.
type Workspace struct {
	Identity *ResourceModelWithAllowedPropertySetIdentity

	// Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are
	// a kind of Microsoft.Web/sites type. If supported, the resource provider must
	// validate and persist this value.
	Kind *string

	// The geo-location where the resource lives
	Location *string

	// The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another
	// Azure resource. If this is present, complete mode deployment will not
	// delete the resource if it is removed from the template since it is managed by another resource.
	ManagedBy *string
	Plan      *ResourceModelWithAllowedPropertySetPlan

	// Detailed properties for Workspace
	Properties *WorkspaceProperties
	SKU        *ResourceModelWithAllowedPropertySetSKU

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; The etag field is not required. If it is provided in the response body, it must also be provided as a header
	// per the normal etag convention. Entity tags are used for comparing two or more entities
	// from the same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match
	// (section 14.26), and If-Range (section 14.27) header fields.
	Etag *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// WorkspaceList - List of Workspace definitions.
type WorkspaceList struct {
	// List of Workspace definitions.
	Value []*Workspace

	// READ-ONLY; Link to the next page of results.
	NextLink *string
}

// WorkspacePatch - Workspace properties that can be patched.
type WorkspacePatch struct {
	// Detailed properties for Workspace
	Properties *WorkspacePatchProperties

	// tags to be updated
	Tags map[string]*string
}

// WorkspacePatchProperties - Workspace properties that can be patched.
type WorkspacePatchProperties struct {
	// List of applicationGroup links.
	ApplicationGroupReferences []*string

	// Description of Workspace.
	Description *string

	// Friendly name of Workspace.
	FriendlyName *string

	// Enabled to allow this resource to be access from the public network
	PublicNetworkAccess *PublicNetworkAccess
}

// WorkspaceProperties - Schema for Workspace properties.
type WorkspaceProperties struct {
	// List of applicationGroup resource Ids.
	ApplicationGroupReferences []*string

	// Description of Workspace.
	Description *string

	// Friendly name of Workspace.
	FriendlyName *string

	// Enabled allows this resource to be accessed from both public and private networks, Disabled allows this resource to only
	// be accessed via private endpoints
	PublicNetworkAccess *PublicNetworkAccess

	// READ-ONLY; Is cloud pc resource.
	CloudPcResource *bool

	// READ-ONLY; ObjectId of Workspace. (internal use)
	ObjectID *string

	// READ-ONLY; List of private endpoint connection associated with the specified resource
	PrivateEndpointConnections []*PrivateEndpointConnection
}
