//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/datalake-analytics/armdatalakeanalytics"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
	"strconv"
)

// DataLakeStoreAccountsServer is a fake server for instances of the armdatalakeanalytics.DataLakeStoreAccountsClient type.
type DataLakeStoreAccountsServer struct {
	// Add is the fake for method DataLakeStoreAccountsClient.Add
	// HTTP status codes to indicate success: http.StatusOK
	Add func(ctx context.Context, resourceGroupName string, accountName string, dataLakeStoreAccountName string, options *armdatalakeanalytics.DataLakeStoreAccountsClientAddOptions) (resp azfake.Responder[armdatalakeanalytics.DataLakeStoreAccountsClientAddResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method DataLakeStoreAccountsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, accountName string, dataLakeStoreAccountName string, options *armdatalakeanalytics.DataLakeStoreAccountsClientDeleteOptions) (resp azfake.Responder[armdatalakeanalytics.DataLakeStoreAccountsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method DataLakeStoreAccountsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, accountName string, dataLakeStoreAccountName string, options *armdatalakeanalytics.DataLakeStoreAccountsClientGetOptions) (resp azfake.Responder[armdatalakeanalytics.DataLakeStoreAccountsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByAccountPager is the fake for method DataLakeStoreAccountsClient.NewListByAccountPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByAccountPager func(resourceGroupName string, accountName string, options *armdatalakeanalytics.DataLakeStoreAccountsClientListByAccountOptions) (resp azfake.PagerResponder[armdatalakeanalytics.DataLakeStoreAccountsClientListByAccountResponse])
}

// NewDataLakeStoreAccountsServerTransport creates a new instance of DataLakeStoreAccountsServerTransport with the provided implementation.
// The returned DataLakeStoreAccountsServerTransport instance is connected to an instance of armdatalakeanalytics.DataLakeStoreAccountsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDataLakeStoreAccountsServerTransport(srv *DataLakeStoreAccountsServer) *DataLakeStoreAccountsServerTransport {
	return &DataLakeStoreAccountsServerTransport{
		srv:                   srv,
		newListByAccountPager: newTracker[azfake.PagerResponder[armdatalakeanalytics.DataLakeStoreAccountsClientListByAccountResponse]](),
	}
}

// DataLakeStoreAccountsServerTransport connects instances of armdatalakeanalytics.DataLakeStoreAccountsClient to instances of DataLakeStoreAccountsServer.
// Don't use this type directly, use NewDataLakeStoreAccountsServerTransport instead.
type DataLakeStoreAccountsServerTransport struct {
	srv                   *DataLakeStoreAccountsServer
	newListByAccountPager *tracker[azfake.PagerResponder[armdatalakeanalytics.DataLakeStoreAccountsClientListByAccountResponse]]
}

// Do implements the policy.Transporter interface for DataLakeStoreAccountsServerTransport.
func (d *DataLakeStoreAccountsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DataLakeStoreAccountsClient.Add":
		resp, err = d.dispatchAdd(req)
	case "DataLakeStoreAccountsClient.Delete":
		resp, err = d.dispatchDelete(req)
	case "DataLakeStoreAccountsClient.Get":
		resp, err = d.dispatchGet(req)
	case "DataLakeStoreAccountsClient.NewListByAccountPager":
		resp, err = d.dispatchNewListByAccountPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DataLakeStoreAccountsServerTransport) dispatchAdd(req *http.Request) (*http.Response, error) {
	if d.srv.Add == nil {
		return nil, &nonRetriableError{errors.New("fake for method Add not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataLakeAnalytics/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dataLakeStoreAccounts/(?P<dataLakeStoreAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armdatalakeanalytics.AddDataLakeStoreParameters](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	dataLakeStoreAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataLakeStoreAccountName")])
	if err != nil {
		return nil, err
	}
	var options *armdatalakeanalytics.DataLakeStoreAccountsClientAddOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armdatalakeanalytics.DataLakeStoreAccountsClientAddOptions{
			Parameters: &body,
		}
	}
	respr, errRespr := d.srv.Add(req.Context(), resourceGroupNameParam, accountNameParam, dataLakeStoreAccountNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DataLakeStoreAccountsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if d.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataLakeAnalytics/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dataLakeStoreAccounts/(?P<dataLakeStoreAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	dataLakeStoreAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataLakeStoreAccountName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.Delete(req.Context(), resourceGroupNameParam, accountNameParam, dataLakeStoreAccountNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DataLakeStoreAccountsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if d.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataLakeAnalytics/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dataLakeStoreAccounts/(?P<dataLakeStoreAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	dataLakeStoreAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataLakeStoreAccountName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.Get(req.Context(), resourceGroupNameParam, accountNameParam, dataLakeStoreAccountNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DataLakeStoreAccountInformation, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DataLakeStoreAccountsServerTransport) dispatchNewListByAccountPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListByAccountPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByAccountPager not implemented")}
	}
	newListByAccountPager := d.newListByAccountPager.get(req)
	if newListByAccountPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataLakeAnalytics/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dataLakeStoreAccounts`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		skipUnescaped, err := url.QueryUnescape(qp.Get("$skip"))
		if err != nil {
			return nil, err
		}
		skipParam, err := parseOptional(skipUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		selectUnescaped, err := url.QueryUnescape(qp.Get("$select"))
		if err != nil {
			return nil, err
		}
		selectParam := getOptional(selectUnescaped)
		orderbyUnescaped, err := url.QueryUnescape(qp.Get("$orderby"))
		if err != nil {
			return nil, err
		}
		orderbyParam := getOptional(orderbyUnescaped)
		countUnescaped, err := url.QueryUnescape(qp.Get("$count"))
		if err != nil {
			return nil, err
		}
		countParam, err := parseOptional(countUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		var options *armdatalakeanalytics.DataLakeStoreAccountsClientListByAccountOptions
		if filterParam != nil || topParam != nil || skipParam != nil || selectParam != nil || orderbyParam != nil || countParam != nil {
			options = &armdatalakeanalytics.DataLakeStoreAccountsClientListByAccountOptions{
				Filter:  filterParam,
				Top:     topParam,
				Skip:    skipParam,
				Select:  selectParam,
				Orderby: orderbyParam,
				Count:   countParam,
			}
		}
		resp := d.srv.NewListByAccountPager(resourceGroupNameParam, accountNameParam, options)
		newListByAccountPager = &resp
		d.newListByAccountPager.add(req, newListByAccountPager)
		server.PagerResponderInjectNextLinks(newListByAccountPager, req, func(page *armdatalakeanalytics.DataLakeStoreAccountsClientListByAccountResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByAccountPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListByAccountPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByAccountPager) {
		d.newListByAccountPager.remove(req)
	}
	return resp, nil
}
