//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/apimanagement/armapimanagement/v2"
	"net/http"
	"net/url"
	"regexp"
)

// AuthorizationLoginLinksServer is a fake server for instances of the armapimanagement.AuthorizationLoginLinksClient type.
type AuthorizationLoginLinksServer struct {
	// Post is the fake for method AuthorizationLoginLinksClient.Post
	// HTTP status codes to indicate success: http.StatusOK
	Post func(ctx context.Context, resourceGroupName string, serviceName string, authorizationProviderID string, authorizationID string, parameters armapimanagement.AuthorizationLoginRequestContract, options *armapimanagement.AuthorizationLoginLinksClientPostOptions) (resp azfake.Responder[armapimanagement.AuthorizationLoginLinksClientPostResponse], errResp azfake.ErrorResponder)
}

// NewAuthorizationLoginLinksServerTransport creates a new instance of AuthorizationLoginLinksServerTransport with the provided implementation.
// The returned AuthorizationLoginLinksServerTransport instance is connected to an instance of armapimanagement.AuthorizationLoginLinksClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAuthorizationLoginLinksServerTransport(srv *AuthorizationLoginLinksServer) *AuthorizationLoginLinksServerTransport {
	return &AuthorizationLoginLinksServerTransport{srv: srv}
}

// AuthorizationLoginLinksServerTransport connects instances of armapimanagement.AuthorizationLoginLinksClient to instances of AuthorizationLoginLinksServer.
// Don't use this type directly, use NewAuthorizationLoginLinksServerTransport instead.
type AuthorizationLoginLinksServerTransport struct {
	srv *AuthorizationLoginLinksServer
}

// Do implements the policy.Transporter interface for AuthorizationLoginLinksServerTransport.
func (a *AuthorizationLoginLinksServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AuthorizationLoginLinksClient.Post":
		resp, err = a.dispatchPost(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AuthorizationLoginLinksServerTransport) dispatchPost(req *http.Request) (*http.Response, error) {
	if a.srv.Post == nil {
		return nil, &nonRetriableError{errors.New("fake for method Post not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/authorizationProviders/(?P<authorizationProviderId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/authorizations/(?P<authorizationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getLoginLinks`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armapimanagement.AuthorizationLoginRequestContract](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	authorizationProviderIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("authorizationProviderId")])
	if err != nil {
		return nil, err
	}
	authorizationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("authorizationId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Post(req.Context(), resourceGroupNameParam, serviceNameParam, authorizationProviderIDParam, authorizationIDParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AuthorizationLoginResponseContract, req)
	if err != nil {
		return nil, err
	}
	if val := server.GetResponse(respr).ETag; val != nil {
		resp.Header.Set("ETag", *val)
	}
	return resp, nil
}
