// Code generated by smithy-go-codegen DO NOT EDIT.

package xray

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/xray/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Retrieves a service graph for traces based on the specified RetrievalToken
//
// from the CloudWatch log group generated by Transaction Search. This API does not
// initiate a retrieval job. You must first execute StartTraceRetrieval to obtain
// the required RetrievalToken .
//
// The trace graph describes services that process incoming requests and any
// downstream services they call, which may include Amazon Web Services resources,
// external APIs, or databases.
//
// The response is empty until the RetrievalStatus is COMPLETE. Retry the request
// after the status changes from RUNNING or SCHEDULED to COMPLETE to access the
// full service graph.
//
// When CloudWatch log is the destination, this API can support cross-account
// observability and service graph retrieval across linked accounts.
//
// For retrieving graphs from X-Ray directly as opposed to the Transaction-Search
// Log group, see [GetTraceGraph].
//
// [GetTraceGraph]: https://docs.aws.amazon.com/xray/latest/api/API_GetTraceGraph.html
func (c *Client) GetRetrievedTracesGraph(ctx context.Context, params *GetRetrievedTracesGraphInput, optFns ...func(*Options)) (*GetRetrievedTracesGraphOutput, error) {
	if params == nil {
		params = &GetRetrievedTracesGraphInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetRetrievedTracesGraph", params, optFns, c.addOperationGetRetrievedTracesGraphMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetRetrievedTracesGraphOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetRetrievedTracesGraphInput struct {

	//  Retrieval token.
	//
	// This member is required.
	RetrievalToken *string

	//  Specify the pagination token returned by a previous request to retrieve the
	// next page of indexes.
	NextToken *string

	noSmithyDocumentSerde
}

type GetRetrievedTracesGraphOutput struct {

	//  Specify the pagination token returned by a previous request to retrieve the
	// next page of indexes.
	NextToken *string

	//  Status of the retrieval.
	RetrievalStatus types.RetrievalStatus

	//  Retrieved services.
	Services []types.RetrievedService

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetRetrievedTracesGraphMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetRetrievedTracesGraph{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetRetrievedTracesGraph{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetRetrievedTracesGraph"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetRetrievedTracesGraphValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetRetrievedTracesGraph(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetRetrievedTracesGraph(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetRetrievedTracesGraph",
	}
}
