// Code generated by smithy-go-codegen DO NOT EDIT.

package qbusiness

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/qbusiness/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves the content of a document that was ingested into Amazon Q Business.
// This API validates user authorization against document ACLs before returning a
// pre-signed URL for secure document access. You can download or view source
// documents referenced in chat responses through the URL.
func (c *Client) GetDocumentContent(ctx context.Context, params *GetDocumentContentInput, optFns ...func(*Options)) (*GetDocumentContentOutput, error) {
	if params == nil {
		params = &GetDocumentContentInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetDocumentContent", params, optFns, c.addOperationGetDocumentContentMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetDocumentContentOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetDocumentContentInput struct {

	// The unique identifier of the Amazon Q Business application containing the
	// document. This ensures the request is scoped to the correct application
	// environment and its associated security policies.
	//
	// This member is required.
	ApplicationId *string

	// The unique identifier of the document that is indexed via BatchPutDocument API
	// or file-upload or connector sync. It is also found in chat or chatSync response.
	//
	// This member is required.
	DocumentId *string

	// The identifier of the index where documents are indexed.
	//
	// This member is required.
	IndexId *string

	// The identifier of the data source from which the document was ingested. This
	// field is not present if the document is ingested by directly calling the
	// BatchPutDocument API. If the document is from a file-upload data source, the
	// datasource will be "uploaded-docs-file-stat-datasourceid".
	DataSourceId *string

	// Document outputFormat. Defaults to RAW if not selected.
	OutputFormat types.OutputFormat

	noSmithyDocumentSerde
}

type GetDocumentContentOutput struct {

	// The MIME type of the document content. When outputFormat is RAW, this
	// corresponds to the original document's MIME type (e.g., application/pdf,
	// text/plain,
	// application/vnd.openxmlformats-officedocument.wordprocessingml.document). When
	// outputFormat is EXTRACTED, the MIME type is always application/json.
	//
	// This member is required.
	MimeType *string

	// A pre-signed URL that provides temporary access to download the document
	// content directly from Amazon Q Business. The URL expires after 5 minutes for
	// security purposes. This URL is generated only after successful ACL validation.
	//
	// This member is required.
	PresignedUrl *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetDocumentContentMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetDocumentContent{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetDocumentContent{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetDocumentContent"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetDocumentContentValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetDocumentContent(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetDocumentContent(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetDocumentContent",
	}
}
