// Code generated by smithy-go-codegen DO NOT EDIT.

package lexmodelsv2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/lexmodelsv2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// The list of test set records.
func (c *Client) ListTestSetRecords(ctx context.Context, params *ListTestSetRecordsInput, optFns ...func(*Options)) (*ListTestSetRecordsOutput, error) {
	if params == nil {
		params = &ListTestSetRecordsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListTestSetRecords", params, optFns, c.addOperationListTestSetRecordsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListTestSetRecordsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListTestSetRecordsInput struct {

	// The identifier of the test set to list its test set records.
	//
	// This member is required.
	TestSetId *string

	// The maximum number of test set records to return in each page. If there are
	// fewer records than the max page size, only the actual number of records are
	// returned.
	MaxResults *int32

	// If the response from the ListTestSetRecords operation contains more results
	// than specified in the maxResults parameter, a token is returned in the response.
	// Use that token in the nextToken parameter to return the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListTestSetRecordsOutput struct {

	// A token that indicates whether there are more records to return in a response
	// to the ListTestSetRecords operation. If the nextToken field is present, you send
	// the contents as the nextToken parameter of a ListTestSetRecords operation
	// request to get the next page of records.
	NextToken *string

	// The list of records from the test set.
	TestSetRecords []types.TestSetTurnRecord

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListTestSetRecordsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListTestSetRecords{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListTestSetRecords{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListTestSetRecords"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListTestSetRecordsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListTestSetRecords(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListTestSetRecordsPaginatorOptions is the paginator options for
// ListTestSetRecords
type ListTestSetRecordsPaginatorOptions struct {
	// The maximum number of test set records to return in each page. If there are
	// fewer records than the max page size, only the actual number of records are
	// returned.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListTestSetRecordsPaginator is a paginator for ListTestSetRecords
type ListTestSetRecordsPaginator struct {
	options   ListTestSetRecordsPaginatorOptions
	client    ListTestSetRecordsAPIClient
	params    *ListTestSetRecordsInput
	nextToken *string
	firstPage bool
}

// NewListTestSetRecordsPaginator returns a new ListTestSetRecordsPaginator
func NewListTestSetRecordsPaginator(client ListTestSetRecordsAPIClient, params *ListTestSetRecordsInput, optFns ...func(*ListTestSetRecordsPaginatorOptions)) *ListTestSetRecordsPaginator {
	if params == nil {
		params = &ListTestSetRecordsInput{}
	}

	options := ListTestSetRecordsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListTestSetRecordsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListTestSetRecordsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListTestSetRecords page.
func (p *ListTestSetRecordsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListTestSetRecordsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListTestSetRecords(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListTestSetRecordsAPIClient is a client that implements the ListTestSetRecords
// operation.
type ListTestSetRecordsAPIClient interface {
	ListTestSetRecords(context.Context, *ListTestSetRecordsInput, ...func(*Options)) (*ListTestSetRecordsOutput, error)
}

var _ ListTestSetRecordsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListTestSetRecords(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListTestSetRecords",
	}
}
