// Code generated by smithy-go-codegen DO NOT EDIT.

package backupsearch

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/backupsearch/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// This operation returns a list of all backups (recovery points) in a paginated
// format that were included in the search job.
//
// If a search does not display an expected backup in the results, you can call
// this operation to display each backup included in the search. Any backups that
// were not included because they have a FAILED status from a permissions issue
// will be displayed, along with a status message.
//
// Only recovery points with a backup index that has a status of ACTIVE will be
// included in search results. If the index has any other status, its status will
// be displayed along with a status message.
func (c *Client) ListSearchJobBackups(ctx context.Context, params *ListSearchJobBackupsInput, optFns ...func(*Options)) (*ListSearchJobBackupsOutput, error) {
	if params == nil {
		params = &ListSearchJobBackupsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListSearchJobBackups", params, optFns, c.addOperationListSearchJobBackupsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListSearchJobBackupsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListSearchJobBackupsInput struct {

	// The unique string that specifies the search job.
	//
	// This member is required.
	SearchJobIdentifier *string

	// The maximum number of resource list items to be returned.
	MaxResults *int32

	// The next item following a partial list of returned backups included in a search
	// job.
	//
	// For example, if a request is made to return MaxResults number of backups,
	// NextToken allows you to return more items in your list starting at the location
	// pointed to by the next token.
	NextToken *string

	noSmithyDocumentSerde
}

type ListSearchJobBackupsOutput struct {

	// The recovery points returned the results of a search job
	//
	// This member is required.
	Results []types.SearchJobBackupsResult

	// The next item following a partial list of returned backups included in a search
	// job.
	//
	// For example, if a request is made to return MaxResults number of backups,
	// NextToken allows you to return more items in your list starting at the location
	// pointed to by the next token.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListSearchJobBackupsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListSearchJobBackups{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListSearchJobBackups{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListSearchJobBackups"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListSearchJobBackupsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListSearchJobBackups(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListSearchJobBackupsPaginatorOptions is the paginator options for
// ListSearchJobBackups
type ListSearchJobBackupsPaginatorOptions struct {
	// The maximum number of resource list items to be returned.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListSearchJobBackupsPaginator is a paginator for ListSearchJobBackups
type ListSearchJobBackupsPaginator struct {
	options   ListSearchJobBackupsPaginatorOptions
	client    ListSearchJobBackupsAPIClient
	params    *ListSearchJobBackupsInput
	nextToken *string
	firstPage bool
}

// NewListSearchJobBackupsPaginator returns a new ListSearchJobBackupsPaginator
func NewListSearchJobBackupsPaginator(client ListSearchJobBackupsAPIClient, params *ListSearchJobBackupsInput, optFns ...func(*ListSearchJobBackupsPaginatorOptions)) *ListSearchJobBackupsPaginator {
	if params == nil {
		params = &ListSearchJobBackupsInput{}
	}

	options := ListSearchJobBackupsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListSearchJobBackupsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListSearchJobBackupsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListSearchJobBackups page.
func (p *ListSearchJobBackupsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListSearchJobBackupsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListSearchJobBackups(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListSearchJobBackupsAPIClient is a client that implements the
// ListSearchJobBackups operation.
type ListSearchJobBackupsAPIClient interface {
	ListSearchJobBackups(context.Context, *ListSearchJobBackupsInput, ...func(*Options)) (*ListSearchJobBackupsOutput, error)
}

var _ ListSearchJobBackupsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListSearchJobBackups(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListSearchJobBackups",
	}
}
