// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package forgejo

import (
	"context"
	"fmt"

	f3_tree "code.forgejo.org/f3/gof3/v3/tree/f3"
	"code.forgejo.org/f3/gof3/v3/tree/generic"

	forgejo_sdk "code.forgejo.org/f3/gof3/v3/forges/forgejo/sdk"
)

type comments struct {
	container
}

func (o *comments) ListPage(ctx context.Context, page int) generic.ChildrenSlice {
	children := generic.NewChildrenSlice(0)
	if page > 1 {
		return children
	}

	var err error
	var forgejoComments []*forgejo_sdk.Comment

	owner := f3_tree.GetOwnerName(o.GetNode())
	project := f3_tree.GetProjectName(o.GetNode())
	commentable := f3_tree.GetCommentableID(o.GetNode())

	forgejoComments, _, err = o.getClient().ListIssueComments(owner, project, commentable, forgejo_sdk.ListIssueCommentOptions{})
	if err != nil {
		panic(fmt.Errorf("error while listing comments: %v", err))
	}

	return f3_tree.ConvertListed(ctx, o.GetNode(), f3_tree.ConvertToAny(forgejoComments...)...)
}

func newComments() generic.NodeDriverInterface {
	return &comments{}
}
