// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.2.0
// - protoc             v4.23.1
// source: blob.proto

package gitalypb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// BlobServiceClient is the client API for BlobService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type BlobServiceClient interface {
	// GetBlob returns the contents of a blob object referenced by its object
	// ID. We use a stream to return a chunked arbitrarily large binary
	// response
	GetBlob(ctx context.Context, in *GetBlobRequest, opts ...grpc.CallOption) (BlobService_GetBlobClient, error)
	// This comment is left unintentionally blank.
	GetBlobs(ctx context.Context, in *GetBlobsRequest, opts ...grpc.CallOption) (BlobService_GetBlobsClient, error)
	// ListBlobs will list all blobs reachable from a given set of revisions by
	// doing a graph walk. It is not valid to pass revisions which do not resolve
	// to an existing object.
	ListBlobs(ctx context.Context, in *ListBlobsRequest, opts ...grpc.CallOption) (BlobService_ListBlobsClient, error)
	// ListAllBlobs retrieves all blobs pointers in the repository, including
	// those not reachable by any reference.
	ListAllBlobs(ctx context.Context, in *ListAllBlobsRequest, opts ...grpc.CallOption) (BlobService_ListAllBlobsClient, error)
	// GetLFSPointers retrieves LFS pointers from a given set of object IDs.
	// This RPC filters all requested objects and only returns those which refer
	// to a valid LFS pointer.
	GetLFSPointers(ctx context.Context, in *GetLFSPointersRequest, opts ...grpc.CallOption) (BlobService_GetLFSPointersClient, error)
	// ListLFSPointers retrieves LFS pointers reachable from a given set of
	// revisions by doing a graph walk. This includes both normal revisions like
	// an object ID or branch, but also the pseudo-revisions "--all" and "--not"
	// as documented in git-rev-parse(1). Revisions which don't directly or
	// transitively reference any LFS pointers are ignored. It is not valid to
	// pass revisions which do not resolve to an existing object.
	ListLFSPointers(ctx context.Context, in *ListLFSPointersRequest, opts ...grpc.CallOption) (BlobService_ListLFSPointersClient, error)
	// ListAllLFSPointers retrieves all LFS pointers in the repository, including
	// those not reachable by any reference.
	ListAllLFSPointers(ctx context.Context, in *ListAllLFSPointersRequest, opts ...grpc.CallOption) (BlobService_ListAllLFSPointersClient, error)
}

type blobServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewBlobServiceClient(cc grpc.ClientConnInterface) BlobServiceClient {
	return &blobServiceClient{cc}
}

func (c *blobServiceClient) GetBlob(ctx context.Context, in *GetBlobRequest, opts ...grpc.CallOption) (BlobService_GetBlobClient, error) {
	stream, err := c.cc.NewStream(ctx, &BlobService_ServiceDesc.Streams[0], "/gitaly.BlobService/GetBlob", opts...)
	if err != nil {
		return nil, err
	}
	x := &blobServiceGetBlobClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type BlobService_GetBlobClient interface {
	Recv() (*GetBlobResponse, error)
	grpc.ClientStream
}

type blobServiceGetBlobClient struct {
	grpc.ClientStream
}

func (x *blobServiceGetBlobClient) Recv() (*GetBlobResponse, error) {
	m := new(GetBlobResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *blobServiceClient) GetBlobs(ctx context.Context, in *GetBlobsRequest, opts ...grpc.CallOption) (BlobService_GetBlobsClient, error) {
	stream, err := c.cc.NewStream(ctx, &BlobService_ServiceDesc.Streams[1], "/gitaly.BlobService/GetBlobs", opts...)
	if err != nil {
		return nil, err
	}
	x := &blobServiceGetBlobsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type BlobService_GetBlobsClient interface {
	Recv() (*GetBlobsResponse, error)
	grpc.ClientStream
}

type blobServiceGetBlobsClient struct {
	grpc.ClientStream
}

func (x *blobServiceGetBlobsClient) Recv() (*GetBlobsResponse, error) {
	m := new(GetBlobsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *blobServiceClient) ListBlobs(ctx context.Context, in *ListBlobsRequest, opts ...grpc.CallOption) (BlobService_ListBlobsClient, error) {
	stream, err := c.cc.NewStream(ctx, &BlobService_ServiceDesc.Streams[2], "/gitaly.BlobService/ListBlobs", opts...)
	if err != nil {
		return nil, err
	}
	x := &blobServiceListBlobsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type BlobService_ListBlobsClient interface {
	Recv() (*ListBlobsResponse, error)
	grpc.ClientStream
}

type blobServiceListBlobsClient struct {
	grpc.ClientStream
}

func (x *blobServiceListBlobsClient) Recv() (*ListBlobsResponse, error) {
	m := new(ListBlobsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *blobServiceClient) ListAllBlobs(ctx context.Context, in *ListAllBlobsRequest, opts ...grpc.CallOption) (BlobService_ListAllBlobsClient, error) {
	stream, err := c.cc.NewStream(ctx, &BlobService_ServiceDesc.Streams[3], "/gitaly.BlobService/ListAllBlobs", opts...)
	if err != nil {
		return nil, err
	}
	x := &blobServiceListAllBlobsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type BlobService_ListAllBlobsClient interface {
	Recv() (*ListAllBlobsResponse, error)
	grpc.ClientStream
}

type blobServiceListAllBlobsClient struct {
	grpc.ClientStream
}

func (x *blobServiceListAllBlobsClient) Recv() (*ListAllBlobsResponse, error) {
	m := new(ListAllBlobsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *blobServiceClient) GetLFSPointers(ctx context.Context, in *GetLFSPointersRequest, opts ...grpc.CallOption) (BlobService_GetLFSPointersClient, error) {
	stream, err := c.cc.NewStream(ctx, &BlobService_ServiceDesc.Streams[4], "/gitaly.BlobService/GetLFSPointers", opts...)
	if err != nil {
		return nil, err
	}
	x := &blobServiceGetLFSPointersClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type BlobService_GetLFSPointersClient interface {
	Recv() (*GetLFSPointersResponse, error)
	grpc.ClientStream
}

type blobServiceGetLFSPointersClient struct {
	grpc.ClientStream
}

func (x *blobServiceGetLFSPointersClient) Recv() (*GetLFSPointersResponse, error) {
	m := new(GetLFSPointersResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *blobServiceClient) ListLFSPointers(ctx context.Context, in *ListLFSPointersRequest, opts ...grpc.CallOption) (BlobService_ListLFSPointersClient, error) {
	stream, err := c.cc.NewStream(ctx, &BlobService_ServiceDesc.Streams[5], "/gitaly.BlobService/ListLFSPointers", opts...)
	if err != nil {
		return nil, err
	}
	x := &blobServiceListLFSPointersClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type BlobService_ListLFSPointersClient interface {
	Recv() (*ListLFSPointersResponse, error)
	grpc.ClientStream
}

type blobServiceListLFSPointersClient struct {
	grpc.ClientStream
}

func (x *blobServiceListLFSPointersClient) Recv() (*ListLFSPointersResponse, error) {
	m := new(ListLFSPointersResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *blobServiceClient) ListAllLFSPointers(ctx context.Context, in *ListAllLFSPointersRequest, opts ...grpc.CallOption) (BlobService_ListAllLFSPointersClient, error) {
	stream, err := c.cc.NewStream(ctx, &BlobService_ServiceDesc.Streams[6], "/gitaly.BlobService/ListAllLFSPointers", opts...)
	if err != nil {
		return nil, err
	}
	x := &blobServiceListAllLFSPointersClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type BlobService_ListAllLFSPointersClient interface {
	Recv() (*ListAllLFSPointersResponse, error)
	grpc.ClientStream
}

type blobServiceListAllLFSPointersClient struct {
	grpc.ClientStream
}

func (x *blobServiceListAllLFSPointersClient) Recv() (*ListAllLFSPointersResponse, error) {
	m := new(ListAllLFSPointersResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// BlobServiceServer is the server API for BlobService service.
// All implementations must embed UnimplementedBlobServiceServer
// for forward compatibility
type BlobServiceServer interface {
	// GetBlob returns the contents of a blob object referenced by its object
	// ID. We use a stream to return a chunked arbitrarily large binary
	// response
	GetBlob(*GetBlobRequest, BlobService_GetBlobServer) error
	// This comment is left unintentionally blank.
	GetBlobs(*GetBlobsRequest, BlobService_GetBlobsServer) error
	// ListBlobs will list all blobs reachable from a given set of revisions by
	// doing a graph walk. It is not valid to pass revisions which do not resolve
	// to an existing object.
	ListBlobs(*ListBlobsRequest, BlobService_ListBlobsServer) error
	// ListAllBlobs retrieves all blobs pointers in the repository, including
	// those not reachable by any reference.
	ListAllBlobs(*ListAllBlobsRequest, BlobService_ListAllBlobsServer) error
	// GetLFSPointers retrieves LFS pointers from a given set of object IDs.
	// This RPC filters all requested objects and only returns those which refer
	// to a valid LFS pointer.
	GetLFSPointers(*GetLFSPointersRequest, BlobService_GetLFSPointersServer) error
	// ListLFSPointers retrieves LFS pointers reachable from a given set of
	// revisions by doing a graph walk. This includes both normal revisions like
	// an object ID or branch, but also the pseudo-revisions "--all" and "--not"
	// as documented in git-rev-parse(1). Revisions which don't directly or
	// transitively reference any LFS pointers are ignored. It is not valid to
	// pass revisions which do not resolve to an existing object.
	ListLFSPointers(*ListLFSPointersRequest, BlobService_ListLFSPointersServer) error
	// ListAllLFSPointers retrieves all LFS pointers in the repository, including
	// those not reachable by any reference.
	ListAllLFSPointers(*ListAllLFSPointersRequest, BlobService_ListAllLFSPointersServer) error
	mustEmbedUnimplementedBlobServiceServer()
}

// UnimplementedBlobServiceServer must be embedded to have forward compatible implementations.
type UnimplementedBlobServiceServer struct {
}

func (UnimplementedBlobServiceServer) GetBlob(*GetBlobRequest, BlobService_GetBlobServer) error {
	return status.Errorf(codes.Unimplemented, "method GetBlob not implemented")
}
func (UnimplementedBlobServiceServer) GetBlobs(*GetBlobsRequest, BlobService_GetBlobsServer) error {
	return status.Errorf(codes.Unimplemented, "method GetBlobs not implemented")
}
func (UnimplementedBlobServiceServer) ListBlobs(*ListBlobsRequest, BlobService_ListBlobsServer) error {
	return status.Errorf(codes.Unimplemented, "method ListBlobs not implemented")
}
func (UnimplementedBlobServiceServer) ListAllBlobs(*ListAllBlobsRequest, BlobService_ListAllBlobsServer) error {
	return status.Errorf(codes.Unimplemented, "method ListAllBlobs not implemented")
}
func (UnimplementedBlobServiceServer) GetLFSPointers(*GetLFSPointersRequest, BlobService_GetLFSPointersServer) error {
	return status.Errorf(codes.Unimplemented, "method GetLFSPointers not implemented")
}
func (UnimplementedBlobServiceServer) ListLFSPointers(*ListLFSPointersRequest, BlobService_ListLFSPointersServer) error {
	return status.Errorf(codes.Unimplemented, "method ListLFSPointers not implemented")
}
func (UnimplementedBlobServiceServer) ListAllLFSPointers(*ListAllLFSPointersRequest, BlobService_ListAllLFSPointersServer) error {
	return status.Errorf(codes.Unimplemented, "method ListAllLFSPointers not implemented")
}
func (UnimplementedBlobServiceServer) mustEmbedUnimplementedBlobServiceServer() {}

// UnsafeBlobServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to BlobServiceServer will
// result in compilation errors.
type UnsafeBlobServiceServer interface {
	mustEmbedUnimplementedBlobServiceServer()
}

func RegisterBlobServiceServer(s grpc.ServiceRegistrar, srv BlobServiceServer) {
	s.RegisterService(&BlobService_ServiceDesc, srv)
}

func _BlobService_GetBlob_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetBlobRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(BlobServiceServer).GetBlob(m, &blobServiceGetBlobServer{stream})
}

type BlobService_GetBlobServer interface {
	Send(*GetBlobResponse) error
	grpc.ServerStream
}

type blobServiceGetBlobServer struct {
	grpc.ServerStream
}

func (x *blobServiceGetBlobServer) Send(m *GetBlobResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _BlobService_GetBlobs_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetBlobsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(BlobServiceServer).GetBlobs(m, &blobServiceGetBlobsServer{stream})
}

type BlobService_GetBlobsServer interface {
	Send(*GetBlobsResponse) error
	grpc.ServerStream
}

type blobServiceGetBlobsServer struct {
	grpc.ServerStream
}

func (x *blobServiceGetBlobsServer) Send(m *GetBlobsResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _BlobService_ListBlobs_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ListBlobsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(BlobServiceServer).ListBlobs(m, &blobServiceListBlobsServer{stream})
}

type BlobService_ListBlobsServer interface {
	Send(*ListBlobsResponse) error
	grpc.ServerStream
}

type blobServiceListBlobsServer struct {
	grpc.ServerStream
}

func (x *blobServiceListBlobsServer) Send(m *ListBlobsResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _BlobService_ListAllBlobs_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ListAllBlobsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(BlobServiceServer).ListAllBlobs(m, &blobServiceListAllBlobsServer{stream})
}

type BlobService_ListAllBlobsServer interface {
	Send(*ListAllBlobsResponse) error
	grpc.ServerStream
}

type blobServiceListAllBlobsServer struct {
	grpc.ServerStream
}

func (x *blobServiceListAllBlobsServer) Send(m *ListAllBlobsResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _BlobService_GetLFSPointers_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetLFSPointersRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(BlobServiceServer).GetLFSPointers(m, &blobServiceGetLFSPointersServer{stream})
}

type BlobService_GetLFSPointersServer interface {
	Send(*GetLFSPointersResponse) error
	grpc.ServerStream
}

type blobServiceGetLFSPointersServer struct {
	grpc.ServerStream
}

func (x *blobServiceGetLFSPointersServer) Send(m *GetLFSPointersResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _BlobService_ListLFSPointers_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ListLFSPointersRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(BlobServiceServer).ListLFSPointers(m, &blobServiceListLFSPointersServer{stream})
}

type BlobService_ListLFSPointersServer interface {
	Send(*ListLFSPointersResponse) error
	grpc.ServerStream
}

type blobServiceListLFSPointersServer struct {
	grpc.ServerStream
}

func (x *blobServiceListLFSPointersServer) Send(m *ListLFSPointersResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _BlobService_ListAllLFSPointers_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ListAllLFSPointersRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(BlobServiceServer).ListAllLFSPointers(m, &blobServiceListAllLFSPointersServer{stream})
}

type BlobService_ListAllLFSPointersServer interface {
	Send(*ListAllLFSPointersResponse) error
	grpc.ServerStream
}

type blobServiceListAllLFSPointersServer struct {
	grpc.ServerStream
}

func (x *blobServiceListAllLFSPointersServer) Send(m *ListAllLFSPointersResponse) error {
	return x.ServerStream.SendMsg(m)
}

// BlobService_ServiceDesc is the grpc.ServiceDesc for BlobService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var BlobService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "gitaly.BlobService",
	HandlerType: (*BlobServiceServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "GetBlob",
			Handler:       _BlobService_GetBlob_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetBlobs",
			Handler:       _BlobService_GetBlobs_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ListBlobs",
			Handler:       _BlobService_ListBlobs_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ListAllBlobs",
			Handler:       _BlobService_ListAllBlobs_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetLFSPointers",
			Handler:       _BlobService_GetLFSPointers_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ListLFSPointers",
			Handler:       _BlobService_ListLFSPointers_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ListAllLFSPointers",
			Handler:       _BlobService_ListAllLFSPointers_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "blob.proto",
}
