"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.subsetFont = subsetFont;
const Rectify = require("@ot-builder/rectify");
const initial_visible_glyphs_1 = require("../support/initial-visible-glyphs");
function subsetFont(font, text, gsf) {
    const { glyphs, rectifier } = (0, initial_visible_glyphs_1.createSubsetRectifier)(font, new Set([...text].map(s => s.codePointAt(0))));
    font.glyphs = gsf.createStoreFromList(glyphs);
    Rectify.inPlaceRectifyFontGlyphReferences(rectifier, font);
}
//# sourceMappingURL=subset.js.map