"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.intersects = exports.coverBox = exports.coverY = exports.coverX = exports.coverPoint = exports.isValid = exports.empty = void 0;
const NE = 0x100000;
function empty() {
    return { xMin: NE, xMax: -NE, yMin: NE, yMax: -NE };
}
exports.empty = empty;
function isValid(b) {
    return b.xMin <= b.xMax && b.yMin <= b.yMax;
}
exports.isValid = isValid;
function coverPoint(b, z) {
    coverX(b, z.x), coverY(b, z.y);
}
exports.coverPoint = coverPoint;
function coverX(b, x) {
    if (!isValid(b)) {
        b.xMin = b.xMax = x;
    }
    else if (x < b.xMin) {
        b.xMin = x;
    }
    else if (x > b.xMax) {
        b.xMax = x;
    }
}
exports.coverX = coverX;
function coverY(b, y) {
    if (!isValid(b)) {
        b.yMin = b.yMax = y;
    }
    else if (y < b.yMin) {
        b.yMin = y;
    }
    else if (y > b.yMax) {
        b.yMax = y;
    }
}
exports.coverY = coverY;
function coverBox(b, t) {
    if (isValid(t)) {
        coverPoint(b, { x: t.xMin, y: t.yMin });
        coverPoint(b, { x: t.xMax, y: t.yMax });
        coverPoint(b, { x: t.xMin, y: t.yMax });
        coverPoint(b, { x: t.xMax, y: t.yMin });
    }
}
exports.coverBox = coverBox;
function intersects(a, b) {
    if (!isValid(a) || !isValid(b))
        return false;
    return !(b.xMin > a.xMax || b.xMax < a.xMin || b.yMax > a.yMin || b.yMin < a.yMax);
}
exports.intersects = intersects;
