"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WriteCffGlyphs = exports.ReadCffGlyphs = void 0;
const bin_util_1 = require("@ot-builder/bin-util");
const errors_1 = require("@ot-builder/errors");
const io_bin_cff_1 = require("@ot-builder/io-bin-cff");
const ot_glyphs_1 = require("@ot-builder/ot-glyphs");
exports.ReadCffGlyphs = {
    readGlyphs(sfnt, cfg, gOrd, ctx) {
        const bCff2 = sfnt.tables.get(ot_glyphs_1.Cff.Tag2);
        if (bCff2) {
            return new bin_util_1.BinaryView(bCff2).next(io_bin_cff_1.Cff2Io, cfg, gOrd, ctx.designSpace, ctx.coStat);
        }
        const bCff1 = sfnt.tables.get(ot_glyphs_1.Cff.Tag1);
        if (bCff1)
            return new bin_util_1.BinaryView(bCff1).next(io_bin_cff_1.Cff1Io, cfg, gOrd, ctx.coStat);
        throw errors_1.Errors.Unreachable();
    }
};
exports.WriteCffGlyphs = {
    writeMetricVariance: true,
    writeGlyphs(sfnt, cfg, coGlyphs, gOrd, ctx) {
        const cff = coGlyphs.cff;
        if (cff.version > 1) {
            sfnt.add(ot_glyphs_1.Cff.Tag2, bin_util_1.Frag.pack(bin_util_1.Frag.from(io_bin_cff_1.Cff2Io, cff, gOrd, cfg, ctx.head, ctx.designSpace, ctx.stat)));
        }
        else {
            sfnt.add(ot_glyphs_1.Cff.Tag1, bin_util_1.Frag.pack(bin_util_1.Frag.from(io_bin_cff_1.Cff1Io, cff, gOrd, cfg, ctx.head, ctx.stat)));
        }
    }
};
//# sourceMappingURL=index.js.map