"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Os2MinMaxCharStat = void 0;
const interface_1 = require("./interface");
///////////////////////////////////////////////////////////////////////////////////////////////////
class Os2MinMaxCharStat extends interface_1.EmptyStat {
    constructor(os2, external) {
        super(external);
        this.os2 = os2;
        this.min = 0xffffff;
        this.max = 0;
    }
    addEncoding(u) {
        super.addEncoding(u);
        if (u < this.min)
            this.min = u;
        if (u > this.max)
            this.max = u;
    }
    settle() {
        super.settle();
        // Set the stats only if we really initialized it
        if (this.min <= this.max) {
            this.os2.usFirstCharIndex = this.min;
            this.os2.usLastCharIndex = Math.min(0xffff, this.max);
        }
    }
}
exports.Os2MinMaxCharStat = Os2MinMaxCharStat;
//# sourceMappingURL=os2-min-max-char-index.js.map