"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CffGlyphCoStatSource = exports.CffReadContext = void 0;
const glyph_data_sink_1 = require("../charset/glyph-data-sink");
const source_1 = require("../strings/source");
class CffReadContext {
    constructor(version = 2, vwCffTable, gss = null) {
        this.version = version;
        this.vwCffTable = vwCffTable;
        this.ivs = null;
        this.strings = null;
        this.naming = null;
        if (version <= 1) {
            this.strings = new source_1.CffStringSource();
            this.naming = new glyph_data_sink_1.CffGlyphNaming();
        }
        this.coStat = new CffGlyphCoStatSource(gss);
    }
}
exports.CffReadContext = CffReadContext;
class CffGlyphCoStatSource {
    constructor(outer) {
        this.outer = outer;
    }
    getHMetric(gid, extent) {
        if (this.outer)
            return this.outer.getHMetric(gid, extent);
        else
            return null;
    }
    getVMetric(gid, extent) {
        if (this.outer)
            return this.outer.getVMetric(gid, extent);
        else
            return null;
    }
}
exports.CffGlyphCoStatSource = CffGlyphCoStatSource;
//# sourceMappingURL=read.js.map