"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.inferSaveCfg = exports.OptimizationLevel = void 0;
var OptimizationLevel;
(function (OptimizationLevel) {
    OptimizationLevel[OptimizationLevel["Speed"] = 0] = "Speed";
    OptimizationLevel[OptimizationLevel["None"] = 1] = "None";
    OptimizationLevel[OptimizationLevel["Size"] = 2] = "Size";
})(OptimizationLevel = exports.OptimizationLevel || (exports.OptimizationLevel = {}));
function inferSaveCfg(state, font) {
    const cfg = {};
    cfg.glyphStore = { statOs2XAvgCharWidth: state.recalcOs2XAvgCharWidth };
    switch (state.optimizationLevel) {
        case OptimizationLevel.Speed: {
            // OTL: use faster coverage + use flat single sub/pos
            const m = new Map();
            if (font.gsub)
                for (const lookup of font.gsub.lookups)
                    m.set(lookup, 10);
            if (font.gpos)
                for (const lookup of font.gpos.lookups)
                    m.set(lookup, 10);
            cfg.layout = { gdefWriteTrick: 10, lookupWriteTricks: m };
            break;
        }
        case OptimizationLevel.Size: {
            cfg.cff = { doLocalOptimization: true, doGlobalOptimization: true };
            break;
        }
    }
    return cfg;
}
exports.inferSaveCfg = inferSaveCfg;
//# sourceMappingURL=index.js.map