# Reporting Security Issues

The Autodesk team and community take security bugs in flask-rebar seriously. We appreciate your efforts to responsibly disclose your findings, and will make every effort to acknowledge your contributions.

## Reporting a Security Vulnerability to Autodesk

This vulnerability disclosure policy applies to any vulnerabilities you are considering reporting to Autodesk.

We recommend reading this vulnerability disclosure policy fully before you report a vulnerability and always acting in compliance with it.

We value those who take the time and effort to report security vulnerabilities according to this policy. However, we do not offer monetary rewards for vulnerability disclosures.

If you believe you have found a security vulnerability relating to Autodesk's systems or products, please submit a vulnerability report to [Autodesk HackerOne program](https://hackerone.com/autodesk) or [psirt@autodesk.com](mailto:psirt@autodesk.com). Otherwise, submit a report an incident at [Autodesk Trust Center](https://www.autodesk.com/trust/security).

In your report please include details of:

- The software package, website, IP or page where the vulnerability can be observed.
- A brief description of the type of vulnerability, for example; "XSS vulnerability".
- Steps to reproduce. These should be a benign, non-destructive, proof of concept. This helps to ensure that the report can be triaged quickly and accurately. It also reduces the likelihood of duplicate reports, or malicious exploitation of some vulnerabilities, such as sub-domain takeovers.

Autodesk will send a response indicating the next steps in handling your report. After the initial reply to your report, the security team will keep you informed of the progress towards a fix and full announcement, and may ask for additional information or guidance.

## Responsible Disclosure

We appreciate the responsible disclosure of security vulnerabilities. Please allow us a reasonable amount of time to address the issue before making it public.

## Supported Versions

| Version   | Supported          |
|-----------|--------------------|
| 3.0+      | :white_check_mark: |
| <=2.4.1   | :x:                |

## Learning More About Security

To learn more about Autodesk Security, please see the [Autodesk Trust Center](https://www.autodesk.com/trust/security).

## Receiving Security Information From Autodesk

Technical security information about our products and services is distributed through several channels.

- Autodesk distributes information to customers about security vulnerabilities via https://autodesk.com and [Autodesk Trust Center](https://www.autodesk.com/trust/security).
- Autodesk may issue release notes and security bulletins detailing security vulnerabilities, workarounds, remediations and any indicators of compromise to aid incident response teams.