#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Legend of Keepers
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250520.5

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='legend-of-keepers'
GAME_NAME='Legend of Keepers: Career of a Dungeon Manager'

GAME_ID_DEMO="${GAME_ID}-demo"
GAME_NAME_DEMO='Legend of Keepers: Prologue'

## This Linux native build of the game fails to run correctly.
## It spams errors related to fmodstudio (for some reason it can’t find the library),
## and fails to progress further than the profile selection screen.
## Support for the Windows build is included as a workaround.
ARCHIVE_BASE_LINUX_0_NAME='legend_of_keepers_career_of_a_dungeon_manager_1_1_0_2_57134.sh'
ARCHIVE_BASE_LINUX_0_MD5='a1d7f09037caaa7212cfd8a61a992289'
ARCHIVE_BASE_LINUX_0_SIZE='1113810'
ARCHIVE_BASE_LINUX_0_VERSION='1.1.0.2-gog57134'
ARCHIVE_BASE_LINUX_0_URL='https://www.gog.com/game/legend_of_keepers_career_of_a_dungeon_master'

ARCHIVE_BASE_WINDOWS_0_NAME='setup_legend_of_keepers_career_of_a_dungeon_manager_1.1.0.3_(69681).exe'
ARCHIVE_BASE_WINDOWS_0_MD5='f4f741dccc54018e4a5bc1118e54336b'
ARCHIVE_BASE_WINDOWS_0_SIZE='1137440'
ARCHIVE_BASE_WINDOWS_0_VERSION='1.1.0.3-gog69681'
ARCHIVE_BASE_WINDOWS_0_URL='https://www.gog.com/game/legend_of_keepers_career_of_a_dungeon_master'

ARCHIVE_BASE_DEMO_LINUX_0_NAME='legend_of_keepers_prologue_0_9_2_1_44469.sh'
ARCHIVE_BASE_DEMO_LINUX_0_MD5='af73802b552219f834b53734b955906b'
ARCHIVE_BASE_DEMO_LINUX_0_SIZE='1012855'
ARCHIVE_BASE_DEMO_LINUX_0_VERSION='0.9.2.1-gog44469'
ARCHIVE_BASE_DEMO_LINUX_0_URL='https://www.gog.com/game/legend_of_keepers_prologue'

ARCHIVE_BASE_DEMO_WINDOWS_0_NAME='setup_legend_of_keepers_prologue_0.9.2.1_(44468).exe'
ARCHIVE_BASE_DEMO_WINDOWS_0_MD5='5d861b01134173210cfec816274539f7'
ARCHIVE_BASE_DEMO_WINDOWS_0_SIZE='1026797'
ARCHIVE_BASE_DEMO_WINDOWS_0_VERSION='0.9.2.1-gog44468'
ARCHIVE_BASE_DEMO_WINDOWS_0_URL='https://www.gog.com/game/legend_of_keepers_prologue'

UNITY3D_NAME_LINUX='LegendOfKeepers'
UNITY3D_NAME_WINDOWS='legendofkeepers'
UNITY3D_NAME_DEMO_LINUX='LegendOfKeepersPrologue'
UNITY3D_NAME_DEMO_WINDOWS='legendofkeepersprologue'
UNITY3D_PLUGINS='
libEOSSDK-Linux-Shipping.so
libfmodstudioL.so
libfmodstudio.so
libresonanceaudio.so'
## TODO: Check if the Steam library is required.
UNITY3D_PLUGINS="$UNITY3D_PLUGINS
libsteam_api.so"

CONTENT_PATH_DEFAULT_LINUX='data/noarch/game'
CONTENT_PATH_DEFAULT_WINDOWS='.'
CONTENT_PATH_DEFAULT_DEMO_LINUX='data/noarch/game'
CONTENT_PATH_DEFAULT_DEMO_WINDOWS='.'
## The Windows demo fails to run if the Galaxy library are not available.
CONTENT_GAME0_BIN_FILES_DEMO_WINDOWS='
galaxy.dll
galaxycsharpglue.dll'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/LocalLow/GoblinzStudio/LegendOfKeepers'
WINE_PERSISTENT_DIRECTORIES_DEMO='
users/${USER}/AppData/LocalLow/GoblinzStudio/LegendOfKeepersPrologue'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ID="${GAME_ID}-bin"
PKG_BIN_ID_LINUX="${PKG_BIN_ID}-linux"
PKG_BIN_ID_WINDOWS="${PKG_BIN_ID}-windows"
PKG_BIN_ID_DEMO="${GAME_ID_DEMO}-bin"
PKG_BIN_ID_DEMO_LINUX="${PKG_BIN_ID_DEMO}-linux"
PKG_BIN_ID_DEMO_WINDOWS="${PKG_BIN_ID_DEMO}-windows"
PKG_BIN_PROVIDES="
$PKG_BIN_ID"
PKG_BIN_PROVIDES_DEMO="
$PKG_BIN_ID_DEMO"
PKG_BIN_ARCH_LINUX='64'
PKG_BIN_ARCH_WINDOWS='32'
PKG_BIN_ARCH_DEMO_LINUX='64'
PKG_BIN_ARCH_DEMO_WINDOWS='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES_LINUX='
libc.so.6
libdl.so.2
libgcc_s.so.1
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6
libz.so.1'
PKG_BIN_DEPENDENCIES_LIBRARIES_DEMO_LINUX="$PKG_BIN_DEPENDENCIES_LIBRARIES_LINUX"
PKG_BIN_DEPENDENCIES_GSTREAMER_PLUGINS_WINDOWS='
video/quicktime, variant=(string)iso'
PKG_BIN_DEPENDENCIES_GSTREAMER_PLUGINS_DEMO_WINDOWS="$PKG_BIN_DEPENDENCIES_GSTREAMER_PLUGINS_WINDOWS"
## Handle upgrades from pre-20250520.5 packages.
PKG_BIN_PROVIDES="${PKG_BIN_PROVIDES:-}
legend-of-keepers"
PKG_BIN_PROVIDES_DEMO="${PKG_BIN_PROVIDES_DEMO:-}
legend-of-keepers-demo"

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_ID_LINUX="${PKG_DATA_ID}-linux"
PKG_DATA_ID_WINDOWS="${PKG_DATA_ID}-windows"
PKG_DATA_ID_DEMO="${GAME_ID_DEMO}-data"
PKG_DATA_ID_DEMO_LINUX="${PKG_DATA_ID_DEMO}-linux"
PKG_DATA_ID_DEMO_WINDOWS="${PKG_DATA_ID_DEMO}-windows"
PKG_DATA_PROVIDES="
$PKG_DATA_ID"
PKG_DATA_PROVIDES_DEMO="
$PKG_DATA_ID_DEMO"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
